<?php
/**
*qdPM
*
* NOTICE OF LICENSE
*
* This source file is subject to the Open Software License (OSL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/osl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@qdPM.net so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade qdPM to newer
* versions in the future. If you wish to customize qdPM for your
* needs please refer to http://www.qdPM.net for more information.
*
* @copyright  Copyright (c) 2009  Sergey Kharchishin and Kym Romanets (http://www.qdpm.net)
* @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
*/
?>
<?php
// Connection Component Binding
Doctrine_Manager::getInstance()->bindComponent('TasksGroups', 'doctrine');

/**
 * BaseTasksGroups
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property integer $id
 * @property integer $projects_id
 * @property string $name
 * @property Projects $Projects
 * @property Doctrine_Collection $Tasks
 * 
 * @method integer             getId()          Returns the current record's "id" value
 * @method integer             getProjectsId()  Returns the current record's "projects_id" value
 * @method string              getName()        Returns the current record's "name" value
 * @method Projects            getProjects()    Returns the current record's "Projects" value
 * @method Doctrine_Collection getTasks()       Returns the current record's "Tasks" collection
 * @method TasksGroups         setId()          Sets the current record's "id" value
 * @method TasksGroups         setProjectsId()  Sets the current record's "projects_id" value
 * @method TasksGroups         setName()        Sets the current record's "name" value
 * @method TasksGroups         setProjects()    Sets the current record's "Projects" value
 * @method TasksGroups         setTasks()       Sets the current record's "Tasks" collection
 * 
 * @package    sf_sandbox
 * @subpackage model
 * @author     Your name here
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BaseTasksGroups extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('tasks_groups');
        $this->hasColumn('id', 'integer', 4, array(
             'type' => 'integer',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => true,
             'autoincrement' => true,
             'length' => 4,
             ));
        $this->hasColumn('projects_id', 'integer', 4, array(
             'type' => 'integer',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'default' => '0',
             'notnull' => true,
             'autoincrement' => false,
             'length' => 4,
             ));
        $this->hasColumn('name', 'string', 255, array(
             'type' => 'string',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'default' => '',
             'notnull' => true,
             'autoincrement' => false,
             'length' => 255,
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('Projects', array(
             'local' => 'projects_id',
             'foreign' => 'id'));

        $this->hasMany('Tasks', array(
             'local' => 'id',
             'foreign' => 'tasks_groups_id'));
    }
}
