<?php
/**
*qdPM
*
* NOTICE OF LICENSE
*
* This source file is subject to the Open Software License (OSL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/osl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@qdPM.net so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade qdPM to newer
* versions in the future. If you wish to customize qdPM for your
* needs please refer to http://www.qdPM.net for more information.
*
* @copyright  Copyright (c) 2009  Sergey Kharchishin and Kym Romanets (http://www.qdpm.net)
* @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
*/
?>
<?php
// Connection Component Binding
Doctrine_Manager::getInstance()->bindComponent('DiscussionsComments', 'doctrine');

/**
 * BaseDiscussionsComments
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property integer $id
 * @property integer $discussions_id
 * @property integer $users_id
 * @property integer $discussions_status_id
 * @property string $description
 * @property timestamp $created_at
 * @property Discussions $Discussions
 * @property Users $Users
 * @property DiscussionsStatus $DiscussionsStatus
 * 
 * @method integer             getId()                    Returns the current record's "id" value
 * @method integer             getDiscussionsId()         Returns the current record's "discussions_id" value
 * @method integer             getUsersId()               Returns the current record's "users_id" value
 * @method integer             getDiscussionsStatusId()   Returns the current record's "discussions_status_id" value
 * @method string              getDescription()           Returns the current record's "description" value
 * @method timestamp           getCreatedAt()             Returns the current record's "created_at" value
 * @method Discussions         getDiscussions()           Returns the current record's "Discussions" value
 * @method Users               getUsers()                 Returns the current record's "Users" value
 * @method DiscussionsStatus   getDiscussionsStatus()     Returns the current record's "DiscussionsStatus" value
 * @method DiscussionsComments setId()                    Sets the current record's "id" value
 * @method DiscussionsComments setDiscussionsId()         Sets the current record's "discussions_id" value
 * @method DiscussionsComments setUsersId()               Sets the current record's "users_id" value
 * @method DiscussionsComments setDiscussionsStatusId()   Sets the current record's "discussions_status_id" value
 * @method DiscussionsComments setDescription()           Sets the current record's "description" value
 * @method DiscussionsComments setCreatedAt()             Sets the current record's "created_at" value
 * @method DiscussionsComments setDiscussions()           Sets the current record's "Discussions" value
 * @method DiscussionsComments setUsers()                 Sets the current record's "Users" value
 * @method DiscussionsComments setDiscussionsStatus()     Sets the current record's "DiscussionsStatus" value
 * 
 * @package    sf_sandbox
 * @subpackage model
 * @author     Your name here
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BaseDiscussionsComments extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('discussions_comments');
        $this->hasColumn('id', 'integer', 4, array(
             'type' => 'integer',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => true,
             'autoincrement' => true,
             'length' => 4,
             ));
        $this->hasColumn('discussions_id', 'integer', 4, array(
             'type' => 'integer',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'default' => '0',
             'notnull' => true,
             'autoincrement' => false,
             'length' => 4,
             ));
        $this->hasColumn('users_id', 'integer', 4, array(
             'type' => 'integer',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => 4,
             ));
        $this->hasColumn('discussions_status_id', 'integer', 4, array(
             'type' => 'integer',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => 4,
             ));
        $this->hasColumn('description', 'string', null, array(
             'type' => 'string',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => '',
             ));
        $this->hasColumn('created_at', 'timestamp', 25, array(
             'type' => 'timestamp',
             'fixed' => 0,
             'unsigned' => false,
             'primary' => false,
             'notnull' => false,
             'autoincrement' => false,
             'length' => 25,
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('Discussions', array(
             'local' => 'discussions_id',
             'foreign' => 'id'));

        $this->hasOne('Users', array(
             'local' => 'users_id',
             'foreign' => 'id'));

        $this->hasOne('DiscussionsStatus', array(
             'local' => 'discussions_status_id',
             'foreign' => 'id'));
    }
}
