<?php
/**
*qdPM
*
* NOTICE OF LICENSE
*
* This source file is subject to the Open Software License (OSL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/osl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@qdPM.net so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade qdPM to newer
* versions in the future. If you wish to customize qdPM for your
* needs please refer to http://www.qdPM.net for more information.
*
* @copyright  Copyright (c) 2009  Sergey Kharchishin and Kym Romanets (http://www.qdpm.net)
* @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
*/
?>
<?php

/**
 * UsersGroups
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @package    sf_sandbox
 * @subpackage model
 * @author     Your name here
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
class UsersGroups extends BaseUsersGroups
{
  public static function getLdapDafaultGroupId()
  {
    if($ug = Doctrine_Core::getTable('UsersGroups')->createQuery()->addWhere('ldap_default=1')->fetchOne())
    {
      return $ug->getId();
    }
    else
    {
      return false;
    }

  }
  
  public static function countUsersByGroupId($id)
  {
    return Doctrine_Core::getTable('Users')->createQuery()->addWhere('users_group_id=?',$id)->count();
  }
  
  public static function getNameById($id,$separator='<br>')
  {
    $n = array();
    foreach(explode(',',$id) as $v)
    {
      if($ug = Doctrine_Core::getTable('UsersGroups')->find($v))
      {
        $n[] = $ug->getName();
      }
    }
    
    return implode($separator,$n);
  }

  public static function getChoicesByType($type=false,$add_empty = false)
  {
    $q = Doctrine_Core::getTable('UsersGroups')
      ->createQuery();
        
    $groups = $q->orderBy('name')->execute();
    
    $choices = array();
    
    if($add_empty)
    {
      $choices[''] = '';
    }
        
    foreach($groups as $v)
    {
      $choices[$v->getId()]=$v->getName(); 
    }
    
    return $choices;
  }
  
  public static function is_checked_reports_field($k,$ug)
  {
    if(is_object($ug))
    if(in_array($k,explode(',',$ug->getAllowManageReports())))
    {
      return 'checked="checked"';
    }
    else
    {
      return '';
    }
  }
  
  
  public static function getAccessNameByKey($k)
  {
    
    $a = '<i style="color:#cbcbcb">' .__('none') . '</i>';
        
    switch($k)
    {  
      case 1: 
          $a = t::__('Full Access');
        break;      
      case 2: 
          $a = t::__('View Only');
        break;
      case 3: 
          $a = t::__('View Own');
        break;  
      case 4: 
          $a = t::__('Manage Own');
        break;                            
    }
    
    return $a ;
  } 
  
  
  public static function getReportAccessNameByKey($k,$ug)
  {
    if(in_array($k,explode(',',$ug->getAllowManageReports())))
    {
      return t::__('Yes');;
    }
    else
    {
      return '<i style="color:#cbcbcb">' .__('none') . '</i>';
    }    
  }
  
  public static function getAccessNameByValue($v)
  {
    if($v>0)
    {
      return t::__('Yes');;
    }
    else
    {
      return '<i style="color:#cbcbcb">' .__('none') . '</i>';
    }
  }
    
  public static function getAccessTable($ug, $type='',$include_reports = true)
  {
    $html = '';
            
    switch($type)
    {
      case 'projects':
         $html = '
            <table class="listingDataTable">
              <tr>
                <td><b>' . t::__('Projects'). ':</b></td>
                <td>' . UsersGroups::getAccessNameByKey($ug->getAllowManageProjects()) . '</td>
              </tr>              
              <tr>
                <td>' . t::__('Comments'). ':</td>
                <td>' . UsersGroups::getAccessNameByValue($ug->getAllowManageProjects()).   '</td>
              </tr>
              </table>
              <table class="listingDataTable">' .
              ($include_reports ?
              '<tr>
                <td>' . t::__('Projects Reports'). ':</td>
                <td>' . UsersGroups::getAccessNameByValue($ug->getAllowManageProjects()) . '</td>
              </tr>'
               :'') .
              '
             </table>'; 
        break;
       case 'tasks':
         $html = '
            <table class="listingDataTable">
              <tr>
                <td ><b>' . t::__('Tasks'). ':</b></td>
                <td>' . UsersGroups::getAccessNameByKey($ug->getAllowManageTasks()) . '</td>
              </tr>
              <tr>
                <td>' . t::__('Comments'). ':</td>
                <td>' . UsersGroups::getAccessNameByValue($ug->getAllowManageTasks()).   '</td>
              </tr>
              </table>' .
              ($include_reports ?
              '<table class="listingDataTable">
              <tr>
                <td>' . t::__('Tasks Reports'). ':</td>
                <td>' . UsersGroups::getAccessNameByValue($ug->getAllowManageTasks()) . '</td>
              </tr>
              <tr>
                <td>' . t::__('Gantt Chart'). ':</td>
                <td>' . UsersGroups::getAccessNameByValue($ug->getAllowManageTasks()) . '</td>
              </tr>
              <tr>
                <td>' . t::__('Time Report'). ':</td>
                <td>' . UsersGroups::getAccessNameByValue($ug->getAllowManageTasks()) . '</td>
              </tr>
              <tr>
                <td>' . t::__('Personal Time Report'). ':</td>
                <td>' . UsersGroups::getAccessNameByValue($ug->getAllowManageTasks()) . '</td>
              </tr> 
             </table>':''); 
        break;
       case 'tickets':
         $html = '
            <table class="listingDataTable">
              <tr>
                <td style="font-size: 11px;"><b>' . t::__('Tickets'). ':</b></td>
                <td>' . UsersGroups::getAccessNameByKey($ug->getAllowManageTickets()) . '</td>
              </tr>
              <tr>
                <td>' . t::__('Comments'). ':</td>
                <td>' .  UsersGroups::getAccessNameByValue($ug->getAllowManageTickets()).   '</td>
              </tr>
              </table>' .
              ($include_reports ?
              '<table class="listingDataTable">
              <tr>
                <td>' . t::__('Tickets Reports'). ':</td>
                <td>' .  UsersGroups::getAccessNameByValue($ug->getAllowManageTickets()) . '</td>
              </tr> 
             </table>':''); 
        break;
       case 'discussions':
         $html = '
            <table class="listingDataTable">
              <tr>
                <td><b>' . t::__('Discussions'). ':</b></td>
                <td>' . UsersGroups::getAccessNameByKey($ug->getAllowManageDiscussions()) . '</td>
              </tr>
              <tr>
                <td>' . t::__('Comments'). ':</td>
                <td>' . UsersGroups::getAccessNameByValue($ug->getAllowManageDiscussions()).   '</td>
              </tr>
              </table>' .
              ($include_reports ?
              '<table class="listingDataTable">
              <tr>
                <td>' . t::__('Discussions Reports'). ':</td>
                <td>' . UsersGroups::getAccessNameByValue($ug->getAllowManageDiscussions()) . '</td>
              </tr> 
             </table>':''); 
        break;
        case 'extra':
         $html = '
            <table class="listingDataTable">
              <tr>
                <td><b>' . t::__('Configuration'). ':</b></td>
                <td>' . UsersGroups::getAccessNameByValue($ug->getAllowManageConfiguration()) . '</td>
              </tr>
              <tr>
                <td>' . t::__('Users'). ':</td>
                <td>' . UsersGroups::getAccessNameByValue($ug->getAllowManageUsers()) . '</td>
              </tr>
             </table>'; 
        break;
    }
    
    $html = str_replace('<td>','<td style="white-space:normal">',$html);
    
    return $html;
  }
}
