<?php
/**
*qdPM
*
* NOTICE OF LICENSE
*
* This source file is subject to the Open Software License (OSL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/osl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@qdPM.net so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade qdPM to newer
* versions in the future. If you wish to customize qdPM for your
* needs please refer to http://www.qdPM.net for more information.
*
* @copyright  Copyright (c) 2009  Sergey Kharchishin and Kym Romanets (http://www.qdpm.net)
* @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
*/
?>
<?php

/**
 * Events
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @package    sf_sandbox
 * @subpackage model
 * @author     Your name here
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
class Events extends BaseEvents
{

  public static function get_events($date_from, $date_to,$calendar_type,$users_id)
  {
    global $app_user;
    
    $list = array();
    
    
    $where_sql = " where ( (date_format(start_date,'%Y-%m-%d')>='" . $date_from . "' and  date_format(end_date,'%Y-%m-%d')<='" . $date_to . "') or 
                           (date_format(start_date,'%Y-%m-%d')<'" . $date_from . "' and  date_format(end_date,'%Y-%m-%d')>'" . $date_to . "') or
                           (date_format(start_date,'%Y-%m-%d')<'" . $date_from . "' and  date_format(end_date,'%Y-%m-%d')<='" . $date_to . "' and  date_format(end_date,'%Y-%m-%d')>='" . $date_from . "') or
                           (date_format(start_date,'%Y-%m-%d')>='" . $date_from . "' and date_format(start_date,'%Y-%m-%d')<='" . $date_to . "' and  date_format(end_date,'%Y-%m-%d')>'" . $date_to . "') 
                           ) ";
    
    switch($calendar_type)
    {
      case 'personal':
          $where_sql .= " and users_id='" . $users_id . "' "; 
        break;
      case 'public':
          $where_sql .= " and users_id is null "; 
        break;
    }
    
    $events_query = "select * from events " . $where_sql . " order by start_date";
    
    //echo $events_query;  
      
    $connection = Doctrine_Manager::connection();  
    $statement = $connection->execute($events_query);        
    $events_list = $statement->fetchAll(PDO::FETCH_ASSOC);
                 
    
    foreach($events_list as $events)
    {
      $list[] = $events; 
    }
        
    
    return $list;
  }  
      
  public static function getEventsListByDateQuery($timestamp, $users_id = null)
  {
    $q = Doctrine_Core::getTable('Events')
        ->createQuery()
        ->addWhere("'" . date('Y-m-d',$timestamp) . "' BETWEEN date_format(start_date,'%Y-%m-%d') AND date_format(end_date,'%Y-%m-%d')");
        
    if($users_id==null)
    {
      $q->addWhere('users_id is null or public_status = 1');
    }
    else
    {
      $q->addWhere('users_id =?',$users_id);
    }
    

    
    $q->orderBy('start_date'); 
    
    return $q->execute();    
  }
  
  
  public static function getEventsListByDate($timestamp, $users_id = null, $sf_user)
  {        
    $html = '';
                                                       
    foreach(Events::getEventsListByDateQuery($timestamp,$users_id) as $events)
    {                      
      $edit_action = '';
      
      if(($sf_user->hasCredential('public_scheduler_access_full_access') and $users_id==null) or ($sf_user->hasCredential('allow_manage_personal_scheduler') and $users_id>0))
      {
        $edit_action = 'onClick="openModalBox(\'' . url_for('scheduler/edit?id=' . $events->getEventId() . '&users_id=' . $users_id) . '\')"';
      }
      
      if($users_id==null and $events->getPublicStatus()==1)
      {
        $edit_action = '';
      }
      
      $event_name = '<a class="jt" href="#" onClick="return false" title="<b>' . __('Start Date'). ':</b> ' . app::dateTimeFormat($events->getStartDate()) . ' - <b>' . __('End Date'). ':</b> ' . app::dateTimeFormat($events->getEndDate()) . '" rel="' . url_for('scheduler/info?id=' . $events->getEventId()). '">' . $events->getEventName() . '</a>';
      
      $time = date('H:i',app::getDateTimestamp($events->getStartDate()));
      
      if($time!='00:00')
      {
        $event_name = $time . ' ' . $event_name;
      }
                                    
      $html .= '<div class="eventItem" ' . $edit_action . '>'  .  $event_name . '</div>';
            
    }            
               
    return $html;
  }
  
  public static function getCountTodaysEvents($users_id = null)
  { 
    return count(self::get_events(date('Y-m-d'),date('Y-m-d'),'personal',$users_id));
    //return count(Events::getEventsListByDateQuery(mktime(0, 0, 0, date('m'), date('d'), date('Y')),$users_id));
  }
}
