<?php
/**
*qdPM
*
* NOTICE OF LICENSE
*
* This source file is subject to the Open Software License (OSL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/osl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@qdPM.net so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade qdPM to newer
* versions in the future. If you wish to customize qdPM for your
* needs please refer to http://www.qdPM.net for more information.
*
* @copyright  Copyright (c) 2009  Sergey Kharchishin and Kym Romanets (http://www.qdpm.net)
* @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
*/
?>
<?php

/**
 * DiscussionsComments
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @package    sf_sandbox
 * @subpackage model
 * @author     Your name here
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
class DiscussionsComments extends BaseDiscussionsComments
{
  public static function sendNotification($c,$comment,$sf_user)
  {
    $to = array();
    
    if(sfConfig::get('app_notify_all_discussions')=='on')
    {
      $users_list = Projects::getTeamUsersByAccess($comment->getDiscussions()->getProjectsId(),'discussions');                 
    }
    else
    {
      $users_list = explode(',',$comment->getDiscussions()->getAssignedTo());
    }
        
    foreach($users_list as $v)
    {
      if($u = Doctrine_Core::getTable('Users')->find($v))
      {        
        $to[$u->getEmail()]=$u->getName();        
      }
    }
              
    $user = $sf_user->getAttribute('user');
    $from[$user->getEmail()] = $user->getName();
    $to[$comment->getDiscussions()->getUsers()->getEmail()] = $comment->getDiscussions()->getUsers()->getName();
    $to[$user->getEmail()] = $user->getName();
    
    $discussions_comments = Doctrine_Core::getTable('DiscussionsComments')
      ->createQuery()
      ->addWhere('discussions_id=?',$comment->getDiscussionsId())      
      ->orderBy('created_at desc')
      ->execute();
      
    foreach($discussions_comments as $v)
    {      
      $to[$v->getUsers()->getEmail()]=$v->getUsers()->getName();      
    }
      
    if(sfConfig::get('app_send_email_to_owner')=='off')
    {
      unset($to[$user->getEmail()]);             
    }
    
    $to = array_unique($to);
     
    $subject = t::__('New Discussion Comment') . ': ' . $comment->getDiscussions()->getProjects()->getName() . ' - ' . $comment->getDiscussions()->getName() . ($comment->getDiscussions()->getDiscussionsStatusId()>0 ? ' [' . $comment->getDiscussions()->getDiscussionsStatus()->getName() . ']':'');
    $body  = $c->getComponent('discussionsComments','emailBody',array('discussions'=>$comment->getDiscussions()));
                
    Users::sendEmail($from,$to,$subject,$body,$sf_user);
  }
}
