<?php namespace Anomaly\Streams\Platform\Installer\Console\Command;

use Anomaly\Streams\Platform\Installer\Installer;
use Anomaly\Streams\Platform\Installer\InstallerCollection;
use Illuminate\Console\Command;
use Illuminate\Contracts\Bus\SelfHandling;
use Illuminate\Contracts\Container\Container;

/**
 * Class RunInstallers
 *
 * @link          http://anomaly.is/streams-platform
 * @author        AnomalyLabs, Inc. <hello@anomaly.is>
 * @author        Ryan Thompson <ryan@anomaly.is>
 * @package       Anomaly\Streams\Platform\Installer\Console\Command
 */
class RunInstallers implements SelfHandling
{

    /**
     * The console command.
     *
     * @var Command
     */
    protected $command;

    /**
     * The installer collection.
     *
     * @var InstallerCollection
     */
    protected $installers;

    /**
     * Create a new RunInstallers instance.
     *
     * @param InstallerCollection $installers
     * @param Command             $command
     */
    public function __construct(InstallerCollection $installers, Command $command = null)
    {
        $this->command    = $command;
        $this->installers = $installers;
    }

    /**
     * Handle the command.
     *
     * @param Container $container
     */
    public function handle(Container $container)
    {
        $step  = 1;
        $total = $this->installers->count();

        /* @var Installer $installer */
        while ($installer = $this->installers->shift()) {

            if ($this->command) {
                $this->command->info("{$step}/{$total} " . trans($installer->getMessage()));
            }

            $container->call($installer->getTask());

            $step++;
        }
    }
}
