<?php
namespace CoffeeScript;
use \ArrayAccess as ArrayAccess;
Init::init();

/* Driver template for the PHP_ParserGenerator parser generator. (PHP port of LEMON)
*/

/**
 * This can be used to store both the string representation of
 * a token, and any useful meta-data associated with the token.
 *
 * meta-data should be stored as an array
 */
class yyToken implements ArrayAccess
{
    public $string = '';
    public $metadata = array();

    function __construct($s, $m = array())
    {
        if ($s instanceof yyToken) {
            $this->string = $s->string;
            $this->metadata = $s->metadata;
        } else {
            $this->string = (string) $s;
            if ($m instanceof yyToken) {
                $this->metadata = $m->metadata;
            } elseif (is_array($m)) {
                $this->metadata = $m;
            }
        }
    }

    function __toString()
    {
        return $this->string;
    }

    function offsetExists($offset)
    {
        return isset($this->metadata[$offset]);
    }

    function offsetGet($offset)
    {
        return $this->metadata[$offset];
    }

    function offsetSet($offset, $value)
    {
        if ($offset === null) {
            if (isset($value[0])) {
                $x = ($value instanceof yyToken) ?
                    $value->metadata : $value;
                $this->metadata = array_merge($this->metadata, $x);
                return;
            }
            $offset = count($this->metadata);
        }
        if ($value === null) {
            return;
        }
        if ($value instanceof yyToken) {
            if ($value->metadata) {
                $this->metadata[$offset] = $value->metadata;
            }
        } elseif ($value) {
            $this->metadata[$offset] = $value;
        }
    }

    function offsetUnset($offset)
    {
        unset($this->metadata[$offset]);
    }
}

/** The following structure represents a single element of the
 * parser's stack.  Information stored includes:
 *
 *   +  The state number for the parser at this level of the stack.
 *
 *   +  The value of the token stored at this level of the stack.
 *      (In other words, the "major" token.)
 *
 *   +  The semantic value stored at this level of the stack.  This is
 *      the information used by the action routines in the grammar.
 *      It is sometimes called the "minor" token.
 */
class yyStackEntry
{
    public $stateno;       /* The state-number */
    public $major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
    public $minor; /* The user-supplied minor token value.  This
                   ** is the value of the token  */
};

// code external to the class is included here

// declare_class is output here
#line 2 "/var/www/coffeescript-php/grammar.y"
 class Parser #line 102 "/var/www/coffeescript-php/grammar.php"
{
  static $LINE = 0;
  static $FILE = 'unknown';

/* First off, code is included which follows the "include_class" declaration
** in the input file. */

/* Next is all token values, as class constants
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
    const YY_POST_IF                     =  1;
    const YY_IF                          =  2;
    const YY_ELSE                        =  3;
    const YY_FOR                         =  4;
    const YY_WHILE                       =  5;
    const YY_UNTIL                       =  6;
    const YY_LOOP                        =  7;
    const YY_SUPER                       =  8;
    const YY_CLASS                       =  9;
    const YY_FORIN                       = 10;
    const YY_FOROF                       = 11;
    const YY_BY                          = 12;
    const YY_WHEN                        = 13;
    const YY_EQUALS                      = 14;
    const YY_COLON                       = 15;
    const YY_COMPOUND_ASSIGN             = 16;
    const YY_RETURN                      = 17;
    const YY_THROW                       = 18;
    const YY_EXTENDS                     = 19;
    const YY_INDENT                      = 20;
    const YY_OUTDENT                     = 21;
    const YY_LOGIC                       = 22;
    const YY_COMPARE                     = 23;
    const YY_RELATION                    = 24;
    const YY_SHIFT                       = 25;
    const YY_MATH                        = 26;
    const YY_PLUS                        = 27;
    const YY_MINUS                       = 28;
    const YY_UNARY                       = 29;
    const YY_EXISTENTIAL                 = 30;
    const YY_INCREMENT                   = 31;
    const YY_DECREMENT                   = 32;
    const YY_CALL_START                  = 33;
    const YY_CALL_END                    = 34;
    const YY_ACCESSOR                    = 35;
    const YY_EXISTENTIAL_ACCESSOR        = 36;
    const YY_PROTOTYPE                   = 37;
    const YY_TERMINATOR                  = 38;
    const YY_STATEMENT                   = 39;
    const YY_IDENTIFIER                  = 40;
    const YY_NUMBER                      = 41;
    const YY_STRING                      = 42;
    const YY_JS                          = 43;
    const YY_REGEX                       = 44;
    const YY_DEBUGGER                    = 45;
    const YY_BOOL                        = 46;
    const YY_HERECOMMENT                 = 47;
    const YY_PARAM_START                 = 48;
    const YY_PARAM_END                   = 49;
    const YY_FUNC                        = 50;
    const YY_BOUND_FUNC                  = 51;
    const YY_COMMA                       = 52;
    const YY_RANGE_EXCLUSIVE             = 53;
    const YY_INDEX_START                 = 54;
    const YY_INDEX_END                   = 55;
    const YY_INDEX_SOAK                  = 56;
    const YY_OBJECT_START                = 57;
    const YY_OBJECT_END                  = 58;
    const YY_FUNC_EXIST                  = 59;
    const YY_THIS                        = 60;
    const YY_AT_SIGN                     = 61;
    const YY_ARRAY_START                 = 62;
    const YY_ARRAY_END                   = 63;
    const YY_RANGE_INCLUSIVE             = 64;
    const YY_TRY                         = 65;
    const YY_FINALLY                     = 66;
    const YY_CATCH                       = 67;
    const YY_PAREN_START                 = 68;
    const YY_PAREN_END                   = 69;
    const YY_OWN                         = 70;
    const YY_SWITCH                      = 71;
    const YY_LEADING_WHEN                = 72;
    const YY_NO_ACTION = 512;
    const YY_ACCEPT_ACTION = 511;
    const YY_ERROR_ACTION = 510;

/* Next are that tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < self::YYNSTATE                              Shift N.  That is,
**                                                        push the lookahead
**                                                        token onto the stack
**                                                        and goto state N.
**
**   self::YYNSTATE <= N < self::YYNSTATE+self::YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == self::YYNSTATE+self::YYNRULE                    A syntax error has occurred.
**
**   N == self::YYNSTATE+self::YYNRULE+1                  The parser accepts its
**                                                        input. (and concludes parsing)
**
**   N == self::YYNSTATE+self::YYNRULE+2                  No such action.  Denotes unused
**                                                        slots in the yy_action[] table.
**
** The action table is constructed as a single large static array $yy_action.
** Given state S and lookahead X, the action is computed as
**
**      self::$yy_action[self::$yy_shift_ofst[S] + X ]
**
** If the index value self::$yy_shift_ofst[S]+X is out of range or if the value
** self::$yy_lookahead[self::$yy_shift_ofst[S]+X] is not equal to X or if
** self::$yy_shift_ofst[S] is equal to self::YY_SHIFT_USE_DFLT, it means that
** the action is not in the table and that self::$yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the static $yy_reduce_ofst array is used in place of
** the static $yy_shift_ofst array and self::YY_REDUCE_USE_DFLT is used in place of
** self::YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  self::$yy_action        A single table containing all actions.
**  self::$yy_lookahead     A table containing the lookahead for each entry in
**                          yy_action.  Used to detect hash collisions.
**  self::$yy_shift_ofst    For each state, the offset into self::$yy_action for
**                          shifting terminals.
**  self::$yy_reduce_ofst   For each state, the offset into self::$yy_action for
**                          shifting non-terminals after a reduce.
**  self::$yy_default       Default action for each state.
*/
    const YY_SZ_ACTTAB = 4561;
static public $yy_action = array(
 /*     0 */   511,  181,  186,  235,   90,  118,  254,  255,  111,  109,
 /*    10 */   266,  267,  264,  263,  259,  260,  261,  262,  246,  245,
 /*    20 */   237,  232,  300,  178,   32,   34,  238,  309,  158,  304,
 /*    30 */    35,   19,  269,  299,    4,  164,  132,  301,  298,  297,
 /*    40 */    39,   21,   36,   22,   20,   32,   34,  225,  309,  226,
 /*    50 */   135,  154,  291,  147,  135,   20,   32,   34,   65,  309,
 /*    60 */   183,   70,  117,  254,  255,  111,  109,  266,  267,  264,
 /*    70 */   263,  259,  260,  261,  262,  246,  245,  237,  232,  300,
 /*    80 */   178,  151,  152,  238,  251,  158,  251,  230,  231,  269,
 /*    90 */   299,  287,  164,  234,  301,  298,  297,   21,   36,   22,
 /*   100 */    20,   32,   34,  139,  309,  283,  241,  144,  154,  291,
 /*   110 */   147,  135,  243,   13,  244,  135,    8,  183,   69,  117,
 /*   120 */   254,  255,  111,  109,  266,  267,  264,  263,  259,  260,
 /*   130 */   261,  262,  246,  245,  237,  232,  300,  178,  130,    8,
 /*   140 */   238,   66,  158,  242,  306,  200,  269,  299,   52,  164,
 /*   150 */   169,  301,  298,  297,   16,  185,  222,   45,  201,  195,
 /*   160 */    13,   44,  191,  180,  199,  154,  291,  147,  135,  268,
 /*   170 */   239,   37,   26,  159,  183,   77,  117,  254,  255,  111,
 /*   180 */   109,  266,  267,  264,  263,  259,  260,  261,  262,  246,
 /*   190 */   245,  237,  232,  300,  178,  128,  272,  238,  310,  158,
 /*   200 */   129,  272,  293,  269,  299,  287,  164,    1,  301,  298,
 /*   210 */   297,  179,   36,   22,   20,   32,   34,  138,  309,  283,
 /*   220 */    40,  292,  154,  291,  147,  135,  275,  131,   13,  240,
 /*   230 */   236,  183,   77,  117,  254,  255,  111,  109,  266,  267,
 /*   240 */   264,  263,  259,  260,  261,  262,  246,  245,  237,  232,
 /*   250 */   300,  178,  280,  277,  238,   75,  158,  205,  150,  202,
 /*   260 */   269,  299,  287,  164,  190,  301,  298,  297,   22,   20,
 /*   270 */    32,   34,  207,  309,  139,  225,  283,  226,  135,  154,
 /*   280 */   291,  147,  135,   13,  206,  198,   17,  302,  183,   77,
 /*   290 */   117,  254,  255,  111,  109,  266,  267,  264,  263,  259,
 /*   300 */   260,  261,  262,  246,  245,  237,  232,  300,  178,  220,
 /*   310 */   251,  238,  251,  158,  271,  307,   15,  269,  299,  287,
 /*   320 */   164,  165,  301,  298,  297,  305,    5,   62,  227,   62,
 /*   330 */   207,  140,    3,  283,    2,  176,  154,  291,  147,  135,
 /*   340 */    68,  187,  206,  198,   11,  183,   77,  117,  254,  255,
 /*   350 */   111,  109,  266,  267,  264,  263,  259,  260,  261,  262,
 /*   360 */   246,  245,  237,  232,  300,  178,  211,  184,  238,  286,
 /*   370 */   158,    5,  285,  248,  269,  299,  287,  164,  258,  301,
 /*   380 */   298,  297,  381,  252,  381,  381,  381,  250,  145,   11,
 /*   390 */   283,  155,    9,  154,  291,  147,  135,  166,  247,  270,
 /*   400 */   149,  308,  183,  381,  309,  381,   14,  175,  381,  235,
 /*   410 */    90,  118,  254,  255,  111,  109,  266,  267,  264,  263,
 /*   420 */   259,  260,  261,  262,  246,  245,  237,  232,  300,  178,
 /*   430 */   278,  170,  238,  295,  158,  182,  376,  249,  269,  299,
 /*   440 */   168,  164,  134,  301,  298,  297,   56,  279,   67,   47,
 /*   450 */    24,   12,  160,   58,  376,  276,  189,  154,  291,  147,
 /*   460 */   135,   57,   25,  265,    6,  167,  183,  177,  376,  333,
 /*   470 */   257,   42,   43,   50,  250,   59,   60,   28,  142,  376,
 /*   480 */    67,   47,   24,  256,  251,  230,  231,  233,  229,  228,
 /*   490 */   224,  234,   63,   61,  240,  236,  225,  333,  226,  135,
 /*   500 */   333,   62,  333,  333,  303,  153,    3,  288,  333,  148,
 /*   510 */    55,   64,    7,  333,  207,   18,  333,  333,   56,  333,
 /*   520 */    67,   47,   24,   12,  160,   58,  206,  198,    8,  221,
 /*   530 */   333,  193,  217,   57,   25,  219,   53,  333,  333,  214,
 /*   540 */   173,  204,  208,   42,   43,   50,  333,   59,   60,  333,
 /*   550 */   218,  184,  143,  333,   54,  256,  251,  230,  231,  233,
 /*   560 */   229,  228,  224,  234,   63,  212,  240,  236,   51,  333,
 /*   570 */   223,  333,  225,   62,  226,  135,  303,  153,    3,   27,
 /*   580 */   333,  148,  333,  225,    7,  226,  135,   18,  172,  333,
 /*   590 */   235,   90,  118,  254,  255,  111,  109,  266,  267,  264,
 /*   600 */   263,  259,  260,  261,  262,  246,  245,  237,  232,  300,
 /*   610 */   178,  296,  333,  238,  225,  158,  226,  135,  333,  269,
 /*   620 */   299,   14,  164,  333,  301,  298,  297,   56,  333,   67,
 /*   630 */    47,   24,   12,  160,   58,  333,  333,    5,  154,  291,
 /*   640 */   147,  135,   57,   25,  333,    6,  333,  183,  333,  333,
 /*   650 */   333,  203,   42,   43,   50,   11,   59,   60,  333,  210,
 /*   660 */   225,  141,  226,  135,  256,  251,  230,  231,  233,  229,
 /*   670 */   228,  224,  234,   63,  333,  240,  236,  333,  333,  273,
 /*   680 */   333,  333,   62,  333,  333,  303,  153,    3,  333,  333,
 /*   690 */   148,  333,  333,    7,  333,  171,   18,  235,   90,  118,
 /*   700 */   254,  255,  111,  109,  266,  267,  264,  263,  259,  260,
 /*   710 */   261,  262,  246,  245,  237,  232,  300,  178,  333,  333,
 /*   720 */   238,  333,  158,  333,    5,  284,  269,  299,  333,  164,
 /*   730 */    14,  301,  298,  297,   56,  333,   67,   47,   24,   12,
 /*   740 */   160,   58,   11,  333,  333,  154,  291,  147,  135,   57,
 /*   750 */    25,   61,  215,  333,  183,  333,  333,  333,  333,   42,
 /*   760 */    43,   50,  333,   59,   60,  333,  333,  333,  333,   64,
 /*   770 */   333,  256,  251,  230,  231,  233,  229,  228,  224,  234,
 /*   780 */    63,  333,  240,  236,  333,  213,  333,  333,  333,   62,
 /*   790 */   333,  333,  303,  153,    3,  333,  311,  148,  333,  333,
 /*   800 */     7,  333,  333,   18,  333,   77,  117,  254,  255,  111,
 /*   810 */   109,  266,  267,  264,  263,  259,  260,  261,  262,  246,
 /*   820 */   245,  237,  232,  300,  178,  333,  333,  238,  333,  158,
 /*   830 */   333,  333,   38,  269,  299,  287,  164,  333,  301,  298,
 /*   840 */   297,  333,   39,   21,   36,   22,   20,   32,   34,  290,
 /*   850 */   309,  333,  154,  291,  147,  135,  333,  333,  333,  333,
 /*   860 */   333,  183,   77,  117,  254,  255,  111,  109,  266,  267,
 /*   870 */   264,  263,  259,  260,  261,  262,  246,  245,  237,  232,
 /*   880 */   300,  178,  333,  333,  238,  333,  158,  333,  333,  333,
 /*   890 */   269,  299,  287,  164,  333,  301,  298,  297,  333,   39,
 /*   900 */    21,   36,   22,   20,   32,   34,  282,  309,  333,  154,
 /*   910 */   291,  147,  135,  221,  333,  333,  333,  333,  183,  219,
 /*   920 */   174,  333,  333,  216,  173,  204,  208,  253,   90,  118,
 /*   930 */   254,  255,  111,  109,  266,  267,  264,  263,  259,  260,
 /*   940 */   261,  262,  246,  245,  237,  232,  300,  178,  333,  333,
 /*   950 */   238,  333,  158,  333,  333,   29,  269,  299,  333,  164,
 /*   960 */   333,  301,  298,  297,   39,   21,   36,   22,   20,   32,
 /*   970 */    34,  333,  309,  333,  333,  154,  291,  147,  135,  333,
 /*   980 */   333,  333,  333,  281,  183,   94,  117,  254,  255,  111,
 /*   990 */   109,  266,  267,  264,  263,  259,  260,  261,  262,  246,
 /*  1000 */   245,  237,  232,  300,  178,  333,  333,  238,  333,  158,
 /*  1010 */   333,  333,  333,  269,  299,  333,  164,  333,  301,  298,
 /*  1020 */   297,   56,  333,   67,   47,   24,   12,  160,   58,  333,
 /*  1030 */   333,  333,  154,  291,  147,  135,   57,   25,  333,   48,
 /*  1040 */   333,  183,  333,  333,  333,  333,   42,   43,   50,  333,
 /*  1050 */    59,   60,  333,  333,  333,  333,  333,  333,  256,  251,
 /*  1060 */   230,  231,  233,  229,  228,  224,  234,   63,  333,  240,
 /*  1070 */   236,  333,  333,  333,  333,  333,   62,  333,  333,  303,
 /*  1080 */   153,    3,  333,  333,  148,  333,  333,    7,  333,  333,
 /*  1090 */    18,  333,  333,   56,  333,   67,   47,   24,   12,  160,
 /*  1100 */    58,  333,  333,  416,  333,  137,  136,  146,   57,   25,
 /*  1110 */   333,  125,  333,  333,  333,  333,  333,  333,   42,   43,
 /*  1120 */    50,  333,   59,   60,    4,  333,  132,  333,  251,  294,
 /*  1130 */   256,  251,  230,  231,  233,  229,  228,  224,  234,   63,
 /*  1140 */   333,  240,  236,  333,  333,   62,  333,  333,   62,  144,
 /*  1150 */     2,  303,  153,    3,  333,  333,  148,  333,  333,    7,
 /*  1160 */   333,  333,   18,  333,  333,   56,  333,   67,   47,   24,
 /*  1170 */    12,  160,   58,  333,  333,  333,  333,  137,  136,  146,
 /*  1180 */    57,   25,  333,   33,  333,  333,  333,  333,  333,  333,
 /*  1190 */    42,   43,   50,  333,   59,   60,    4,  333,  132,  333,
 /*  1200 */   333,  294,  256,  251,  230,  231,  233,  229,  228,  224,
 /*  1210 */   234,   63,  333,  240,  236,  333,  333,  333,  333,  333,
 /*  1220 */    62,  333,  333,  303,  153,    3,  333,  333,  148,  333,
 /*  1230 */   333,    7,  333,  333,   18,   89,  117,  254,  255,  111,
 /*  1240 */   109,  266,  267,  264,  263,  259,  260,  261,  262,  246,
 /*  1250 */   245,  237,  232,  300,  178,  333,  333,  238,  333,  158,
 /*  1260 */   333,  333,  333,  269,  299,  333,  164,  333,  301,  298,
 /*  1270 */   297,   56,  333,   67,   47,   24,   12,  160,   58,  333,
 /*  1280 */   133,  333,  154,  291,  147,  135,   57,   25,  333,    8,
 /*  1290 */   333,  183,  333,  333,  333,  333,   42,   43,   50,  333,
 /*  1300 */    59,   60,  333,  333,  333,  333,  333,  333,  256,  251,
 /*  1310 */   230,  231,  233,  229,  228,  224,  234,   63,  333,  240,
 /*  1320 */   236,  333,  333,  333,  333,  333,   62,  333,  333,  303,
 /*  1330 */   153,    3,  333,  333,  148,  333,  333,    7,  333,  333,
 /*  1340 */    18,  333,  333,   56,  333,   67,   47,   24,   12,  160,
 /*  1350 */    58,  333,  333,  333,  333,  333,  333,  333,   57,   25,
 /*  1360 */   333,  333,  188,  333,  333,  333,  333,  333,   42,   43,
 /*  1370 */    50,  333,   59,   60,  333,  333,  333,  333,  333,  333,
 /*  1380 */   256,  251,  230,  231,  233,  229,  228,  224,  234,   63,
 /*  1390 */   333,  240,  236,  333,  333,  333,  333,  333,   62,  333,
 /*  1400 */   333,  303,  153,    3,  333,  333,  148,  333,  333,    7,
 /*  1410 */   333,  333,   18,  333,  333,   56,  333,   67,   47,   24,
 /*  1420 */    12,  160,   58,  333,  333,  333,  333,  333,  333,  333,
 /*  1430 */    57,   25,  333,   10,  333,  333,  333,  333,  333,  333,
 /*  1440 */    42,   43,   50,  333,   59,   60,  333,  333,  333,  333,
 /*  1450 */   333,  333,  256,  251,  230,  231,  233,  229,  228,  224,
 /*  1460 */   234,   63,  333,  240,  236,  333,  333,  333,  333,  333,
 /*  1470 */    62,  333,  333,  303,  153,    3,  333,  333,  148,  333,
 /*  1480 */   333,    7,  333,  333,   18,  333,  333,   56,  333,   67,
 /*  1490 */    47,   24,   12,  160,   58,  333,  333,  333,  333,  333,
 /*  1500 */   333,  333,   57,   25,  333,    6,  333,  333,  333,  333,
 /*  1510 */   333,  333,   42,   43,   50,  333,   59,   60,  333,  333,
 /*  1520 */   333,  333,  333,  333,  256,  251,  230,  231,  233,  229,
 /*  1530 */   228,  224,  234,   63,  333,  240,  236,  333,  333,  333,
 /*  1540 */   333,  333,   62,  333,  333,  303,  153,    3,  333,  333,
 /*  1550 */   148,  333,  333,    7,  333,  333,   18,  123,  117,  254,
 /*  1560 */   255,  111,  109,  266,  267,  264,  263,  259,  260,  261,
 /*  1570 */   262,  246,  245,  237,  232,  300,  178,  333,  333,  238,
 /*  1580 */   333,  158,  333,  333,  333,  269,  299,  333,  164,  333,
 /*  1590 */   301,  298,  297,   56,  333,   67,   47,   24,   12,  160,
 /*  1600 */    58,  333,  333,  333,  154,  291,  147,  135,   57,   25,
 /*  1610 */   333,  333,  333,  183,  333,  333,  333,  333,   42,   43,
 /*  1620 */    50,  333,   59,   60,  333,  333,  333,  333,  333,  333,
 /*  1630 */   256,  251,  230,  231,  233,  229,  228,  224,  234,   63,
 /*  1640 */   333,  240,  236,  333,  333,  333,  333,  333,   62,  333,
 /*  1650 */   333,  303,  153,    3,  333,  333,  148,  333,  333,    7,
 /*  1660 */   333,  333,   18,  333,  122,  117,  254,  255,  111,  109,
 /*  1670 */   266,  267,  264,  263,  259,  260,  261,  262,  246,  245,
 /*  1680 */   237,  232,  300,  178,  333,  333,  238,  333,  158,  333,
 /*  1690 */   333,   31,  269,  299,  333,  164,  333,  301,  298,  297,
 /*  1700 */    39,   21,   36,   22,   20,   32,   34,  333,  309,  333,
 /*  1710 */   333,  154,  291,  147,  135,  333,  333,  333,  333,  333,
 /*  1720 */   183,   82,  117,  254,  255,  111,  109,  266,  267,  264,
 /*  1730 */   263,  259,  260,  261,  262,  246,  245,  237,  232,  300,
 /*  1740 */   178,  333,  333,  238,  200,  158,  333,  333,  333,  269,
 /*  1750 */   299,  333,  164,  333,  301,  298,  297,  201,  195,  333,
 /*  1760 */   333,  197,  180,  199,  333,  333,  333,  333,  154,  291,
 /*  1770 */   147,  135,  333,  333,  333,  333,  333,  183,  101,  117,
 /*  1780 */   254,  255,  111,  109,  266,  267,  264,  263,  259,  260,
 /*  1790 */   261,  262,  246,  245,  237,  232,  300,  178,  333,  333,
 /*  1800 */   238,  333,  158,  333,  333,  333,  269,  299,  333,  164,
 /*  1810 */   333,  301,  298,  297,  333,  333,  333,  333,  333,  333,
 /*  1820 */   333,  333,  333,  333,  333,  154,  291,  147,  135,  333,
 /*  1830 */   333,  333,  333,  333,  183,   95,  117,  254,  255,  111,
 /*  1840 */   109,  266,  267,  264,  263,  259,  260,  261,  262,  246,
 /*  1850 */   245,  237,  232,  300,  178,  333,  333,  238,  333,  158,
 /*  1860 */   333,  333,  333,  269,  299,  333,  164,  333,  301,  298,
 /*  1870 */   297,  333,  333,  333,  333,  333,  333,  333,  333,  333,
 /*  1880 */   333,  333,  154,  291,  147,  135,  333,  333,  333,  333,
 /*  1890 */   333,  183,   96,  117,  254,  255,  111,  109,  266,  267,
 /*  1900 */   264,  263,  259,  260,  261,  262,  246,  245,  237,  232,
 /*  1910 */   300,  178,  333,  333,  238,  333,  158,  333,  333,  333,
 /*  1920 */   269,  299,  333,  164,  333,  301,  298,  297,  333,  333,
 /*  1930 */   333,  333,  333,  333,  333,  333,  333,  333,  333,  154,
 /*  1940 */   291,  147,  135,  333,  333,  333,  333,  333,  183,  100,
 /*  1950 */   117,  254,  255,  111,  109,  266,  267,  264,  263,  259,
 /*  1960 */   260,  261,  262,  246,  245,  237,  232,  300,  178,  333,
 /*  1970 */   333,  238,  333,  158,  333,  333,  333,  269,  299,  333,
 /*  1980 */   164,  333,  301,  298,  297,  333,  333,  333,  333,  333,
 /*  1990 */   333,  333,  333,  333,  333,  333,  154,  291,  147,  135,
 /*  2000 */   333,  333,  333,  333,  333,  183,  115,  117,  254,  255,
 /*  2010 */   111,  109,  266,  267,  264,  263,  259,  260,  261,  262,
 /*  2020 */   246,  245,  237,  232,  300,  178,  333,  333,  238,  333,
 /*  2030 */   158,  333,  333,  333,  269,  299,  333,  164,  333,  301,
 /*  2040 */   298,  297,  333,  333,  333,  333,  333,  333,  333,  333,
 /*  2050 */   333,  333,  333,  154,  291,  147,  135,  333,  333,  333,
 /*  2060 */   333,  333,  183,  110,  117,  254,  255,  111,  109,  266,
 /*  2070 */   267,  264,  263,  259,  260,  261,  262,  246,  245,  237,
 /*  2080 */   232,  300,  178,  333,  333,  238,  333,  158,  333,  333,
 /*  2090 */   333,  269,  299,  333,  164,  333,  301,  298,  297,  333,
 /*  2100 */   333,  333,  333,  333,  333,  333,  333,  333,  333,  333,
 /*  2110 */   154,  291,  147,  135,  333,  333,  333,  333,  333,  183,
 /*  2120 */    84,  117,  254,  255,  111,  109,  266,  267,  264,  263,
 /*  2130 */   259,  260,  261,  262,  246,  245,  237,  232,  300,  178,
 /*  2140 */   333,  333,  238,  333,  158,  333,  333,  333,  269,  299,
 /*  2150 */   333,  164,  333,  301,  298,  297,  333,  333,  333,  333,
 /*  2160 */   333,  333,  333,  333,  333,  333,  333,  154,  291,  147,
 /*  2170 */   135,  333,  333,  333,  333,  333,  183,   73,  117,  254,
 /*  2180 */   255,  111,  109,  266,  267,  264,  263,  259,  260,  261,
 /*  2190 */   262,  246,  245,  237,  232,  300,  178,  333,  333,  238,
 /*  2200 */   333,  158,  333,  333,  333,  269,  299,  333,  164,  333,
 /*  2210 */   301,  298,  297,  333,  333,  333,  333,  333,  333,  333,
 /*  2220 */   333,  333,  333,  333,  154,  291,  147,  135,  333,  333,
 /*  2230 */   333,  333,  333,  183,   81,  117,  254,  255,  111,  109,
 /*  2240 */   266,  267,  264,  263,  259,  260,  261,  262,  246,  245,
 /*  2250 */   237,  232,  300,  178,  333,  333,  238,  333,  158,  333,
 /*  2260 */   333,  333,  269,  299,  333,  164,  333,  301,  298,  297,
 /*  2270 */   333,  333,  333,  333,  333,  333,  333,  333,  333,  333,
 /*  2280 */   333,  154,  291,  147,  135,  333,  333,  333,  333,  333,
 /*  2290 */   183,   83,  117,  254,  255,  111,  109,  266,  267,  264,
 /*  2300 */   263,  259,  260,  261,  262,  246,  245,  237,  232,  300,
 /*  2310 */   178,  333,  333,  238,  333,  158,  333,  333,  333,  269,
 /*  2320 */   299,  333,  164,  333,  301,  298,  297,  333,  333,  333,
 /*  2330 */   333,  333,  333,  333,  333,  333,  333,  333,  154,  291,
 /*  2340 */   147,  135,  333,  333,  333,  333,  333,  183,  102,  117,
 /*  2350 */   254,  255,  111,  109,  266,  267,  264,  263,  259,  260,
 /*  2360 */   261,  262,  246,  245,  237,  232,  300,  178,  333,  333,
 /*  2370 */   238,  333,  158,  333,  333,  333,  269,  299,  333,  164,
 /*  2380 */   333,  301,  298,  297,  333,  333,  333,  333,  333,  333,
 /*  2390 */   333,  333,  333,  333,  333,  154,  291,  147,  135,  333,
 /*  2400 */   333,  333,  333,  333,  183,   72,  117,  254,  255,  111,
 /*  2410 */   109,  266,  267,  264,  263,  259,  260,  261,  262,  246,
 /*  2420 */   245,  237,  232,  300,  178,  333,  333,  238,  333,  158,
 /*  2430 */   333,  333,  333,  269,  299,  333,  164,  333,  301,  298,
 /*  2440 */   297,  333,  333,  333,  333,  333,  333,  333,  333,  333,
 /*  2450 */   333,  333,  154,  291,  147,  135,  333,  333,  333,  333,
 /*  2460 */   333,  183,  104,  117,  254,  255,  111,  109,  266,  267,
 /*  2470 */   264,  263,  259,  260,  261,  262,  246,  245,  237,  232,
 /*  2480 */   300,  178,  333,  333,  238,  333,  158,  333,  333,  333,
 /*  2490 */   269,  299,  333,  164,  333,  301,  298,  297,  333,  333,
 /*  2500 */   333,  333,  333,  333,  333,  333,  333,  333,  333,  154,
 /*  2510 */   291,  147,  135,  333,  333,  333,  333,  333,  183,   71,
 /*  2520 */   117,  254,  255,  111,  109,  266,  267,  264,  263,  259,
 /*  2530 */   260,  261,  262,  246,  245,  237,  232,  300,  178,  333,
 /*  2540 */   333,  238,  333,  158,  333,  333,  333,  269,  299,  333,
 /*  2550 */   164,  333,  301,  298,  297,  333,  333,  333,  333,  333,
 /*  2560 */   333,  333,  333,  333,  333,  333,  154,  291,  147,  135,
 /*  2570 */   333,  333,  333,  333,  333,  183,   85,  117,  254,  255,
 /*  2580 */   111,  109,  266,  267,  264,  263,  259,  260,  261,  262,
 /*  2590 */   246,  245,  237,  232,  300,  178,  333,  333,  238,  333,
 /*  2600 */   158,  333,  333,  333,  269,  299,  333,  164,  333,  301,
 /*  2610 */   298,  297,  333,  333,  333,  333,  333,  333,  333,  333,
 /*  2620 */   333,  333,  333,  154,  291,  147,  135,  333,  333,  333,
 /*  2630 */   333,  333,  183,   76,  117,  254,  255,  111,  109,  266,
 /*  2640 */   267,  264,  263,  259,  260,  261,  262,  246,  245,  237,
 /*  2650 */   232,  300,  178,  333,  333,  238,  333,  158,  333,  333,
 /*  2660 */   333,  269,  299,  333,  164,  333,  301,  298,  297,  333,
 /*  2670 */   333,  333,  333,  333,  333,  333,  333,  333,  333,  333,
 /*  2680 */   154,  291,  147,  135,  333,  333,  333,  333,  333,  183,
 /*  2690 */    88,  117,  254,  255,  111,  109,  266,  267,  264,  263,
 /*  2700 */   259,  260,  261,  262,  246,  245,  237,  232,  300,  178,
 /*  2710 */   333,  333,  238,  333,  158,  333,  333,  333,  269,  299,
 /*  2720 */   333,  164,  333,  301,  298,  297,  333,  333,  333,  333,
 /*  2730 */   333,  333,  333,  333,  333,  333,  333,  154,  291,  147,
 /*  2740 */   135,  333,  333,  333,  333,  333,  183,   93,  117,  254,
 /*  2750 */   255,  111,  109,  266,  267,  264,  263,  259,  260,  261,
 /*  2760 */   262,  246,  245,  237,  232,  300,  178,  333,  333,  238,
 /*  2770 */   333,  158,  333,  333,  333,  269,  299,  333,  164,  333,
 /*  2780 */   301,  298,  297,  333,  333,  333,  333,  333,  333,  333,
 /*  2790 */   333,  333,  333,  333,  154,  291,  147,  135,  333,  333,
 /*  2800 */   333,  333,  333,  183,  120,  117,  254,  255,  111,  109,
 /*  2810 */   266,  267,  264,  263,  259,  260,  261,  262,  246,  245,
 /*  2820 */   237,  232,  300,  178,  333,  333,  238,  333,  158,  333,
 /*  2830 */   333,  333,  269,  299,  333,  164,  333,  301,  298,  297,
 /*  2840 */   333,  333,  333,  333,  333,  333,  333,  333,  333,  333,
 /*  2850 */   333,  154,  291,  147,  135,  333,  333,  333,  333,  333,
 /*  2860 */   183,  114,  117,  254,  255,  111,  109,  266,  267,  264,
 /*  2870 */   263,  259,  260,  261,  262,  246,  245,  237,  232,  300,
 /*  2880 */   178,  333,  333,  238,  333,  158,  333,  333,  333,  269,
 /*  2890 */   299,  333,  164,  333,  301,  298,  297,  333,  333,  333,
 /*  2900 */   333,  333,  333,  333,  333,  333,  333,  333,  154,  291,
 /*  2910 */   147,  135,  333,  333,  333,  333,  333,  183,  119,  117,
 /*  2920 */   254,  255,  111,  109,  266,  267,  264,  263,  259,  260,
 /*  2930 */   261,  262,  246,  245,  237,  232,  300,  178,  333,  333,
 /*  2940 */   238,  333,  158,  333,  333,  333,  269,  299,  333,  164,
 /*  2950 */   333,  301,  298,  297,  333,  333,  333,  333,  333,  333,
 /*  2960 */   333,  333,  333,  333,  333,  154,  291,  147,  135,  333,
 /*  2970 */   333,  333,  333,  333,  183,  116,  117,  254,  255,  111,
 /*  2980 */   109,  266,  267,  264,  263,  259,  260,  261,  262,  246,
 /*  2990 */   245,  237,  232,  300,  178,  333,  333,  238,  333,  158,
 /*  3000 */   333,  333,  333,  269,  299,  333,  164,  333,  301,  298,
 /*  3010 */   297,  333,  333,  333,  333,  333,  333,  333,  333,  333,
 /*  3020 */   333,  333,  154,  291,  147,  135,  333,  333,  333,  333,
 /*  3030 */   333,  183,   74,  117,  254,  255,  111,  109,  266,  267,
 /*  3040 */   264,  263,  259,  260,  261,  262,  246,  245,  237,  232,
 /*  3050 */   300,  178,  333,  333,  238,  333,  158,  333,  333,  333,
 /*  3060 */   269,  299,  333,  164,  333,  301,  298,  297,  333,  333,
 /*  3070 */   333,  333,  333,  333,  333,  333,  333,  333,  333,  154,
 /*  3080 */   291,  147,  135,  333,  333,  333,  333,  333,  183,   97,
 /*  3090 */   117,  254,  255,  111,  109,  266,  267,  264,  263,  259,
 /*  3100 */   260,  261,  262,  246,  245,  237,  232,  300,  178,  333,
 /*  3110 */   333,  238,  333,  158,  333,  333,  333,  269,  299,  333,
 /*  3120 */   164,  333,  301,  298,  297,  333,  333,  333,  333,  333,
 /*  3130 */   333,  333,  333,  333,  333,  333,  154,  291,  147,  135,
 /*  3140 */   333,  333,  333,  333,  333,  183,   98,  117,  254,  255,
 /*  3150 */   111,  109,  266,  267,  264,  263,  259,  260,  261,  262,
 /*  3160 */   246,  245,  237,  232,  300,  178,  333,  333,  238,  333,
 /*  3170 */   158,  333,  333,  333,  269,  299,  333,  164,  333,  301,
 /*  3180 */   298,  297,  333,  333,  333,  333,  333,  333,  333,  333,
 /*  3190 */   333,  333,  333,  154,  291,  147,  135,  333,  333,  333,
 /*  3200 */   333,  333,  183,   78,  117,  254,  255,  111,  109,  266,
 /*  3210 */   267,  264,  263,  259,  260,  261,  262,  246,  245,  237,
 /*  3220 */   232,  300,  178,  333,  333,  238,  333,  158,  333,  333,
 /*  3230 */   333,  269,  299,  333,  164,  333,  301,  298,  297,  333,
 /*  3240 */   333,  333,  333,  333,  333,  333,  333,  333,  333,  333,
 /*  3250 */   154,  291,  147,  135,  333,  333,  333,  333,  333,  183,
 /*  3260 */   105,  117,  254,  255,  111,  109,  266,  267,  264,  263,
 /*  3270 */   259,  260,  261,  262,  246,  245,  237,  232,  300,  178,
 /*  3280 */   333,  333,  238,  333,  158,  333,  333,  333,  269,  299,
 /*  3290 */   333,  164,  333,  301,  298,  297,  333,  333,  333,  333,
 /*  3300 */   333,  333,  333,  333,  333,  333,  333,  154,  291,  147,
 /*  3310 */   135,  333,  333,  333,  333,  333,  183,  108,  117,  254,
 /*  3320 */   255,  111,  109,  266,  267,  264,  263,  259,  260,  261,
 /*  3330 */   262,  246,  245,  237,  232,  300,  178,  333,  333,  238,
 /*  3340 */   333,  158,  333,  333,  333,  269,  299,  333,  164,  333,
 /*  3350 */   301,  298,  297,  333,  333,  333,  333,  333,  333,  333,
 /*  3360 */   333,  333,  333,  333,  154,  291,  147,  135,  333,  333,
 /*  3370 */   333,  333,  333,  183,   87,  117,  254,  255,  111,  109,
 /*  3380 */   266,  267,  264,  263,  259,  260,  261,  262,  246,  245,
 /*  3390 */   237,  232,  300,  178,  333,  333,  238,  333,  158,  333,
 /*  3400 */   333,  333,  269,  299,  333,  164,  333,  301,  298,  297,
 /*  3410 */   333,  333,  333,  333,  333,  333,  333,  333,  333,  333,
 /*  3420 */   333,  154,  291,  147,  135,  333,  333,  333,  333,  333,
 /*  3430 */   183,   92,  117,  254,  255,  111,  109,  266,  267,  264,
 /*  3440 */   263,  259,  260,  261,  262,  246,  245,  237,  232,  300,
 /*  3450 */   178,  333,  333,  238,  333,  158,  333,  333,  333,  269,
 /*  3460 */   299,  333,  164,  333,  301,  298,  297,  333,  333,  333,
 /*  3470 */   333,  333,  333,  333,  333,  333,  333,  333,  154,  291,
 /*  3480 */   147,  135,  333,  333,  333,  333,  333,  183,  121,  117,
 /*  3490 */   254,  255,  111,  109,  266,  267,  264,  263,  259,  260,
 /*  3500 */   261,  262,  246,  245,  237,  232,  300,  178,  333,  333,
 /*  3510 */   238,  333,  158,  333,  333,  333,  269,  299,  333,  164,
 /*  3520 */   333,  301,  298,  297,  333,  333,  333,  333,  333,  333,
 /*  3530 */   333,  333,  333,  333,  333,  154,  291,  147,  135,  333,
 /*  3540 */   333,  333,  333,  333,  183,  124,  117,  254,  255,  111,
 /*  3550 */   109,  266,  267,  264,  263,  259,  260,  261,  262,  246,
 /*  3560 */   245,  237,  232,  300,  178,  333,  333,  238,  333,  158,
 /*  3570 */   333,  333,  333,  269,  299,  333,  164,  333,  301,  298,
 /*  3580 */   297,  333,  333,  333,  333,  333,  333,  333,  333,  333,
 /*  3590 */   333,  333,  154,  291,  147,  135,  333,  333,  333,  333,
 /*  3600 */   333,  183,   79,  117,  254,  255,  111,  109,  266,  267,
 /*  3610 */   264,  263,  259,  260,  261,  262,  246,  245,  237,  232,
 /*  3620 */   300,  178,  333,  333,  238,  333,  158,  333,  333,  333,
 /*  3630 */   269,  299,  333,  164,  333,  301,  298,  297,  333,  333,
 /*  3640 */   333,  333,  333,  333,  333,  333,  333,  333,  333,  154,
 /*  3650 */   291,  147,  135,  333,  333,  333,  333,  333,  183,   91,
 /*  3660 */   117,  254,  255,  111,  109,  266,  267,  264,  263,  259,
 /*  3670 */   260,  261,  262,  246,  245,  237,  232,  300,  178,  333,
 /*  3680 */   333,  238,  333,  158,  333,  333,  333,  269,  299,  333,
 /*  3690 */   164,  333,  301,  298,  297,  333,  333,  333,  333,  333,
 /*  3700 */   333,  333,  333,  333,  333,  333,  154,  291,  147,  135,
 /*  3710 */   333,  333,  333,  333,  333,  183,  103,  117,  254,  255,
 /*  3720 */   111,  109,  266,  267,  264,  263,  259,  260,  261,  262,
 /*  3730 */   246,  245,  237,  232,  300,  178,  333,  333,  238,  333,
 /*  3740 */   158,  333,  333,  333,  269,  299,  333,  164,  333,  301,
 /*  3750 */   298,  297,  333,  333,  333,  333,  333,  333,  333,  333,
 /*  3760 */   333,  333,  333,  154,  291,  147,  135,  333,  333,  333,
 /*  3770 */   333,  333,  183,  106,  117,  254,  255,  111,  109,  266,
 /*  3780 */   267,  264,  263,  259,  260,  261,  262,  246,  245,  237,
 /*  3790 */   232,  300,  178,  333,  333,  238,  333,  158,  333,  333,
 /*  3800 */   333,  269,  299,  333,  164,  333,  301,  298,  297,  333,
 /*  3810 */   333,  333,  333,  333,  333,  333,  333,  333,  333,  333,
 /*  3820 */   154,  291,  147,  135,  333,  333,  333,  333,  333,  183,
 /*  3830 */    80,  117,  254,  255,  111,  109,  266,  267,  264,  263,
 /*  3840 */   259,  260,  261,  262,  246,  245,  237,  232,  300,  178,
 /*  3850 */   333,  333,  238,  333,  158,  333,  333,  333,  269,  299,
 /*  3860 */   333,  164,  333,  301,  298,  297,  333,  333,  333,  333,
 /*  3870 */   333,  333,  333,  333,  333,  333,  333,  154,  291,  147,
 /*  3880 */   135,  333,  333,  333,  333,  333,  183,   99,  117,  254,
 /*  3890 */   255,  111,  109,  266,  267,  264,  263,  259,  260,  261,
 /*  3900 */   262,  246,  245,  237,  232,  300,  178,  333,  333,  238,
 /*  3910 */   333,  158,  333,  333,  333,  269,  299,  333,  164,  333,
 /*  3920 */   301,  298,  297,  333,  333,  333,  333,  333,  333,  333,
 /*  3930 */   333,  333,  333,  333,  154,  291,  147,  135,  333,  333,
 /*  3940 */   333,  333,  333,  183,  107,  117,  254,  255,  111,  109,
 /*  3950 */   266,  267,  264,  263,  259,  260,  261,  262,  246,  245,
 /*  3960 */   237,  232,  300,  178,  333,  333,  238,  333,  158,  333,
 /*  3970 */   333,  333,  269,  299,  333,  164,  333,  301,  298,  297,
 /*  3980 */   333,  333,  333,  333,  333,  333,  333,  333,  333,  333,
 /*  3990 */   333,  154,  291,  147,  135,  333,  333,  333,  333,  333,
 /*  4000 */   183,   86,  117,  254,  255,  111,  109,  266,  267,  264,
 /*  4010 */   263,  259,  260,  261,  262,  246,  245,  237,  232,  300,
 /*  4020 */   178,  333,  333,  238,  333,  158,  333,  333,  333,  269,
 /*  4030 */   299,  333,  164,  333,  301,  298,  297,   56,  333,  333,
 /*  4040 */   333,  333,   12,  160,   58,  333,  333,  333,  154,  291,
 /*  4050 */   147,  135,   57,   25,  333,  333,  333,  183,  333,  333,
 /*  4060 */   333,  333,   42,   43,   50,  333,   59,   60,  333,  333,
 /*  4070 */   333,  333,  333,  333,  256,  251,  230,  231,  233,  229,
 /*  4080 */   228,  224,  234,   63,  333,  240,  236,  160,  333,  333,
 /*  4090 */   333,  333,   62,  333,  333,  303,  153,    3,   46,    8,
 /*  4100 */   148,  333,  333,    7,  333,   30,   18,  333,   67,   47,
 /*  4110 */    24,  333,  333,  333,  333,  333,  333,  333,  333,  251,
 /*  4120 */   230,  231,  233,  229,  228,  224,   39,   21,   36,   22,
 /*  4130 */    20,   32,   34,  333,  309,  333,   62,  333,  333,  303,
 /*  4140 */   153,    3,  333,  313,  333,  333,  333,    7,  333,  112,
 /*  4150 */   113,  333,  333,  333,  333,  333,  333,  213,  333,  333,
 /*  4160 */   333,  237,  232,  300,  274,  333,   30,  238,  311,   67,
 /*  4170 */    47,   24,  333,  269,  299,  333,  127,  333,  301,  298,
 /*  4180 */   297,   30,  333,  333,   67,   47,   24,   39,   21,   36,
 /*  4190 */    22,   20,   32,   34,  333,  309,  333,  333,  333,  333,
 /*  4200 */   126,  333,   39,   21,   36,   22,   20,   32,   34,   30,
 /*  4210 */   309,  333,   67,   47,   24,  333,  333,  333,  163,  333,
 /*  4220 */    30,  333,  333,   67,   47,   24,  333,  333,  333,  311,
 /*  4230 */    39,   21,   36,   22,   20,   32,   34,  333,  309,  333,
 /*  4240 */   194,   39,   21,   36,   22,   20,   32,   34,  333,  309,
 /*  4250 */   200,   30,  333,  333,   67,   47,   24,  333,  333,  333,
 /*  4260 */   333,  333,  333,  201,  195,  333,  333,  192,  180,  199,
 /*  4270 */     8,  312,   39,   21,   36,   22,   20,   32,   34,   30,
 /*  4280 */   309,  333,   67,   47,   24,  333,  156,  333,  333,  333,
 /*  4290 */   333,  333,  333,  333,  333,  333,  333,  333,  333,  209,
 /*  4300 */    39,   21,   36,   22,   20,   32,   34,   30,  309,  333,
 /*  4310 */    67,   47,   24,  333,  333,  333,  160,  333,  333,  333,
 /*  4320 */   333,  333,  333,  333,  333,  333,  333,  196,   39,   21,
 /*  4330 */    36,   22,   20,   32,   34,   30,  309,  333,   67,   47,
 /*  4340 */    24,  333,  333,  333,  333,  333,  333,  333,  251,  230,
 /*  4350 */   231,  233,  229,  228,  224,  333,   39,   21,   36,   22,
 /*  4360 */    20,   32,   34,  333,  309,   62,  112,  113,  303,  153,
 /*  4370 */     3,  333,  333,  333,  333,  333,    7,  333,  237,  232,
 /*  4380 */   300,  274,  333,  333,  238,  333,  333,  289,  333,  333,
 /*  4390 */   269,  299,  333,  161,  333,  301,  298,  297,  333,  112,
 /*  4400 */   113,  333,  333,  333,  333,  333,  333,  333,  333,  333,
 /*  4410 */   333,  237,  232,  300,  274,   30,  333,  238,   67,   47,
 /*  4420 */    24,  333,  333,  269,  299,  333,  162,  333,  301,  298,
 /*  4430 */   297,   67,   47,   24,  333,  333,   39,   21,   36,   22,
 /*  4440 */    20,   32,   34,  333,  309,  333,  333,    8,  333,   39,
 /*  4450 */    21,   36,   22,   20,   32,   34,  333,  309,   67,   47,
 /*  4460 */    24,  333,  333,  333,  333,  333,  333,   49,  333,  333,
 /*  4470 */   333,  333,  333,  333,  333,  333,   39,   21,   36,   22,
 /*  4480 */    20,   32,   34,  333,  309,   67,   47,   24,  333,  333,
 /*  4490 */   333,  333,  333,  333,   41,  333,   23,    8,  333,   67,
 /*  4500 */    47,   24,  333,   39,   21,   36,   22,   20,   32,   34,
 /*  4510 */   381,  309,  381,  381,  381,  333,  333,   39,   21,   36,
 /*  4520 */    22,   20,   32,   34,  200,  309,  333,  333,  333,  333,
 /*  4530 */   333,  381,  333,  381,  333,  333,  381,  201,  195,  333,
 /*  4540 */   333,  192,  180,  199,  333,  333,  333,  333,  333,  333,
 /*  4550 */   333,  333,  333,  333,  333,  333,  333,  333,  333,  333,
 /*  4560 */   157,
    );
    static public $yy_lookahead = array(
 /*     0 */    74,   75,   76,   77,   78,   79,   80,   81,   82,   83,
 /*    10 */    84,   85,   86,   87,   88,   89,   90,   91,   92,   93,
 /*    20 */    94,   95,   96,   97,   27,   28,  100,   30,  102,   76,
 /*    30 */    12,   13,  106,  107,   54,  109,   56,  111,  112,  113,
 /*    40 */    22,   23,   24,   25,   26,   27,   28,  125,   30,  127,
 /*    50 */   128,  125,  126,  127,  128,   26,   27,   28,   52,   30,
 /*    60 */   134,   78,   79,   80,   81,   82,   83,   84,   85,   86,
 /*    70 */    87,   88,   89,   90,   91,   92,   93,   94,   95,   96,
 /*    80 */    97,   66,   67,  100,   40,  102,   40,   41,   42,  106,
 /*    90 */   107,  108,  109,   47,  111,  112,  113,   23,   24,   25,
 /*   100 */    26,   27,   28,  120,   30,  122,   76,   61,  125,  126,
 /*   110 */   127,  128,  125,   38,  127,  128,   20,  134,   78,   79,
 /*   120 */    80,   81,   82,   83,   84,   85,   86,   87,   88,   89,
 /*   130 */    90,   91,   92,   93,   94,   95,   96,   97,   49,   20,
 /*   140 */   100,   52,  102,   21,   69,   81,  106,  107,   52,  109,
 /*   150 */   103,  111,  112,  113,   16,  115,  116,   19,   94,   95,
 /*   160 */    38,  121,   98,   99,  100,  125,  126,  127,  128,   31,
 /*   170 */    32,   10,   11,   94,  134,   78,   79,   80,   81,   82,
 /*   180 */    83,   84,   85,   86,   87,   88,   89,   90,   91,   92,
 /*   190 */    93,   94,   95,   96,   97,  132,  133,  100,   94,  102,
 /*   200 */   132,  133,  119,  106,  107,  108,  109,   33,  111,  112,
 /*   210 */   113,   21,   24,   25,   26,   27,   28,  120,   30,  122,
 /*   220 */    14,   76,  125,  126,  127,  128,   76,    3,   38,   50,
 /*   230 */    51,  134,   78,   79,   80,   81,   82,   83,   84,   85,
 /*   240 */    86,   87,   88,   89,   90,   91,   92,   93,   94,   95,
 /*   250 */    96,   97,   21,   21,  100,   52,  102,   55,   66,   53,
 /*   260 */   106,  107,  108,  109,   38,  111,  112,  113,   25,   26,
 /*   270 */    27,   28,   94,   30,  120,  125,  122,  127,  128,  125,
 /*   280 */   126,  127,  128,   38,  106,  107,   15,  119,  134,   78,
 /*   290 */    79,   80,   81,   82,   83,   84,   85,   86,   87,   88,
 /*   300 */    89,   90,   91,   92,   93,   94,   95,   96,   97,  131,
 /*   310 */    40,  100,   40,  102,   38,   69,   14,  106,  107,  108,
 /*   320 */   109,  103,  111,  112,  113,   76,   20,   57,  129,   57,
 /*   330 */    94,  120,   62,  122,   62,   76,  125,  126,  127,  128,
 /*   340 */    70,  124,  106,  107,   38,  134,   78,   79,   80,   81,
 /*   350 */    82,   83,   84,   85,   86,   87,   88,   89,   90,   91,
 /*   360 */    92,   93,   94,   95,   96,   97,  130,  131,  100,   63,
 /*   370 */   102,   20,   21,   94,  106,  107,  108,  109,  114,  111,
 /*   380 */   112,  113,   33,  110,   35,   36,   37,  114,  120,   38,
 /*   390 */   122,  118,   52,  125,  126,  127,  128,  103,   94,   76,
 /*   400 */   102,   76,  134,   54,   30,   56,   72,   75,   59,   77,
 /*   410 */    78,   79,   80,   81,   82,   83,   84,   85,   86,   87,
 /*   420 */    88,   89,   90,   91,   92,   93,   94,   95,   96,   97,
 /*   430 */   133,  103,  100,   76,  102,   76,   20,   94,  106,  107,
 /*   440 */   103,  109,   76,  111,  112,  113,    2,   76,    4,    5,
 /*   450 */     6,    7,    8,    9,   38,   76,   76,  125,  126,  127,
 /*   460 */   128,   17,   18,  119,   20,  103,  134,   76,   52,  135,
 /*   470 */   110,   27,   28,   29,  114,   31,   32,    1,  118,   63,
 /*   480 */     4,    5,    6,   39,   40,   41,   42,   43,   44,   45,
 /*   490 */    46,   47,   48,   20,   50,   51,  125,  135,  127,  128,
 /*   500 */   135,   57,  135,  135,   60,   61,   62,   63,  135,   65,
 /*   510 */     2,   38,   68,  135,   94,   71,  135,  135,    2,  135,
 /*   520 */     4,    5,    6,    7,    8,    9,  106,  107,   20,   94,
 /*   530 */   135,   58,  112,   17,   18,  100,   20,  135,  135,  104,
 /*   540 */   105,  106,  107,   27,   28,   29,  135,   31,   32,  135,
 /*   550 */   130,  131,    3,  135,   38,   39,   40,   41,   42,   43,
 /*   560 */    44,   45,   46,   47,   48,   76,   50,   51,  121,  135,
 /*   570 */    21,  135,  125,   57,  127,  128,   60,   61,   62,  121,
 /*   580 */   135,   65,  135,  125,   68,  127,  128,   71,   75,  135,
 /*   590 */    77,   78,   79,   80,   81,   82,   83,   84,   85,   86,
 /*   600 */    87,   88,   89,   90,   91,   92,   93,   94,   95,   96,
 /*   610 */    97,   76,  135,  100,  125,  102,  127,  128,  135,  106,
 /*   620 */   107,   72,  109,  135,  111,  112,  113,    2,  135,    4,
 /*   630 */     5,    6,    7,    8,    9,  135,  135,   20,  125,  126,
 /*   640 */   127,  128,   17,   18,  135,   20,  135,  134,  135,  135,
 /*   650 */   135,   34,   27,   28,   29,   38,   31,   32,  135,   34,
 /*   660 */   125,    3,  127,  128,   39,   40,   41,   42,   43,   44,
 /*   670 */    45,   46,   47,   48,  135,   50,   51,  135,  135,   21,
 /*   680 */   135,  135,   57,  135,  135,   60,   61,   62,  135,  135,
 /*   690 */    65,  135,  135,   68,  135,   75,   71,   77,   78,   79,
 /*   700 */    80,   81,   82,   83,   84,   85,   86,   87,   88,   89,
 /*   710 */    90,   91,   92,   93,   94,   95,   96,   97,  135,  135,
 /*   720 */   100,  135,  102,  135,   20,   21,  106,  107,  135,  109,
 /*   730 */    72,  111,  112,  113,    2,  135,    4,    5,    6,    7,
 /*   740 */     8,    9,   38,  135,  135,  125,  126,  127,  128,   17,
 /*   750 */    18,   20,   21,  135,  134,  135,  135,  135,  135,   27,
 /*   760 */    28,   29,  135,   31,   32,  135,  135,  135,  135,   38,
 /*   770 */   135,   39,   40,   41,   42,   43,   44,   45,   46,   47,
 /*   780 */    48,  135,   50,   51,  135,   53,  135,  135,  135,   57,
 /*   790 */   135,  135,   60,   61,   62,  135,   64,   65,  135,  135,
 /*   800 */    68,  135,  135,   71,  135,   78,   79,   80,   81,   82,
 /*   810 */    83,   84,   85,   86,   87,   88,   89,   90,   91,   92,
 /*   820 */    93,   94,   95,   96,   97,  135,  135,  100,  135,  102,
 /*   830 */   135,  135,   12,  106,  107,  108,  109,  135,  111,  112,
 /*   840 */   113,  135,   22,   23,   24,   25,   26,   27,   28,  122,
 /*   850 */    30,  135,  125,  126,  127,  128,  135,  135,  135,  135,
 /*   860 */   135,  134,   78,   79,   80,   81,   82,   83,   84,   85,
 /*   870 */    86,   87,   88,   89,   90,   91,   92,   93,   94,   95,
 /*   880 */    96,   97,  135,  135,  100,  135,  102,  135,  135,  135,
 /*   890 */   106,  107,  108,  109,  135,  111,  112,  113,  135,   22,
 /*   900 */    23,   24,   25,   26,   27,   28,  122,   30,  135,  125,
 /*   910 */   126,  127,  128,   94,  135,  135,  135,  135,  134,  100,
 /*   920 */   101,  135,  135,  104,  105,  106,  107,   77,   78,   79,
 /*   930 */    80,   81,   82,   83,   84,   85,   86,   87,   88,   89,
 /*   940 */    90,   91,   92,   93,   94,   95,   96,   97,  135,  135,
 /*   950 */   100,  135,  102,  135,  135,   13,  106,  107,  135,  109,
 /*   960 */   135,  111,  112,  113,   22,   23,   24,   25,   26,   27,
 /*   970 */    28,  135,   30,  135,  135,  125,  126,  127,  128,  135,
 /*   980 */   135,  135,  135,   76,  134,   78,   79,   80,   81,   82,
 /*   990 */    83,   84,   85,   86,   87,   88,   89,   90,   91,   92,
 /*  1000 */    93,   94,   95,   96,   97,  135,  135,  100,  135,  102,
 /*  1010 */   135,  135,  135,  106,  107,  135,  109,  135,  111,  112,
 /*  1020 */   113,    2,  135,    4,    5,    6,    7,    8,    9,  135,
 /*  1030 */   135,  135,  125,  126,  127,  128,   17,   18,  135,   20,
 /*  1040 */   135,  134,  135,  135,  135,  135,   27,   28,   29,  135,
 /*  1050 */    31,   32,  135,  135,  135,  135,  135,  135,   39,   40,
 /*  1060 */    41,   42,   43,   44,   45,   46,   47,   48,  135,   50,
 /*  1070 */    51,  135,  135,  135,  135,  135,   57,  135,  135,   60,
 /*  1080 */    61,   62,  135,  135,   65,  135,  135,   68,  135,  135,
 /*  1090 */    71,  135,  135,    2,  135,    4,    5,    6,    7,    8,
 /*  1100 */     9,  135,  135,   33,  135,   35,   36,   37,   17,   18,
 /*  1110 */   135,   20,  135,  135,  135,  135,  135,  135,   27,   28,
 /*  1120 */    29,  135,   31,   32,   54,  135,   56,  135,   40,   59,
 /*  1130 */    39,   40,   41,   42,   43,   44,   45,   46,   47,   48,
 /*  1140 */   135,   50,   51,  135,  135,   57,  135,  135,   57,   61,
 /*  1150 */    62,   60,   61,   62,  135,  135,   65,  135,  135,   68,
 /*  1160 */   135,  135,   71,  135,  135,    2,  135,    4,    5,    6,
 /*  1170 */     7,    8,    9,  135,  135,  135,  135,   35,   36,   37,
 /*  1180 */    17,   18,  135,   20,  135,  135,  135,  135,  135,  135,
 /*  1190 */    27,   28,   29,  135,   31,   32,   54,  135,   56,  135,
 /*  1200 */   135,   59,   39,   40,   41,   42,   43,   44,   45,   46,
 /*  1210 */    47,   48,  135,   50,   51,  135,  135,  135,  135,  135,
 /*  1220 */    57,  135,  135,   60,   61,   62,  135,  135,   65,  135,
 /*  1230 */   135,   68,  135,  135,   71,   78,   79,   80,   81,   82,
 /*  1240 */    83,   84,   85,   86,   87,   88,   89,   90,   91,   92,
 /*  1250 */    93,   94,   95,   96,   97,  135,  135,  100,  135,  102,
 /*  1260 */   135,  135,  135,  106,  107,  135,  109,  135,  111,  112,
 /*  1270 */   113,    2,  135,    4,    5,    6,    7,    8,    9,  135,
 /*  1280 */   123,  135,  125,  126,  127,  128,   17,   18,  135,   20,
 /*  1290 */   135,  134,  135,  135,  135,  135,   27,   28,   29,  135,
 /*  1300 */    31,   32,  135,  135,  135,  135,  135,  135,   39,   40,
 /*  1310 */    41,   42,   43,   44,   45,   46,   47,   48,  135,   50,
 /*  1320 */    51,  135,  135,  135,  135,  135,   57,  135,  135,   60,
 /*  1330 */    61,   62,  135,  135,   65,  135,  135,   68,  135,  135,
 /*  1340 */    71,  135,  135,    2,  135,    4,    5,    6,    7,    8,
 /*  1350 */     9,  135,  135,  135,  135,  135,  135,  135,   17,   18,
 /*  1360 */   135,  135,   21,  135,  135,  135,  135,  135,   27,   28,
 /*  1370 */    29,  135,   31,   32,  135,  135,  135,  135,  135,  135,
 /*  1380 */    39,   40,   41,   42,   43,   44,   45,   46,   47,   48,
 /*  1390 */   135,   50,   51,  135,  135,  135,  135,  135,   57,  135,
 /*  1400 */   135,   60,   61,   62,  135,  135,   65,  135,  135,   68,
 /*  1410 */   135,  135,   71,  135,  135,    2,  135,    4,    5,    6,
 /*  1420 */     7,    8,    9,  135,  135,  135,  135,  135,  135,  135,
 /*  1430 */    17,   18,  135,   20,  135,  135,  135,  135,  135,  135,
 /*  1440 */    27,   28,   29,  135,   31,   32,  135,  135,  135,  135,
 /*  1450 */   135,  135,   39,   40,   41,   42,   43,   44,   45,   46,
 /*  1460 */    47,   48,  135,   50,   51,  135,  135,  135,  135,  135,
 /*  1470 */    57,  135,  135,   60,   61,   62,  135,  135,   65,  135,
 /*  1480 */   135,   68,  135,  135,   71,  135,  135,    2,  135,    4,
 /*  1490 */     5,    6,    7,    8,    9,  135,  135,  135,  135,  135,
 /*  1500 */   135,  135,   17,   18,  135,   20,  135,  135,  135,  135,
 /*  1510 */   135,  135,   27,   28,   29,  135,   31,   32,  135,  135,
 /*  1520 */   135,  135,  135,  135,   39,   40,   41,   42,   43,   44,
 /*  1530 */    45,   46,   47,   48,  135,   50,   51,  135,  135,  135,
 /*  1540 */   135,  135,   57,  135,  135,   60,   61,   62,  135,  135,
 /*  1550 */    65,  135,  135,   68,  135,  135,   71,   78,   79,   80,
 /*  1560 */    81,   82,   83,   84,   85,   86,   87,   88,   89,   90,
 /*  1570 */    91,   92,   93,   94,   95,   96,   97,  135,  135,  100,
 /*  1580 */   135,  102,  135,  135,  135,  106,  107,  135,  109,  135,
 /*  1590 */   111,  112,  113,    2,  135,    4,    5,    6,    7,    8,
 /*  1600 */     9,  135,  135,  135,  125,  126,  127,  128,   17,   18,
 /*  1610 */   135,  135,  135,  134,  135,  135,  135,  135,   27,   28,
 /*  1620 */    29,  135,   31,   32,  135,  135,  135,  135,  135,  135,
 /*  1630 */    39,   40,   41,   42,   43,   44,   45,   46,   47,   48,
 /*  1640 */   135,   50,   51,  135,  135,  135,  135,  135,   57,  135,
 /*  1650 */   135,   60,   61,   62,  135,  135,   65,  135,  135,   68,
 /*  1660 */   135,  135,   71,  135,   78,   79,   80,   81,   82,   83,
 /*  1670 */    84,   85,   86,   87,   88,   89,   90,   91,   92,   93,
 /*  1680 */    94,   95,   96,   97,  135,  135,  100,  135,  102,  135,
 /*  1690 */   135,   13,  106,  107,  135,  109,  135,  111,  112,  113,
 /*  1700 */    22,   23,   24,   25,   26,   27,   28,  135,   30,  135,
 /*  1710 */   135,  125,  126,  127,  128,  135,  135,  135,  135,  135,
 /*  1720 */   134,   78,   79,   80,   81,   82,   83,   84,   85,   86,
 /*  1730 */    87,   88,   89,   90,   91,   92,   93,   94,   95,   96,
 /*  1740 */    97,  135,  135,  100,   81,  102,  135,  135,  135,  106,
 /*  1750 */   107,  135,  109,  135,  111,  112,  113,   94,   95,  135,
 /*  1760 */   135,   98,   99,  100,  135,  135,  135,  135,  125,  126,
 /*  1770 */   127,  128,  135,  135,  135,  135,  135,  134,   78,   79,
 /*  1780 */    80,   81,   82,   83,   84,   85,   86,   87,   88,   89,
 /*  1790 */    90,   91,   92,   93,   94,   95,   96,   97,  135,  135,
 /*  1800 */   100,  135,  102,  135,  135,  135,  106,  107,  135,  109,
 /*  1810 */   135,  111,  112,  113,  135,  135,  135,  135,  135,  135,
 /*  1820 */   135,  135,  135,  135,  135,  125,  126,  127,  128,  135,
 /*  1830 */   135,  135,  135,  135,  134,   78,   79,   80,   81,   82,
 /*  1840 */    83,   84,   85,   86,   87,   88,   89,   90,   91,   92,
 /*  1850 */    93,   94,   95,   96,   97,  135,  135,  100,  135,  102,
 /*  1860 */   135,  135,  135,  106,  107,  135,  109,  135,  111,  112,
 /*  1870 */   113,  135,  135,  135,  135,  135,  135,  135,  135,  135,
 /*  1880 */   135,  135,  125,  126,  127,  128,  135,  135,  135,  135,
 /*  1890 */   135,  134,   78,   79,   80,   81,   82,   83,   84,   85,
 /*  1900 */    86,   87,   88,   89,   90,   91,   92,   93,   94,   95,
 /*  1910 */    96,   97,  135,  135,  100,  135,  102,  135,  135,  135,
 /*  1920 */   106,  107,  135,  109,  135,  111,  112,  113,  135,  135,
 /*  1930 */   135,  135,  135,  135,  135,  135,  135,  135,  135,  125,
 /*  1940 */   126,  127,  128,  135,  135,  135,  135,  135,  134,   78,
 /*  1950 */    79,   80,   81,   82,   83,   84,   85,   86,   87,   88,
 /*  1960 */    89,   90,   91,   92,   93,   94,   95,   96,   97,  135,
 /*  1970 */   135,  100,  135,  102,  135,  135,  135,  106,  107,  135,
 /*  1980 */   109,  135,  111,  112,  113,  135,  135,  135,  135,  135,
 /*  1990 */   135,  135,  135,  135,  135,  135,  125,  126,  127,  128,
 /*  2000 */   135,  135,  135,  135,  135,  134,   78,   79,   80,   81,
 /*  2010 */    82,   83,   84,   85,   86,   87,   88,   89,   90,   91,
 /*  2020 */    92,   93,   94,   95,   96,   97,  135,  135,  100,  135,
 /*  2030 */   102,  135,  135,  135,  106,  107,  135,  109,  135,  111,
 /*  2040 */   112,  113,  135,  135,  135,  135,  135,  135,  135,  135,
 /*  2050 */   135,  135,  135,  125,  126,  127,  128,  135,  135,  135,
 /*  2060 */   135,  135,  134,   78,   79,   80,   81,   82,   83,   84,
 /*  2070 */    85,   86,   87,   88,   89,   90,   91,   92,   93,   94,
 /*  2080 */    95,   96,   97,  135,  135,  100,  135,  102,  135,  135,
 /*  2090 */   135,  106,  107,  135,  109,  135,  111,  112,  113,  135,
 /*  2100 */   135,  135,  135,  135,  135,  135,  135,  135,  135,  135,
 /*  2110 */   125,  126,  127,  128,  135,  135,  135,  135,  135,  134,
 /*  2120 */    78,   79,   80,   81,   82,   83,   84,   85,   86,   87,
 /*  2130 */    88,   89,   90,   91,   92,   93,   94,   95,   96,   97,
 /*  2140 */   135,  135,  100,  135,  102,  135,  135,  135,  106,  107,
 /*  2150 */   135,  109,  135,  111,  112,  113,  135,  135,  135,  135,
 /*  2160 */   135,  135,  135,  135,  135,  135,  135,  125,  126,  127,
 /*  2170 */   128,  135,  135,  135,  135,  135,  134,   78,   79,   80,
 /*  2180 */    81,   82,   83,   84,   85,   86,   87,   88,   89,   90,
 /*  2190 */    91,   92,   93,   94,   95,   96,   97,  135,  135,  100,
 /*  2200 */   135,  102,  135,  135,  135,  106,  107,  135,  109,  135,
 /*  2210 */   111,  112,  113,  135,  135,  135,  135,  135,  135,  135,
 /*  2220 */   135,  135,  135,  135,  125,  126,  127,  128,  135,  135,
 /*  2230 */   135,  135,  135,  134,   78,   79,   80,   81,   82,   83,
 /*  2240 */    84,   85,   86,   87,   88,   89,   90,   91,   92,   93,
 /*  2250 */    94,   95,   96,   97,  135,  135,  100,  135,  102,  135,
 /*  2260 */   135,  135,  106,  107,  135,  109,  135,  111,  112,  113,
 /*  2270 */   135,  135,  135,  135,  135,  135,  135,  135,  135,  135,
 /*  2280 */   135,  125,  126,  127,  128,  135,  135,  135,  135,  135,
 /*  2290 */   134,   78,   79,   80,   81,   82,   83,   84,   85,   86,
 /*  2300 */    87,   88,   89,   90,   91,   92,   93,   94,   95,   96,
 /*  2310 */    97,  135,  135,  100,  135,  102,  135,  135,  135,  106,
 /*  2320 */   107,  135,  109,  135,  111,  112,  113,  135,  135,  135,
 /*  2330 */   135,  135,  135,  135,  135,  135,  135,  135,  125,  126,
 /*  2340 */   127,  128,  135,  135,  135,  135,  135,  134,   78,   79,
 /*  2350 */    80,   81,   82,   83,   84,   85,   86,   87,   88,   89,
 /*  2360 */    90,   91,   92,   93,   94,   95,   96,   97,  135,  135,
 /*  2370 */   100,  135,  102,  135,  135,  135,  106,  107,  135,  109,
 /*  2380 */   135,  111,  112,  113,  135,  135,  135,  135,  135,  135,
 /*  2390 */   135,  135,  135,  135,  135,  125,  126,  127,  128,  135,
 /*  2400 */   135,  135,  135,  135,  134,   78,   79,   80,   81,   82,
 /*  2410 */    83,   84,   85,   86,   87,   88,   89,   90,   91,   92,
 /*  2420 */    93,   94,   95,   96,   97,  135,  135,  100,  135,  102,
 /*  2430 */   135,  135,  135,  106,  107,  135,  109,  135,  111,  112,
 /*  2440 */   113,  135,  135,  135,  135,  135,  135,  135,  135,  135,
 /*  2450 */   135,  135,  125,  126,  127,  128,  135,  135,  135,  135,
 /*  2460 */   135,  134,   78,   79,   80,   81,   82,   83,   84,   85,
 /*  2470 */    86,   87,   88,   89,   90,   91,   92,   93,   94,   95,
 /*  2480 */    96,   97,  135,  135,  100,  135,  102,  135,  135,  135,
 /*  2490 */   106,  107,  135,  109,  135,  111,  112,  113,  135,  135,
 /*  2500 */   135,  135,  135,  135,  135,  135,  135,  135,  135,  125,
 /*  2510 */   126,  127,  128,  135,  135,  135,  135,  135,  134,   78,
 /*  2520 */    79,   80,   81,   82,   83,   84,   85,   86,   87,   88,
 /*  2530 */    89,   90,   91,   92,   93,   94,   95,   96,   97,  135,
 /*  2540 */   135,  100,  135,  102,  135,  135,  135,  106,  107,  135,
 /*  2550 */   109,  135,  111,  112,  113,  135,  135,  135,  135,  135,
 /*  2560 */   135,  135,  135,  135,  135,  135,  125,  126,  127,  128,
 /*  2570 */   135,  135,  135,  135,  135,  134,   78,   79,   80,   81,
 /*  2580 */    82,   83,   84,   85,   86,   87,   88,   89,   90,   91,
 /*  2590 */    92,   93,   94,   95,   96,   97,  135,  135,  100,  135,
 /*  2600 */   102,  135,  135,  135,  106,  107,  135,  109,  135,  111,
 /*  2610 */   112,  113,  135,  135,  135,  135,  135,  135,  135,  135,
 /*  2620 */   135,  135,  135,  125,  126,  127,  128,  135,  135,  135,
 /*  2630 */   135,  135,  134,   78,   79,   80,   81,   82,   83,   84,
 /*  2640 */    85,   86,   87,   88,   89,   90,   91,   92,   93,   94,
 /*  2650 */    95,   96,   97,  135,  135,  100,  135,  102,  135,  135,
 /*  2660 */   135,  106,  107,  135,  109,  135,  111,  112,  113,  135,
 /*  2670 */   135,  135,  135,  135,  135,  135,  135,  135,  135,  135,
 /*  2680 */   125,  126,  127,  128,  135,  135,  135,  135,  135,  134,
 /*  2690 */    78,   79,   80,   81,   82,   83,   84,   85,   86,   87,
 /*  2700 */    88,   89,   90,   91,   92,   93,   94,   95,   96,   97,
 /*  2710 */   135,  135,  100,  135,  102,  135,  135,  135,  106,  107,
 /*  2720 */   135,  109,  135,  111,  112,  113,  135,  135,  135,  135,
 /*  2730 */   135,  135,  135,  135,  135,  135,  135,  125,  126,  127,
 /*  2740 */   128,  135,  135,  135,  135,  135,  134,   78,   79,   80,
 /*  2750 */    81,   82,   83,   84,   85,   86,   87,   88,   89,   90,
 /*  2760 */    91,   92,   93,   94,   95,   96,   97,  135,  135,  100,
 /*  2770 */   135,  102,  135,  135,  135,  106,  107,  135,  109,  135,
 /*  2780 */   111,  112,  113,  135,  135,  135,  135,  135,  135,  135,
 /*  2790 */   135,  135,  135,  135,  125,  126,  127,  128,  135,  135,
 /*  2800 */   135,  135,  135,  134,   78,   79,   80,   81,   82,   83,
 /*  2810 */    84,   85,   86,   87,   88,   89,   90,   91,   92,   93,
 /*  2820 */    94,   95,   96,   97,  135,  135,  100,  135,  102,  135,
 /*  2830 */   135,  135,  106,  107,  135,  109,  135,  111,  112,  113,
 /*  2840 */   135,  135,  135,  135,  135,  135,  135,  135,  135,  135,
 /*  2850 */   135,  125,  126,  127,  128,  135,  135,  135,  135,  135,
 /*  2860 */   134,   78,   79,   80,   81,   82,   83,   84,   85,   86,
 /*  2870 */    87,   88,   89,   90,   91,   92,   93,   94,   95,   96,
 /*  2880 */    97,  135,  135,  100,  135,  102,  135,  135,  135,  106,
 /*  2890 */   107,  135,  109,  135,  111,  112,  113,  135,  135,  135,
 /*  2900 */   135,  135,  135,  135,  135,  135,  135,  135,  125,  126,
 /*  2910 */   127,  128,  135,  135,  135,  135,  135,  134,   78,   79,
 /*  2920 */    80,   81,   82,   83,   84,   85,   86,   87,   88,   89,
 /*  2930 */    90,   91,   92,   93,   94,   95,   96,   97,  135,  135,
 /*  2940 */   100,  135,  102,  135,  135,  135,  106,  107,  135,  109,
 /*  2950 */   135,  111,  112,  113,  135,  135,  135,  135,  135,  135,
 /*  2960 */   135,  135,  135,  135,  135,  125,  126,  127,  128,  135,
 /*  2970 */   135,  135,  135,  135,  134,   78,   79,   80,   81,   82,
 /*  2980 */    83,   84,   85,   86,   87,   88,   89,   90,   91,   92,
 /*  2990 */    93,   94,   95,   96,   97,  135,  135,  100,  135,  102,
 /*  3000 */   135,  135,  135,  106,  107,  135,  109,  135,  111,  112,
 /*  3010 */   113,  135,  135,  135,  135,  135,  135,  135,  135,  135,
 /*  3020 */   135,  135,  125,  126,  127,  128,  135,  135,  135,  135,
 /*  3030 */   135,  134,   78,   79,   80,   81,   82,   83,   84,   85,
 /*  3040 */    86,   87,   88,   89,   90,   91,   92,   93,   94,   95,
 /*  3050 */    96,   97,  135,  135,  100,  135,  102,  135,  135,  135,
 /*  3060 */   106,  107,  135,  109,  135,  111,  112,  113,  135,  135,
 /*  3070 */   135,  135,  135,  135,  135,  135,  135,  135,  135,  125,
 /*  3080 */   126,  127,  128,  135,  135,  135,  135,  135,  134,   78,
 /*  3090 */    79,   80,   81,   82,   83,   84,   85,   86,   87,   88,
 /*  3100 */    89,   90,   91,   92,   93,   94,   95,   96,   97,  135,
 /*  3110 */   135,  100,  135,  102,  135,  135,  135,  106,  107,  135,
 /*  3120 */   109,  135,  111,  112,  113,  135,  135,  135,  135,  135,
 /*  3130 */   135,  135,  135,  135,  135,  135,  125,  126,  127,  128,
 /*  3140 */   135,  135,  135,  135,  135,  134,   78,   79,   80,   81,
 /*  3150 */    82,   83,   84,   85,   86,   87,   88,   89,   90,   91,
 /*  3160 */    92,   93,   94,   95,   96,   97,  135,  135,  100,  135,
 /*  3170 */   102,  135,  135,  135,  106,  107,  135,  109,  135,  111,
 /*  3180 */   112,  113,  135,  135,  135,  135,  135,  135,  135,  135,
 /*  3190 */   135,  135,  135,  125,  126,  127,  128,  135,  135,  135,
 /*  3200 */   135,  135,  134,   78,   79,   80,   81,   82,   83,   84,
 /*  3210 */    85,   86,   87,   88,   89,   90,   91,   92,   93,   94,
 /*  3220 */    95,   96,   97,  135,  135,  100,  135,  102,  135,  135,
 /*  3230 */   135,  106,  107,  135,  109,  135,  111,  112,  113,  135,
 /*  3240 */   135,  135,  135,  135,  135,  135,  135,  135,  135,  135,
 /*  3250 */   125,  126,  127,  128,  135,  135,  135,  135,  135,  134,
 /*  3260 */    78,   79,   80,   81,   82,   83,   84,   85,   86,   87,
 /*  3270 */    88,   89,   90,   91,   92,   93,   94,   95,   96,   97,
 /*  3280 */   135,  135,  100,  135,  102,  135,  135,  135,  106,  107,
 /*  3290 */   135,  109,  135,  111,  112,  113,  135,  135,  135,  135,
 /*  3300 */   135,  135,  135,  135,  135,  135,  135,  125,  126,  127,
 /*  3310 */   128,  135,  135,  135,  135,  135,  134,   78,   79,   80,
 /*  3320 */    81,   82,   83,   84,   85,   86,   87,   88,   89,   90,
 /*  3330 */    91,   92,   93,   94,   95,   96,   97,  135,  135,  100,
 /*  3340 */   135,  102,  135,  135,  135,  106,  107,  135,  109,  135,
 /*  3350 */   111,  112,  113,  135,  135,  135,  135,  135,  135,  135,
 /*  3360 */   135,  135,  135,  135,  125,  126,  127,  128,  135,  135,
 /*  3370 */   135,  135,  135,  134,   78,   79,   80,   81,   82,   83,
 /*  3380 */    84,   85,   86,   87,   88,   89,   90,   91,   92,   93,
 /*  3390 */    94,   95,   96,   97,  135,  135,  100,  135,  102,  135,
 /*  3400 */   135,  135,  106,  107,  135,  109,  135,  111,  112,  113,
 /*  3410 */   135,  135,  135,  135,  135,  135,  135,  135,  135,  135,
 /*  3420 */   135,  125,  126,  127,  128,  135,  135,  135,  135,  135,
 /*  3430 */   134,   78,   79,   80,   81,   82,   83,   84,   85,   86,
 /*  3440 */    87,   88,   89,   90,   91,   92,   93,   94,   95,   96,
 /*  3450 */    97,  135,  135,  100,  135,  102,  135,  135,  135,  106,
 /*  3460 */   107,  135,  109,  135,  111,  112,  113,  135,  135,  135,
 /*  3470 */   135,  135,  135,  135,  135,  135,  135,  135,  125,  126,
 /*  3480 */   127,  128,  135,  135,  135,  135,  135,  134,   78,   79,
 /*  3490 */    80,   81,   82,   83,   84,   85,   86,   87,   88,   89,
 /*  3500 */    90,   91,   92,   93,   94,   95,   96,   97,  135,  135,
 /*  3510 */   100,  135,  102,  135,  135,  135,  106,  107,  135,  109,
 /*  3520 */   135,  111,  112,  113,  135,  135,  135,  135,  135,  135,
 /*  3530 */   135,  135,  135,  135,  135,  125,  126,  127,  128,  135,
 /*  3540 */   135,  135,  135,  135,  134,   78,   79,   80,   81,   82,
 /*  3550 */    83,   84,   85,   86,   87,   88,   89,   90,   91,   92,
 /*  3560 */    93,   94,   95,   96,   97,  135,  135,  100,  135,  102,
 /*  3570 */   135,  135,  135,  106,  107,  135,  109,  135,  111,  112,
 /*  3580 */   113,  135,  135,  135,  135,  135,  135,  135,  135,  135,
 /*  3590 */   135,  135,  125,  126,  127,  128,  135,  135,  135,  135,
 /*  3600 */   135,  134,   78,   79,   80,   81,   82,   83,   84,   85,
 /*  3610 */    86,   87,   88,   89,   90,   91,   92,   93,   94,   95,
 /*  3620 */    96,   97,  135,  135,  100,  135,  102,  135,  135,  135,
 /*  3630 */   106,  107,  135,  109,  135,  111,  112,  113,  135,  135,
 /*  3640 */   135,  135,  135,  135,  135,  135,  135,  135,  135,  125,
 /*  3650 */   126,  127,  128,  135,  135,  135,  135,  135,  134,   78,
 /*  3660 */    79,   80,   81,   82,   83,   84,   85,   86,   87,   88,
 /*  3670 */    89,   90,   91,   92,   93,   94,   95,   96,   97,  135,
 /*  3680 */   135,  100,  135,  102,  135,  135,  135,  106,  107,  135,
 /*  3690 */   109,  135,  111,  112,  113,  135,  135,  135,  135,  135,
 /*  3700 */   135,  135,  135,  135,  135,  135,  125,  126,  127,  128,
 /*  3710 */   135,  135,  135,  135,  135,  134,   78,   79,   80,   81,
 /*  3720 */    82,   83,   84,   85,   86,   87,   88,   89,   90,   91,
 /*  3730 */    92,   93,   94,   95,   96,   97,  135,  135,  100,  135,
 /*  3740 */   102,  135,  135,  135,  106,  107,  135,  109,  135,  111,
 /*  3750 */   112,  113,  135,  135,  135,  135,  135,  135,  135,  135,
 /*  3760 */   135,  135,  135,  125,  126,  127,  128,  135,  135,  135,
 /*  3770 */   135,  135,  134,   78,   79,   80,   81,   82,   83,   84,
 /*  3780 */    85,   86,   87,   88,   89,   90,   91,   92,   93,   94,
 /*  3790 */    95,   96,   97,  135,  135,  100,  135,  102,  135,  135,
 /*  3800 */   135,  106,  107,  135,  109,  135,  111,  112,  113,  135,
 /*  3810 */   135,  135,  135,  135,  135,  135,  135,  135,  135,  135,
 /*  3820 */   125,  126,  127,  128,  135,  135,  135,  135,  135,  134,
 /*  3830 */    78,   79,   80,   81,   82,   83,   84,   85,   86,   87,
 /*  3840 */    88,   89,   90,   91,   92,   93,   94,   95,   96,   97,
 /*  3850 */   135,  135,  100,  135,  102,  135,  135,  135,  106,  107,
 /*  3860 */   135,  109,  135,  111,  112,  113,  135,  135,  135,  135,
 /*  3870 */   135,  135,  135,  135,  135,  135,  135,  125,  126,  127,
 /*  3880 */   128,  135,  135,  135,  135,  135,  134,   78,   79,   80,
 /*  3890 */    81,   82,   83,   84,   85,   86,   87,   88,   89,   90,
 /*  3900 */    91,   92,   93,   94,   95,   96,   97,  135,  135,  100,
 /*  3910 */   135,  102,  135,  135,  135,  106,  107,  135,  109,  135,
 /*  3920 */   111,  112,  113,  135,  135,  135,  135,  135,  135,  135,
 /*  3930 */   135,  135,  135,  135,  125,  126,  127,  128,  135,  135,
 /*  3940 */   135,  135,  135,  134,   78,   79,   80,   81,   82,   83,
 /*  3950 */    84,   85,   86,   87,   88,   89,   90,   91,   92,   93,
 /*  3960 */    94,   95,   96,   97,  135,  135,  100,  135,  102,  135,
 /*  3970 */   135,  135,  106,  107,  135,  109,  135,  111,  112,  113,
 /*  3980 */   135,  135,  135,  135,  135,  135,  135,  135,  135,  135,
 /*  3990 */   135,  125,  126,  127,  128,  135,  135,  135,  135,  135,
 /*  4000 */   134,   78,   79,   80,   81,   82,   83,   84,   85,   86,
 /*  4010 */    87,   88,   89,   90,   91,   92,   93,   94,   95,   96,
 /*  4020 */    97,  135,  135,  100,  135,  102,  135,  135,  135,  106,
 /*  4030 */   107,  135,  109,  135,  111,  112,  113,    2,  135,  135,
 /*  4040 */   135,  135,    7,    8,    9,  135,  135,  135,  125,  126,
 /*  4050 */   127,  128,   17,   18,  135,  135,  135,  134,  135,  135,
 /*  4060 */   135,  135,   27,   28,   29,  135,   31,   32,  135,  135,
 /*  4070 */   135,  135,  135,  135,   39,   40,   41,   42,   43,   44,
 /*  4080 */    45,   46,   47,   48,  135,   50,   51,    8,  135,  135,
 /*  4090 */   135,  135,   57,  135,  135,   60,   61,   62,   19,   20,
 /*  4100 */    65,  135,  135,   68,  135,    1,   71,  135,    4,    5,
 /*  4110 */     6,  135,  135,  135,  135,  135,  135,  135,  135,   40,
 /*  4120 */    41,   42,   43,   44,   45,   46,   22,   23,   24,   25,
 /*  4130 */    26,   27,   28,  135,   30,  135,   57,  135,  135,   60,
 /*  4140 */    61,   62,  135,   76,  135,  135,  135,   68,  135,   82,
 /*  4150 */    83,  135,  135,  135,  135,  135,  135,   53,  135,  135,
 /*  4160 */   135,   94,   95,   96,   97,  135,    1,  100,   64,    4,
 /*  4170 */     5,    6,  135,  106,  107,  135,  109,  135,  111,  112,
 /*  4180 */   113,    1,  135,  135,    4,    5,    6,   22,   23,   24,
 /*  4190 */    25,   26,   27,   28,  135,   30,  135,  135,  135,  135,
 /*  4200 */    20,  135,   22,   23,   24,   25,   26,   27,   28,    1,
 /*  4210 */    30,  135,    4,    5,    6,  135,  135,  135,   53,  135,
 /*  4220 */     1,  135,  135,    4,    5,    6,  135,  135,  135,   64,
 /*  4230 */    22,   23,   24,   25,   26,   27,   28,  135,   30,  135,
 /*  4240 */    21,   22,   23,   24,   25,   26,   27,   28,  135,   30,
 /*  4250 */    81,    1,  135,  135,    4,    5,    6,  135,  135,  135,
 /*  4260 */   135,  135,  135,   94,   95,  135,  135,   98,   99,  100,
 /*  4270 */    20,   63,   22,   23,   24,   25,   26,   27,   28,    1,
 /*  4280 */    30,  135,    4,    5,    6,  135,  117,  135,  135,  135,
 /*  4290 */   135,  135,  135,  135,  135,  135,  135,  135,  135,   21,
 /*  4300 */    22,   23,   24,   25,   26,   27,   28,    1,   30,  135,
 /*  4310 */     4,    5,    6,  135,  135,  135,    8,  135,  135,  135,
 /*  4320 */   135,  135,  135,  135,  135,  135,  135,   21,   22,   23,
 /*  4330 */    24,   25,   26,   27,   28,    1,   30,  135,    4,    5,
 /*  4340 */     6,  135,  135,  135,  135,  135,  135,  135,   40,   41,
 /*  4350 */    42,   43,   44,   45,   46,  135,   22,   23,   24,   25,
 /*  4360 */    26,   27,   28,  135,   30,   57,   82,   83,   60,   61,
 /*  4370 */    62,  135,  135,  135,  135,  135,   68,  135,   94,   95,
 /*  4380 */    96,   97,  135,  135,  100,  135,  135,   53,  135,  135,
 /*  4390 */   106,  107,  135,  109,  135,  111,  112,  113,  135,   82,
 /*  4400 */    83,  135,  135,  135,  135,  135,  135,  135,  135,  135,
 /*  4410 */   135,   94,   95,   96,   97,    1,  135,  100,    4,    5,
 /*  4420 */     6,  135,  135,  106,  107,  135,  109,  135,  111,  112,
 /*  4430 */   113,    4,    5,    6,  135,  135,   22,   23,   24,   25,
 /*  4440 */    26,   27,   28,  135,   30,  135,  135,   20,  135,   22,
 /*  4450 */    23,   24,   25,   26,   27,   28,  135,   30,    4,    5,
 /*  4460 */     6,  135,  135,  135,  135,  135,  135,   13,  135,  135,
 /*  4470 */   135,  135,  135,  135,  135,  135,   22,   23,   24,   25,
 /*  4480 */    26,   27,   28,  135,   30,    4,    5,    6,  135,  135,
 /*  4490 */   135,  135,  135,  135,   13,  135,   19,   20,  135,    4,
 /*  4500 */     5,    6,  135,   22,   23,   24,   25,   26,   27,   28,
 /*  4510 */    33,   30,   35,   36,   37,  135,  135,   22,   23,   24,
 /*  4520 */    25,   26,   27,   28,   81,   30,  135,  135,  135,  135,
 /*  4530 */   135,   54,  135,   56,  135,  135,   59,   94,   95,  135,
 /*  4540 */   135,   98,   99,  100,  135,  135,  135,  135,  135,  135,
 /*  4550 */   135,  135,  135,  135,  135,  135,  135,  135,  135,  135,
 /*  4560 */   117,
);
    const YY_SHIFT_USE_DFLT = -21;
    const YY_SHIFT_MAX = 187;
    static public $yy_shift_ofst = array(
 /*     0 */  1269,  625,  444,  444,  732, 1485, 1485, 1413, 1341, 1591,
 /*    10 */  1591, 1591, 1269, 1591, 1591,  516, 1019, 1163, 1091, 1591,
 /*    20 */  1591, 1591, 1591, 1591, 1591, 1591, 1591, 1591, 1591, 1591,
 /*    30 */  1591, 1591, 1591, 1591, 1591, 1591, 1591, 1591, 1591, 1591,
 /*    40 */  1591, 1591, 1591, 1591, 1591, 1591, 1591, 1591, 1591, 1591,
 /*    50 */  1591, 1591, 1591, 1591, 1591, 1591, 1591, 4035, 4079, 4308,
 /*    60 */  4308,   46,   46, 1088,   46,   46, 1088,  270,  272, 4104,
 /*    70 */  4165, 4250, 4250, 4427, 4427,  272, 4306, 4334, 4180, 4219,
 /*    80 */  4208, 4278, 4414, 4414, 4414, 4414, 4414, 4481, 4454, 4414,
 /*    90 */  4414, 4414, 4414, 4495, 4495, 4495,   18,  820, 1678,  942,
 /*   100 */   877,  877,  877,  877,  877,  877,  877,  877,  877, 1070,
 /*   110 */    74, 1070, 1142, 1142,  188,  243,   29,  476,  476,   -3,
 /*   120 */   374,  374,  374,  374,  374,  334,  334, 4477,  549,  658,
 /*   130 */   179,  508,  -20,   96,   15,  161,   44,   44,  340,  340,
 /*   140 */   340,  119,  174,  119,   44,  340,   44,  119,  119,  119,
 /*   150 */   119,  119,   44,   44,  119,  174,    6,    6,  119,  119,
 /*   160 */   174,  349,  349,  416,  138,  473,  351,  704,  617,  731,
 /*   170 */   306,  190,  122,  206,   89,   75,  276,  231,  302,  246,
 /*   180 */   271,  245,  232,  224,  203,  202,  226,  192,
);
    const YY_REDUCE_USE_DFLT = -79;
    const YY_REDUCE_MAX = 160;
    static public $yy_reduce_ofst = array(
 /*     0 */   -74,  268,  154,  -17,   40,  211,   97,  332,  513,  727,
 /*    10 */   620,  784,  907,  850, 1157, 3239, 3182, 3353, 3125, 3011,
 /*    20 */  2840, 2783, 2897, 2954, 3296, 3695, 3809, 3752, 3923, 3866,
 /*    30 */  3581, 3638, 3467, 3524, 3410, 3068, 1928, 1814, 1871, 1985,
 /*    40 */  2042, 1757, 1586, 1479, 1643, 1700, 2099, 2612, 2555, 2669,
 /*    50 */  2726, 2498, 2213, 2156, 2270, 2327, 2441, 2384, 4067, 4317,
 /*    60 */  4284, 4443, 4169,  819, 1663,   64,  435,  420,  236,  447,
 /*    70 */   458,  371,  150,  489,  535,  178,  -78,  -78,  -78,  -78,
 /*    80 */   -78,  -78,  -78,  -78,  -78,  -78,  -78,  -78,  -78,  -78,
 /*    90 */   -78,  -78,  -78,  -78,  -78,  -78,  -78,  -78,  -78,  -78,
 /*   100 */   -78,  -78,  -78,  -78,  -78,  -78,  -78,  -78,  -78,  360,
 /*   110 */   -78,  273,  273,  360,  -78,  -78,  -78,  -13,  -13,  -78,
 /*   120 */   -78,  -78,  -78,  -78,  -78,   68,   63,  357,  297,  297,
 /*   130 */   298,  323,  264,  259,  217,  199,  279,  304,  294,  328,
 /*   140 */   362,  391,  344,  359,  104,  337,  343,  379,  366,  380,
 /*   150 */   325,  -47,   79,  104,  145,   83,  218,   47,   30,  249,
 /*   160 */   168,
);
    static public $yyExpectedTokens = array(
        /* 0 */ array(2, 4, 5, 6, 7, 8, 9, 17, 18, 20, 27, 28, 29, 31, 32, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 57, 60, 61, 62, 65, 68, 71, ),
        /* 1 */ array(2, 4, 5, 6, 7, 8, 9, 17, 18, 20, 27, 28, 29, 31, 32, 34, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 57, 60, 61, 62, 65, 68, 71, ),
        /* 2 */ array(2, 4, 5, 6, 7, 8, 9, 17, 18, 20, 27, 28, 29, 31, 32, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 57, 60, 61, 62, 63, 65, 68, 71, ),
        /* 3 */ array(2, 4, 5, 6, 7, 8, 9, 17, 18, 20, 27, 28, 29, 31, 32, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 57, 60, 61, 62, 63, 65, 68, 71, ),
        /* 4 */ array(2, 4, 5, 6, 7, 8, 9, 17, 18, 27, 28, 29, 31, 32, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 53, 57, 60, 61, 62, 64, 65, 68, 71, ),
        /* 5 */ array(2, 4, 5, 6, 7, 8, 9, 17, 18, 20, 27, 28, 29, 31, 32, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 57, 60, 61, 62, 65, 68, 71, ),
        /* 6 */ array(2, 4, 5, 6, 7, 8, 9, 17, 18, 20, 27, 28, 29, 31, 32, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 57, 60, 61, 62, 65, 68, 71, ),
        /* 7 */ array(2, 4, 5, 6, 7, 8, 9, 17, 18, 20, 27, 28, 29, 31, 32, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 57, 60, 61, 62, 65, 68, 71, ),
        /* 8 */ array(2, 4, 5, 6, 7, 8, 9, 17, 18, 21, 27, 28, 29, 31, 32, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 57, 60, 61, 62, 65, 68, 71, ),
        /* 9 */ array(2, 4, 5, 6, 7, 8, 9, 17, 18, 27, 28, 29, 31, 32, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 57, 60, 61, 62, 65, 68, 71, ),
        /* 10 */ array(2, 4, 5, 6, 7, 8, 9, 17, 18, 27, 28, 29, 31, 32, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 57, 60, 61, 62, 65, 68, 71, ),
        /* 11 */ array(2, 4, 5, 6, 7, 8, 9, 17, 18, 27, 28, 29, 31, 32, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 57, 60, 61, 62, 65, 68, 71, ),
        /* 12 */ array(2, 4, 5, 6, 7, 8, 9, 17, 18, 20, 27, 28, 29, 31, 32, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 57, 60, 61, 62, 65, 68, 71, ),
        /* 13 */ array(2, 4, 5, 6, 7, 8, 9, 17, 18, 27, 28, 29, 31, 32, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 57, 60, 61, 62, 65, 68, 71, ),
        /* 14 */ array(2, 4, 5, 6, 7, 8, 9, 17, 18, 27, 28, 29, 31, 32, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 57, 60, 61, 62, 65, 68, 71, ),
        /* 15 */ array(2, 4, 5, 6, 7, 8, 9, 17, 18, 20, 27, 28, 29, 31, 32, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 57, 60, 61, 62, 65, 68, 71, ),
        /* 16 */ array(2, 4, 5, 6, 7, 8, 9, 17, 18, 20, 27, 28, 29, 31, 32, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 57, 60, 61, 62, 65, 68, 71, ),
        /* 17 */ array(2, 4, 5, 6, 7, 8, 9, 17, 18, 20, 27, 28, 29, 31, 32, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 57, 60, 61, 62, 65, 68, 71, ),
        /* 18 */ array(2, 4, 5, 6, 7, 8, 9, 17, 18, 20, 27, 28, 29, 31, 32, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 57, 60, 61, 62, 65, 68, 71, ),
        /* 19 */ array(2, 4, 5, 6, 7, 8, 9, 17, 18, 27, 28, 29, 31, 32, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 57, 60, 61, 62, 65, 68, 71, ),
        /* 20 */ array(2, 4, 5, 6, 7, 8, 9, 17, 18, 27, 28, 29, 31, 32, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 57, 60, 61, 62, 65, 68, 71, ),
        /* 21 */ array(2, 4, 5, 6, 7, 8, 9, 17, 18, 27, 28, 29, 31, 32, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 57, 60, 61, 62, 65, 68, 71, ),
        /* 22 */ array(2, 4, 5, 6, 7, 8, 9, 17, 18, 27, 28, 29, 31, 32, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 57, 60, 61, 62, 65, 68, 71, ),
        /* 23 */ array(2, 4, 5, 6, 7, 8, 9, 17, 18, 27, 28, 29, 31, 32, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 57, 60, 61, 62, 65, 68, 71, ),
        /* 24 */ array(2, 4, 5, 6, 7, 8, 9, 17, 18, 27, 28, 29, 31, 32, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 57, 60, 61, 62, 65, 68, 71, ),
        /* 25 */ array(2, 4, 5, 6, 7, 8, 9, 17, 18, 27, 28, 29, 31, 32, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 57, 60, 61, 62, 65, 68, 71, ),
        /* 26 */ array(2, 4, 5, 6, 7, 8, 9, 17, 18, 27, 28, 29, 31, 32, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 57, 60, 61, 62, 65, 68, 71, ),
        /* 27 */ array(2, 4, 5, 6, 7, 8, 9, 17, 18, 27, 28, 29, 31, 32, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 57, 60, 61, 62, 65, 68, 71, ),
        /* 28 */ array(2, 4, 5, 6, 7, 8, 9, 17, 18, 27, 28, 29, 31, 32, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 57, 60, 61, 62, 65, 68, 71, ),
        /* 29 */ array(2, 4, 5, 6, 7, 8, 9, 17, 18, 27, 28, 29, 31, 32, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 57, 60, 61, 62, 65, 68, 71, ),
        /* 30 */ array(2, 4, 5, 6, 7, 8, 9, 17, 18, 27, 28, 29, 31, 32, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 57, 60, 61, 62, 65, 68, 71, ),
        /* 31 */ array(2, 4, 5, 6, 7, 8, 9, 17, 18, 27, 28, 29, 31, 32, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 57, 60, 61, 62, 65, 68, 71, ),
        /* 32 */ array(2, 4, 5, 6, 7, 8, 9, 17, 18, 27, 28, 29, 31, 32, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 57, 60, 61, 62, 65, 68, 71, ),
        /* 33 */ array(2, 4, 5, 6, 7, 8, 9, 17, 18, 27, 28, 29, 31, 32, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 57, 60, 61, 62, 65, 68, 71, ),
        /* 34 */ array(2, 4, 5, 6, 7, 8, 9, 17, 18, 27, 28, 29, 31, 32, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 57, 60, 61, 62, 65, 68, 71, ),
        /* 35 */ array(2, 4, 5, 6, 7, 8, 9, 17, 18, 27, 28, 29, 31, 32, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 57, 60, 61, 62, 65, 68, 71, ),
        /* 36 */ array(2, 4, 5, 6, 7, 8, 9, 17, 18, 27, 28, 29, 31, 32, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 57, 60, 61, 62, 65, 68, 71, ),
        /* 37 */ array(2, 4, 5, 6, 7, 8, 9, 17, 18, 27, 28, 29, 31, 32, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 57, 60, 61, 62, 65, 68, 71, ),
        /* 38 */ array(2, 4, 5, 6, 7, 8, 9, 17, 18, 27, 28, 29, 31, 32, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 57, 60, 61, 62, 65, 68, 71, ),
        /* 39 */ array(2, 4, 5, 6, 7, 8, 9, 17, 18, 27, 28, 29, 31, 32, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 57, 60, 61, 62, 65, 68, 71, ),
        /* 40 */ array(2, 4, 5, 6, 7, 8, 9, 17, 18, 27, 28, 29, 31, 32, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 57, 60, 61, 62, 65, 68, 71, ),
        /* 41 */ array(2, 4, 5, 6, 7, 8, 9, 17, 18, 27, 28, 29, 31, 32, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 57, 60, 61, 62, 65, 68, 71, ),
        /* 42 */ array(2, 4, 5, 6, 7, 8, 9, 17, 18, 27, 28, 29, 31, 32, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 57, 60, 61, 62, 65, 68, 71, ),
        /* 43 */ array(2, 4, 5, 6, 7, 8, 9, 17, 18, 27, 28, 29, 31, 32, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 57, 60, 61, 62, 65, 68, 71, ),
        /* 44 */ array(2, 4, 5, 6, 7, 8, 9, 17, 18, 27, 28, 29, 31, 32, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 57, 60, 61, 62, 65, 68, 71, ),
        /* 45 */ array(2, 4, 5, 6, 7, 8, 9, 17, 18, 27, 28, 29, 31, 32, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 57, 60, 61, 62, 65, 68, 71, ),
        /* 46 */ array(2, 4, 5, 6, 7, 8, 9, 17, 18, 27, 28, 29, 31, 32, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 57, 60, 61, 62, 65, 68, 71, ),
        /* 47 */ array(2, 4, 5, 6, 7, 8, 9, 17, 18, 27, 28, 29, 31, 32, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 57, 60, 61, 62, 65, 68, 71, ),
        /* 48 */ array(2, 4, 5, 6, 7, 8, 9, 17, 18, 27, 28, 29, 31, 32, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 57, 60, 61, 62, 65, 68, 71, ),
        /* 49 */ array(2, 4, 5, 6, 7, 8, 9, 17, 18, 27, 28, 29, 31, 32, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 57, 60, 61, 62, 65, 68, 71, ),
        /* 50 */ array(2, 4, 5, 6, 7, 8, 9, 17, 18, 27, 28, 29, 31, 32, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 57, 60, 61, 62, 65, 68, 71, ),
        /* 51 */ array(2, 4, 5, 6, 7, 8, 9, 17, 18, 27, 28, 29, 31, 32, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 57, 60, 61, 62, 65, 68, 71, ),
        /* 52 */ array(2, 4, 5, 6, 7, 8, 9, 17, 18, 27, 28, 29, 31, 32, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 57, 60, 61, 62, 65, 68, 71, ),
        /* 53 */ array(2, 4, 5, 6, 7, 8, 9, 17, 18, 27, 28, 29, 31, 32, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 57, 60, 61, 62, 65, 68, 71, ),
        /* 54 */ array(2, 4, 5, 6, 7, 8, 9, 17, 18, 27, 28, 29, 31, 32, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 57, 60, 61, 62, 65, 68, 71, ),
        /* 55 */ array(2, 4, 5, 6, 7, 8, 9, 17, 18, 27, 28, 29, 31, 32, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 57, 60, 61, 62, 65, 68, 71, ),
        /* 56 */ array(2, 4, 5, 6, 7, 8, 9, 17, 18, 27, 28, 29, 31, 32, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 57, 60, 61, 62, 65, 68, 71, ),
        /* 57 */ array(2, 7, 8, 9, 17, 18, 27, 28, 29, 31, 32, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 50, 51, 57, 60, 61, 62, 65, 68, 71, ),
        /* 58 */ array(8, 19, 20, 40, 41, 42, 43, 44, 45, 46, 57, 60, 61, 62, 68, ),
        /* 59 */ array(8, 40, 41, 42, 43, 44, 45, 46, 57, 60, 61, 62, 68, ),
        /* 60 */ array(8, 40, 41, 42, 43, 44, 45, 46, 57, 60, 61, 62, 68, ),
        /* 61 */ array(40, 41, 42, 47, 61, ),
        /* 62 */ array(40, 41, 42, 47, 61, ),
        /* 63 */ array(40, 57, 61, 62, ),
        /* 64 */ array(40, 41, 42, 47, 61, ),
        /* 65 */ array(40, 41, 42, 47, 61, ),
        /* 66 */ array(40, 57, 61, 62, ),
        /* 67 */ array(40, 57, 62, 70, ),
        /* 68 */ array(40, 57, 62, ),
        /* 69 */ array(1, 4, 5, 6, 22, 23, 24, 25, 26, 27, 28, 30, 53, 64, ),
        /* 70 */ array(1, 4, 5, 6, 22, 23, 24, 25, 26, 27, 28, 30, 53, 64, ),
        /* 71 */ array(1, 4, 5, 6, 20, 22, 23, 24, 25, 26, 27, 28, 30, ),
        /* 72 */ array(1, 4, 5, 6, 20, 22, 23, 24, 25, 26, 27, 28, 30, ),
        /* 73 */ array(4, 5, 6, 20, 22, 23, 24, 25, 26, 27, 28, 30, ),
        /* 74 */ array(4, 5, 6, 20, 22, 23, 24, 25, 26, 27, 28, 30, ),
        /* 75 */ array(40, 57, 62, ),
        /* 76 */ array(1, 4, 5, 6, 21, 22, 23, 24, 25, 26, 27, 28, 30, ),
        /* 77 */ array(1, 4, 5, 6, 22, 23, 24, 25, 26, 27, 28, 30, 53, ),
        /* 78 */ array(1, 4, 5, 6, 20, 22, 23, 24, 25, 26, 27, 28, 30, ),
        /* 79 */ array(1, 4, 5, 6, 21, 22, 23, 24, 25, 26, 27, 28, 30, ),
        /* 80 */ array(1, 4, 5, 6, 22, 23, 24, 25, 26, 27, 28, 30, 63, ),
        /* 81 */ array(1, 4, 5, 6, 21, 22, 23, 24, 25, 26, 27, 28, 30, ),
        /* 82 */ array(1, 4, 5, 6, 22, 23, 24, 25, 26, 27, 28, 30, ),
        /* 83 */ array(1, 4, 5, 6, 22, 23, 24, 25, 26, 27, 28, 30, ),
        /* 84 */ array(1, 4, 5, 6, 22, 23, 24, 25, 26, 27, 28, 30, ),
        /* 85 */ array(1, 4, 5, 6, 22, 23, 24, 25, 26, 27, 28, 30, ),
        /* 86 */ array(1, 4, 5, 6, 22, 23, 24, 25, 26, 27, 28, 30, ),
        /* 87 */ array(4, 5, 6, 13, 22, 23, 24, 25, 26, 27, 28, 30, ),
        /* 88 */ array(4, 5, 6, 13, 22, 23, 24, 25, 26, 27, 28, 30, ),
        /* 89 */ array(1, 4, 5, 6, 22, 23, 24, 25, 26, 27, 28, 30, ),
        /* 90 */ array(1, 4, 5, 6, 22, 23, 24, 25, 26, 27, 28, 30, ),
        /* 91 */ array(1, 4, 5, 6, 22, 23, 24, 25, 26, 27, 28, 30, ),
        /* 92 */ array(1, 4, 5, 6, 22, 23, 24, 25, 26, 27, 28, 30, ),
        /* 93 */ array(4, 5, 6, 22, 23, 24, 25, 26, 27, 28, 30, ),
        /* 94 */ array(4, 5, 6, 22, 23, 24, 25, 26, 27, 28, 30, ),
        /* 95 */ array(4, 5, 6, 22, 23, 24, 25, 26, 27, 28, 30, ),
        /* 96 */ array(12, 13, 22, 23, 24, 25, 26, 27, 28, 30, ),
        /* 97 */ array(12, 22, 23, 24, 25, 26, 27, 28, 30, ),
        /* 98 */ array(13, 22, 23, 24, 25, 26, 27, 28, 30, ),
        /* 99 */ array(13, 22, 23, 24, 25, 26, 27, 28, 30, ),
        /* 100 */ array(22, 23, 24, 25, 26, 27, 28, 30, ),
        /* 101 */ array(22, 23, 24, 25, 26, 27, 28, 30, ),
        /* 102 */ array(22, 23, 24, 25, 26, 27, 28, 30, ),
        /* 103 */ array(22, 23, 24, 25, 26, 27, 28, 30, ),
        /* 104 */ array(22, 23, 24, 25, 26, 27, 28, 30, ),
        /* 105 */ array(22, 23, 24, 25, 26, 27, 28, 30, ),
        /* 106 */ array(22, 23, 24, 25, 26, 27, 28, 30, ),
        /* 107 */ array(22, 23, 24, 25, 26, 27, 28, 30, ),
        /* 108 */ array(22, 23, 24, 25, 26, 27, 28, 30, ),
        /* 109 */ array(33, 35, 36, 37, 54, 56, 59, ),
        /* 110 */ array(23, 24, 25, 26, 27, 28, 30, ),
        /* 111 */ array(33, 35, 36, 37, 54, 56, 59, ),
        /* 112 */ array(35, 36, 37, 54, 56, 59, ),
        /* 113 */ array(35, 36, 37, 54, 56, 59, ),
        /* 114 */ array(24, 25, 26, 27, 28, 30, ),
        /* 115 */ array(25, 26, 27, 28, 30, ),
        /* 116 */ array(26, 27, 28, 30, ),
        /* 117 */ array(1, 4, 5, 6, ),
        /* 118 */ array(1, 4, 5, 6, ),
        /* 119 */ array(27, 28, 30, ),
        /* 120 */ array(30, ),
        /* 121 */ array(30, ),
        /* 122 */ array(30, ),
        /* 123 */ array(30, ),
        /* 124 */ array(30, ),
        /* 125 */ array(72, ),
        /* 126 */ array(72, ),
        /* 127 */ array(19, 20, 33, 35, 36, 37, 54, 56, 59, ),
        /* 128 */ array(3, 21, 72, ),
        /* 129 */ array(3, 21, 72, ),
        /* 130 */ array(50, 51, ),
        /* 131 */ array(2, 20, ),
        /* 132 */ array(54, 56, ),
        /* 133 */ array(20, 52, ),
        /* 134 */ array(66, 67, ),
        /* 135 */ array(10, 11, ),
        /* 136 */ array(40, ),
        /* 137 */ array(40, ),
        /* 138 */ array(52, ),
        /* 139 */ array(52, ),
        /* 140 */ array(52, ),
        /* 141 */ array(20, ),
        /* 142 */ array(33, ),
        /* 143 */ array(20, ),
        /* 144 */ array(40, ),
        /* 145 */ array(52, ),
        /* 146 */ array(40, ),
        /* 147 */ array(20, ),
        /* 148 */ array(20, ),
        /* 149 */ array(20, ),
        /* 150 */ array(20, ),
        /* 151 */ array(20, ),
        /* 152 */ array(40, ),
        /* 153 */ array(40, ),
        /* 154 */ array(20, ),
        /* 155 */ array(33, ),
        /* 156 */ array(52, ),
        /* 157 */ array(52, ),
        /* 158 */ array(20, ),
        /* 159 */ array(20, ),
        /* 160 */ array(33, ),
        /* 161 */ array(33, 35, 36, 37, 54, 56, 59, ),
        /* 162 */ array(33, 35, 36, 37, 54, 56, 59, ),
        /* 163 */ array(20, 38, 52, 63, ),
        /* 164 */ array(16, 19, 31, 32, ),
        /* 165 */ array(20, 38, 58, ),
        /* 166 */ array(20, 21, 38, ),
        /* 167 */ array(20, 21, 38, ),
        /* 168 */ array(20, 34, 38, ),
        /* 169 */ array(20, 21, 38, ),
        /* 170 */ array(20, 38, 63, ),
        /* 171 */ array(21, 38, ),
        /* 172 */ array(21, 38, ),
        /* 173 */ array(14, 53, ),
        /* 174 */ array(49, 52, ),
        /* 175 */ array(38, 69, ),
        /* 176 */ array(38, ),
        /* 177 */ array(21, ),
        /* 178 */ array(14, ),
        /* 179 */ array(69, ),
        /* 180 */ array(15, ),
        /* 181 */ array(38, ),
        /* 182 */ array(21, ),
        /* 183 */ array(3, ),
        /* 184 */ array(52, ),
        /* 185 */ array(55, ),
        /* 186 */ array(38, ),
        /* 187 */ array(66, ),
        /* 188 */ array(),
        /* 189 */ array(),
        /* 190 */ array(),
        /* 191 */ array(),
        /* 192 */ array(),
        /* 193 */ array(),
        /* 194 */ array(),
        /* 195 */ array(),
        /* 196 */ array(),
        /* 197 */ array(),
        /* 198 */ array(),
        /* 199 */ array(),
        /* 200 */ array(),
        /* 201 */ array(),
        /* 202 */ array(),
        /* 203 */ array(),
        /* 204 */ array(),
        /* 205 */ array(),
        /* 206 */ array(),
        /* 207 */ array(),
        /* 208 */ array(),
        /* 209 */ array(),
        /* 210 */ array(),
        /* 211 */ array(),
        /* 212 */ array(),
        /* 213 */ array(),
        /* 214 */ array(),
        /* 215 */ array(),
        /* 216 */ array(),
        /* 217 */ array(),
        /* 218 */ array(),
        /* 219 */ array(),
        /* 220 */ array(),
        /* 221 */ array(),
        /* 222 */ array(),
        /* 223 */ array(),
        /* 224 */ array(),
        /* 225 */ array(),
        /* 226 */ array(),
        /* 227 */ array(),
        /* 228 */ array(),
        /* 229 */ array(),
        /* 230 */ array(),
        /* 231 */ array(),
        /* 232 */ array(),
        /* 233 */ array(),
        /* 234 */ array(),
        /* 235 */ array(),
        /* 236 */ array(),
        /* 237 */ array(),
        /* 238 */ array(),
        /* 239 */ array(),
        /* 240 */ array(),
        /* 241 */ array(),
        /* 242 */ array(),
        /* 243 */ array(),
        /* 244 */ array(),
        /* 245 */ array(),
        /* 246 */ array(),
        /* 247 */ array(),
        /* 248 */ array(),
        /* 249 */ array(),
        /* 250 */ array(),
        /* 251 */ array(),
        /* 252 */ array(),
        /* 253 */ array(),
        /* 254 */ array(),
        /* 255 */ array(),
        /* 256 */ array(),
        /* 257 */ array(),
        /* 258 */ array(),
        /* 259 */ array(),
        /* 260 */ array(),
        /* 261 */ array(),
        /* 262 */ array(),
        /* 263 */ array(),
        /* 264 */ array(),
        /* 265 */ array(),
        /* 266 */ array(),
        /* 267 */ array(),
        /* 268 */ array(),
        /* 269 */ array(),
        /* 270 */ array(),
        /* 271 */ array(),
        /* 272 */ array(),
        /* 273 */ array(),
        /* 274 */ array(),
        /* 275 */ array(),
        /* 276 */ array(),
        /* 277 */ array(),
        /* 278 */ array(),
        /* 279 */ array(),
        /* 280 */ array(),
        /* 281 */ array(),
        /* 282 */ array(),
        /* 283 */ array(),
        /* 284 */ array(),
        /* 285 */ array(),
        /* 286 */ array(),
        /* 287 */ array(),
        /* 288 */ array(),
        /* 289 */ array(),
        /* 290 */ array(),
        /* 291 */ array(),
        /* 292 */ array(),
        /* 293 */ array(),
        /* 294 */ array(),
        /* 295 */ array(),
        /* 296 */ array(),
        /* 297 */ array(),
        /* 298 */ array(),
        /* 299 */ array(),
        /* 300 */ array(),
        /* 301 */ array(),
        /* 302 */ array(),
        /* 303 */ array(),
        /* 304 */ array(),
        /* 305 */ array(),
        /* 306 */ array(),
        /* 307 */ array(),
        /* 308 */ array(),
        /* 309 */ array(),
        /* 310 */ array(),
        /* 311 */ array(),
        /* 312 */ array(),
        /* 313 */ array(),
);
    static public $yy_default = array(
 /*     0 */   314,  510,  510,  510,  510,  510,  510,  510,  510,  365,
 /*    10 */   510,  510,  510,  319,  510,  510,  510,  510,  510,  510,
 /*    20 */   510,  510,  510,  510,  510,  510,  510,  510,  510,  510,
 /*    30 */   510,  510,  510,  510,  510,  510,  510,  510,  510,  510,
 /*    40 */   510,  510,  510,  510,  431,  510,  510,  510,  510,  510,
 /*    50 */   510,  429,  510,  510,  510,  510,  510,  358,  404,  510,
 /*    60 */   510,  399,  399,  366,  510,  365,  510,  510,  510,  396,
 /*    70 */   437,  510,  510,  406,  410,  510,  510,  437,  510,  510,
 /*    80 */   510,  510,  430,  440,  371,  428,  490,  451,  449,  439,
 /*    90 */   320,  491,  351,  450,  458,  452,  471,  473,  475,  472,
 /*   100 */   476,  509,  348,  477,  357,  507,  446,  474,  347,  326,
 /*   110 */   505,  325,  416,  416,  504,  506,  503,  510,  321,  502,
 /*   120 */   492,  501,  494,  493,  500,  510,  510,  408,  510,  510,
 /*   130 */   510,  510,  510,  510,  441,  510,  510,  510,  364,  364,
 /*   140 */   364,  510,  510,  510,  510,  364,  392,  510,  510,  510,
 /*   150 */   510,  510,  510,  421,  510,  510,  364,  364,  510,  510,
 /*   160 */   414,  495,  496,  426,  381,  510,  510,  510,  510,  510,
 /*   170 */   510,  510,  510,  369,  510,  510,  484,  510,  384,  510,
 /*   180 */   350,  315,  510,  488,  469,  510,  510,  442,  337,  360,
 /*   190 */   316,  401,  400,  398,  352,  355,  508,  402,  468,  356,
 /*   200 */   353,  354,  370,  419,  374,  394,  467,  466,  375,  349,
 /*   210 */   418,  465,  407,  426,  368,  403,  367,  462,  464,  373,
 /*   220 */   470,  372,  397,  478,  346,  455,  460,  463,  345,  344,
 /*   230 */   340,  341,  342,  343,  359,  317,  363,  377,  380,  497,
 /*   240 */   362,  361,  338,  454,  459,  336,  335,  389,  390,  391,
 /*   250 */   393,  339,  378,  318,  322,  323,  324,  379,  395,  331,
 /*   260 */   332,  333,  334,  330,  329,  413,  327,  328,  498,  382,
 /*   270 */   489,  485,  482,  480,  384,  487,  461,  479,  483,  486,
 /*   280 */   481,  457,  434,  432,  436,  435,  424,  438,  423,  376,
 /*   290 */   433,  456,  453,  412,  417,  409,  411,  388,  387,  383,
 /*   300 */   385,  386,  415,  420,  443,  445,  447,  448,  444,  499,
 /*   310 */   422,  425,  427,  405,
);
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    self::YYNOCODE      is a number which corresponds
**                        to no legal terminal or nonterminal number.  This
**                        number is used to fill in empty slots of the hash 
**                        table.
**    self::YYFALLBACK    If defined, this indicates that one or more tokens
**                        have fall-back values which should be used if the
**                        original value of the token will not parse.
**    self::YYSTACKDEPTH  is the maximum depth of the parser's stack.
**    self::YYNSTATE      the combined number of states.
**    self::YYNRULE       the number of rules in the grammar
**    self::YYERRORSYMBOL is the code number of the error symbol.  If not
**                        defined, then do no error processing.
*/
    const YYNOCODE = 136;
    const YYSTACKDEPTH = 100;
    const YYNSTATE = 314;
    const YYNRULE = 196;
    const YYERRORSYMBOL = 73;
    const YYERRSYMDT = 'yy0';
    const YYFALLBACK = 0;
    /** The next table maps tokens into fallback tokens.  If a construct
     * like the following:
     * 
     *      %fallback ID X Y Z.
     *
     * appears in the grammer, then ID becomes a fallback token for X, Y,
     * and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
     * but it does not parse, the type of the token is changed to ID and
     * the parse is retried before an error is thrown.
     */
    static public $yyFallback = array(
    );
    /**
     * Turn parser tracing on by giving a stream to which to write the trace
     * and a prompt to preface each trace message.  Tracing is turned off
     * by making either argument NULL 
     *
     * Inputs:
     * 
     * - A stream resource to which trace output should be written.
     *   If NULL, then tracing is turned off.
     * - A prefix string written at the beginning of every
     *   line of trace output.  If NULL, then tracing is
     *   turned off.
     *
     * Outputs:
     * 
     * - None.
     * @param resource
     * @param string
     */
    static function Trace($TraceFILE, $zTracePrompt)
    {
        if (!$TraceFILE) {
            $zTracePrompt = 0;
        } elseif (!$zTracePrompt) {
            $TraceFILE = 0;
        }
        self::$yyTraceFILE = $TraceFILE;
        self::$yyTracePrompt = $zTracePrompt;
    }

    /**
     * Output debug information to output (php://output stream)
     */
    static function PrintTrace()
    {
        self::$yyTraceFILE = fopen('php://output', 'w');
        self::$yyTracePrompt = '';
    }

    /**
     * @var resource|0
     */
    static public $yyTraceFILE;
    /**
     * String to prepend to debug output
     * @var string|0
     */
    static public $yyTracePrompt;
    /**
     * @var int
     */
    public $yyidx = -1;                    /* Index of top element in stack */
    /**
     * @var int
     */
    public $yyerrcnt;                 /* Shifts left before out of the error */
    /**
     * @var array
     */
    public $yystack = array();  /* The parser's stack */

    /**
     * For tracing shifts, the names of all terminals and nonterminals
     * are required.  The following table supplies these names
     * @var array
     */
    static public $yyTokenName = array( 
  '$',             'YY_POST_IF',    'YY_IF',         'YY_ELSE',     
  'YY_FOR',        'YY_WHILE',      'YY_UNTIL',      'YY_LOOP',     
  'YY_SUPER',      'YY_CLASS',      'YY_FORIN',      'YY_FOROF',    
  'YY_BY',         'YY_WHEN',       'YY_EQUALS',     'YY_COLON',    
  'YY_COMPOUND_ASSIGN',  'YY_RETURN',     'YY_THROW',      'YY_EXTENDS',  
  'YY_INDENT',     'YY_OUTDENT',    'YY_LOGIC',      'YY_COMPARE',  
  'YY_RELATION',   'YY_SHIFT',      'YY_MATH',       'YY_PLUS',     
  'YY_MINUS',      'YY_UNARY',      'YY_EXISTENTIAL',  'YY_INCREMENT',
  'YY_DECREMENT',  'YY_CALL_START',  'YY_CALL_END',   'YY_ACCESSOR', 
  'YY_EXISTENTIAL_ACCESSOR',  'YY_PROTOTYPE',  'YY_TERMINATOR',  'YY_STATEMENT',
  'YY_IDENTIFIER',  'YY_NUMBER',     'YY_STRING',     'YY_JS',       
  'YY_REGEX',      'YY_DEBUGGER',   'YY_BOOL',       'YY_HERECOMMENT',
  'YY_PARAM_START',  'YY_PARAM_END',  'YY_FUNC',       'YY_BOUND_FUNC',
  'YY_COMMA',      'YY_RANGE_EXCLUSIVE',  'YY_INDEX_START',  'YY_INDEX_END',
  'YY_INDEX_SOAK',  'YY_OBJECT_START',  'YY_OBJECT_END',  'YY_FUNC_EXIST',
  'YY_THIS',       'YY_AT_SIGN',    'YY_ARRAY_START',  'YY_ARRAY_END',
  'YY_RANGE_INCLUSIVE',  'YY_TRY',        'YY_FINALLY',    'YY_CATCH',    
  'YY_PAREN_START',  'YY_PAREN_END',  'YY_OWN',        'YY_SWITCH',   
  'YY_LEADING_WHEN',  'error',         'root',          'body',        
  'block',         'line',          'expression',    'statement',   
  'return',        'comment',       'value',         'invocation',  
  'code',          'operation',     'assign',        'if',          
  'try',           'while',         'for',           'switch',      
  'class',         'throw',         'identifier',    'alphanumeric',
  'literal',       'assignable',    'assignObj',     'objAssignable',
  'thisProperty',  'paramList',     'funcGlyph',     'optComma',    
  'param',         'paramVar',      'array',         'object',      
  'splat',         'simpleAssignable',  'accessor',      'parenthetical',
  'range',         'this',          'index',         'indexValue',  
  'slice',         'assignList',    'optFuncExist',  'arguments',   
  'argList',       'rangeDots',     'arg',           'simpleArgs',  
  'catch',         'whileSource',   'loop',          'forBody',     
  'forStart',      'forSource',     'forVariables',  'forValue',    
  'whens',         'when',          'ifBlock',     
    );

    /**
     * For tracing reduce actions, the names of all rules are required.
     * @var array
     */
    static public $yyRuleName = array(
 /*   0 */ "root ::=",
 /*   1 */ "root ::= body",
 /*   2 */ "root ::= block YY_TERMINATOR",
 /*   3 */ "body ::= line",
 /*   4 */ "body ::= body YY_TERMINATOR line",
 /*   5 */ "body ::= body YY_TERMINATOR",
 /*   6 */ "line ::= expression",
 /*   7 */ "line ::= statement",
 /*   8 */ "statement ::= return",
 /*   9 */ "statement ::= comment",
 /*  10 */ "statement ::= YY_STATEMENT",
 /*  11 */ "expression ::= value",
 /*  12 */ "expression ::= invocation",
 /*  13 */ "expression ::= code",
 /*  14 */ "expression ::= operation",
 /*  15 */ "expression ::= assign",
 /*  16 */ "expression ::= if",
 /*  17 */ "expression ::= try",
 /*  18 */ "expression ::= while",
 /*  19 */ "expression ::= for",
 /*  20 */ "expression ::= switch",
 /*  21 */ "expression ::= class",
 /*  22 */ "expression ::= throw",
 /*  23 */ "block ::= YY_INDENT YY_OUTDENT",
 /*  24 */ "block ::= YY_INDENT body YY_OUTDENT",
 /*  25 */ "identifier ::= YY_IDENTIFIER",
 /*  26 */ "alphanumeric ::= YY_NUMBER",
 /*  27 */ "alphanumeric ::= YY_STRING",
 /*  28 */ "literal ::= alphanumeric",
 /*  29 */ "literal ::= YY_JS",
 /*  30 */ "literal ::= YY_REGEX",
 /*  31 */ "literal ::= YY_DEBUGGER",
 /*  32 */ "literal ::= YY_BOOL",
 /*  33 */ "assign ::= assignable YY_EQUALS expression",
 /*  34 */ "assign ::= assignable YY_EQUALS YY_TERMINATOR expression",
 /*  35 */ "assign ::= assignable YY_EQUALS YY_INDENT expression YY_OUTDENT",
 /*  36 */ "assignObj ::= objAssignable",
 /*  37 */ "assignObj ::= objAssignable YY_COLON expression",
 /*  38 */ "assignObj ::= objAssignable YY_COLON YY_INDENT expression YY_OUTDENT",
 /*  39 */ "assignObj ::= comment",
 /*  40 */ "objAssignable ::= identifier",
 /*  41 */ "objAssignable ::= alphanumeric",
 /*  42 */ "objAssignable ::= thisProperty",
 /*  43 */ "return ::= YY_RETURN expression",
 /*  44 */ "return ::= YY_RETURN",
 /*  45 */ "comment ::= YY_HERECOMMENT",
 /*  46 */ "code ::= YY_PARAM_START paramList YY_PARAM_END funcGlyph block",
 /*  47 */ "code ::= funcGlyph block",
 /*  48 */ "funcGlyph ::= YY_FUNC",
 /*  49 */ "funcGlyph ::= YY_BOUND_FUNC",
 /*  50 */ "optComma ::=",
 /*  51 */ "optComma ::= YY_COMMA",
 /*  52 */ "paramList ::=",
 /*  53 */ "paramList ::= param",
 /*  54 */ "paramList ::= paramList YY_COMMA param",
 /*  55 */ "param ::= paramVar",
 /*  56 */ "param ::= paramVar YY_RANGE_EXCLUSIVE",
 /*  57 */ "param ::= paramVar YY_EQUALS expression",
 /*  58 */ "paramVar ::= identifier",
 /*  59 */ "paramVar ::= thisProperty",
 /*  60 */ "paramVar ::= array",
 /*  61 */ "paramVar ::= object",
 /*  62 */ "splat ::= expression YY_RANGE_EXCLUSIVE",
 /*  63 */ "simpleAssignable ::= identifier",
 /*  64 */ "simpleAssignable ::= value accessor",
 /*  65 */ "simpleAssignable ::= invocation accessor",
 /*  66 */ "simpleAssignable ::= thisProperty",
 /*  67 */ "assignable ::= simpleAssignable",
 /*  68 */ "assignable ::= array",
 /*  69 */ "assignable ::= object",
 /*  70 */ "value ::= assignable",
 /*  71 */ "value ::= literal",
 /*  72 */ "value ::= parenthetical",
 /*  73 */ "value ::= range",
 /*  74 */ "value ::= this",
 /*  75 */ "accessor ::= YY_ACCESSOR identifier",
 /*  76 */ "accessor ::= YY_EXISTENTIAL_ACCESSOR identifier",
 /*  77 */ "accessor ::= YY_PROTOTYPE identifier",
 /*  78 */ "accessor ::= YY_PROTOTYPE",
 /*  79 */ "accessor ::= index",
 /*  80 */ "index ::= YY_INDEX_START indexValue YY_INDEX_END",
 /*  81 */ "index ::= YY_INDEX_SOAK index",
 /*  82 */ "indexValue ::= expression",
 /*  83 */ "indexValue ::= slice",
 /*  84 */ "object ::= YY_OBJECT_START assignList optComma YY_OBJECT_END",
 /*  85 */ "assignList ::=",
 /*  86 */ "assignList ::= assignObj",
 /*  87 */ "assignList ::= assignList YY_COMMA assignObj",
 /*  88 */ "assignList ::= assignList optComma YY_TERMINATOR assignObj",
 /*  89 */ "assignList ::= assignList optComma YY_INDENT assignList optComma YY_OUTDENT",
 /*  90 */ "class ::= YY_CLASS",
 /*  91 */ "class ::= YY_CLASS block",
 /*  92 */ "class ::= YY_CLASS YY_EXTENDS expression",
 /*  93 */ "class ::= YY_CLASS YY_EXTENDS expression block",
 /*  94 */ "class ::= YY_CLASS simpleAssignable",
 /*  95 */ "class ::= YY_CLASS simpleAssignable block",
 /*  96 */ "class ::= YY_CLASS simpleAssignable YY_EXTENDS expression",
 /*  97 */ "class ::= YY_CLASS simpleAssignable YY_EXTENDS expression block",
 /*  98 */ "invocation ::= value optFuncExist arguments",
 /*  99 */ "invocation ::= invocation optFuncExist arguments",
 /* 100 */ "invocation ::= YY_SUPER",
 /* 101 */ "invocation ::= YY_SUPER arguments",
 /* 102 */ "optFuncExist ::=",
 /* 103 */ "optFuncExist ::= YY_FUNC_EXIST",
 /* 104 */ "arguments ::= YY_CALL_START YY_CALL_END",
 /* 105 */ "arguments ::= YY_CALL_START argList optComma YY_CALL_END",
 /* 106 */ "this ::= YY_THIS",
 /* 107 */ "this ::= YY_AT_SIGN",
 /* 108 */ "thisProperty ::= YY_AT_SIGN identifier",
 /* 109 */ "array ::= YY_ARRAY_START YY_ARRAY_END",
 /* 110 */ "array ::= YY_ARRAY_START argList optComma YY_ARRAY_END",
 /* 111 */ "rangeDots ::= YY_RANGE_INCLUSIVE",
 /* 112 */ "rangeDots ::= YY_RANGE_EXCLUSIVE",
 /* 113 */ "range ::= YY_ARRAY_START expression rangeDots expression YY_ARRAY_END",
 /* 114 */ "slice ::= expression rangeDots expression",
 /* 115 */ "slice ::= expression rangeDots",
 /* 116 */ "slice ::= rangeDots expression",
 /* 117 */ "slice ::= rangeDots",
 /* 118 */ "argList ::= arg",
 /* 119 */ "argList ::= argList YY_COMMA arg",
 /* 120 */ "argList ::= argList optComma YY_TERMINATOR arg",
 /* 121 */ "argList ::= YY_INDENT argList optComma YY_OUTDENT",
 /* 122 */ "argList ::= argList optComma YY_INDENT argList optComma YY_OUTDENT",
 /* 123 */ "arg ::= expression",
 /* 124 */ "arg ::= splat",
 /* 125 */ "simpleArgs ::= expression",
 /* 126 */ "simpleArgs ::= simpleArgs YY_COMMA expression",
 /* 127 */ "try ::= YY_TRY block",
 /* 128 */ "try ::= YY_TRY block catch",
 /* 129 */ "try ::= YY_TRY block YY_FINALLY block",
 /* 130 */ "try ::= YY_TRY block catch YY_FINALLY block",
 /* 131 */ "catch ::= YY_CATCH identifier block",
 /* 132 */ "throw ::= YY_THROW expression",
 /* 133 */ "parenthetical ::= YY_PAREN_START body YY_PAREN_END",
 /* 134 */ "parenthetical ::= YY_PAREN_START YY_INDENT body YY_OUTDENT YY_PAREN_END",
 /* 135 */ "whileSource ::= YY_WHILE expression",
 /* 136 */ "whileSource ::= YY_WHILE expression YY_WHEN expression",
 /* 137 */ "whileSource ::= YY_UNTIL expression",
 /* 138 */ "whileSource ::= YY_UNTIL expression YY_WHEN expression",
 /* 139 */ "while ::= whileSource block",
 /* 140 */ "while ::= statement whileSource",
 /* 141 */ "while ::= expression whileSource",
 /* 142 */ "while ::= loop",
 /* 143 */ "loop ::= YY_LOOP block",
 /* 144 */ "loop ::= YY_LOOP expression",
 /* 145 */ "for ::= statement forBody",
 /* 146 */ "for ::= expression forBody",
 /* 147 */ "for ::= forBody block",
 /* 148 */ "forBody ::= YY_FOR range",
 /* 149 */ "forBody ::= forStart forSource",
 /* 150 */ "forStart ::= YY_FOR forVariables",
 /* 151 */ "forStart ::= YY_FOR YY_OWN forVariables",
 /* 152 */ "forValue ::= identifier",
 /* 153 */ "forValue ::= array",
 /* 154 */ "forValue ::= object",
 /* 155 */ "forVariables ::= forValue",
 /* 156 */ "forVariables ::= forValue YY_COMMA forValue",
 /* 157 */ "forSource ::= YY_FORIN expression",
 /* 158 */ "forSource ::= YY_FOROF expression",
 /* 159 */ "forSource ::= YY_FORIN expression YY_WHEN expression",
 /* 160 */ "forSource ::= YY_FOROF expression YY_WHEN expression",
 /* 161 */ "forSource ::= YY_FORIN expression YY_BY expression",
 /* 162 */ "forSource ::= YY_FORIN expression YY_WHEN expression YY_BY expression",
 /* 163 */ "forSource ::= YY_FORIN expression YY_BY expression YY_WHEN expression",
 /* 164 */ "switch ::= YY_SWITCH expression YY_INDENT whens YY_OUTDENT",
 /* 165 */ "switch ::= YY_SWITCH expression YY_INDENT whens YY_ELSE block YY_OUTDENT",
 /* 166 */ "switch ::= YY_SWITCH YY_INDENT whens YY_OUTDENT",
 /* 167 */ "switch ::= YY_SWITCH YY_INDENT whens YY_ELSE block YY_OUTDENT",
 /* 168 */ "whens ::= when",
 /* 169 */ "whens ::= whens when",
 /* 170 */ "when ::= YY_LEADING_WHEN simpleArgs block",
 /* 171 */ "when ::= YY_LEADING_WHEN simpleArgs block YY_TERMINATOR",
 /* 172 */ "ifBlock ::= YY_IF expression block",
 /* 173 */ "ifBlock ::= ifBlock YY_ELSE YY_IF expression block",
 /* 174 */ "if ::= ifBlock",
 /* 175 */ "if ::= ifBlock YY_ELSE block",
 /* 176 */ "if ::= statement YY_POST_IF expression",
 /* 177 */ "if ::= expression YY_POST_IF expression",
 /* 178 */ "operation ::= YY_UNARY expression",
 /* 179 */ "operation ::= YY_MINUS expression",
 /* 180 */ "operation ::= YY_PLUS expression",
 /* 181 */ "operation ::= YY_DECREMENT simpleAssignable",
 /* 182 */ "operation ::= YY_INCREMENT simpleAssignable",
 /* 183 */ "operation ::= simpleAssignable YY_DECREMENT",
 /* 184 */ "operation ::= simpleAssignable YY_INCREMENT",
 /* 185 */ "operation ::= expression YY_EXISTENTIAL",
 /* 186 */ "operation ::= expression YY_PLUS expression",
 /* 187 */ "operation ::= expression YY_MINUS expression",
 /* 188 */ "operation ::= expression YY_MATH expression",
 /* 189 */ "operation ::= expression YY_SHIFT expression",
 /* 190 */ "operation ::= expression YY_COMPARE expression",
 /* 191 */ "operation ::= expression YY_LOGIC expression",
 /* 192 */ "operation ::= expression YY_RELATION expression",
 /* 193 */ "operation ::= simpleAssignable YY_COMPOUND_ASSIGN expression",
 /* 194 */ "operation ::= simpleAssignable YY_COMPOUND_ASSIGN YY_INDENT expression YY_OUTDENT",
 /* 195 */ "operation ::= simpleAssignable YY_EXTENDS expression",
    );

    /**
     * This function returns the symbolic name associated with a token
     * value.
     * @param int
     * @return string
     */
    static function tokenName($tokenType)
    {
        if ($tokenType === 0) {
            return 'End of Input';
        }
        if ($tokenType > 0 && $tokenType < count(self::$yyTokenName)) {
            return self::$yyTokenName[$tokenType];
        } else {
            return "Unknown";
        }
    }

    /**
     * The following function deletes the value associated with a
     * symbol.  The symbol can be either a terminal or nonterminal.
     * @param int the symbol code
     * @param mixed the symbol's value
     */
    static function yy_destructor($yymajor, $yypminor)
    {
        switch ($yymajor) {
        /* Here is inserted the actions which take place when a
        ** terminal or non-terminal is destroyed.  This can happen
        ** when the symbol is popped from the stack during a
        ** reduce or during error processing or when a parser is 
        ** being destroyed before it is finished parsing.
        **
        ** Note: during a reduce, the only symbols destroyed are those
        ** which appear on the RHS of the rule, but which are not used
        ** inside the C code.
        */
            default:  break;   /* If no destructor action specified: do nothing */
        }
    }

    /**
     * Pop the parser's stack once.
     *
     * If there is a destructor routine associated with the token which
     * is popped from the stack, then call it.
     *
     * Return the major token number for the symbol popped.
     * @param yyParser
     * @return int
     */
    function yy_pop_parser_stack()
    {
        if (!count($this->yystack)) {
            return;
        }
        $yytos = array_pop($this->yystack);
        if (self::$yyTraceFILE && $this->yyidx >= 0) {
            fwrite(self::$yyTraceFILE,
                self::$yyTracePrompt . 'Popping ' . self::tokenName($yytos->major) .
                    "\n");
        }
        $yymajor = $yytos->major;
        self::yy_destructor($yymajor, $yytos->minor);
        $this->yyidx--;
        return $yymajor;
    }

    /**
     * Deallocate and destroy a parser.  Destructors are all called for
     * all stack elements before shutting the parser down.
     */
    function __destruct()
    {
        while ($this->yyidx >= 0) {
            $this->yy_pop_parser_stack();
        }
        if (is_resource(self::$yyTraceFILE)) {
            fclose(self::$yyTraceFILE);
        }
    }

    /**
     * Based on the current state and parser stack, get a list of all
     * possible lookahead tokens
     * @param int
     * @return array
     */
    function yy_get_expected_tokens($token)
    {
        $state = $this->yystack[$this->yyidx]->stateno;
        $expected = self::$yyExpectedTokens[$state];
        if (in_array($token, self::$yyExpectedTokens[$state], true)) {
            return $expected;
        }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done++ == 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return array_unique($expected);
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[$yyruleno]['rhs'];
                    $nextstate = $this->yy_find_reduce_action(
                        $this->yystack[$this->yyidx]->stateno,
                        self::$yyRuleInfo[$yyruleno]['lhs']);
                    if (isset(self::$yyExpectedTokens[$nextstate])) {
                        $expected += self::$yyExpectedTokens[$nextstate];
                            if (in_array($token,
                                  self::$yyExpectedTokens[$nextstate], true)) {
                            $this->yyidx = $yyidx;
                            $this->yystack = $stack;
                            return array_unique($expected);
                        }
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx++;
                        $x = new yyStackEntry;
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[$yyruleno]['lhs'];
                        $this->yystack[$this->yyidx] = $x;
                        continue 2;
                    } elseif ($nextstate == self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return array_unique($expected);
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return $expected;
                    } else {
                        $yyact = $nextstate;
                    }
                } while (true);
            }
            break;
        } while (true);
        return array_unique($expected);
    }

    /**
     * Based on the parser state and current parser stack, determine whether
     * the lookahead token is possible.
     * 
     * The parser will convert the token value to an error token if not.  This
     * catches some unusual edge cases where the parser would fail.
     * @param int
     * @return bool
     */
    function yy_is_expected_token($token)
    {
        if ($token === 0) {
            return true; // 0 is not part of this
        }
        $state = $this->yystack[$this->yyidx]->stateno;
        if (in_array($token, self::$yyExpectedTokens[$state], true)) {
            return true;
        }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done++ == 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return true;
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[$yyruleno]['rhs'];
                    $nextstate = $this->yy_find_reduce_action(
                        $this->yystack[$this->yyidx]->stateno,
                        self::$yyRuleInfo[$yyruleno]['lhs']);
                    if (isset(self::$yyExpectedTokens[$nextstate]) &&
                          in_array($token, self::$yyExpectedTokens[$nextstate], true)) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        return true;
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx++;
                        $x = new yyStackEntry;
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[$yyruleno]['lhs'];
                        $this->yystack[$this->yyidx] = $x;
                        continue 2;
                    } elseif ($nextstate == self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        if (!$token) {
                            // end of input: this is valid
                            return true;
                        }
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return false;
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return true;
                    } else {
                        $yyact = $nextstate;
                    }
                } while (true);
            }
            break;
        } while (true);
        $this->yyidx = $yyidx;
        $this->yystack = $stack;
        return true;
    }

    /**
     * Find the appropriate action for a parser given the terminal
     * look-ahead token iLookAhead.
     *
     * If the look-ahead token is YYNOCODE, then check to see if the action is
     * independent of the look-ahead.  If it is, return the action, otherwise
     * return YY_NO_ACTION.
     * @param int The look-ahead token
     */
    function yy_find_shift_action($iLookAhead)
    {
        $stateno = $this->yystack[$this->yyidx]->stateno;
     
        /* if ($this->yyidx < 0) return self::YY_NO_ACTION;  */
        if (!isset(self::$yy_shift_ofst[$stateno])) {
            // no shift actions
            return self::$yy_default[$stateno];
        }
        $i = self::$yy_shift_ofst[$stateno];
        if ($i === self::YY_SHIFT_USE_DFLT) {
            return self::$yy_default[$stateno];
        }
        if ($iLookAhead == self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB ||
              self::$yy_lookahead[$i] != $iLookAhead) {
            if (count(self::$yyFallback) && $iLookAhead < count(self::$yyFallback)
                   && ($iFallback = self::$yyFallback[$iLookAhead]) != 0) {
                if (self::$yyTraceFILE) {
                    fwrite(self::$yyTraceFILE, self::$yyTracePrompt . "FALLBACK " .
                        self::tokenName($iLookAhead) . " => " .
                        self::tokenName($iFallback) . "\n");
                }
                return $this->yy_find_shift_action($iFallback);
            }
            return self::$yy_default[$stateno];
        } else {
            return self::$yy_action[$i];
        }
    }

    /**
     * Find the appropriate action for a parser given the non-terminal
     * look-ahead token $iLookAhead.
     *
     * If the look-ahead token is self::YYNOCODE, then check to see if the action is
     * independent of the look-ahead.  If it is, return the action, otherwise
     * return self::YY_NO_ACTION.
     * @param int Current state number
     * @param int The look-ahead token
     */
    function yy_find_reduce_action($stateno, $iLookAhead)
    {
        /* $stateno = $this->yystack[$this->yyidx]->stateno; */

        if (!isset(self::$yy_reduce_ofst[$stateno])) {
            return self::$yy_default[$stateno];
        }
        $i = self::$yy_reduce_ofst[$stateno];
        if ($i == self::YY_REDUCE_USE_DFLT) {
            return self::$yy_default[$stateno];
        }
        if ($iLookAhead == self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB ||
              self::$yy_lookahead[$i] != $iLookAhead) {
            return self::$yy_default[$stateno];
        } else {
            return self::$yy_action[$i];
        }
    }

    /**
     * Perform a shift action.
     * @param int The new state to shift in
     * @param int The major token to shift in
     * @param mixed the minor token to shift in
     */
    function yy_shift($yyNewState, $yyMajor, $yypMinor)
    {
        $this->yyidx++;
        if ($this->yyidx >= self::YYSTACKDEPTH) {
            $this->yyidx--;
            if (self::$yyTraceFILE) {
                fprintf(self::$yyTraceFILE, "%sStack Overflow!\n", self::$yyTracePrompt);
            }
            while ($this->yyidx >= 0) {
                $this->yy_pop_parser_stack();
            }
            /* Here code is inserted which will execute if the parser
            ** stack ever overflows */
            return;
        }
        $yytos = new yyStackEntry;
        $yytos->stateno = $yyNewState;
        $yytos->major = $yyMajor;
        $yytos->minor = $yypMinor;
        array_push($this->yystack, $yytos);
        if (self::$yyTraceFILE && $this->yyidx > 0) {
            fprintf(self::$yyTraceFILE, "%sShift %d\n", self::$yyTracePrompt,
                $yyNewState);
            fprintf(self::$yyTraceFILE, "%sStack:", self::$yyTracePrompt);
            for ($i = 1; $i <= $this->yyidx; $i++) {
                fprintf(self::$yyTraceFILE, " %s",
                    self::tokenName($this->yystack[$i]->major));
            }
            fwrite(self::$yyTraceFILE,"\n");
        }
    }

    /**
     * The following table contains information about every rule that
     * is used during the reduce.
     *
     * <pre>
     * array(
     *  array(
     *   int $lhs;         Symbol on the left-hand side of the rule
     *   int $nrhs;     Number of right-hand side symbols in the rule
     *  ),...
     * );
     * </pre>
     */
    static public $yyRuleInfo = array(
  array( 'lhs' => 74, 'rhs' => 0 ),
  array( 'lhs' => 74, 'rhs' => 1 ),
  array( 'lhs' => 74, 'rhs' => 2 ),
  array( 'lhs' => 75, 'rhs' => 1 ),
  array( 'lhs' => 75, 'rhs' => 3 ),
  array( 'lhs' => 75, 'rhs' => 2 ),
  array( 'lhs' => 77, 'rhs' => 1 ),
  array( 'lhs' => 77, 'rhs' => 1 ),
  array( 'lhs' => 79, 'rhs' => 1 ),
  array( 'lhs' => 79, 'rhs' => 1 ),
  array( 'lhs' => 79, 'rhs' => 1 ),
  array( 'lhs' => 78, 'rhs' => 1 ),
  array( 'lhs' => 78, 'rhs' => 1 ),
  array( 'lhs' => 78, 'rhs' => 1 ),
  array( 'lhs' => 78, 'rhs' => 1 ),
  array( 'lhs' => 78, 'rhs' => 1 ),
  array( 'lhs' => 78, 'rhs' => 1 ),
  array( 'lhs' => 78, 'rhs' => 1 ),
  array( 'lhs' => 78, 'rhs' => 1 ),
  array( 'lhs' => 78, 'rhs' => 1 ),
  array( 'lhs' => 78, 'rhs' => 1 ),
  array( 'lhs' => 78, 'rhs' => 1 ),
  array( 'lhs' => 78, 'rhs' => 1 ),
  array( 'lhs' => 76, 'rhs' => 2 ),
  array( 'lhs' => 76, 'rhs' => 3 ),
  array( 'lhs' => 94, 'rhs' => 1 ),
  array( 'lhs' => 95, 'rhs' => 1 ),
  array( 'lhs' => 95, 'rhs' => 1 ),
  array( 'lhs' => 96, 'rhs' => 1 ),
  array( 'lhs' => 96, 'rhs' => 1 ),
  array( 'lhs' => 96, 'rhs' => 1 ),
  array( 'lhs' => 96, 'rhs' => 1 ),
  array( 'lhs' => 96, 'rhs' => 1 ),
  array( 'lhs' => 86, 'rhs' => 3 ),
  array( 'lhs' => 86, 'rhs' => 4 ),
  array( 'lhs' => 86, 'rhs' => 5 ),
  array( 'lhs' => 98, 'rhs' => 1 ),
  array( 'lhs' => 98, 'rhs' => 3 ),
  array( 'lhs' => 98, 'rhs' => 5 ),
  array( 'lhs' => 98, 'rhs' => 1 ),
  array( 'lhs' => 99, 'rhs' => 1 ),
  array( 'lhs' => 99, 'rhs' => 1 ),
  array( 'lhs' => 99, 'rhs' => 1 ),
  array( 'lhs' => 80, 'rhs' => 2 ),
  array( 'lhs' => 80, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 84, 'rhs' => 5 ),
  array( 'lhs' => 84, 'rhs' => 2 ),
  array( 'lhs' => 102, 'rhs' => 1 ),
  array( 'lhs' => 102, 'rhs' => 1 ),
  array( 'lhs' => 103, 'rhs' => 0 ),
  array( 'lhs' => 103, 'rhs' => 1 ),
  array( 'lhs' => 101, 'rhs' => 0 ),
  array( 'lhs' => 101, 'rhs' => 1 ),
  array( 'lhs' => 101, 'rhs' => 3 ),
  array( 'lhs' => 104, 'rhs' => 1 ),
  array( 'lhs' => 104, 'rhs' => 2 ),
  array( 'lhs' => 104, 'rhs' => 3 ),
  array( 'lhs' => 105, 'rhs' => 1 ),
  array( 'lhs' => 105, 'rhs' => 1 ),
  array( 'lhs' => 105, 'rhs' => 1 ),
  array( 'lhs' => 105, 'rhs' => 1 ),
  array( 'lhs' => 108, 'rhs' => 2 ),
  array( 'lhs' => 109, 'rhs' => 1 ),
  array( 'lhs' => 109, 'rhs' => 2 ),
  array( 'lhs' => 109, 'rhs' => 2 ),
  array( 'lhs' => 109, 'rhs' => 1 ),
  array( 'lhs' => 97, 'rhs' => 1 ),
  array( 'lhs' => 97, 'rhs' => 1 ),
  array( 'lhs' => 97, 'rhs' => 1 ),
  array( 'lhs' => 82, 'rhs' => 1 ),
  array( 'lhs' => 82, 'rhs' => 1 ),
  array( 'lhs' => 82, 'rhs' => 1 ),
  array( 'lhs' => 82, 'rhs' => 1 ),
  array( 'lhs' => 82, 'rhs' => 1 ),
  array( 'lhs' => 110, 'rhs' => 2 ),
  array( 'lhs' => 110, 'rhs' => 2 ),
  array( 'lhs' => 110, 'rhs' => 2 ),
  array( 'lhs' => 110, 'rhs' => 1 ),
  array( 'lhs' => 110, 'rhs' => 1 ),
  array( 'lhs' => 114, 'rhs' => 3 ),
  array( 'lhs' => 114, 'rhs' => 2 ),
  array( 'lhs' => 115, 'rhs' => 1 ),
  array( 'lhs' => 115, 'rhs' => 1 ),
  array( 'lhs' => 107, 'rhs' => 4 ),
  array( 'lhs' => 117, 'rhs' => 0 ),
  array( 'lhs' => 117, 'rhs' => 1 ),
  array( 'lhs' => 117, 'rhs' => 3 ),
  array( 'lhs' => 117, 'rhs' => 4 ),
  array( 'lhs' => 117, 'rhs' => 6 ),
  array( 'lhs' => 92, 'rhs' => 1 ),
  array( 'lhs' => 92, 'rhs' => 2 ),
  array( 'lhs' => 92, 'rhs' => 3 ),
  array( 'lhs' => 92, 'rhs' => 4 ),
  array( 'lhs' => 92, 'rhs' => 2 ),
  array( 'lhs' => 92, 'rhs' => 3 ),
  array( 'lhs' => 92, 'rhs' => 4 ),
  array( 'lhs' => 92, 'rhs' => 5 ),
  array( 'lhs' => 83, 'rhs' => 3 ),
  array( 'lhs' => 83, 'rhs' => 3 ),
  array( 'lhs' => 83, 'rhs' => 1 ),
  array( 'lhs' => 83, 'rhs' => 2 ),
  array( 'lhs' => 118, 'rhs' => 0 ),
  array( 'lhs' => 118, 'rhs' => 1 ),
  array( 'lhs' => 119, 'rhs' => 2 ),
  array( 'lhs' => 119, 'rhs' => 4 ),
  array( 'lhs' => 113, 'rhs' => 1 ),
  array( 'lhs' => 113, 'rhs' => 1 ),
  array( 'lhs' => 100, 'rhs' => 2 ),
  array( 'lhs' => 106, 'rhs' => 2 ),
  array( 'lhs' => 106, 'rhs' => 4 ),
  array( 'lhs' => 121, 'rhs' => 1 ),
  array( 'lhs' => 121, 'rhs' => 1 ),
  array( 'lhs' => 112, 'rhs' => 5 ),
  array( 'lhs' => 116, 'rhs' => 3 ),
  array( 'lhs' => 116, 'rhs' => 2 ),
  array( 'lhs' => 116, 'rhs' => 2 ),
  array( 'lhs' => 116, 'rhs' => 1 ),
  array( 'lhs' => 120, 'rhs' => 1 ),
  array( 'lhs' => 120, 'rhs' => 3 ),
  array( 'lhs' => 120, 'rhs' => 4 ),
  array( 'lhs' => 120, 'rhs' => 4 ),
  array( 'lhs' => 120, 'rhs' => 6 ),
  array( 'lhs' => 122, 'rhs' => 1 ),
  array( 'lhs' => 122, 'rhs' => 1 ),
  array( 'lhs' => 123, 'rhs' => 1 ),
  array( 'lhs' => 123, 'rhs' => 3 ),
  array( 'lhs' => 88, 'rhs' => 2 ),
  array( 'lhs' => 88, 'rhs' => 3 ),
  array( 'lhs' => 88, 'rhs' => 4 ),
  array( 'lhs' => 88, 'rhs' => 5 ),
  array( 'lhs' => 124, 'rhs' => 3 ),
  array( 'lhs' => 93, 'rhs' => 2 ),
  array( 'lhs' => 111, 'rhs' => 3 ),
  array( 'lhs' => 111, 'rhs' => 5 ),
  array( 'lhs' => 125, 'rhs' => 2 ),
  array( 'lhs' => 125, 'rhs' => 4 ),
  array( 'lhs' => 125, 'rhs' => 2 ),
  array( 'lhs' => 125, 'rhs' => 4 ),
  array( 'lhs' => 89, 'rhs' => 2 ),
  array( 'lhs' => 89, 'rhs' => 2 ),
  array( 'lhs' => 89, 'rhs' => 2 ),
  array( 'lhs' => 89, 'rhs' => 1 ),
  array( 'lhs' => 126, 'rhs' => 2 ),
  array( 'lhs' => 126, 'rhs' => 2 ),
  array( 'lhs' => 90, 'rhs' => 2 ),
  array( 'lhs' => 90, 'rhs' => 2 ),
  array( 'lhs' => 90, 'rhs' => 2 ),
  array( 'lhs' => 127, 'rhs' => 2 ),
  array( 'lhs' => 127, 'rhs' => 2 ),
  array( 'lhs' => 128, 'rhs' => 2 ),
  array( 'lhs' => 128, 'rhs' => 3 ),
  array( 'lhs' => 131, 'rhs' => 1 ),
  array( 'lhs' => 131, 'rhs' => 1 ),
  array( 'lhs' => 131, 'rhs' => 1 ),
  array( 'lhs' => 130, 'rhs' => 1 ),
  array( 'lhs' => 130, 'rhs' => 3 ),
  array( 'lhs' => 129, 'rhs' => 2 ),
  array( 'lhs' => 129, 'rhs' => 2 ),
  array( 'lhs' => 129, 'rhs' => 4 ),
  array( 'lhs' => 129, 'rhs' => 4 ),
  array( 'lhs' => 129, 'rhs' => 4 ),
  array( 'lhs' => 129, 'rhs' => 6 ),
  array( 'lhs' => 129, 'rhs' => 6 ),
  array( 'lhs' => 91, 'rhs' => 5 ),
  array( 'lhs' => 91, 'rhs' => 7 ),
  array( 'lhs' => 91, 'rhs' => 4 ),
  array( 'lhs' => 91, 'rhs' => 6 ),
  array( 'lhs' => 132, 'rhs' => 1 ),
  array( 'lhs' => 132, 'rhs' => 2 ),
  array( 'lhs' => 133, 'rhs' => 3 ),
  array( 'lhs' => 133, 'rhs' => 4 ),
  array( 'lhs' => 134, 'rhs' => 3 ),
  array( 'lhs' => 134, 'rhs' => 5 ),
  array( 'lhs' => 87, 'rhs' => 1 ),
  array( 'lhs' => 87, 'rhs' => 3 ),
  array( 'lhs' => 87, 'rhs' => 3 ),
  array( 'lhs' => 87, 'rhs' => 3 ),
  array( 'lhs' => 85, 'rhs' => 2 ),
  array( 'lhs' => 85, 'rhs' => 2 ),
  array( 'lhs' => 85, 'rhs' => 2 ),
  array( 'lhs' => 85, 'rhs' => 2 ),
  array( 'lhs' => 85, 'rhs' => 2 ),
  array( 'lhs' => 85, 'rhs' => 2 ),
  array( 'lhs' => 85, 'rhs' => 2 ),
  array( 'lhs' => 85, 'rhs' => 2 ),
  array( 'lhs' => 85, 'rhs' => 3 ),
  array( 'lhs' => 85, 'rhs' => 3 ),
  array( 'lhs' => 85, 'rhs' => 3 ),
  array( 'lhs' => 85, 'rhs' => 3 ),
  array( 'lhs' => 85, 'rhs' => 3 ),
  array( 'lhs' => 85, 'rhs' => 3 ),
  array( 'lhs' => 85, 'rhs' => 3 ),
  array( 'lhs' => 85, 'rhs' => 3 ),
  array( 'lhs' => 85, 'rhs' => 5 ),
  array( 'lhs' => 85, 'rhs' => 3 ),
    );

    /**
     * The following table contains a mapping of reduce action to method name
     * that handles the reduction.
     * 
     * If a rule is not set, it has no handler.
     */
    static public $yyReduceMap = array(
        0 => 0,
        23 => 0,
        1 => 1,
        6 => 1,
        7 => 1,
        8 => 1,
        9 => 1,
        11 => 1,
        12 => 1,
        13 => 1,
        14 => 1,
        15 => 1,
        16 => 1,
        17 => 1,
        18 => 1,
        19 => 1,
        20 => 1,
        21 => 1,
        22 => 1,
        28 => 1,
        39 => 1,
        40 => 1,
        41 => 1,
        42 => 1,
        51 => 1,
        58 => 1,
        59 => 1,
        60 => 1,
        61 => 1,
        66 => 1,
        67 => 1,
        70 => 1,
        74 => 1,
        79 => 1,
        123 => 1,
        124 => 1,
        125 => 1,
        142 => 1,
        150 => 1,
        152 => 1,
        168 => 1,
        174 => 1,
        2 => 2,
        5 => 2,
        24 => 2,
        80 => 2,
        3 => 3,
        4 => 4,
        10 => 10,
        25 => 10,
        26 => 10,
        27 => 10,
        29 => 10,
        30 => 10,
        31 => 10,
        32 => 32,
        33 => 33,
        34 => 34,
        35 => 35,
        36 => 36,
        63 => 36,
        68 => 36,
        69 => 36,
        71 => 36,
        72 => 36,
        73 => 36,
        153 => 36,
        154 => 36,
        37 => 37,
        38 => 38,
        43 => 43,
        44 => 44,
        45 => 45,
        46 => 46,
        47 => 47,
        48 => 48,
        49 => 49,
        50 => 50,
        52 => 52,
        85 => 52,
        104 => 52,
        53 => 53,
        86 => 53,
        118 => 53,
        155 => 53,
        54 => 54,
        119 => 54,
        55 => 55,
        56 => 56,
        57 => 57,
        62 => 62,
        64 => 64,
        65 => 65,
        75 => 75,
        76 => 76,
        77 => 77,
        78 => 78,
        81 => 81,
        82 => 82,
        83 => 83,
        84 => 84,
        87 => 87,
        88 => 88,
        89 => 89,
        122 => 89,
        90 => 90,
        91 => 91,
        92 => 92,
        93 => 93,
        94 => 94,
        95 => 95,
        96 => 96,
        97 => 97,
        98 => 98,
        99 => 98,
        100 => 100,
        101 => 101,
        102 => 102,
        103 => 103,
        105 => 105,
        121 => 105,
        106 => 106,
        107 => 106,
        108 => 108,
        109 => 109,
        110 => 110,
        111 => 111,
        112 => 112,
        113 => 113,
        114 => 114,
        115 => 115,
        116 => 116,
        117 => 117,
        120 => 120,
        126 => 126,
        156 => 126,
        127 => 127,
        128 => 128,
        129 => 129,
        130 => 130,
        131 => 131,
        132 => 132,
        133 => 133,
        134 => 134,
        135 => 135,
        136 => 136,
        137 => 137,
        138 => 138,
        139 => 139,
        140 => 140,
        141 => 140,
        143 => 143,
        144 => 144,
        145 => 145,
        146 => 145,
        147 => 147,
        148 => 148,
        149 => 149,
        151 => 151,
        157 => 157,
        158 => 158,
        159 => 159,
        160 => 160,
        161 => 161,
        162 => 162,
        163 => 163,
        164 => 164,
        165 => 165,
        166 => 166,
        167 => 167,
        169 => 169,
        170 => 170,
        171 => 171,
        172 => 172,
        173 => 173,
        175 => 175,
        176 => 176,
        177 => 176,
        178 => 178,
        181 => 178,
        182 => 178,
        179 => 179,
        180 => 179,
        183 => 183,
        184 => 183,
        185 => 185,
        186 => 186,
        187 => 186,
        188 => 186,
        189 => 186,
        190 => 186,
        191 => 186,
        192 => 192,
        193 => 193,
        194 => 194,
        195 => 195,
    );
    /* Beginning here are the reduction cases.  A typical example
    ** follows:
    **  #line <lineno> <grammarfile>
    **   function yy_r0($yymsp){ ... }           // User supplied code
    **  #line <lineno> <thisfile>
    */
#line 28 "/var/www/coffeescript-php/grammar.y"
    function yy_r0(){ $this->_retvalue = yy('Block');     }
#line 2672 "/var/www/coffeescript-php/grammar.php"
#line 29 "/var/www/coffeescript-php/grammar.y"
    function yy_r1(){ $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;     }
#line 2675 "/var/www/coffeescript-php/grammar.php"
#line 30 "/var/www/coffeescript-php/grammar.y"
    function yy_r2(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;     }
#line 2678 "/var/www/coffeescript-php/grammar.php"
#line 32 "/var/www/coffeescript-php/grammar.y"
    function yy_r3(){ $this->_retvalue = yy_Block::wrap(array($this->yystack[$this->yyidx + 0]->minor));     }
#line 2681 "/var/www/coffeescript-php/grammar.php"
#line 33 "/var/www/coffeescript-php/grammar.y"
    function yy_r4(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor->push($this->yystack[$this->yyidx + 0]->minor);     }
#line 2684 "/var/www/coffeescript-php/grammar.php"
#line 41 "/var/www/coffeescript-php/grammar.y"
    function yy_r10(){ $this->_retvalue = yy('Literal', $this->yystack[$this->yyidx + 0]->minor);     }
#line 2687 "/var/www/coffeescript-php/grammar.php"
#line 69 "/var/www/coffeescript-php/grammar.y"
    function yy_r32(){
  $val = yy('Literal', $this->yystack[$this->yyidx + 0]->minor);
  $val->is_undefined = $this->yystack[$this->yyidx + 0]->minor === 'undefined';
  $this->_retvalue = $val;
    }
#line 2694 "/var/www/coffeescript-php/grammar.php"
#line 75 "/var/www/coffeescript-php/grammar.y"
    function yy_r33(){ $this->_retvalue = yy('Assign', $this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + 0]->minor);     }
#line 2697 "/var/www/coffeescript-php/grammar.php"
#line 76 "/var/www/coffeescript-php/grammar.y"
    function yy_r34(){ $this->_retvalue = yy('Assign', $this->yystack[$this->yyidx + -3]->minor, $this->yystack[$this->yyidx + 0]->minor);     }
#line 2700 "/var/www/coffeescript-php/grammar.php"
#line 77 "/var/www/coffeescript-php/grammar.y"
    function yy_r35(){ $this->_retvalue = yy('Assign', $this->yystack[$this->yyidx + -4]->minor, $this->yystack[$this->yyidx + -1]->minor);     }
#line 2703 "/var/www/coffeescript-php/grammar.php"
#line 79 "/var/www/coffeescript-php/grammar.y"
    function yy_r36(){ $this->_retvalue = yy('Value', $this->yystack[$this->yyidx + 0]->minor);     }
#line 2706 "/var/www/coffeescript-php/grammar.php"
#line 80 "/var/www/coffeescript-php/grammar.y"
    function yy_r37(){ $this->_retvalue = yy('Assign', yy('Value', $this->yystack[$this->yyidx + -2]->minor), $this->yystack[$this->yyidx + 0]->minor, 'object');     }
#line 2709 "/var/www/coffeescript-php/grammar.php"
#line 81 "/var/www/coffeescript-php/grammar.y"
    function yy_r38(){ $this->_retvalue = yy('Assign', yy('Value', $this->yystack[$this->yyidx + -4]->minor), $this->yystack[$this->yyidx + -1]->minor, 'object');     }
#line 2712 "/var/www/coffeescript-php/grammar.php"
#line 88 "/var/www/coffeescript-php/grammar.y"
    function yy_r43(){ $this->_retvalue = yy('Return', $this->yystack[$this->yyidx + 0]->minor);     }
#line 2715 "/var/www/coffeescript-php/grammar.php"
#line 89 "/var/www/coffeescript-php/grammar.y"
    function yy_r44(){ $this->_retvalue = yy('Return');     }
#line 2718 "/var/www/coffeescript-php/grammar.php"
#line 91 "/var/www/coffeescript-php/grammar.y"
    function yy_r45(){ $this->_retvalue = yy('Comment', $this->yystack[$this->yyidx + 0]->minor);     }
#line 2721 "/var/www/coffeescript-php/grammar.php"
#line 93 "/var/www/coffeescript-php/grammar.y"
    function yy_r46(){ $this->_retvalue = yy('Code', $this->yystack[$this->yyidx + -3]->minor, $this->yystack[$this->yyidx + 0]->minor, $this->yystack[$this->yyidx + -1]->minor);     }
#line 2724 "/var/www/coffeescript-php/grammar.php"
#line 94 "/var/www/coffeescript-php/grammar.y"
    function yy_r47(){ $this->_retvalue = yy('Code', array(), $this->yystack[$this->yyidx + 0]->minor, $this->yystack[$this->yyidx + -1]->minor);     }
#line 2727 "/var/www/coffeescript-php/grammar.php"
#line 96 "/var/www/coffeescript-php/grammar.y"
    function yy_r48(){ $this->_retvalue = 'func';     }
#line 2730 "/var/www/coffeescript-php/grammar.php"
#line 97 "/var/www/coffeescript-php/grammar.y"
    function yy_r49(){ $this->_retvalue = 'boundfunc';     }
#line 2733 "/var/www/coffeescript-php/grammar.php"
#line 99 "/var/www/coffeescript-php/grammar.y"
    function yy_r50(){ $this->_retvalue = '';     }
#line 2736 "/var/www/coffeescript-php/grammar.php"
#line 102 "/var/www/coffeescript-php/grammar.y"
    function yy_r52(){ $this->_retvalue = array();     }
#line 2739 "/var/www/coffeescript-php/grammar.php"
#line 103 "/var/www/coffeescript-php/grammar.y"
    function yy_r53(){ $this->_retvalue = array($this->yystack[$this->yyidx + 0]->minor);     }
#line 2742 "/var/www/coffeescript-php/grammar.php"
#line 104 "/var/www/coffeescript-php/grammar.y"
    function yy_r54(){ $this->_retvalue = array_merge($this->yystack[$this->yyidx + -2]->minor, array($this->yystack[$this->yyidx + 0]->minor));     }
#line 2745 "/var/www/coffeescript-php/grammar.php"
#line 106 "/var/www/coffeescript-php/grammar.y"
    function yy_r55(){ $this->_retvalue = yy('Param', $this->yystack[$this->yyidx + 0]->minor);     }
#line 2748 "/var/www/coffeescript-php/grammar.php"
#line 107 "/var/www/coffeescript-php/grammar.y"
    function yy_r56(){ $this->_retvalue = yy('Param', $this->yystack[$this->yyidx + -1]->minor, NULL, TRUE);     }
#line 2751 "/var/www/coffeescript-php/grammar.php"
#line 108 "/var/www/coffeescript-php/grammar.y"
    function yy_r57(){ $this->_retvalue = yy('Param', $this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + 0]->minor);     }
#line 2754 "/var/www/coffeescript-php/grammar.php"
#line 115 "/var/www/coffeescript-php/grammar.y"
    function yy_r62(){ $this->_retvalue = yy('Splat', $this->yystack[$this->yyidx + -1]->minor);     }
#line 2757 "/var/www/coffeescript-php/grammar.php"
#line 118 "/var/www/coffeescript-php/grammar.y"
    function yy_r64(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor->add($this->yystack[$this->yyidx + 0]->minor);     }
#line 2760 "/var/www/coffeescript-php/grammar.php"
#line 119 "/var/www/coffeescript-php/grammar.y"
    function yy_r65(){ $this->_retvalue = yy('Value', $this->yystack[$this->yyidx + -1]->minor, is_object($this->yystack[$this->yyidx + 0]->minor) ? array($this->yystack[$this->yyidx + 0]->minor) : (array) $this->yystack[$this->yyidx + 0]->minor);     }
#line 2763 "/var/www/coffeescript-php/grammar.php"
#line 132 "/var/www/coffeescript-php/grammar.y"
    function yy_r75(){ $this->_retvalue = yy('Access', $this->yystack[$this->yyidx + 0]->minor);     }
#line 2766 "/var/www/coffeescript-php/grammar.php"
#line 133 "/var/www/coffeescript-php/grammar.y"
    function yy_r76(){ $this->_retvalue = yy('Access', $this->yystack[$this->yyidx + 0]->minor, 'soak');     }
#line 2769 "/var/www/coffeescript-php/grammar.php"
#line 134 "/var/www/coffeescript-php/grammar.y"
    function yy_r77(){ $this->_retvalue = array( yy('Access', yy('Literal', 'prototype')), yy('Access', $this->yystack[$this->yyidx + 0]->minor) );     }
#line 2772 "/var/www/coffeescript-php/grammar.php"
#line 135 "/var/www/coffeescript-php/grammar.y"
    function yy_r78(){ $this->_retvalue = yy('Access', yy('Literal', 'prototype'));     }
#line 2775 "/var/www/coffeescript-php/grammar.php"
#line 139 "/var/www/coffeescript-php/grammar.y"
    function yy_r81(){ $this->_retvalue = extend($this->yystack[$this->yyidx + 0]->minor, array('soak' => TRUE));     }
#line 2778 "/var/www/coffeescript-php/grammar.php"
#line 141 "/var/www/coffeescript-php/grammar.y"
    function yy_r82(){ $this->_retvalue = yy('Index', $this->yystack[$this->yyidx + 0]->minor);     }
#line 2781 "/var/www/coffeescript-php/grammar.php"
#line 142 "/var/www/coffeescript-php/grammar.y"
    function yy_r83(){ $this->_retvalue = yy('Slice', $this->yystack[$this->yyidx + 0]->minor);     }
#line 2784 "/var/www/coffeescript-php/grammar.php"
#line 144 "/var/www/coffeescript-php/grammar.y"
    function yy_r84(){
  $object_start = $this->yystack[$this->yyidx - 3]->minor;
  $generated = isset($object_start->generated) ? $object_start->generated : FALSE;

  $this->_retvalue = yy('Obj', $this->yystack[$this->yyidx + -2]->minor, $generated);
    }
#line 2792 "/var/www/coffeescript-php/grammar.php"
#line 153 "/var/www/coffeescript-php/grammar.y"
    function yy_r87(){ $this->yystack[$this->yyidx + -2]->minor[] = $this->yystack[$this->yyidx + 0]->minor; $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor;     }
#line 2795 "/var/www/coffeescript-php/grammar.php"
#line 154 "/var/www/coffeescript-php/grammar.y"
    function yy_r88(){ $this->yystack[$this->yyidx + -3]->minor[] = $this->yystack[$this->yyidx + 0]->minor; $this->_retvalue = $this->yystack[$this->yyidx + -3]->minor;     }
#line 2798 "/var/www/coffeescript-php/grammar.php"
#line 155 "/var/www/coffeescript-php/grammar.y"
    function yy_r89(){ $this->_retvalue = array_merge($this->yystack[$this->yyidx + -5]->minor, $this->yystack[$this->yyidx + -2]->minor);     }
#line 2801 "/var/www/coffeescript-php/grammar.php"
#line 157 "/var/www/coffeescript-php/grammar.y"
    function yy_r90(){ $this->_retvalue = yy('Class');     }
#line 2804 "/var/www/coffeescript-php/grammar.php"
#line 158 "/var/www/coffeescript-php/grammar.y"
    function yy_r91(){ $this->_retvalue = yy('Class', NULL, NULL, $this->yystack[$this->yyidx + 0]->minor);     }
#line 2807 "/var/www/coffeescript-php/grammar.php"
#line 159 "/var/www/coffeescript-php/grammar.y"
    function yy_r92(){ $this->_retvalue = yy('Class', NULL, $this->yystack[$this->yyidx + 0]->minor);     }
#line 2810 "/var/www/coffeescript-php/grammar.php"
#line 160 "/var/www/coffeescript-php/grammar.y"
    function yy_r93(){ $this->_retvalue = yy('Class', NULL, $this->yystack[$this->yyidx + -1]->minor, $this->yystack[$this->yyidx + 0]->minor);     }
#line 2813 "/var/www/coffeescript-php/grammar.php"
#line 161 "/var/www/coffeescript-php/grammar.y"
    function yy_r94(){ $this->_retvalue = yy('Class', $this->yystack[$this->yyidx + 0]->minor);     }
#line 2816 "/var/www/coffeescript-php/grammar.php"
#line 162 "/var/www/coffeescript-php/grammar.y"
    function yy_r95(){ $this->_retvalue = yy('Class', $this->yystack[$this->yyidx + -1]->minor, NULL, $this->yystack[$this->yyidx + 0]->minor);     }
#line 2819 "/var/www/coffeescript-php/grammar.php"
#line 163 "/var/www/coffeescript-php/grammar.y"
    function yy_r96(){ $this->_retvalue = yy('Class', $this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + 0]->minor);     }
#line 2822 "/var/www/coffeescript-php/grammar.php"
#line 164 "/var/www/coffeescript-php/grammar.y"
    function yy_r97(){ $this->_retvalue = yy('Class', $this->yystack[$this->yyidx + -3]->minor, $this->yystack[$this->yyidx + -1]->minor, $this->yystack[$this->yyidx + 0]->minor);     }
#line 2825 "/var/www/coffeescript-php/grammar.php"
#line 166 "/var/www/coffeescript-php/grammar.y"
    function yy_r98(){ $this->_retvalue = yy('Call', $this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + 0]->minor, $this->yystack[$this->yyidx + -1]->minor);     }
#line 2828 "/var/www/coffeescript-php/grammar.php"
#line 168 "/var/www/coffeescript-php/grammar.y"
    function yy_r100(){ $this->_retvalue = yy('Call', 'super', array(yy('Splat', yy('Literal', 'arguments'))));     }
#line 2831 "/var/www/coffeescript-php/grammar.php"
#line 169 "/var/www/coffeescript-php/grammar.y"
    function yy_r101(){ $this->_retvalue = yy('Call', 'super', $this->yystack[$this->yyidx + 0]->minor);     }
#line 2834 "/var/www/coffeescript-php/grammar.php"
#line 171 "/var/www/coffeescript-php/grammar.y"
    function yy_r102(){ $this->_retvalue = FALSE;     }
#line 2837 "/var/www/coffeescript-php/grammar.php"
#line 172 "/var/www/coffeescript-php/grammar.y"
    function yy_r103(){ $this->_retvalue = TRUE;     }
#line 2840 "/var/www/coffeescript-php/grammar.php"
#line 175 "/var/www/coffeescript-php/grammar.y"
    function yy_r105(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor;     }
#line 2843 "/var/www/coffeescript-php/grammar.php"
#line 177 "/var/www/coffeescript-php/grammar.y"
    function yy_r106(){ $this->_retvalue = yy('Value', yy('Literal', 'this'));     }
#line 2846 "/var/www/coffeescript-php/grammar.php"
#line 180 "/var/www/coffeescript-php/grammar.y"
    function yy_r108(){ $this->_retvalue = yy('Value', yy('Literal', 'this'), array(yy('Access', $this->yystack[$this->yyidx + 0]->minor)), 'this');     }
#line 2849 "/var/www/coffeescript-php/grammar.php"
#line 182 "/var/www/coffeescript-php/grammar.y"
    function yy_r109(){ $this->_retvalue = yy('Arr', array());     }
#line 2852 "/var/www/coffeescript-php/grammar.php"
#line 183 "/var/www/coffeescript-php/grammar.y"
    function yy_r110(){ $this->_retvalue = yy('Arr', $this->yystack[$this->yyidx + -2]->minor);     }
#line 2855 "/var/www/coffeescript-php/grammar.php"
#line 185 "/var/www/coffeescript-php/grammar.y"
    function yy_r111(){ $this->_retvalue = 'inclusive';     }
#line 2858 "/var/www/coffeescript-php/grammar.php"
#line 186 "/var/www/coffeescript-php/grammar.y"
    function yy_r112(){ $this->_retvalue = 'exclusive';     }
#line 2861 "/var/www/coffeescript-php/grammar.php"
#line 188 "/var/www/coffeescript-php/grammar.y"
    function yy_r113(){ $this->_retvalue = yy('Range', $this->yystack[$this->yyidx + -3]->minor, $this->yystack[$this->yyidx + -1]->minor, $this->yystack[$this->yyidx + -2]->minor);     }
#line 2864 "/var/www/coffeescript-php/grammar.php"
#line 190 "/var/www/coffeescript-php/grammar.y"
    function yy_r114(){ $this->_retvalue = yy('Range', $this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + 0]->minor, $this->yystack[$this->yyidx + -1]->minor);     }
#line 2867 "/var/www/coffeescript-php/grammar.php"
#line 191 "/var/www/coffeescript-php/grammar.y"
    function yy_r115(){ $this->_retvalue = yy('Range', $this->yystack[$this->yyidx + -1]->minor, NULL, $this->yystack[$this->yyidx + 0]->minor);     }
#line 2870 "/var/www/coffeescript-php/grammar.php"
#line 192 "/var/www/coffeescript-php/grammar.y"
    function yy_r116(){ $this->_retvalue = yy('Range', NULL, $this->yystack[$this->yyidx + 0]->minor, $this->yystack[$this->yyidx + -1]->minor);     }
#line 2873 "/var/www/coffeescript-php/grammar.php"
#line 193 "/var/www/coffeescript-php/grammar.y"
    function yy_r117(){ $this->_retvalue = yy('Range', NULL, NULL, $this->yystack[$this->yyidx + 0]->minor);     }
#line 2876 "/var/www/coffeescript-php/grammar.php"
#line 197 "/var/www/coffeescript-php/grammar.y"
    function yy_r120(){ $this->_retvalue = array_merge($this->yystack[$this->yyidx + -3]->minor, array($this->yystack[$this->yyidx + 0]->minor));     }
#line 2879 "/var/www/coffeescript-php/grammar.php"
#line 205 "/var/www/coffeescript-php/grammar.y"
    function yy_r126(){ $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + 0]->minor);     }
#line 2882 "/var/www/coffeescript-php/grammar.php"
#line 207 "/var/www/coffeescript-php/grammar.y"
    function yy_r127(){ $this->_retvalue = yy('Try', $this->yystack[$this->yyidx + 0]->minor);     }
#line 2885 "/var/www/coffeescript-php/grammar.php"
#line 208 "/var/www/coffeescript-php/grammar.y"
    function yy_r128(){ $this->_retvalue = yy('Try', $this->yystack[$this->yyidx + -1]->minor, $this->yystack[$this->yyidx + 0]->minor[0], $this->yystack[$this->yyidx + 0]->minor[1]);      }
#line 2888 "/var/www/coffeescript-php/grammar.php"
#line 209 "/var/www/coffeescript-php/grammar.y"
    function yy_r129(){ $this->_retvalue = yy('Try', $this->yystack[$this->yyidx + -2]->minor, NULL, NULL, $this->yystack[$this->yyidx + 0]->minor);     }
#line 2891 "/var/www/coffeescript-php/grammar.php"
#line 210 "/var/www/coffeescript-php/grammar.y"
    function yy_r130(){ $this->_retvalue = yy('Try', $this->yystack[$this->yyidx + -3]->minor, $this->yystack[$this->yyidx + -2]->minor[0], $this->yystack[$this->yyidx + -2]->minor[1], $this->yystack[$this->yyidx + 0]->minor);     }
#line 2894 "/var/www/coffeescript-php/grammar.php"
#line 212 "/var/www/coffeescript-php/grammar.y"
    function yy_r131(){ $this->_retvalue = array($this->yystack[$this->yyidx + -1]->minor, $this->yystack[$this->yyidx + 0]->minor);     }
#line 2897 "/var/www/coffeescript-php/grammar.php"
#line 214 "/var/www/coffeescript-php/grammar.y"
    function yy_r132(){ $this->_retvalue = yy('Throw', $this->yystack[$this->yyidx + 0]->minor);     }
#line 2900 "/var/www/coffeescript-php/grammar.php"
#line 216 "/var/www/coffeescript-php/grammar.y"
    function yy_r133(){ $this->_retvalue = yy('Parens', $this->yystack[$this->yyidx + -1]->minor);     }
#line 2903 "/var/www/coffeescript-php/grammar.php"
#line 217 "/var/www/coffeescript-php/grammar.y"
    function yy_r134(){ $this->_retvalue = yy('Parens', $this->yystack[$this->yyidx + -2]->minor);     }
#line 2906 "/var/www/coffeescript-php/grammar.php"
#line 219 "/var/www/coffeescript-php/grammar.y"
    function yy_r135(){ $this->_retvalue = yy('While', $this->yystack[$this->yyidx + 0]->minor);     }
#line 2909 "/var/www/coffeescript-php/grammar.php"
#line 220 "/var/www/coffeescript-php/grammar.y"
    function yy_r136(){ $this->_retvalue = yy('While', $this->yystack[$this->yyidx + -2]->minor, array('guard' => $this->yystack[$this->yyidx + 0]->minor));     }
#line 2912 "/var/www/coffeescript-php/grammar.php"
#line 221 "/var/www/coffeescript-php/grammar.y"
    function yy_r137(){ $this->_retvalue = yy('While', $this->yystack[$this->yyidx + 0]->minor, array('invert' => TRUE));     }
#line 2915 "/var/www/coffeescript-php/grammar.php"
#line 222 "/var/www/coffeescript-php/grammar.y"
    function yy_r138(){ $this->_retvalue = yy('While', $this->yystack[$this->yyidx + -2]->minor, array('invert' => TRUE, 'guard' => $this->yystack[$this->yyidx + 0]->minor));     }
#line 2918 "/var/www/coffeescript-php/grammar.php"
#line 224 "/var/www/coffeescript-php/grammar.y"
    function yy_r139(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor->add_body($this->yystack[$this->yyidx + 0]->minor);     }
#line 2921 "/var/www/coffeescript-php/grammar.php"
#line 225 "/var/www/coffeescript-php/grammar.y"
    function yy_r140(){ $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor->add_body(yy_Block::wrap(array($this->yystack[$this->yyidx + -1]->minor)));     }
#line 2924 "/var/www/coffeescript-php/grammar.php"
#line 229 "/var/www/coffeescript-php/grammar.y"
    function yy_r143(){ $this->_retvalue = yy('While', yy('Literal', 'true')); $this->_retvalue->add_body($this->yystack[$this->yyidx + 0]->minor);     }
#line 2927 "/var/www/coffeescript-php/grammar.php"
#line 230 "/var/www/coffeescript-php/grammar.y"
    function yy_r144(){ $this->_retvalue = yy('While', yy('Literal', 'true')); $this->_retvalue->add_body(yy_Block::wrap($this->yystack[$this->yyidx + 0]->minor));     }
#line 2930 "/var/www/coffeescript-php/grammar.php"
#line 232 "/var/www/coffeescript-php/grammar.y"
    function yy_r145(){ $this->_retvalue = yy('For', $this->yystack[$this->yyidx + -1]->minor, $this->yystack[$this->yyidx + 0]->minor);     }
#line 2933 "/var/www/coffeescript-php/grammar.php"
#line 234 "/var/www/coffeescript-php/grammar.y"
    function yy_r147(){ $this->_retvalue = yy('For', $this->yystack[$this->yyidx + 0]->minor, $this->yystack[$this->yyidx + -1]->minor);     }
#line 2936 "/var/www/coffeescript-php/grammar.php"
#line 236 "/var/www/coffeescript-php/grammar.y"
    function yy_r148(){ $this->_retvalue = array('source' => yy('Value', $this->yystack[$this->yyidx + 0]->minor));     }
#line 2939 "/var/www/coffeescript-php/grammar.php"
#line 237 "/var/www/coffeescript-php/grammar.y"
    function yy_r149(){ $this->yystack[$this->yyidx + 0]->minor['own'] = isset($this->yystack[$this->yyidx + -1]->minor['own']) ? $this->yystack[$this->yyidx + -1]->minor['own'] : NULL; $this->yystack[$this->yyidx + 0]->minor['name'] = $this->yystack[$this->yyidx + -1]->minor[0]; $this->yystack[$this->yyidx + 0]->minor['index'] = isset($this->yystack[$this->yyidx + -1]->minor[1]) ? $this->yystack[$this->yyidx + -1]->minor[1] : NULL; $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;     }
#line 2942 "/var/www/coffeescript-php/grammar.php"
#line 240 "/var/www/coffeescript-php/grammar.y"
    function yy_r151(){ $this->yystack[$this->yyidx + 0]->minor['own'] = TRUE; $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;     }
#line 2945 "/var/www/coffeescript-php/grammar.php"
#line 249 "/var/www/coffeescript-php/grammar.y"
    function yy_r157(){ $this->_retvalue = array('source' => $this->yystack[$this->yyidx + 0]->minor);     }
#line 2948 "/var/www/coffeescript-php/grammar.php"
#line 250 "/var/www/coffeescript-php/grammar.y"
    function yy_r158(){ $this->_retvalue = array('source' => $this->yystack[$this->yyidx + 0]->minor, 'object' => TRUE);     }
#line 2951 "/var/www/coffeescript-php/grammar.php"
#line 251 "/var/www/coffeescript-php/grammar.y"
    function yy_r159(){ $this->_retvalue = array('source' => $this->yystack[$this->yyidx + -2]->minor, 'guard' => $this->yystack[$this->yyidx + 0]->minor);     }
#line 2954 "/var/www/coffeescript-php/grammar.php"
#line 252 "/var/www/coffeescript-php/grammar.y"
    function yy_r160(){ $this->_retvalue = array('source' => $this->yystack[$this->yyidx + -2]->minor, 'guard' => $this->yystack[$this->yyidx + 0]->minor, 'object' => TRUE);     }
#line 2957 "/var/www/coffeescript-php/grammar.php"
#line 253 "/var/www/coffeescript-php/grammar.y"
    function yy_r161(){ $this->_retvalue = array('source' => $this->yystack[$this->yyidx + -2]->minor, 'step' => $this->yystack[$this->yyidx + 0]->minor);     }
#line 2960 "/var/www/coffeescript-php/grammar.php"
#line 254 "/var/www/coffeescript-php/grammar.y"
    function yy_r162(){ $this->_retvalue = array('source' => $this->yystack[$this->yyidx + -4]->minor, 'guard' => $this->yystack[$this->yyidx + -2]->minor, 'step' => $this->yystack[$this->yyidx + 0]->minor);     }
#line 2963 "/var/www/coffeescript-php/grammar.php"
#line 255 "/var/www/coffeescript-php/grammar.y"
    function yy_r163(){ $this->_retvalue = array('source' => $this->yystack[$this->yyidx + -4]->minor, 'step' => $this->yystack[$this->yyidx + -2]->minor, 'guard' => $this->yystack[$this->yyidx + 0]->minor);     }
#line 2966 "/var/www/coffeescript-php/grammar.php"
#line 257 "/var/www/coffeescript-php/grammar.y"
    function yy_r164(){ $this->_retvalue = yy('Switch', $this->yystack[$this->yyidx + -3]->minor, $this->yystack[$this->yyidx + -1]->minor);     }
#line 2969 "/var/www/coffeescript-php/grammar.php"
#line 258 "/var/www/coffeescript-php/grammar.y"
    function yy_r165(){ $this->_retvalue = yy('Switch', $this->yystack[$this->yyidx + -5]->minor, $this->yystack[$this->yyidx + -3]->minor, $this->yystack[$this->yyidx + -1]->minor);     }
#line 2972 "/var/www/coffeescript-php/grammar.php"
#line 259 "/var/www/coffeescript-php/grammar.y"
    function yy_r166(){ $this->_retvalue = yy('Switch', NULL, $this->yystack[$this->yyidx + -1]->minor);     }
#line 2975 "/var/www/coffeescript-php/grammar.php"
#line 260 "/var/www/coffeescript-php/grammar.y"
    function yy_r167(){ $this->_retvalue = yy('Switch', NULL, $this->yystack[$this->yyidx + -3]->minor, $this->yystack[$this->yyidx + -1]->minor);     }
#line 2978 "/var/www/coffeescript-php/grammar.php"
#line 263 "/var/www/coffeescript-php/grammar.y"
    function yy_r169(){ $this->_retvalue = array_merge($this->yystack[$this->yyidx + -1]->minor, $this->yystack[$this->yyidx + 0]->minor);     }
#line 2981 "/var/www/coffeescript-php/grammar.php"
#line 265 "/var/www/coffeescript-php/grammar.y"
    function yy_r170(){ $this->_retvalue = array(array($this->yystack[$this->yyidx + -1]->minor, $this->yystack[$this->yyidx + 0]->minor));     }
#line 2984 "/var/www/coffeescript-php/grammar.php"
#line 266 "/var/www/coffeescript-php/grammar.y"
    function yy_r171(){ $this->_retvalue = array(array($this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + -1]->minor));     }
#line 2987 "/var/www/coffeescript-php/grammar.php"
#line 268 "/var/www/coffeescript-php/grammar.y"
    function yy_r172(){ $this->_retvalue = yy('If', $this->yystack[$this->yyidx + -1]->minor, $this->yystack[$this->yyidx + 0]->minor, array('type' => $this->yystack[$this->yyidx + -2]->minor));     }
#line 2990 "/var/www/coffeescript-php/grammar.php"
#line 269 "/var/www/coffeescript-php/grammar.y"
    function yy_r173(){ $this->_retvalue = $this->yystack[$this->yyidx + -4]->minor->add_else(yy('If', $this->yystack[$this->yyidx + -1]->minor, $this->yystack[$this->yyidx + 0]->minor, array('type' => $this->yystack[$this->yyidx + -2]->minor)));     }
#line 2993 "/var/www/coffeescript-php/grammar.php"
#line 272 "/var/www/coffeescript-php/grammar.y"
    function yy_r175(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor->add_else($this->yystack[$this->yyidx + 0]->minor);     }
#line 2996 "/var/www/coffeescript-php/grammar.php"
#line 273 "/var/www/coffeescript-php/grammar.y"
    function yy_r176(){ $this->_retvalue = yy('If', $this->yystack[$this->yyidx + 0]->minor, yy_Block::wrap(array($this->yystack[$this->yyidx + -2]->minor)), array('type' => $this->yystack[$this->yyidx + -1]->minor, 'statement' => TRUE));     }
#line 2999 "/var/www/coffeescript-php/grammar.php"
#line 276 "/var/www/coffeescript-php/grammar.y"
    function yy_r178(){ $this->_retvalue = yy('Op', $this->yystack[$this->yyidx + -1]->minor, $this->yystack[$this->yyidx + 0]->minor);     }
#line 3002 "/var/www/coffeescript-php/grammar.php"
#line 277 "/var/www/coffeescript-php/grammar.y"
    function yy_r179(){ $this->_retvalue = yy('Op', $this->yystack[$this->yyidx + -1]->minor, $this->yystack[$this->yyidx + 0]->minor); /* prec: 'UNARY'; */     }
#line 3005 "/var/www/coffeescript-php/grammar.php"
#line 282 "/var/www/coffeescript-php/grammar.y"
    function yy_r183(){ $this->_retvalue = yy('Op', $this->yystack[$this->yyidx + 0]->minor, $this->yystack[$this->yyidx + -1]->minor, NULL, TRUE);     }
#line 3008 "/var/www/coffeescript-php/grammar.php"
#line 285 "/var/www/coffeescript-php/grammar.y"
    function yy_r185(){ $this->_retvalue = yy('Existence', $this->yystack[$this->yyidx + -1]->minor);     }
#line 3011 "/var/www/coffeescript-php/grammar.php"
#line 287 "/var/www/coffeescript-php/grammar.y"
    function yy_r186(){ $this->_retvalue = yy('Op', $this->yystack[$this->yyidx + -1]->minor, $this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + 0]->minor);     }
#line 3014 "/var/www/coffeescript-php/grammar.php"
#line 294 "/var/www/coffeescript-php/grammar.y"
    function yy_r192(){
  if ($this->yystack[$this->yyidx + -1]->minor{0} === '!') {
    $this->_retvalue = yy('Op', substr($this->yystack[$this->yyidx + -1]->minor, 1), $this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + 0]->minor);
    $this->_retvalue = $this->_retvalue->invert();
  }
  else {
    $this->_retvalue = yy('Op', $this->yystack[$this->yyidx + -1]->minor, $this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + 0]->minor);
  }
    }
#line 3025 "/var/www/coffeescript-php/grammar.php"
#line 304 "/var/www/coffeescript-php/grammar.y"
    function yy_r193(){ $this->_retvalue = yy('Assign', $this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + 0]->minor, $this->yystack[$this->yyidx + -1]->minor);     }
#line 3028 "/var/www/coffeescript-php/grammar.php"
#line 305 "/var/www/coffeescript-php/grammar.y"
    function yy_r194(){ $this->_retvalue = yy('Assign', $this->yystack[$this->yyidx + -4]->minor, $this->yystack[$this->yyidx + -1]->minor, $this->yystack[$this->yyidx + -3]->minor);     }
#line 3031 "/var/www/coffeescript-php/grammar.php"
#line 306 "/var/www/coffeescript-php/grammar.y"
    function yy_r195(){ $this->_retvalue = yy('Extends', $this->yystack[$this->yyidx + -2]->minor, $this->yystack[$this->yyidx + 0]->minor);     }
#line 3034 "/var/www/coffeescript-php/grammar.php"

    /**
     * placeholder for the left hand side in a reduce operation.
     * 
     * For a parser with a rule like this:
     * <pre>
     * rule(A) ::= B. { A = 1; }
     * </pre>
     * 
     * The parser will translate to something like:
     * 
     * <code>
     * function yy_r0(){$this->_retvalue = 1;}
     * </code>
     */
    private $_retvalue;

    /**
     * Perform a reduce action and the shift that must immediately
     * follow the reduce.
     * 
     * For a rule such as:
     * 
     * <pre>
     * A ::= B blah C. { dosomething(); }
     * </pre>
     * 
     * This function will first call the action, if any, ("dosomething();" in our
     * example), and then it will pop three states from the stack,
     * one for each entry on the right-hand side of the expression
     * (B, blah, and C in our example rule), and then push the result of the action
     * back on to the stack with the resulting state reduced to (as described in the .out
     * file)
     * @param int Number of the rule by which to reduce
     */
    function yy_reduce($yyruleno)
    {
        //int $yygoto;                     /* The next state */
        //int $yyact;                      /* The next action */
        //mixed $yygotominor;        /* The LHS of the rule reduced */
        //yyStackEntry $yymsp;            /* The top of the parser's stack */
        //int $yysize;                     /* Amount to pop the stack */
        $yymsp = $this->yystack[$this->yyidx];
        if (self::$yyTraceFILE && $yyruleno >= 0 
              && $yyruleno < count(self::$yyRuleName)) {
            fprintf(self::$yyTraceFILE, "%sReduce (%d) [%s].\n",
                self::$yyTracePrompt, $yyruleno,
                self::$yyRuleName[$yyruleno]);
        }

        $this->_retvalue = $yy_lefthand_side = null;
        if (array_key_exists($yyruleno, self::$yyReduceMap)) {
            // call the action
            $this->_retvalue = null;
            $this->{'yy_r' . self::$yyReduceMap[$yyruleno]}();
            $yy_lefthand_side = $this->_retvalue;
        }
        $yygoto = self::$yyRuleInfo[$yyruleno]['lhs'];
        $yysize = self::$yyRuleInfo[$yyruleno]['rhs'];
        $this->yyidx -= $yysize;
        for ($i = $yysize; $i; $i--) {
            // pop all of the right-hand side parameters
            array_pop($this->yystack);
        }
        $yyact = $this->yy_find_reduce_action($this->yystack[$this->yyidx]->stateno, $yygoto);
        if ($yyact < self::YYNSTATE) {
            /* If we are not debugging and the reduce action popped at least
            ** one element off the stack, then we can push the new element back
            ** onto the stack here, and skip the stack overflow test in yy_shift().
            ** That gives a significant speed improvement. */
            if (!self::$yyTraceFILE && $yysize) {
                $this->yyidx++;
                $x = new yyStackEntry;
                $x->stateno = $yyact;
                $x->major = $yygoto;
                $x->minor = $yy_lefthand_side;
                $this->yystack[$this->yyidx] = $x;
            } else {
                $this->yy_shift($yyact, $yygoto, $yy_lefthand_side);
            }
        } elseif ($yyact == self::YYNSTATE + self::YYNRULE + 1) {
            $this->yy_accept();
        }
    }

    /**
     * The following code executes when the parse fails
     * 
     * Code from %parse_fail is inserted here
     */
    function yy_parse_failed()
    {
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sFail!\n", self::$yyTracePrompt);
        }
        while ($this->yyidx >= 0) {
            $this->yy_pop_parser_stack();
        }
        /* Here code is inserted which will be executed whenever the
        ** parser fails */
    }

    /**
     * The following code executes when a syntax error first occurs.
     * 
     * %syntax_error code is inserted here
     * @param int The major type of the error token
     * @param mixed The minor type of the error token
     */
    function yy_syntax_error($yymajor, $TOKEN)
    {
#line 4 "/var/www/coffeescript-php/grammar.y"
 
  throw new SyntaxError(
    'unexpected '.$this->tokenName($yymajor).' in '.self::$FILE.':'
  . (self::$LINE + 1).'.'
  );
#line 3153 "/var/www/coffeescript-php/grammar.php"
    }

    /**
     * The following is executed when the parser accepts
     * 
     * %parse_accept code is inserted here
     */
    function yy_accept()
    {
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sAccept!\n", self::$yyTracePrompt);
        }
        while ($this->yyidx >= 0) {
            $stack = $this->yy_pop_parser_stack();
        }
        /* Here code is inserted which will be executed whenever the
        ** parser accepts */
    }

    /**
     * The main parser program.
     * 
     * The first argument is the major token number.  The second is
     * the token value string as scanned from the input.
     *
     * @param int   $yymajor      the token number
     * @param mixed $yytokenvalue the token value
     * @param mixed ...           any extra arguments that should be passed to handlers
     *
     * @return void
     */
    function parse($token)
    {
        list($yymajor, $yytokenvalue, ) = $token ? $token : array(0, 0);
        self::$LINE = isset($token[2]) ? $token[2] : -1;

//        $yyact;            /* The parser action. */
//        $yyendofinput;     /* True if we are at the end of input */
        $yyerrorhit = 0;   /* True if yymajor has invoked an error */
        
        /* (re)initialize the parser, if necessary */
        if ($this->yyidx === null || $this->yyidx < 0) {
            /* if ($yymajor == 0) return; // not sure why this was here... */
            $this->yyidx = 0;
            $this->yyerrcnt = -1;
            $x = new yyStackEntry;
            $x->stateno = 0;
            $x->major = 0;
            $this->yystack = array();
            array_push($this->yystack, $x);
        }
        $yyendofinput = ($yymajor==0);
        
        if (self::$yyTraceFILE) {
            fprintf(
                self::$yyTraceFILE,
                "%sInput %s\n",
                self::$yyTracePrompt,
                self::tokenName($yymajor)
            );
        }
        
        do {
            $yyact = $this->yy_find_shift_action($yymajor);
            if ($yymajor < self::YYERRORSYMBOL
                && !$this->yy_is_expected_token($yymajor)
            ) {
                // force a syntax error
                $yyact = self::YY_ERROR_ACTION;
            }
            if ($yyact < self::YYNSTATE) {
                $this->yy_shift($yyact, $yymajor, $yytokenvalue);
                $this->yyerrcnt--;
                if ($yyendofinput && $this->yyidx >= 0) {
                    $yymajor = 0;
                } else {
                    $yymajor = self::YYNOCODE;
                }
            } elseif ($yyact < self::YYNSTATE + self::YYNRULE) {
                $this->yy_reduce($yyact - self::YYNSTATE);
            } elseif ($yyact == self::YY_ERROR_ACTION) {
                if (self::$yyTraceFILE) {
                    fprintf(
                        self::$yyTraceFILE,
                        "%sSyntax Error!\n",
                        self::$yyTracePrompt
                    );
                }
                if (self::YYERRORSYMBOL) {
                    /* A syntax error has occurred.
                    ** The response to an error depends upon whether or not the
                    ** grammar defines an error token "ERROR".  
                    **
                    ** This is what we do if the grammar does define ERROR:
                    **
                    **  * Call the %syntax_error function.
                    **
                    **  * Begin popping the stack until we enter a state where
                    **    it is legal to shift the error symbol, then shift
                    **    the error symbol.
                    **
                    **  * Set the error count to three.
                    **
                    **  * Begin accepting and shifting new tokens.  No new error
                    **    processing will occur until three tokens have been
                    **    shifted successfully.
                    **
                    */
                    if ($this->yyerrcnt < 0) {
                        $this->yy_syntax_error($yymajor, $yytokenvalue);
                    }
                    $yymx = $this->yystack[$this->yyidx]->major;
                    if ($yymx == self::YYERRORSYMBOL || $yyerrorhit ) {
                        if (self::$yyTraceFILE) {
                            fprintf(
                                self::$yyTraceFILE,
                                "%sDiscard input token %s\n",
                                self::$yyTracePrompt,
                                self::tokenName($yymajor)
                            );
                        }
                        $this->yy_destructor($yymajor, $yytokenvalue);
                        $yymajor = self::YYNOCODE;
                    } else {
                        while ($this->yyidx >= 0
                            && $yymx != self::YYERRORSYMBOL
                            && ($yyact = $this->yy_find_shift_action(self::YYERRORSYMBOL)) >= self::YYNSTATE
                        ) {
                            $this->yy_pop_parser_stack();
                        }
                        if ($this->yyidx < 0 || $yymajor==0) {
                            $this->yy_destructor($yymajor, $yytokenvalue);
                            $this->yy_parse_failed();
                            $yymajor = self::YYNOCODE;
                        } elseif ($yymx != self::YYERRORSYMBOL) {
                            $u2 = 0;
                            $this->yy_shift($yyact, self::YYERRORSYMBOL, $u2);
                        }
                    }
                    $this->yyerrcnt = 3;
                    $yyerrorhit = 1;
                } else {
                    /* YYERRORSYMBOL is not defined */
                    /* This is what we do if the grammar does not define ERROR:
                    **
                    **  * Report an error message, and throw away the input token.
                    **
                    **  * If the input token is $, then fail the parse.
                    **
                    ** As before, subsequent error messages are suppressed until
                    ** three input tokens have been successfully shifted.
                    */
                    if ($this->yyerrcnt <= 0) {
                        $this->yy_syntax_error($yymajor, $yytokenvalue);
                    }
                    $this->yyerrcnt = 3;
                    $this->yy_destructor($yymajor, $yytokenvalue);
                    if ($yyendofinput) {
                        $this->yy_parse_failed();
                    }
                    $yymajor = self::YYNOCODE;
                }
            } else {
                $this->yy_accept();
                $yymajor = self::YYNOCODE;
            }            
        } while ($yymajor != self::YYNOCODE && $this->yyidx >= 0);

        if ($token === NULL)
        {
          return $this->_retvalue;
        }
    }
}
