<?php namespace Anomaly\Streams\Platform\Model\Users;

use Anomaly\Streams\Platform\Entry\EntryModel;

class UsersUsersEntryModel extends EntryModel
{

    use \Illuminate\Database\Eloquent\SoftDeletes;

    protected $table = 'users_users';

    protected $titleName = 'display_name';

    protected $rules = [
'email' => 'required|unique:users_users,email',
'username' => 'required|unique:users_users,username',
'password' => 'required',
'roles' => 'required',
'display_name' => 'required',
'first_name' => '',
'last_name' => '',
'activated' => '',
'enabled' => '',
'permissions' => '',
'last_login_at' => '',
'remember_token' => '',
'activation_code' => '',
'reset_code' => '',
'last_activity_at' => '',
'ip_address' => '',
];

    protected $fields = [
'email',
'username',
'password',
'roles',
'display_name',
'first_name',
'last_name',
'activated',
'enabled',
'permissions',
'last_login_at',
'remember_token',
'activation_code',
'reset_code',
'last_activity_at',
'ip_address',
];

    protected $dates = ['created_at', 'updated_at', 'last_login_at', 'last_activity_at', 'deleted_at'];

    protected $relationships = ['roles'];

    

    

    

    protected $stream = [
'id' => '17',
'namespace' => 'users',
'slug' => 'users',
'prefix' => 'users_',
'title_column' => 'display_name',
'order_by' => 'id',
'locked' => '0',
'hidden' => '0',
'sortable' => '0',
'trashable' => '1',
'translatable' => '0',
'config' => 'a:0:{}',
'assignments' => [
[
'id' => '99',
'sort_order' => '99',
'stream_id' => '17',
'field_id' => '89',
'config' => 'a:0:{}',
'unique' => '1',
'required' => '1',
'translatable' => '0',
'field' => [
'id' => '89',
'namespace' => 'users',
'slug' => 'email',
'type' => 'anomaly.field_type.email',
'config' => 'a:0:{}',
'locked' => '1',
'translations' => [
[
'id' => '89',
'field_id' => '89',
'locale' => 'en',
'name' => 'anomaly.module.users::field.email.name',
'placeholder' => 'anomaly.module.users::field.email.placeholder',
'warning' => 'anomaly.module.users::field.email.warning',
'instructions' => 'anomaly.module.users::field.email.instructions',
],
],
],
'translations' => [
[
'id' => '99',
'assignment_id' => '99',
'locale' => 'en',
'label' => 'anomaly.module.users::field.email.label.users',
'warning' => 'anomaly.module.users::field.email.warning.users',
'placeholder' => 'anomaly.module.users::field.email.placeholder.users',
'instructions' => 'anomaly.module.users::field.email.instructions.users',
],
],
],
[
'id' => '100',
'sort_order' => '100',
'stream_id' => '17',
'field_id' => '90',
'config' => 'a:0:{}',
'unique' => '1',
'required' => '1',
'translatable' => '0',
'field' => [
'id' => '90',
'namespace' => 'users',
'slug' => 'username',
'type' => 'anomaly.field_type.slug',
'config' => 'a:1:{s:4:"type";s:1:"_";}',
'locked' => '1',
'translations' => [
[
'id' => '90',
'field_id' => '90',
'locale' => 'en',
'name' => 'anomaly.module.users::field.username.name',
'placeholder' => 'anomaly.module.users::field.username.placeholder',
'warning' => 'anomaly.module.users::field.username.warning',
'instructions' => 'anomaly.module.users::field.username.instructions',
],
],
],
'translations' => [
[
'id' => '100',
'assignment_id' => '100',
'locale' => 'en',
'label' => 'anomaly.module.users::field.username.label.users',
'warning' => 'anomaly.module.users::field.username.warning.users',
'placeholder' => 'anomaly.module.users::field.username.placeholder.users',
'instructions' => 'anomaly.module.users::field.username.instructions.users',
],
],
],
[
'id' => '101',
'sort_order' => '101',
'stream_id' => '17',
'field_id' => '91',
'config' => 'a:0:{}',
'unique' => '0',
'required' => '1',
'translatable' => '0',
'field' => [
'id' => '91',
'namespace' => 'users',
'slug' => 'password',
'type' => 'anomaly.field_type.text',
'config' => 'a:1:{s:4:"type";s:8:"password";}',
'locked' => '1',
'translations' => [
[
'id' => '91',
'field_id' => '91',
'locale' => 'en',
'name' => 'anomaly.module.users::field.password.name',
'placeholder' => 'anomaly.module.users::field.password.placeholder',
'warning' => 'anomaly.module.users::field.password.warning',
'instructions' => 'anomaly.module.users::field.password.instructions',
],
],
],
'translations' => [
[
'id' => '101',
'assignment_id' => '101',
'locale' => 'en',
'label' => 'anomaly.module.users::field.password.label.users',
'warning' => 'anomaly.module.users::field.password.warning.users',
'placeholder' => 'anomaly.module.users::field.password.placeholder.users',
'instructions' => 'anomaly.module.users::field.password.instructions.users',
],
],
],
[
'id' => '102',
'sort_order' => '102',
'stream_id' => '17',
'field_id' => '109',
'config' => 'a:0:{}',
'unique' => '0',
'required' => '1',
'translatable' => '0',
'field' => [
'id' => '109',
'namespace' => 'users',
'slug' => 'roles',
'type' => 'anomaly.field_type.multiple',
'config' => 'a:1:{s:7:"related";s:34:"Anomaly\UsersModule\Role\RoleModel";}',
'locked' => '1',
'translations' => [
[
'id' => '109',
'field_id' => '109',
'locale' => 'en',
'name' => 'anomaly.module.users::field.roles.name',
'placeholder' => 'anomaly.module.users::field.roles.placeholder',
'warning' => 'anomaly.module.users::field.roles.warning',
'instructions' => 'anomaly.module.users::field.roles.instructions',
],
],
],
'translations' => [
[
'id' => '102',
'assignment_id' => '102',
'locale' => 'en',
'label' => 'anomaly.module.users::field.roles.label.users',
'warning' => 'anomaly.module.users::field.roles.warning.users',
'placeholder' => 'anomaly.module.users::field.roles.placeholder.users',
'instructions' => 'anomaly.module.users::field.roles.instructions.users',
],
],
],
[
'id' => '103',
'sort_order' => '103',
'stream_id' => '17',
'field_id' => '97',
'config' => 'a:0:{}',
'unique' => '0',
'required' => '1',
'translatable' => '0',
'field' => [
'id' => '97',
'namespace' => 'users',
'slug' => 'display_name',
'type' => 'anomaly.field_type.text',
'config' => 'a:0:{}',
'locked' => '1',
'translations' => [
[
'id' => '97',
'field_id' => '97',
'locale' => 'en',
'name' => 'anomaly.module.users::field.display_name.name',
'placeholder' => 'anomaly.module.users::field.display_name.placeholder',
'warning' => 'anomaly.module.users::field.display_name.warning',
'instructions' => 'anomaly.module.users::field.display_name.instructions',
],
],
],
'translations' => [
[
'id' => '103',
'assignment_id' => '103',
'locale' => 'en',
'label' => 'anomaly.module.users::field.display_name.label.users',
'warning' => 'anomaly.module.users::field.display_name.warning.users',
'placeholder' => 'anomaly.module.users::field.display_name.placeholder.users',
'instructions' => 'anomaly.module.users::field.display_name.instructions.users',
],
],
],
[
'id' => '104',
'sort_order' => '104',
'stream_id' => '17',
'field_id' => '98',
'config' => 'a:0:{}',
'unique' => '0',
'required' => '0',
'translatable' => '0',
'field' => [
'id' => '98',
'namespace' => 'users',
'slug' => 'first_name',
'type' => 'anomaly.field_type.text',
'config' => 'a:0:{}',
'locked' => '1',
'translations' => [
[
'id' => '98',
'field_id' => '98',
'locale' => 'en',
'name' => 'anomaly.module.users::field.first_name.name',
'placeholder' => 'anomaly.module.users::field.first_name.placeholder',
'warning' => 'anomaly.module.users::field.first_name.warning',
'instructions' => 'anomaly.module.users::field.first_name.instructions',
],
],
],
'translations' => [
[
'id' => '104',
'assignment_id' => '104',
'locale' => 'en',
'label' => 'anomaly.module.users::field.first_name.label.users',
'warning' => 'anomaly.module.users::field.first_name.warning.users',
'placeholder' => 'anomaly.module.users::field.first_name.placeholder.users',
'instructions' => 'anomaly.module.users::field.first_name.instructions.users',
],
],
],
[
'id' => '105',
'sort_order' => '105',
'stream_id' => '17',
'field_id' => '99',
'config' => 'a:0:{}',
'unique' => '0',
'required' => '0',
'translatable' => '0',
'field' => [
'id' => '99',
'namespace' => 'users',
'slug' => 'last_name',
'type' => 'anomaly.field_type.text',
'config' => 'a:0:{}',
'locked' => '1',
'translations' => [
[
'id' => '99',
'field_id' => '99',
'locale' => 'en',
'name' => 'anomaly.module.users::field.last_name.name',
'placeholder' => 'anomaly.module.users::field.last_name.placeholder',
'warning' => 'anomaly.module.users::field.last_name.warning',
'instructions' => 'anomaly.module.users::field.last_name.instructions',
],
],
],
'translations' => [
[
'id' => '105',
'assignment_id' => '105',
'locale' => 'en',
'label' => 'anomaly.module.users::field.last_name.label.users',
'warning' => 'anomaly.module.users::field.last_name.warning.users',
'placeholder' => 'anomaly.module.users::field.last_name.placeholder.users',
'instructions' => 'anomaly.module.users::field.last_name.instructions.users',
],
],
],
[
'id' => '106',
'sort_order' => '106',
'stream_id' => '17',
'field_id' => '106',
'config' => 'a:0:{}',
'unique' => '0',
'required' => '0',
'translatable' => '0',
'field' => [
'id' => '106',
'namespace' => 'users',
'slug' => 'activated',
'type' => 'anomaly.field_type.boolean',
'config' => 'a:1:{s:13:"default_value";b:0;}',
'locked' => '1',
'translations' => [
[
'id' => '106',
'field_id' => '106',
'locale' => 'en',
'name' => 'anomaly.module.users::field.activated.name',
'placeholder' => 'anomaly.module.users::field.activated.placeholder',
'warning' => 'anomaly.module.users::field.activated.warning',
'instructions' => 'anomaly.module.users::field.activated.instructions',
],
],
],
'translations' => [
[
'id' => '106',
'assignment_id' => '106',
'locale' => 'en',
'label' => 'anomaly.module.users::field.activated.label.users',
'warning' => 'anomaly.module.users::field.activated.warning.users',
'placeholder' => 'anomaly.module.users::field.activated.placeholder.users',
'instructions' => 'anomaly.module.users::field.activated.instructions.users',
],
],
],
[
'id' => '107',
'sort_order' => '107',
'stream_id' => '17',
'field_id' => '107',
'config' => 'a:0:{}',
'unique' => '0',
'required' => '0',
'translatable' => '0',
'field' => [
'id' => '107',
'namespace' => 'users',
'slug' => 'enabled',
'type' => 'anomaly.field_type.boolean',
'config' => 'a:1:{s:13:"default_value";b:1;}',
'locked' => '1',
'translations' => [
[
'id' => '107',
'field_id' => '107',
'locale' => 'en',
'name' => 'anomaly.module.users::field.enabled.name',
'placeholder' => 'anomaly.module.users::field.enabled.placeholder',
'warning' => 'anomaly.module.users::field.enabled.warning',
'instructions' => 'anomaly.module.users::field.enabled.instructions',
],
],
],
'translations' => [
[
'id' => '107',
'assignment_id' => '107',
'locale' => 'en',
'label' => 'anomaly.module.users::field.enabled.label.users',
'warning' => 'anomaly.module.users::field.enabled.warning.users',
'placeholder' => 'anomaly.module.users::field.enabled.placeholder.users',
'instructions' => 'anomaly.module.users::field.enabled.instructions.users',
],
],
],
[
'id' => '108',
'sort_order' => '108',
'stream_id' => '17',
'field_id' => '96',
'config' => 'a:0:{}',
'unique' => '0',
'required' => '0',
'translatable' => '0',
'field' => [
'id' => '96',
'namespace' => 'users',
'slug' => 'permissions',
'type' => 'anomaly.field_type.checkboxes',
'config' => 'a:0:{}',
'locked' => '1',
'translations' => [
[
'id' => '96',
'field_id' => '96',
'locale' => 'en',
'name' => 'anomaly.module.users::field.permissions.name',
'placeholder' => 'anomaly.module.users::field.permissions.placeholder',
'warning' => 'anomaly.module.users::field.permissions.warning',
'instructions' => 'anomaly.module.users::field.permissions.instructions',
],
],
],
'translations' => [
[
'id' => '108',
'assignment_id' => '108',
'locale' => 'en',
'label' => 'anomaly.module.users::field.permissions.label.users',
'warning' => 'anomaly.module.users::field.permissions.warning.users',
'placeholder' => 'anomaly.module.users::field.permissions.placeholder.users',
'instructions' => 'anomaly.module.users::field.permissions.instructions.users',
],
],
],
[
'id' => '109',
'sort_order' => '109',
'stream_id' => '17',
'field_id' => '94',
'config' => 'a:0:{}',
'unique' => '0',
'required' => '0',
'translatable' => '0',
'field' => [
'id' => '94',
'namespace' => 'users',
'slug' => 'last_login_at',
'type' => 'anomaly.field_type.datetime',
'config' => 'a:0:{}',
'locked' => '1',
'translations' => [
[
'id' => '94',
'field_id' => '94',
'locale' => 'en',
'name' => 'anomaly.module.users::field.last_login_at.name',
'placeholder' => 'anomaly.module.users::field.last_login_at.placeholder',
'warning' => 'anomaly.module.users::field.last_login_at.warning',
'instructions' => 'anomaly.module.users::field.last_login_at.instructions',
],
],
],
'translations' => [
[
'id' => '109',
'assignment_id' => '109',
'locale' => 'en',
'label' => 'anomaly.module.users::field.last_login_at.label.users',
'warning' => 'anomaly.module.users::field.last_login_at.warning.users',
'placeholder' => 'anomaly.module.users::field.last_login_at.placeholder.users',
'instructions' => 'anomaly.module.users::field.last_login_at.instructions.users',
],
],
],
[
'id' => '110',
'sort_order' => '110',
'stream_id' => '17',
'field_id' => '92',
'config' => 'a:0:{}',
'unique' => '0',
'required' => '0',
'translatable' => '0',
'field' => [
'id' => '92',
'namespace' => 'users',
'slug' => 'remember_token',
'type' => 'anomaly.field_type.text',
'config' => 'a:0:{}',
'locked' => '1',
'translations' => [
[
'id' => '92',
'field_id' => '92',
'locale' => 'en',
'name' => 'anomaly.module.users::field.remember_token.name',
'placeholder' => 'anomaly.module.users::field.remember_token.placeholder',
'warning' => 'anomaly.module.users::field.remember_token.warning',
'instructions' => 'anomaly.module.users::field.remember_token.instructions',
],
],
],
'translations' => [
[
'id' => '110',
'assignment_id' => '110',
'locale' => 'en',
'label' => 'anomaly.module.users::field.remember_token.label.users',
'warning' => 'anomaly.module.users::field.remember_token.warning.users',
'placeholder' => 'anomaly.module.users::field.remember_token.placeholder.users',
'instructions' => 'anomaly.module.users::field.remember_token.instructions.users',
],
],
],
[
'id' => '111',
'sort_order' => '111',
'stream_id' => '17',
'field_id' => '104',
'config' => 'a:0:{}',
'unique' => '0',
'required' => '0',
'translatable' => '0',
'field' => [
'id' => '104',
'namespace' => 'users',
'slug' => 'activation_code',
'type' => 'anomaly.field_type.text',
'config' => 'a:0:{}',
'locked' => '1',
'translations' => [
[
'id' => '104',
'field_id' => '104',
'locale' => 'en',
'name' => 'anomaly.module.users::field.activation_code.name',
'placeholder' => 'anomaly.module.users::field.activation_code.placeholder',
'warning' => 'anomaly.module.users::field.activation_code.warning',
'instructions' => 'anomaly.module.users::field.activation_code.instructions',
],
],
],
'translations' => [
[
'id' => '111',
'assignment_id' => '111',
'locale' => 'en',
'label' => 'anomaly.module.users::field.activation_code.label.users',
'warning' => 'anomaly.module.users::field.activation_code.warning.users',
'placeholder' => 'anomaly.module.users::field.activation_code.placeholder.users',
'instructions' => 'anomaly.module.users::field.activation_code.instructions.users',
],
],
],
[
'id' => '112',
'sort_order' => '112',
'stream_id' => '17',
'field_id' => '102',
'config' => 'a:0:{}',
'unique' => '0',
'required' => '0',
'translatable' => '0',
'field' => [
'id' => '102',
'namespace' => 'users',
'slug' => 'reset_code',
'type' => 'anomaly.field_type.text',
'config' => 'a:0:{}',
'locked' => '1',
'translations' => [
[
'id' => '102',
'field_id' => '102',
'locale' => 'en',
'name' => 'anomaly.module.users::field.reset_code.name',
'placeholder' => 'anomaly.module.users::field.reset_code.placeholder',
'warning' => 'anomaly.module.users::field.reset_code.warning',
'instructions' => 'anomaly.module.users::field.reset_code.instructions',
],
],
],
'translations' => [
[
'id' => '112',
'assignment_id' => '112',
'locale' => 'en',
'label' => 'anomaly.module.users::field.reset_code.label.users',
'warning' => 'anomaly.module.users::field.reset_code.warning.users',
'placeholder' => 'anomaly.module.users::field.reset_code.placeholder.users',
'instructions' => 'anomaly.module.users::field.reset_code.instructions.users',
],
],
],
[
'id' => '113',
'sort_order' => '113',
'stream_id' => '17',
'field_id' => '95',
'config' => 'a:0:{}',
'unique' => '0',
'required' => '0',
'translatable' => '0',
'field' => [
'id' => '95',
'namespace' => 'users',
'slug' => 'last_activity_at',
'type' => 'anomaly.field_type.datetime',
'config' => 'a:0:{}',
'locked' => '1',
'translations' => [
[
'id' => '95',
'field_id' => '95',
'locale' => 'en',
'name' => 'anomaly.module.users::field.last_activity_at.name',
'placeholder' => 'anomaly.module.users::field.last_activity_at.placeholder',
'warning' => 'anomaly.module.users::field.last_activity_at.warning',
'instructions' => 'anomaly.module.users::field.last_activity_at.instructions',
],
],
],
'translations' => [
[
'id' => '113',
'assignment_id' => '113',
'locale' => 'en',
'label' => 'anomaly.module.users::field.last_activity_at.label.users',
'warning' => 'anomaly.module.users::field.last_activity_at.warning.users',
'placeholder' => 'anomaly.module.users::field.last_activity_at.placeholder.users',
'instructions' => 'anomaly.module.users::field.last_activity_at.instructions.users',
],
],
],
[
'id' => '114',
'sort_order' => '114',
'stream_id' => '17',
'field_id' => '93',
'config' => 'a:0:{}',
'unique' => '0',
'required' => '0',
'translatable' => '0',
'field' => [
'id' => '93',
'namespace' => 'users',
'slug' => 'ip_address',
'type' => 'anomaly.field_type.text',
'config' => 'a:0:{}',
'locked' => '1',
'translations' => [
[
'id' => '93',
'field_id' => '93',
'locale' => 'en',
'name' => 'anomaly.module.users::field.ip_address.name',
'placeholder' => 'anomaly.module.users::field.ip_address.placeholder',
'warning' => 'anomaly.module.users::field.ip_address.warning',
'instructions' => 'anomaly.module.users::field.ip_address.instructions',
],
],
],
'translations' => [
[
'id' => '114',
'assignment_id' => '114',
'locale' => 'en',
'label' => 'anomaly.module.users::field.ip_address.label.users',
'warning' => 'anomaly.module.users::field.ip_address.warning.users',
'placeholder' => 'anomaly.module.users::field.ip_address.placeholder.users',
'instructions' => 'anomaly.module.users::field.ip_address.instructions.users',
],
],
],
],
'translations' => [
[
'id' => '17',
'stream_id' => '17',
'locale' => 'en',
'name' => 'anomaly.module.users::stream.users.name',
'description' => 'anomaly.module.users::stream.users.description',
],
],
];

    
public function roles()
{

return $this->getFieldType('roles')->getRelation();
}

}
