<?php namespace Anomaly\SettingsModule\Setting\Table;

use Anomaly\Streams\Platform\Addon\AddonCollection;
use Anomaly\Streams\Platform\Addon\Extension\ExtensionCollection;
use Anomaly\Streams\Platform\Addon\Module\ModuleCollection;

/**
 * Class AddonTableEntries
 *
 * @link          http://pyrocms.com/
 * @author        PyroCMS, Inc. <support@pyrocms.com>
 * @author        Ryan Thompson <ryan@pyrocms.com>
 * @package       Anomaly\SettingsModule\Setting\Table
 */
class AddonTableEntries
{

    /**
     * Handle the command.
     *
     * @param AddonTableBuilder $builder
     * @param AddonCollection   $addons
     */
    public function handle(AddonTableBuilder $builder, AddonCollection $addons)
    {
        /* @var AddonCollection|ModuleCollection|ExtensionCollection $entries */
        $entries = $addons->{$builder->getType()}->withAnyConfig(['settings', 'settings/settings']);

        if (in_array($builder->getType(), ['modules', 'extensions'])) {
            $entries = $entries->enabled();
        }

        $builder->setTableEntries($entries);
    }
}
