/*
 * Copyright 2007-2017 Charles du Jeu - Abstrium SAS <team (at) pyd.io>
 * This file is part of Pydio.
 *
 * Pydio is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Pydio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with Pydio.  If not, see <http://www.gnu.org/licenses/>.
 *
 * The latest code can be found at <https://pydio.com>.
 */

'use strict';

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

var React = require('react');

var _require = require('material-ui');

var TextField = _require.TextField;

var _require$requireLib = require('pydio').requireLib('boot');

var ActionDialogMixin = _require$requireLib.ActionDialogMixin;
var CancelButtonProviderMixin = _require$requireLib.CancelButtonProviderMixin;
var SubmitButtonProviderMixin = _require$requireLib.SubmitButtonProviderMixin;

var PydioApi = require('pydio/http/api');

var Callbacks = (function () {
    function Callbacks() {
        _classCallCheck(this, Callbacks);
    }

    _createClass(Callbacks, null, [{
        key: 'createLink',
        value: function createLink() {
            pydio.UI.openComponentInModal('PydioBrowserActions', 'CreateLinkDialog');
        }
    }]);

    return Callbacks;
})();

var CreateLinkDialog = React.createClass({
    displayName: 'CreateLinkDialog',

    mixins: [ActionDialogMixin, CancelButtonProviderMixin, SubmitButtonProviderMixin],

    getDefaultProps: function getDefaultProps() {
        return {
            dialogSize: 'sm',
            dialogTitleId: 'openbrowser.4'
        };
    },

    submit: function submit() {
        var _this = this;

        var name = this.refs.name.getValue();
        var url = this.refs.url.getValue();
        if (!name || !url) return;
        PydioApi.getClient().request({
            get_action: 'mkfile',
            dir: this.props.pydio.getContextHolder().getContextNode().getPath(),
            filename: name + '.url',
            content: url
        }, function () {
            _this.dismiss();
        });
    },

    render: function render() {
        var _this2 = this;

        var mess = this.props.pydio.MessageHash;
        return React.createElement(
            'div',
            null,
            React.createElement(TextField, { ref: 'url', floatingLabelText: mess['openbrowser.6'], fullWidth: true, hintText: 'https://...', onKeyDown: function (e) {
                    _this2.submitOnEnterKey(e);
                } }),
            React.createElement(TextField, { ref: 'name', floatingLabelText: mess['openbrowser.8'], fullWidth: true, onKeyDown: function (e) {
                    _this2.submitOnEnterKey(e);
                } })
        );
    }

});

window.PydioBrowserActions = {
    Callbacks: Callbacks,
    CreateLinkDialog: CreateLinkDialog
};
