/*
 * Copyright 2007-2017 Charles du Jeu - Abstrium SAS <team (at) pyd.io>
 * This file is part of Pydio.
 *
 * Pydio is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Pydio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with Pydio.  If not, see <http://www.gnu.org/licenses/>.
 *
 * The latest code can be found at <https://pydio.com>.
 */

'use strict';

Object.defineProperty(exports, '__esModule', {
    value: true
});
var React = require('react');

var _require = require('material-ui');

var Toggle = _require.Toggle;
var Divider = _require.Divider;
var TextField = _require.TextField;
var RaisedButton = _require.RaisedButton;

var _require$requireLib = require('pydio').requireLib('components');

var ClipboardTextField = _require$requireLib.ClipboardTextField;

var WebDAVPane = React.createClass({
    displayName: 'WebDAVPane',

    componentDidMount: function componentDidMount() {
        this.loadPrefs();
    },
    getMessage: function getMessage(id) {
        return this.props.pydio.MessageHash[id];
    },
    onToggleChange: function onToggleChange(event, newValue) {
        PydioApi.getClient().request({
            get_action: 'webdav_preferences',
            activate: newValue ? "true" : "false"
        }, (function (t) {
            this.setState({ preferences: t.responseJSON });
            this.props.pydio.displayMessage("SUCCESS", this.props.pydio.MessageHash[newValue ? 408 : 409]);
        }).bind(this));
    },
    savePassword: function savePassword(event) {
        PydioApi.getClient().request({
            get_action: 'webdav_preferences',
            webdav_pass: this.refs['passfield'].getValue()
        }, (function (t) {
            this.setState({ preferences: t.responseJSON });
            this.props.pydio.displayMessage("SUCCESS", this.props.pydio.MessageHash[410]);
        }).bind(this));
    },
    loadPrefs: function loadPrefs() {
        if (!this.isMounted()) return;
        PydioApi.getClient().request({
            get_action: 'webdav_preferences'
        }, (function (t) {
            this.setState({ preferences: t.responseJSON });
        }).bind(this));
    },

    renderPasswordField: function renderPasswordField() {

        if (this.state.preferences.digest_set || !this.state.preferences.webdav_force_basic) {
            return null;
        }
        return React.createElement(
            'div',
            null,
            React.createElement(Divider, null),
            React.createElement(
                'div',
                { style: { padding: 16 } },
                React.createElement(
                    'div',
                    null,
                    this.getMessage(407)
                ),
                React.createElement(
                    'div',
                    { style: { display: 'flex', alignItems: 'baseline' } },
                    React.createElement(TextField, {
                        type: 'password',
                        floatingLabelText: this.getMessage(523),
                        ref: 'passfield',
                        style: { flex: 1, marginRight: 10 }
                    }),
                    React.createElement(RaisedButton, {
                        label: 'Save',
                        onClick: this.savePassword
                    })
                )
            ),
            React.createElement(Divider, null)
        );
    },

    renderUrls: function renderUrls() {
        var _this = this;

        var base = this.state.preferences.webdav_base_url;
        var otherUrls = [];
        var toggler = !!this.state.toggler;
        var pydio = this.props.pydio;
        var preferences = this.state.preferences;

        if (toggler) {
            (function () {
                var userRepos = pydio.user.getRepositoriesList();
                var webdavRepos = preferences.webdav_repositories;
                userRepos.forEach((function (repo, key) {
                    if (!webdavRepos[key]) return;
                    otherUrls.push(React.createElement(ClipboardTextField, { key: key, floatingLabelText: repo.getLabel(), inputValue: webdavRepos[key], getMessage: this.getMessage }));
                }).bind(_this));
            })();
        }

        return React.createElement(
            'div',
            null,
            React.createElement(
                'div',
                { style: { padding: 20 } },
                React.createElement(
                    'div',
                    null,
                    this.getMessage(405)
                ),
                React.createElement(ClipboardTextField, { floatingLabelText: this.getMessage(468), inputValue: base, getMessage: this.getMessage })
            ),
            toggler && React.createElement(Divider, null),
            React.createElement(
                'div',
                { style: { padding: 20 } },
                React.createElement(Toggle, { labelPosition: 'right', label: this.getMessage(465), onToggle: function () {
                        _this.setState({ toggler: !toggler });
                    }, toggled: toggler }),
                otherUrls
            )
        );
    },

    render: function render() {
        var webdavActive = this.state && this.state.preferences.webdav_active;
        return React.createElement(
            'div',
            { style: { fontSize: 14 } },
            React.createElement(
                'div',
                { style: { padding: 20 } },
                React.createElement(Toggle, {
                    labelPosition: 'right',
                    label: this.getMessage(406),
                    toggled: webdavActive,
                    onToggle: this.onToggleChange }),
                !webdavActive && React.createElement(
                    'div',
                    { style: { paddingTop: 20 } },
                    this.getMessage(404)
                )
            ),
            webdavActive && React.createElement(
                'div',
                null,
                React.createElement(Divider, null),
                this.renderPasswordField(),
                this.renderUrls()
            )
        );
    }

});

exports['default'] = WebDAVPane;
module.exports = exports['default'];
