const {Component, PropTypes} = require('react')
const {MenuItem, IconMenu, IconButton} = require('material-ui')
const {muiThemeable} = require('material-ui/styles')
const Color = require('color')

class UserBadge extends Component{

    renderMenu(){
        if (!this.props.menus || !this.props.menus.length) {
            return null;
        }
        const menuItems = this.props.menus.map(function(m){
            let rightIcon;
            if(m.checked){
                rightIcon = <span className="mdi mdi-check"/>;
            }
            return (
                <MenuItem
                    primaryText={m.text}
                    onTouchTap={m.callback}
                    rightIcon={rightIcon}/>
            );
        });
        const iconStyle = {fontSize: 18};
        return(
            <IconMenu
                iconButtonElement={<IconButton style={{padding: 16}} iconStyle={iconStyle} iconClassName="icon-ellipsis-vertical"/>}
                anchorOrigin={{horizontal: 'right', vertical: 'top'}}
                targetOrigin={{horizontal: 'right', vertical: 'top'}}
            >
                {menuItems}
            </IconMenu>
        );
    }

    render() {
        let avatar;
        let avatarColor = this.props.muiTheme.palette.avatarsColor;
        if(this.props.type == 'group') {
            avatarColor = Color(avatarColor).darken(.2).toString();
            avatar = <span className="avatar mdi mdi-account-multiple" style={{backgroundColor: avatarColor}}/>;
        }else if(this.props.type == 'team') {
            avatarColor = Color(avatarColor).darken(.2).toString();
            avatar = <span className="avatar mdi mdi-account-multiple-outline" style={{backgroundColor:avatarColor}}/>;
        }else if(this.props.type == 'temporary') {
            avatarColor = Color(avatarColor).lighten(.2).toString();
            avatar = <span className="avatar mdi mdi-account-plus" style={{backgroundColor:avatarColor}}/>;
        }else if(this.props.type == 'remote_user'){
            avatar = <span className="avatar mdi mdi-account-network" style={{backgroundColor:avatarColor}}/>;
        }else{
            avatar = <span className="avatar mdi mdi-account" style={{backgroundColor:avatarColor}}/>;
        }
        const menu = this.renderMenu();
        return (
            <div className={"share-dialog user-badge user-type-" + this.props.type}>
                {avatar}
                <span className="user-badge-label">{this.props.label}</span>
                {this.props.children}
                {menu}
            </div>
        );
    }
}

UserBadge.propTypes = {
    label   : PropTypes.string,
    avatar  : PropTypes.string,
    type    : PropTypes.string,
    menus   : PropTypes.object,
    muiTheme: PropTypes.object,
};

UserBadge = muiThemeable()(UserBadge);

export {UserBadge as default}