/*
 * Copyright 2007-2017 Charles du Jeu - Abstrium SAS <team (at) pyd.io>
 * This file is part of Pydio.
 *
 * Pydio is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Pydio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with Pydio.  If not, see <http://www.gnu.org/licenses/>.
 *
 * The latest code can be found at <https://pydio.com>.
 */

'use strict';

exports.__esModule = true;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var styles = {
    card: {
        backgroundColor: 'white'
    }
};

/**
 * Default InfoPanel Card
 */
var InfoPanelCard = _react2['default'].createClass({
    displayName: 'InfoPanelCard',

    propTypes: {
        title: _react2['default'].PropTypes.string,
        actions: _react2['default'].PropTypes.array
    },

    render: function render() {
        var iconStyle = this.props.iconStyle || {};
        iconStyle = _extends({}, iconStyle, { color: this.props.iconColor, float: 'right' });
        var icon = this.props.icon ? _react2['default'].createElement('div', { style: iconStyle, className: "panelIcon mdi mdi-" + this.props.icon }) : null;
        var title = this.props.title ? _react2['default'].createElement(
            'div',
            { className: 'panelHeader' },
            icon,
            this.props.title
        ) : null;
        var actions = this.props.actions ? _react2['default'].createElement(
            'div',
            { className: 'panelActions' },
            this.props.actions
        ) : null;
        var rows = undefined,
            toolBar = undefined;
        if (this.props.standardData) {
            rows = this.props.standardData.map(function (object) {
                return _react2['default'].createElement(
                    'div',
                    { className: 'infoPanelRow', key: object.key },
                    _react2['default'].createElement(
                        'div',
                        { className: 'infoPanelLabel' },
                        object.label
                    ),
                    _react2['default'].createElement(
                        'div',
                        { className: 'infoPanelValue' },
                        object.value
                    )
                );
            });
        }
        if (this.props.primaryToolbars) {
            var themePalette = this.props.muiTheme.palette;
            var tBarStyle = {
                backgroundColor: themePalette.accent2Color
            };
            toolBar = _react2['default'].createElement(PydioComponents.Toolbar, {
                toolbarStyle: tBarStyle,
                className: 'primaryToolbar',
                renderingType: 'button-icon',
                toolbars: this.props.primaryToolbars,
                controller: this.props.pydio.getController()
            });
        }

        return _react2['default'].createElement(
            MaterialUI.Paper,
            { zDepth: 1, className: 'panelCard', style: _extends({}, this.props.style, styles.card) },
            title,
            _react2['default'].createElement(
                'div',
                { className: 'panelContent', style: this.props.contentStyle },
                this.props.children,
                rows,
                toolBar
            ),
            actions
        );
    }

});

exports['default'] = InfoPanelCard = MaterialUI.Style.muiThemeable()(InfoPanelCard);
exports['default'] = InfoPanelCard;
module.exports = exports['default'];
