
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `pydio825`
--

-- --------------------------------------------------------

--
-- Table structure for table `ajxp_changes`
--

CREATE TABLE `ajxp_changes` (
  `seq` int(20) NOT NULL AUTO_INCREMENT,
  `repository_identifier` text COLLATE utf8_unicode_ci NOT NULL,
  `node_id` bigint(20) NOT NULL,
  `type` enum('create','delete','path','content') COLLATE utf8_unicode_ci NOT NULL,
  `source` text COLLATE utf8_unicode_ci NOT NULL,
  `target` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`seq`),
  KEY `node_id` (`node_id`,`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ajxp_feed`
--

CREATE TABLE `ajxp_feed` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `edate` int(11) NOT NULL,
  `etype` varchar(12) COLLATE utf8_unicode_ci NOT NULL,
  `htype` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `index_path` mediumtext COLLATE utf8_unicode_ci,
  `user_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `repository_id` varchar(33) COLLATE utf8_unicode_ci NOT NULL,
  `user_group` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `repository_scope` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `repository_owner` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `content` longblob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_feed_repo_id` (`repository_id`),
  KEY `idx_feed_user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ajxp_groups`
--

CREATE TABLE `ajxp_groups` (
  `groupPath` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `groupLabel` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`groupPath`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ajxp_index`
--

CREATE TABLE `ajxp_index` (
  `node_id` int(20) NOT NULL AUTO_INCREMENT,
  `node_path` text COLLATE utf8_unicode_ci NOT NULL,
  `bytesize` bigint(20) NOT NULL,
  `md5` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `mtime` int(11) NOT NULL,
  `repository_identifier` text COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`node_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

--
-- Triggers `ajxp_index`
--

-- --------------------------------------------------------

--
-- Table structure for table `ajxp_log`
--

CREATE TABLE `ajxp_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `logdate` datetime DEFAULT NULL,
  `remote_ip` varchar(45) COLLATE utf8_unicode_ci DEFAULT NULL,
  `severity` enum('DEBUG','INFO','NOTICE','WARNING','ERROR') COLLATE utf8_unicode_ci DEFAULT NULL,
  `user` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `source` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `message` text COLLATE utf8_unicode_ci,
  `params` text COLLATE utf8_unicode_ci,
  `repository_id` varchar(32) COLLATE utf8_unicode_ci DEFAULT NULL,
  `device` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `dirname` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `basename` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `source` (`source`),
  KEY `repository_id` (`repository_id`),
  KEY `logdate` (`logdate`),
  KEY `severity` (`severity`),
  KEY `dirname` (`dirname`),
  KEY `basename` (`basename`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

--
-- Dumping data for table `ajxp_log`
--


-- --------------------------------------------------------

--
-- Table structure for table `ajxp_mail_queue`
--

CREATE TABLE `ajxp_mail_queue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `recipient` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `url` text COLLATE utf8_unicode_ci NOT NULL,
  `date_event` int(11) NOT NULL,
  `notification_object` longblob NOT NULL,
  `html` int(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

--
-- Triggers `ajxp_mail_queue`
--
DROP TRIGGER IF EXISTS `mail_queue_go_to_sent`;
DELIMITER //
CREATE TRIGGER `mail_queue_go_to_sent` BEFORE DELETE ON `ajxp_mail_queue`
 FOR EACH ROW INSERT INTO ajxp_mail_sent (recipient,url,date_event,notification_object,html) VALUES (old.recipient,old.url,old.date_event,old.notification_object,old.html)
//
DELIMITER ;

-- --------------------------------------------------------

--
-- Table structure for table `ajxp_mail_sent`
--

CREATE TABLE `ajxp_mail_sent` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `recipient` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `url` text COLLATE utf8_unicode_ci NOT NULL,
  `date_event` int(11) NOT NULL,
  `notification_object` longblob NOT NULL,
  `html` int(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ajxp_mq_queues`
--

CREATE TABLE `ajxp_mq_queues` (
  `channel_name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `content` longblob NOT NULL,
  PRIMARY KEY (`channel_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ajxp_plugin_configs`
--

CREATE TABLE `ajxp_plugin_configs` (
  `id` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `configs` longblob NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `ajxp_plugin_configs`
--

INSERT INTO `ajxp_plugin_configs` VALUES
('core.ajaxplorer', 'a:4:{s:17:"APPLICATION_TITLE";[[ser_site_name]]s:16:"DEFAULT_LANGUAGE";[[ser_language]]s:10:"SERVER_URL";[[ser_softurl]]s:14:"CMDLINE_ACTIVE";b:1;}'),
('core.log', 'a:1:{s:22:"UNIQUE_PLUGIN_INSTANCE";a:3:{s:13:"instance_name";s:7:"log.sql";s:18:"group_switch_value";s:7:"log.sql";s:10:"SQL_DRIVER";a:2:{s:11:"core_driver";s:4:"core";s:18:"group_switch_value";s:4:"core";}}}'),
('core.mq', 'a:1:{s:18:"UNIQUE_MS_INSTANCE";a:3:{s:13:"instance_name";s:6:"mq.sql";s:18:"group_switch_value";s:6:"mq.sql";s:10:"SQL_DRIVER";a:2:{s:11:"core_driver";s:4:"core";s:18:"group_switch_value";s:4:"core";}}}'),
('core.notifications', 'a:2:{s:20:"UNIQUE_FEED_INSTANCE";a:3:{s:13:"instance_name";s:8:"feed.sql";s:18:"group_switch_value";s:8:"feed.sql";s:10:"SQL_DRIVER";a:2:{s:11:"core_driver";s:4:"core";s:18:"group_switch_value";s:4:"core";}}s:11:"USER_EVENTS";b:1;}'),
('gui.ajax', 'a:1:{s:22:"CUSTOM_WELCOME_MESSAGE";[[ser_site_desc]]}');

-- --------------------------------------------------------

--
-- Table structure for table `ajxp_repo`
--

CREATE TABLE `ajxp_repo` (
  `uuid` varchar(33) COLLATE utf8_unicode_ci NOT NULL,
  `parent_uuid` varchar(33) COLLATE utf8_unicode_ci DEFAULT NULL,
  `owner_user_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `child_user_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `path` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `display` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `accessType` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `recycle` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `bcreate` tinyint(1) DEFAULT NULL,
  `writeable` tinyint(1) DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT NULL,
  `isTemplate` tinyint(1) DEFAULT NULL,
  `inferOptionsFromParent` tinyint(1) DEFAULT NULL,
  `slug` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `groupPath` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ajxp_repo_options`
--

CREATE TABLE `ajxp_repo_options` (
  `oid` int(11) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(33) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `val` blob,
  PRIMARY KEY (`oid`),
  KEY `uuid` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ajxp_roles`
--

CREATE TABLE `ajxp_roles` (
  `role_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `serial_role` text COLLATE utf8_unicode_ci NOT NULL,
  `owner_user_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `last_updated` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`role_id`),
  UNIQUE KEY `owner_role` (`role_id`,`owner_user_id`),
  KEY `last_updated` (`last_updated`),
  KEY `owner_user_id` (`owner_user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `ajxp_roles`
--

INSERT INTO `ajxp_roles` VALUES
('AJXP_GRP_/', 'O:25:"Pydio\\Conf\\Core\\AJXP_Role":9:{s:12:"\0*\0groupPath";s:1:"/";s:9:"\0*\0roleId";s:10:"AJXP_GRP_/";s:7:"\0*\0acls";a:3:{i:1;s:2:"rw";s:9:"ajxp_home";s:2:"rw";s:5:"inbox";s:1:"r";}s:13:"\0*\0parameters";a:1:{s:19:"AJXP_REPO_SCOPE_ALL";a:5:{s:9:"core.conf";a:3:{s:17:"ROLE_DISPLAY_NAME";s:10:"Root Group";s:19:"ROLE_FORCE_OVERRIDE";s:5:"false";s:24:"DEFAULT_START_REPOSITORY";s:9:"ajxp_home";}s:11:"core.mailer";a:4:{s:23:"NOTIFICATIONS_EMAIL_GET";s:4:"true";s:29:"NOTIFICATIONS_EMAIL_FREQUENCY";s:1:"M";s:34:"NOTIFICATIONS_EMAIL_FREQUENCY_USER";s:1:"5";s:29:"NOTIFICATIONS_EMAIL_SEND_HTML";s:4:"true";}s:13:"meta.syncable";a:1:{s:13:"REPO_SYNCABLE";s:4:"true";}s:17:"action.disclaimer";a:1:{s:19:"DISCLAIMER_ACCEPTED";s:2:"no";}s:13:"authfront.otp";a:3:{s:15:"yubikey_enabled";s:5:"false";s:20:"google_enabled_admin";s:5:"false";s:14:"google_enabled";s:5:"false";}}}s:10:"\0*\0actions";a:0:{}s:14:"\0*\0autoApplies";a:0:{}s:8:"\0*\0masks";a:0:{}s:14:"\0*\0lastUpdated";i:[[timestamp]];s:10:"\0*\0ownerId";N;}', NULL, [[timestamp]]),
('AJXP_USR_/[[admin_username]]', 'O:25:"Pydio\\Conf\\Core\\AJXP_Role":9:{s:12:"\0*\0groupPath";N;s:9:"\0*\0roleId";[[ser_AJXP_USR]]s:7:"\0*\0acls";a:6:{i:0;s:2:"rw";i:1;s:2:"rw";s:9:"ajxp_home";s:2:"rw";s:5:"inbox";s:2:"rw";s:9:"ajxp_conf";s:2:"rw";s:11:"fs_template";s:2:"rw";}s:13:"\0*\0parameters";a:1:{s:19:"AJXP_REPO_SCOPE_ALL";a:1:{s:9:"core.conf";a:1:{s:17:"USER_DISPLAY_NAME";[[ser_admin_realname]]}}}s:10:"\0*\0actions";a:0:{}s:14:"\0*\0autoApplies";a:0:{}s:8:"\0*\0masks";a:0:{}s:14:"\0*\0lastUpdated";i:[[timestamp]];s:10:"\0*\0ownerId";N;}', NULL, [[timestamp]]),
('EXTERNAL_USERS', 'O:25:"Pydio\\Conf\\Core\\AJXP_Role":9:{s:12:"\0*\0groupPath";N;s:9:"\0*\0roleId";s:14:"EXTERNAL_USERS";s:7:"\0*\0acls";a:0:{}s:13:"\0*\0parameters";a:1:{s:19:"AJXP_REPO_SCOPE_ALL";a:1:{s:9:"core.conf";a:1:{s:17:"ROLE_DISPLAY_NAME";s:14:"External users";}}}s:10:"\0*\0actions";a:1:{s:19:"AJXP_REPO_SCOPE_ALL";a:2:{s:12:"action.share";a:1:{s:16:"open_user_shares";b:0;}s:11:"action.user";a:1:{s:17:"open_address_book";b:0;}}}s:14:"\0*\0autoApplies";a:1:{i:0;s:6:"shared";}s:8:"\0*\0masks";a:0:{}s:14:"\0*\0lastUpdated";i:0;s:10:"\0*\0ownerId";N;}', NULL, [[timestamp]]),
('GUEST', 'O:25:"Pydio\\Conf\\Core\\AJXP_Role":9:{s:12:"\0*\0groupPath";N;s:9:"\0*\0roleId";s:5:"GUEST";s:7:"\0*\0acls";a:0:{}s:13:"\0*\0parameters";a:1:{s:19:"AJXP_REPO_SCOPE_ALL";a:1:{s:9:"core.conf";a:1:{s:17:"ROLE_DISPLAY_NAME";s:15:"Guest user role";}}}s:10:"\0*\0actions";a:1:{s:19:"AJXP_REPO_SCOPE_ALL";a:3:{s:9:"access.fs";a:1:{s:5:"purge";s:8:"disabled";}s:10:"meta.watch";a:1:{s:12:"toggle_watch";s:8:"disabled";}s:12:"index.lucene";a:1:{s:5:"index";s:8:"disabled";}}}s:14:"\0*\0autoApplies";a:1:{i:0;s:5:"guest";}s:8:"\0*\0masks";a:0:{}s:14:"\0*\0lastUpdated";i:0;s:10:"\0*\0ownerId";N;}', NULL, [[timestamp]]),
('MINISITE', 'O:25:"Pydio\\Conf\\Core\\AJXP_Role":9:{s:12:"\0*\0groupPath";N;s:9:"\0*\0roleId";s:8:"MINISITE";s:7:"\0*\0acls";a:0:{}s:13:"\0*\0parameters";a:1:{s:19:"AJXP_REPO_SCOPE_ALL";a:1:{s:9:"core.conf";a:1:{s:17:"ROLE_DISPLAY_NAME";s:14:"Minisite Users";}}}s:10:"\0*\0actions";a:1:{s:22:"AJXP_REPO_SCOPE_SHARED";a:8:{s:9:"access.fs";a:3:{s:9:"ajxp_link";b:0;s:5:"chmod";b:0;s:5:"purge";b:0;}s:10:"meta.watch";a:1:{s:12:"toggle_watch";b:0;}s:11:"conf.serial";a:1:{s:13:"get_bookmarks";b:0;}s:8:"conf.sql";a:1:{s:13:"get_bookmarks";b:0;}s:12:"action.share";a:8:{s:5:"share";b:0;s:11:"share_react";b:0;s:17:"share-edit-shared";b:0;s:22:"share-folder-workspace";b:0;s:19:"share-file-minisite";b:0;s:24:"share-selection-minisite";b:0;s:28:"share-folder-minisite-public";b:0;s:16:"open_user_shares";b:0;}s:8:"gui.ajax";a:1:{s:8:"bookmark";b:0;}s:8:"auth.sql";a:1:{s:11:"pass_change";b:0;}s:11:"action.user";a:1:{s:17:"open_address_book";b:0;}}}s:14:"\0*\0autoApplies";a:0:{}s:8:"\0*\0masks";a:0:{}s:14:"\0*\0lastUpdated";i:0;s:10:"\0*\0ownerId";N;}', NULL, [[timestamp]]),
('MINISITE_NODOWNLOAD', 'O:25:"Pydio\\Conf\\Core\\AJXP_Role":9:{s:12:"\0*\0groupPath";N;s:9:"\0*\0roleId";s:19:"MINISITE_NODOWNLOAD";s:7:"\0*\0acls";a:0:{}s:13:"\0*\0parameters";a:1:{s:19:"AJXP_REPO_SCOPE_ALL";a:1:{s:9:"core.conf";a:1:{s:17:"ROLE_DISPLAY_NAME";s:28:"Minisite Users - No Download";}}}s:10:"\0*\0actions";a:1:{s:22:"AJXP_REPO_SCOPE_SHARED";a:1:{s:9:"access.fs";a:4:{s:8:"download";b:0;s:14:"download_chunk";b:0;s:16:"prepare_chunk_dl";b:0;s:12:"download_all";b:0;}}}s:14:"\0*\0autoApplies";a:0:{}s:8:"\0*\0masks";a:0:{}s:14:"\0*\0lastUpdated";i:0;s:10:"\0*\0ownerId";N;}', NULL, [[timestamp]]);

-- --------------------------------------------------------

--
-- Table structure for table `ajxp_simple_store`
--

CREATE TABLE `ajxp_simple_store` (
  `object_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `store_id` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `serialized_data` longtext COLLATE utf8_unicode_ci,
  `binary_data` longblob,
  `related_object_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `insertion_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`object_id`,`store_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ajxp_tasks`
--

CREATE TABLE `ajxp_tasks` (
  `uid` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `type` int(11) NOT NULL,
  `parent_uid` varchar(40) COLLATE utf8_unicode_ci DEFAULT NULL,
  `flags` int(11) NOT NULL,
  `label` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `user_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `ws_id` varchar(32) COLLATE utf8_unicode_ci NOT NULL,
  `status` int(11) NOT NULL,
  `status_msg` varchar(500) COLLATE utf8_unicode_ci NOT NULL,
  `progress` int(11) NOT NULL,
  `schedule` int(11) NOT NULL,
  `schedule_value` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `action` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `parameters` mediumblob NOT NULL,
  `creation_date` int(11) NOT NULL DEFAULT '0',
  `status_update` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`uid`),
  KEY `ajxp_task_usr_idx` (`user_id`),
  KEY `ajxp_task_status_idx` (`status`),
  KEY `ajxp_task_type` (`type`),
  KEY `ajxp_task_schedule` (`schedule`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ajxp_tasks_nodes`
--

CREATE TABLE `ajxp_tasks_nodes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `task_uid` varchar(40) COLLATE utf8_unicode_ci NOT NULL,
  `node_base_url` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `node_path` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ajxp_taskn_tuid_idx` (`task_uid`),
  KEY `ajxp_taskn_base_idx` (`node_base_url`),
  KEY `ajxp_taskn_path_idx` (`node_path`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ajxp_users`
--

CREATE TABLE `ajxp_users` (
  `login` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `password` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `groupPath` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`login`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `ajxp_users`
--

INSERT INTO `ajxp_users` VALUES
('[[admin_username]]', '[[admin_pass]]', '/');

-- --------------------------------------------------------

--
-- Table structure for table `ajxp_user_bookmarks`
--

CREATE TABLE `ajxp_user_bookmarks` (
  `rid` int(11) NOT NULL AUTO_INCREMENT,
  `login` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `repo_uuid` varchar(33) COLLATE utf8_unicode_ci NOT NULL,
  `path` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `title` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`rid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `ajxp_user_prefs`
--

CREATE TABLE `ajxp_user_prefs` (
  `rid` int(11) NOT NULL AUTO_INCREMENT,
  `login` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `val` blob,
  PRIMARY KEY (`rid`),
  UNIQUE KEY `prefs_login_name` (`login`,`name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=2 ;

--
-- Dumping data for table `ajxp_user_prefs`
--

INSERT INTO `ajxp_user_prefs` VALUES
(1, '[[admin_username]]', 'AJXP_WEBDAV_DATA', '$phpserial$a:1:{s:3:"HA1";s:32:"[[AJXP_WEBDAV_DATA]]";}');

-- --------------------------------------------------------

--
-- Table structure for table `ajxp_user_rights`
--

CREATE TABLE `ajxp_user_rights` (
  `rid` int(11) NOT NULL AUTO_INCREMENT,
  `login` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `repo_uuid` varchar(33) COLLATE utf8_unicode_ci NOT NULL,
  `rights` mediumtext COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`rid`),
  KEY `login` (`login`),
  KEY `repo_uuid` (`repo_uuid`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=6 ;

--
-- Dumping data for table `ajxp_user_rights`
--

INSERT INTO `ajxp_user_rights` VALUES
(4, '[[admin_username]]', 'ajxp.roles', '$phpserial$a:1:{[[ser_AJXP_USR]]b:1;}'),
(5, '[[admin_username]]', 'ajxp.admin', '1');

-- --------------------------------------------------------

--
-- Table structure for table `ajxp_user_teams`
--

CREATE TABLE `ajxp_user_teams` (
  `team_id` varchar(70) COLLATE utf8_unicode_ci NOT NULL,
  `user_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `team_label` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `owner_id` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`team_id`,`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ajxp_version`
--

CREATE TABLE `ajxp_version` (
  `db_build` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `ajxp_version`
--

INSERT INTO `ajxp_version` VALUES
(68);

DROP TRIGGER IF EXISTS `LOG_DELETE`;
DELIMITER //
CREATE TRIGGER `LOG_DELETE` AFTER DELETE ON `ajxp_index`
 FOR EACH ROW INSERT INTO ajxp_changes (repository_identifier, node_id,source,target,type)
  VALUES (old.repository_identifier, old.node_id, old.node_path, 'NULL', 'delete')
//
DELIMITER ;
DROP TRIGGER IF EXISTS `LOG_INSERT`;
DELIMITER //
CREATE TRIGGER `LOG_INSERT` AFTER INSERT ON `ajxp_index`
 FOR EACH ROW INSERT INTO ajxp_changes (repository_identifier, node_id,source,target,type)
  VALUES (new.repository_identifier, new.node_id, 'NULL', new.node_path, 'create')
//
DELIMITER ;
DROP TRIGGER IF EXISTS `LOG_UPDATE`;
DELIMITER //
CREATE TRIGGER `LOG_UPDATE` AFTER UPDATE ON `ajxp_index`
 FOR EACH ROW INSERT INTO ajxp_changes (repository_identifier, node_id,source,target,type)
  VALUES (new.repository_identifier, new.node_id, old.node_path, new.node_path, CASE LENGTH(new.node_path) = LENGTH(old.node_path) AND old.node_path COLLATE utf8_bin = new.node_path COLLATE utf8_bin WHEN true THEN 'content' ELSE 'path' END)
//
DELIMITER ;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
