
SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Database: `precurio44_`
--

-- --------------------------------------------------------

--
-- Table structure for table `activity_effect`
--

CREATE TABLE `activity_effect` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `activity_id` int(11) DEFAULT NULL COMMENT 'activity_log',
  `subject_id` int(11) DEFAULT NULL,
  `date_created` char(15) DEFAULT NULL,
  `active` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `activity_log`
--

CREATE TABLE `activity_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `appid` varchar(255) DEFAULT NULL,
  `type` varchar(255) DEFAULT NULL,
  `item_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL COMMENT 'This is the user that is the "actor" in this activity',
  `group_id` int(11) DEFAULT '0',
  `session_user_id` int(11) DEFAULT NULL COMMENT 'This is the currently logged in user that triggered the activity .Useful for analytic purpose.',
  `only_notify_id` int(11) DEFAULT '0' COMMENT 'Restrict notification to only this user_id',
  `activity_date` varchar(255) DEFAULT NULL COMMENT 'readable version of the date created',
  `date_created` char(15) DEFAULT NULL,
  `active` tinyint(3) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `activity_registry`
--

CREATE TABLE `activity_registry` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `appid` varchar(255) NOT NULL,
  `type` varchar(255) NOT NULL,
  `table_name` varchar(255) NOT NULL,
  `class_path` varchar(255) DEFAULT NULL,
  `class_name` varchar(255) DEFAULT NULL,
  `feed_format` text,
  `mail_format` text,
  `mail_subject` varchar(255) DEFAULT NULL,
  `sms_format` text,
  `feed_enabled` tinyint(1) DEFAULT '1',
  `mail_enabled` tinyint(1) DEFAULT '1',
  `sms_enabled` tinyint(1) DEFAULT '1',
  `date_created` char(15) DEFAULT NULL,
  `active` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=56 ;

--
-- Dumping data for table `activity_registry`
--

INSERT INTO `activity_registry` VALUES
(1, 'NEW TASK', 'task', 'new', 'tasks', 'team/models/vo/TeamTask.php', 'Task', '<span class=''nametext''><a href=''{9}''>{1}</a></span> created task <i><a href=''{3}''>{8}</a></i>.<br>', '', '{1} created a new task.', 'You have a new task - {8}. From {1}', 1, 1, 1, '1395320628', 1),
(2, 'COMPLETE TASK', 'task', 'complete', 'tasks', 'team/models/vo/TeamTask.php', 'Task', '<span class=''nameText''><a href=''{9}''>{1}</a></span> completed task <i><a href=''{3}''>{8}</a>.</i>', '', '{1} has completed a task.', '', 1, 1, 1, '1395320628', 1),
(3, 'TRANSFER TASK', 'task', 'transfer', 'tasks', 'team/models/vo/TeamTask.php', 'Task', '<span class=''nameText''><a href=''{9}''>{1}</a></span> re-assigned task <i><a href=''{3}''>{8}</a></i>', '', '{1} transferred a task.', '', 1, 1, 1, '1395320628', 1),
(4, 'USER ADDED TO TASK', 'task', 'add_user', 'tasks', 'team/models/vo/TeamTask.php', 'Task', '<span class=''nameText''><a href=''{9}''>{1}</a></span> has been added to task <i><a href=''{3}''>{8}</a>,</i>&nbsp;and will now be notified of progress and changes.', '', '{1} is now following your task.', '', 1, 1, 1, '1395320628', 1),
(5, 'FILE UPLOAD TO TASK', 'task', 'add_file', 'tasks', 'team/models/vo/TeamTask.php', 'Task', '<span class=''nameText''><a href=''{9}''>{1}</a></span> shared a file on task <i><a href=''{3}''>{8}</a></i>', '', '{1} attached a file to your task.', '', 1, 1, 1, '1395320628', 1),
(6, 'NEW DISCUSSION', 'discussion', 'new', 'discussions', 'team/models/vo/TeamDiscussion.php', 'Discussion', '<span class=''nameText''><a href=''{9}''>{1}</a></span> created discussion <i><a href=''{3}''>{8}</a>.</i>', '<br>', '{1} started a discussion with you', '<br>', 1, 1, 1, '1395320628', 1),
(7, 'USER ADDED TO DISCUSSION', 'discussion', 'add_user', 'discussions', 'team/models/vo/TeamDiscussion.php', 'Discussion', '<span class=''nameText''><a href=''{9}''>{1}</a></span> has joined discussion <i><a href=''{3}''>{8}</a>.</i>', '', '{1} has joined discussion {8}.', '', 1, 1, 1, '1395320628', 1),
(8, 'COMMENT ON DISCUSSION', 'discussion', 'comment', 'discussions', 'team/models/vo/TeamDiscussion.php', 'Discussion', '<span class=''nameText''><a href=''{9}''>{1}</a></span> posted a message to discussion <i><a href=''{3}''>{8}</a></i>', '', 'New comment on discussion {8}.', '', 1, 1, 1, '1395320628', 1),
(9, 'COMMENT ON TASK', 'task', 'comment', 'tasks', 'team/models/vo/TeamTask.php', 'Task', '<span class=''nameText''><a href=''{9}''>{1}</a></span> posted a comment on task <i><a href=''{3}''>{8}</a></i>', '', 'New comment on task.', '', 1, 1, 1, '1395320628', 1),
(10, 'VIEW DISCUSSION', 'discussion', 'view', 'discussions', 'team/models/vo/TeamDiscussion.php', 'Discussion', '', '', '', '', 0, 0, 0, '1395320628', 1),
(11, 'NEW CONTENT', 'cms', 'new', 'content', 'cms/models/vo/Content.php', 'Content', '<span class=''nameText''><a href=''{9}''>{1}</a></span> created content <i><a href=''{3}''>{8}</a></i>', '', 'New content has been published', '', 1, 1, 1, '1395320628', 1),
(12, 'EDIT CONTENT', 'cms', 'edit', 'content', 'cms/models/vo/Content.php', 'Content', '', '', '', '', 0, 0, 0, '1395320628', 1),
(13, 'VIEW CONTENT', 'cms', 'view', 'content', 'cms/models/vo/Content.php', 'Content', '', '', '', '', 0, 0, 0, '1395320628', 1),
(14, 'NEW DOCUMENT', 'document', 'new', 'documents', 'team/models/vo/TeamDocument.php', 'Document', '<span class=''nameText''><a href=''{9}''>{1}</a></span> uploaded <i><a href=''{3}''>{8}</a></i>', '<span class=''nameText''><a href=''{9}''>{1}</a></span> uploaded <i><a href=''{3}''>{8}</a></i>', '{1} has shared a file with you', '', 1, 1, 1, '1395320628', 1),
(15, 'VIEW DOCUMENT', 'document', 'view', 'documents', 'team/models/vo/TeamDocument.php', 'Document', '', '', '', '', 0, 0, 0, '1395320628', 1),
(16, 'SHARE DOCUMENT', 'document', 'share', 'documents', 'team/models/vo/TeamDocument.php', 'Document', '<span class=''nameText''><a href=''{9}''>{1}</a></span> shared <i><a href=''{3}''>{8}</a></i>', '', 'A document has been shared with you', '', 1, 1, 1, '1395320628', 1),
(17, 'DOWNLOAD DOCUMENT', 'document', 'download', 'documents', 'team/models/vo/TeamDocument.php', 'Document', '', '', '', '', 0, 0, 0, '1395320628', 1),
(18, 'SHARE CONTENT', 'cms', 'share', 'content', 'cms/models/vo/Content.php', 'Content', '<span class=''nameText''><a href=''{9}''>{1}</a></span> shared <i><a href=''{3}''>{8}</a></i>', '', 'A content has been shared with you.', '', 1, 1, 1, '1395320628', 1),
(19, 'COMMENT ON CONTENT', 'cms', 'comment', 'content', 'cms/models/vo/Content.php', 'Content', '<span class=''nameText''><a href=''{9}''>{1}</a></span> posted a comment on content <i><a href=''{3}''>{8}</a></i>', '', 'New comment on content {8}.', '', 1, 1, 1, '1395320628', 1),
(20, 'COMMENT ON DOCUMENT', 'document', 'comment', 'documents', 'team/models/vo/TeamDocument.php', 'Document', '<span class=''nameText''><a href=''{9}''>{1}</a></span> posted a comment on document <i><a href=''{3}''>{8}</a></i>', '', 'New comment on document {8}.', '', 1, 1, 1, '1395320628', 1),
(21, 'SHARE DOCUMENT WITH EXTRANET', 'document', 'extranet_share', 'documents', 'team/models/vo/TeamDocument.php', 'Document', '', '{1} has shared the following file with you. <br/>\n\n{8}\n<br/>\n<a href=''{3}''>Click on this link to view the file.</a>', '{1} has shared a file with you', '', 0, 1, 0, '1395320628', 1),
(22, 'CHECKOUT DOCUMENT', 'document', 'checkout', 'documents', 'team/models/vo/TeamDocument.php', 'Document', '<span class=''nameText''><a href=''{9}''>{1}</a></span> checkout out <i><a href=''{3}''>{8}</a></i> &nbsp; for editing.', '', '', '', 1, 0, 0, '1395320628', 1),
(23, 'ADD USER TO TEAM', 'team', 'add_user', 'groups', 'team/models/vo/Team.php', '', '', '<span class=''nameText''><a href=''{9}''>{1}</a></span> has invited you to collaborate with team "{8}". <a href=''{3}''>Click here to visit the team space</a>.', '{1} has invited you to a team.', '', 0, 1, 0, '1395320628', 1),
(24, 'NEW TEAM', 'team', 'new', 'groups', 'team/models/vo/Team.php', '', '', '', '', '', 0, 0, 0, '1395320628', 1),
(25, 'NEW DOCUMENT VERSION/CHECK-IN DOCUMENT', 'document', 'new_version', 'documents', 'team/models/vo/TeamDocument.php', 'Document', '<span class=''nameText''><a href=''{9}''>{1}</a></span> uploaded a new version of <i><a href=''{3}''>{8}</a></i>', '', '', '', 1, 0, 0, '1395320628', 1),
(26, 'NEW NOTE', 'note', 'new', 'notes', 'team/models/vo/TeamNote.php', 'Note', '<span class=''nameText''><a href=''{9}''>{1}</a></span> added a new note <i><a href=''{3}''>{8}</a></i>', '', 'A new note has been created', '', 1, 1, 0, '1395320628', 1),
(27, 'EDIT NOTE', 'note', 'edit', 'notes', 'team/models/vo/TeamNote.php', 'Note', '<span class=''nameText''><a href=''{9}''>{1}</a></span> edited note <i><a href=''{3}''>{8}</a></i>', '', 'Note ''{8}'' has been updated', '', 1, 0, 0, '1395320628', 1),
(28, 'VIEW NOTE', 'note', 'view', 'notes', 'team/models/vo/TeamNote.php', 'Note', '', '', '', '', 0, 0, 0, '1395320628', 1),
(29, 'COMMENT ON NOTE', 'note', 'comment', 'notes', 'team/models/vo/TeamNote.php', 'Note', '<span class=''nameText''><a href=''{9}''>{1}</a></span> posted a comment on note <i><a href=''{3}''>{8}</a></i>', '', 'New comment on note ''{8}', '', 1, 1, 1, '1395320628', 1),
(30, 'INITATE NEW WORKFLOW FORM', 'workflow', 'new', 'user_processes', 'workflow/models/vo/UserProcess.php', 'UserProcess', '<span class=''nameText''><a href=''{9}''>{1}</a></span> initiated  <i><a href=''{3}''>new workflow request</a></i>', '', '', '', 0, 0, 0, '1395320628', 1),
(31, 'COMMENT ON FORM', 'workflow', 'comment', 'user_processes', 'workflow/models/vo/UserProcess.php', 'UserProcess', '<span class=''nameText''><a href=''{9}''>{1}</a></span> posted a comment on form <i><a href=''{3}''>{8}</a></i>', '', '', '', 1, 0, 0, '1395320628', 1),
(32, 'WORKFLOW PENDING APPROVAL', 'workflow', 'pending', 'user_processes', 'workflow/models/vo/UserProcess.php', 'UserProcess', 'Your <a href=''{3}''>workflow request</a>&nbsp;has been received and will be handled by&nbsp;&nbsp;<span class=''nameText''><a href=''{9}''>{1}</a>.</span>', 'Your <a href="http://localhost:88/precurio4/public/admin/notification/edit/id/{3}">workflow request</a> [{8}] &nbsp;has been received and will be handled by&nbsp;&nbsp;<span class="nameText"><a href="http://localhost:88/precurio4/public/admin/notification/edit/id/{9}">{1}</a>.</span><br>', 'Your form is pending approval', '', 1, 1, 0, '1395320628', 1),
(33, 'WORKFLOW APPROVED', 'workflow', 'approved', 'user_processes', 'workflow/models/vo/UserProcess.php', 'UserProcess', '<span class=''nameText''><a href=''{9}''>{1}</a></span> approved <i><a href=''{3}''>request</a></i> ', '', 'Form has been approved', '', 1, 1, 0, '1395320628', 1),
(34, 'WORKFLOW NOT APPROVED', 'workflow', 'rejected', 'user_processes', 'workflow/models/vo/UserProcess.php', 'UserProcess', '<span class=''nameText''><a href=''{9}''>{1}</a></span> did NOT approve <i><a href=''{3}''>request</a></i> ', '', 'Form has been declined', '', 1, 1, 0, '1395320628', 1),
(35, 'WORKFLOW TRANSFERED', 'workflow', 'transfered', 'user_processes', 'workflow/models/vo/UserProcess.php', 'UserProcess', '<span class=''nameText''><a href=''{9}''>{1}</a></span> transfered <i><a href=''{3}''>request</a></i> ', '', '', '', 1, 0, 0, '1395320628', 1),
(36, 'WORKFLOW COMPLETE', 'workflow', 'completed', 'user_processes', 'workflow/models/vo/UserProcess.php', 'UserProcess', '<i><a href=''{3}''>Workflow process</a></i> is now complete.', '', 'Form approval is now complete.', '', 1, 1, 0, '1395320628', 1),
(37, 'NEW USER STATUS', 'user', 'status', 'status_messages', 'user/models/vo/UserStatus.php', 'UserStatus', '<span class=''nameText''><a href=''{7}/user/profile/view/{5}''>{1} </a></span>: {8}', '', '', '', 1, 0, 0, '1395320628', 1),
(38, 'USER CHANGE PROFILE PICTURE', 'user', 'picture', 'user_details', 'user/models/vo/User.php', 'User', '<span class=''nameText''><a href=''{7}/user/profile/view/{5}''>{1} </a></span> has a new profile picture.', '', '', '', 1, 0, 0, '1395320628', 1),
(39, 'USER CHANGE PHONE NUMBER', 'user', 'phone', 'user_details', 'user/models/vo/User.php', 'User', '<span class=''nameText''><a href=''{7}/user/profile/view/{5}''>{1} </a></span> has updated {2} phone number.', '', '', '', 1, 0, 0, '1395320628', 1),
(40, 'USER CHANGE LOCATION', 'user', 'location', 'user_details', 'user/models/vo/User.php', 'User', '<span class=''nameText''><a href=''{7}/user/profile/view/{5}''>{1} </a></span> has moved to a new location.', '', '', '', 1, 0, 0, '1395320628', 1),
(41, 'USER CHANGE JOB TITLE', 'user', 'job', 'user_details', 'user/models/vo/User.php', 'User', '<span class=''nameText''><a href=''{7}/user/profile/view/{5}''>{1} </a></span> has a new job title.', '', '', '', 1, 0, 0, '1395320628', 1),
(42, 'USER CHANGE DEPARTMENT', 'user', 'department', 'user_details', 'user/models/vo/User.php', 'User', '<span class=''nameText''><a href=''{7}/user/profile/view/{5}''>{1} </a></span> is now in a new department.', '', '', '', 1, 0, 0, '1395320628', 1),
(43, 'USER CHANGE PASSWORD', 'user', 'password', 'user_details', 'user/models/vo/User.php', 'User', '', '', '', '', 0, 0, 0, '1395320628', 1),
(44, 'INVITE USER TO EVENT', 'event', 'add_user', 'events', 'event/models/vo/Event.php', 'Event', '<span class=''nameText''><a href=''{7}/user/profile/view/{5}''>{1} </a></span> invited you to event <i><a href=''{3}''>{8}</a></i>.', '', 'New Event \\\\"{8}\\\\".', '', 1, 1, 1, '1395320628', 1),
(45, 'NEW EVENT', 'event', 'new', 'events', 'event/models/vo/Event.php', 'Event', '<span class=''nameText''><a href=''{7}/user/profile/view/{5}''>{1} </a></span> has created a new event <i><a href=''{3}''>{8}</a></i>.', '', '', '', 1, 0, 0, '1395320628', 1),
(46, 'PHOTO ADDED TO EVENT', 'event', 'add_photo', 'events', 'event/models/vo/Event.php', 'Event', '<span class=''nameText''><a href=''{7}/user/profile/view/{5}''>{1} </a></span> has added a new photo to event <i><a href=''{3}''>{8}</a></i>.', '', 'New Event Photo.', '', 1, 1, 1, '1395320628', 1),
(47, 'EDIT EVENT', 'event', 'edit', 'events', 'event/models/vo/Event.php', 'Event', '<span class=''nameText''><a href=''{7}/user/profile/view/{5}''>{1} </a></span> made some changes to event <i><a href=''{3}''>{8}</a></i>.', '', '', '', 1, 0, 0, '1395320628', 1),
(48, 'FILE ADDED TO EVENT', 'event', 'add_file', 'events', 'event/models/vo/Event.php', 'Event', '<span class=''nameText''><a href=''{7}/user/profile/view/{5}''>{1} </a></span> has added a new document to event <i><a href=''{3}''>{8}</a></i>.', '', 'New Event Document.', '', 1, 1, 1, '1395320628', 1),
(49, 'TASK SHARED WITH TEAM', 'task', 'add_group', 'tasks', 'team/models/vo/TeamTask.php', 'Task', '<span class=''nameText''><a href=''{9}''>{1}</a></span> has been added to task <i><a href=''{3}''>{8}</a></i>.', '', '{1} is now following your task', '', 1, 1, 1, '1395320628', 1),
(50, 'TEAM ADDED TO DISCUSSION', 'discussion', 'add_group', 'discussions', 'team/models/vo/TeamDiscussion.php', 'Discussion', '<span class=''nameText''><a href=''{9}''>{1}</a></span> has joined discussion <i><a href=''{3}''>{8}</a>.</i>', '', '', '', 1, 0, 1, '1395320628', 1),
(51, '', 'note', 'add_group', 'notes', 'team/models/vo/TeamNote.php', 'Note', '', '', '', '', 0, 0, 0, '1395320628', 1),
(52, 'USER FORGOT PASSWORD', 'user', 'forgot', 'user_details', 'user/models/vo/User.php', 'User', '', '<div><span style=''font-size: 1em; line-height: 1.4;''>This email is sent to your because you have requested to reset your password. If you didn''t initiate this request, please report this to the administrator.</span><br></div><div><br></div><div>To continue with your password reset,&nbsp;<a href="{3}">please click here</a>.</div>', 'Reset your password', '', 0, 1, 0, '1395320628', 1),
(53, 'NEW USER REGISTERED BY ADMIN', 'user', 'new', 'user_details', 'user/models/vo/User.php', 'User', '', 'You have been registered on the Precurio intranet platform. <br/> <br/>\n\nBelow is your login information:<br/>\n\n{8}\n<br/> <br/>\n<a href="{3}">Click here to complete your profile on your corporate intranet.</a>', 'You have been registered on the intranet', '', 0, 1, 1, '1395320628', 1),
(54, 'FILE ADDED TO DISCUSSION', 'discussion', 'add_file', 'discussions', 'team/models/vo/TeamDiscussion.php', 'Discussion', '<span class=''nameText''><a href=''{7}/user/profile/view/{5}''>{1} </a></span> has attached a new file to discussion <i><a href=''{3}''>{8}</a></i>.', '', 'New File on Discussion', '', 1, 1, 1, '1395320628', 1),
(55, 'EMAIL FORM TO APPROVER', 'workflow', 'form_email', 'user_processes', 'workflow/models/vo/UserProcess.php', 'UserProcess', '', 'See <a href="{3}" title="" target="">Workflow request</a> &nbsp; below</br> {1}', 'A form has been submited', '', 0, 1, 0, '1395320628', 1);

-- --------------------------------------------------------

--
-- Table structure for table `analytics`
--

CREATE TABLE `analytics` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `session_id` char(30) DEFAULT NULL,
  `module` varchar(255) DEFAULT NULL,
  `controller` varchar(255) DEFAULT NULL,
  `action` varchar(255) DEFAULT NULL,
  `params` text,
  `date_created` char(15) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `app_documents`
--

CREATE TABLE `app_documents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `appid` char(10) DEFAULT NULL,
  `item_id` int(10) NOT NULL,
  `content_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `date_created` char(15) DEFAULT NULL,
  `active` tinyint(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `app_tags`
--

CREATE TABLE `app_tags` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `appid` char(10) DEFAULT NULL,
  `item_id` int(10) NOT NULL,
  `tag_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `date_created` char(15) DEFAULT NULL,
  `active` tinyint(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `bugs`
--

CREATE TABLE `bugs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `type` char(20) NOT NULL,
  `component` char(40) NOT NULL,
  `title` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `date_created` char(15) DEFAULT NULL,
  `active` tinyint(3) unsigned DEFAULT NULL,
  `sent` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `categorys`
--

CREATE TABLE `categorys` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL COMMENT 'user that created the category',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'category id to which it is a sub category of. parent categories have their parent_id as 0',
  `title` varchar(255) DEFAULT NULL,
  `description` text,
  `access_type` tinyint(4) NOT NULL DEFAULT '0' COMMENT '-1 for private, 0 for public, 1 for shared',
  `appid` varchar(30) NOT NULL DEFAULT 'cms' COMMENT 'App that is making use of category feature',
  `date_created` char(20) DEFAULT NULL,
  `active` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `deleted` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'this indicates if a category has been permanently deleted from the recycle bin. A value of 1 means the category has been deleted  permanently, while 0 means the category is still in recycle bin',
  `is_folder` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `is_photo` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'indicates if it is an album folder',
  `is_site` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'indicates if it is a site category',
  `is_locked` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'indicates if a folder has been locked',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `components`
--

CREATE TABLE `components` (
  `componentid` int(11) NOT NULL AUTO_INCREMENT,
  `componentform` int(11) DEFAULT NULL,
  `section` int(11) DEFAULT '0',
  `rowid` int(11) DEFAULT NULL,
  `componenttype` varchar(10) DEFAULT NULL,
  `componentlabel` varchar(250) DEFAULT NULL,
  `componentrequired` int(1) DEFAULT '0',
  `componentdefaultvalue` varchar(250) DEFAULT NULL,
  `frm_database` varchar(255) DEFAULT 'self',
  `frm_table` varchar(255) DEFAULT NULL,
  `frm_label_field` varchar(255) DEFAULT 'title',
  `frm_value_field` varchar(255) DEFAULT 'id',
  `frm_where_clause` text,
  `lastmodified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`componentid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=84 ;

--
-- Dumping data for table `components`
--

INSERT INTO `components` VALUES
(1, 1, 0, 1, 'dropdown', 'Type of Leave', 0, 'Annual', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(2, 1, 0, 2, 'number', 'Number of Days', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(3, 1, 0, 3, 'date', 'Start Date', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(4, 1, 0, 4, 'date', 'End Date', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(5, 1, 0, 5, 'text', 'Contact Telephone during leave', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(6, 1, 0, 6, 'textarea', 'Contact Address during leave', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(7, 1, 0, 7, 'textarea', 'Notes (if any)', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(8, 1, 3, 1, 'signature', 'signature', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(9, 1, 4, 1, 'signature', 'signature', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(10, 2, 0, 1, 'user', 'Name of Person Travelling', 1, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(11, 2, 0, 2, 'department', 'Department', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(12, 2, 0, 3, 'dropdown', 'Type of Travel', 1, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(13, 2, 0, 4, 'textarea', 'Purpose of Travel', 1, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(14, 2, 0, 5, 'text', 'Destination', 1, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(15, 2, 0, 6, 'date', 'Departure Date', 1, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(16, 2, 0, 7, 'text', 'Departure Time', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(17, 2, 0, 8, 'date', 'Arrival Date', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(18, 2, 0, 9, 'text', 'Arrival Time', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(19, 2, 0, 10, 'dropdown', 'Means of transport', 1, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(20, 2, 0, 11, 'check', 'Preferences', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(21, 2, 0, 12, 'textarea', 'Notes (if any)', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(22, 2, 5, 1, 'signature', 'signature', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(23, 2, 6, 1, 'signature', 'signature', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(24, 2, 6, 2, 'price', 'Accommodation Cost', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(25, 2, 6, 3, 'price', 'Flight Tickets', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(26, 2, 6, 4, 'price', 'Road Transportation', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(27, 2, 6, 5, 'price', 'Other Costs', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(28, 3, 0, 2, 'text', 'Item', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(29, 3, 0, 3, 'textarea', 'Specifications (if any)', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(30, 3, 0, 4, 'textarea', 'Purpose', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(31, 3, 0, 5, 'number', 'Quantity', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(32, 3, 0, 6, 'price', 'Price (if known)', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(33, 3, 0, 7, 'date', 'Required Delivery date', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(34, 3, 0, 8, 'textarea', 'Suggested Supppliers', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(35, 3, 0, 9, 'textarea', 'Notes (if any)', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(36, 3, 7, 1, 'signature', 'signature', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(37, 3, 8, 1, 'signature', 'signature', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(38, 5, 0, 2, 'text', 'Item Requested', 1, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(39, 5, 0, 3, 'textarea', 'Description', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(40, 5, 0, 4, 'number', 'Quantity', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(41, 5, 9, 1, 'signature', 'signature', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(42, 5, 10, 1, 'signature', 'signature', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(43, 5, 10, 2, 'number', 'Quantity Issued', 1, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(44, 5, 10, 3, 'date', 'Date Issued', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(45, 4, 0, 3, 'price', 'Amount Requested', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(46, 4, 0, 2, 'textarea', 'Purpose / Justification', 1, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(47, 4, 0, 1, 'date', 'Date needed', 1, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(48, 4, 0, 4, 'date', 'Date to be returned', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(49, 4, 11, 1, 'signature', 'signature', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(50, 4, 12, 1, 'signature', 'signature', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(51, 4, 12, 2, 'price', 'Amount Issued', 1, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(52, 4, 12, 3, 'date', 'Date Issued', 1, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(53, 6, 0, 1, 'dropdown', 'Room', 1, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(54, 6, 0, 2, 'textarea', 'Purpose', 1, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(55, 6, 0, 3, 'date', 'Date', 1, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(56, 6, 0, 4, 'text', 'Time', 1, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(57, 6, 0, 5, 'text', 'Duration (hours)', 0, '1hr', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(58, 6, 0, 6, 'dropdown', 'Recurring', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(59, 6, 0, 7, 'textarea', 'Additional Equipment Needed', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(60, 6, 13, 1, 'signature', 'signature', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(61, 7, 0, 1, 'price', 'Amount of Reimbursement', 1, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(62, 7, 0, 2, 'textarea', 'Description of Expense', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(63, 7, 0, 3, 'text', 'Account Number', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(64, 7, 14, 1, 'signature', 'signature', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(65, 7, 15, 1, 'signature', 'signature', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(66, 7, 15, 2, 'price', 'Amount Approved', 1, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(67, 7, 15, 3, 'date', 'Date Approved', 1, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(68, 8, 0, 1, 'user', 'Requested By', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(69, 8, 0, 2, 'department', 'Department', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(70, 8, 0, 3, 'location', 'Location', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(71, 8, 16, 1, 'signature', 'signature', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(72, 8, 16, 2, 'check', 'Signature', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(73, 8, 0, 4, 'file', 'CV', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(74, 9, 0, 1, 'text', 'Name of Current', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(75, 9, 0, 2, 'date', 'Date of Open', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(76, 9, 17, 1, 'text', 'Alternative Name', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(77, 9, 18, 1, 'signature', 'signature', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(78, 9, 19, 1, 'text', 'Finance Personnel', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(79, 1, 20, 1, 'signature', 'signature', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(80, 10, 0, 1, 'text', 'Visitor Name', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(81, 10, 0, 2, 'dropdown', 'Visitor Type', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(82, 10, 21, 1, 'signature', 'signature', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]'),
(83, 10, 0, 3, 'radio', 'Official', 0, '', 'self', NULL, 'title', 'id', NULL, '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `contacts`
--

CREATE TABLE `contacts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int(10) unsigned NOT NULL DEFAULT '0',
  `user_id` int(10) unsigned DEFAULT NULL,
  `full_name` varchar(255) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `company` varchar(255) DEFAULT NULL,
  `work_phone` varchar(255) DEFAULT NULL,
  `mobile_phone` varchar(255) DEFAULT NULL,
  `fax` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `website` varchar(255) DEFAULT NULL,
  `job_title` varchar(255) DEFAULT NULL,
  `twitter` varchar(255) DEFAULT NULL,
  `shared` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `date_created` char(15) DEFAULT NULL,
  `last_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `active` tinyint(4) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `content`
--

CREATE TABLE `content` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `image_path` varchar(255) DEFAULT NULL,
  `summary` text,
  `body` text,
  `user_id` int(10) unsigned DEFAULT '0',
  `poll_id` int(10) unsigned DEFAULT '0',
  `url` varchar(255) NOT NULL DEFAULT '#',
  `keyword` varchar(255) DEFAULT '',
  `is_featured` tinyint(3) unsigned DEFAULT '0',
  `is_photo` tinyint(3) unsigned DEFAULT '0',
  `is_document` tinyint(3) unsigned DEFAULT '0',
  `date_created` char(15) DEFAULT NULL,
  `last_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `active` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `deleted` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT 'A value of 1 means the content has been deleted  permanently, while 0 means the content is still in recycle bin',
  `num_of_hits` int(10) unsigned NOT NULL DEFAULT '0',
  `rating` int(11) NOT NULL DEFAULT '0',
  `is_public` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `template` varchar(255) DEFAULT NULL COMMENT 'a default template is handled at code level',
  `is_page` tinyint(1) unsigned DEFAULT '0',
  `disable_comments` tinyint(1) unsigned DEFAULT '0',
  `is_site` tinyint(1) unsigned DEFAULT '0',
  `confirm_read` tinyint(1) unsigned DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `content_approval`
--

CREATE TABLE `content_approval` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `featured` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `advert` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `news` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `group_content` tinyint(3) NOT NULL DEFAULT '0' COMMENT 'this is ignored if group_id = 0',
  `group_id` int(10) unsigned NOT NULL DEFAULT '0',
  `active` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `date_created` char(15) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `content_categorys`
--

CREATE TABLE `content_categorys` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `content_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL COMMENT 'user that assigned the content to the category',
  `date_created` char(20) DEFAULT NULL,
  `active` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `content_lock_history`
--

CREATE TABLE `content_lock_history` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `content_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `lock` tinyint(1) unsigned NOT NULL,
  `active` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `date_created` char(15) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `content_ratings`
--

CREATE TABLE `content_ratings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `content_id` int(10) unsigned DEFAULT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `value` tinyint(4) DEFAULT NULL,
  `date_created` char(15) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `department`
--

CREATE TABLE `department` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `group_id` int(10) unsigned NOT NULL,
  `colour_code` varchar(255) DEFAULT NULL,
  `date_created` char(255) DEFAULT NULL,
  `active` tinyint(3) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `discussions`
--

CREATE TABLE `discussions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `creator_user_id` int(11) DEFAULT NULL,
  `date_created` char(15) DEFAULT NULL,
  `last_updated` char(15) DEFAULT NULL,
  `active` tinyint(4) unsigned DEFAULT NULL,
  `is_team` tinyint(3) unsigned DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `discussion_groups`
--

CREATE TABLE `discussion_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `discussion_id` int(10) unsigned NOT NULL,
  `group_id` int(10) unsigned NOT NULL,
  `date_created` char(15) DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `discussion_users`
--

CREATE TABLE `discussion_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `discussion_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `date_created` char(15) NOT NULL,
  `active` tinyint(3) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `documents`
--

CREATE TABLE `documents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `content_id` int(10) NOT NULL,
  `file_name` varchar(255) NOT NULL,
  `file_type` char(5) DEFAULT NULL,
  `file_author` varchar(255) DEFAULT NULL,
  `file_size` int(10) unsigned DEFAULT NULL,
  `file_date_created` char(15) DEFAULT NULL,
  `file_content` longblob,
  `date_created` char(15) DEFAULT NULL,
  `last_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `document_checkout`
--

CREATE TABLE `document_checkout` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `document_id` int(10) unsigned NOT NULL,
  `check_out` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `check_in` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `user_id` int(10) unsigned NOT NULL,
  `version` char(10) DEFAULT NULL,
  `active` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `cancelled` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `date_created` char(15) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `document_download_log`
--

CREATE TABLE `document_download_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `document_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `date_created` char(15) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `document_history`
--

CREATE TABLE `document_history` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `content_id` int(10) unsigned NOT NULL,
  `file_name` varchar(255) NOT NULL,
  `file_type` char(5) DEFAULT NULL,
  `file_author` varchar(255) DEFAULT NULL,
  `file_size` int(10) unsigned DEFAULT NULL,
  `file_date_created` char(15) DEFAULT NULL,
  `file_content` longblob,
  `date_created` char(15) DEFAULT NULL,
  `last_modified` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `document_password`
--

CREATE TABLE `document_password` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `document_id` int(10) unsigned NOT NULL,
  `password` varchar(100) DEFAULT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `active` tinyint(1) unsigned DEFAULT NULL,
  `date_created` char(15) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `document_versions`
--

CREATE TABLE `document_versions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `document_history_id` int(10) unsigned NOT NULL COMMENT 'a value of zero means this version has not been moved to the history and so is the most recent version. Note that the most recent version is not necessarily the current version since a user can set an older version as the current version',
  `document_id` int(10) unsigned NOT NULL,
  `version` char(10) NOT NULL,
  `notes` text,
  `user_id` int(10) unsigned NOT NULL,
  `current` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Is the current version?',
  `major` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT 'Is a major version',
  `active` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `date_created` char(15) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `email_documents`
--

CREATE TABLE `email_documents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `email_message_id` int(10) unsigned NOT NULL COMMENT 'foreign key to email_messages',
  `document_id` int(10) unsigned NOT NULL,
  `date_created` char(15) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `email_messages`
--

CREATE TABLE `email_messages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `user_email_id` int(10) unsigned DEFAULT NULL COMMENT 'foreign key the user_emails',
  `message` text,
  `mailbox` char(20) DEFAULT NULL,
  `message_id` varchar(255) DEFAULT NULL,
  `from_address` varchar(255) DEFAULT NULL,
  `to_address` varchar(255) DEFAULT NULL,
  `cc_address` varchar(255) DEFAULT NULL,
  `bcc_address` varchar(255) DEFAULT NULL,
  `reply_address` varchar(255) DEFAULT NULL,
  `sender_address` varchar(255) DEFAULT NULL,
  `return_address` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `in_reply_to` varchar(255) DEFAULT NULL,
  `followup_to` varchar(255) DEFAULT NULL,
  `is_recent` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_seen` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_flagged` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_deleted` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_draft` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `message_size` varchar(50) DEFAULT NULL,
  `message_date` varchar(50) DEFAULT NULL,
  `date_created` char(15) DEFAULT NULL,
  `active` tinyint(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `events`
--

CREATE TABLE `events` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `summary` varchar(255) DEFAULT NULL,
  `host` varchar(255) DEFAULT NULL,
  `location_id` int(10) unsigned DEFAULT NULL,
  `venue` varchar(255) DEFAULT NULL,
  `start_date` char(11) DEFAULT NULL,
  `start_time` varchar(255) DEFAULT '9am',
  `end_date` char(11) DEFAULT NULL,
  `end_time` varchar(255) DEFAULT '5pm',
  `start_timestamp` char(15) DEFAULT NULL COMMENT 'unix timestamp of the start date',
  `description` longtext,
  `is_open` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `work_related` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `open_guest_list` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `restrict_content_access` tinyint(4) unsigned NOT NULL DEFAULT '0',
  `disable_content_access` tinyint(4) unsigned NOT NULL DEFAULT '0',
  `logo` varchar(255) DEFAULT NULL,
  `date_created` char(15) DEFAULT NULL,
  `last_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `active` tinyint(4) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `event_contents`
--

CREATE TABLE `event_contents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `event_id` int(10) unsigned NOT NULL,
  `content_id` int(10) unsigned NOT NULL,
  `date_created` char(15) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `event_status`
--

CREATE TABLE `event_status` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `event_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `status` tinyint(4) NOT NULL DEFAULT '0',
  `date_created` char(15) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `facts`
--

CREATE TABLE `facts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `url` varchar(255) DEFAULT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `date_created` char(255) DEFAULT NULL,
  `active` tinyint(3) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `featured_user`
--

CREATE TABLE `featured_user` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `comment` text NOT NULL,
  `expires` char(15) DEFAULT NULL,
  `date_created` char(15) NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `forms`
--

CREATE TABLE `forms` (
  `formid` int(11) NOT NULL AUTO_INCREMENT,
  `formName` varchar(50) DEFAULT NULL,
  `formDescription` text,
  `createdBy` varchar(50) DEFAULT NULL,
  `lastModified` datetime DEFAULT NULL,
  `active` int(1) DEFAULT '1',
  `formCode` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`formid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=10 ;

--
-- Dumping data for table `forms`
--

INSERT INTO `forms` VALUES
(1, 'Leave Request Form', 'to be filled by employee when applying for leave and vacations', ' ', NULL, 1, 'LRF'),
(2, 'Travel Request Form', '', 'Precurio Team', NULL, 1, 'TRF'),
(3, 'Purchase Request Form', 'To be filled by employee when requesting the purchase of an item', 'Precurio Team', NULL, 0, 'PRF'),
(4, 'Cash Advance Forms', 'For should be used for requesting cash advance of less than 20,000 Naira', 'Mayor Brain', NULL, 0, 'CAF'),
(5, 'Materials Requisition Form', 'to be filled by employee when requesting materials such as papers, ink etc', 'Precurio Team', NULL, 0, 'MRF'),
(6, 'Meeting Room Request', '', 'Precurio Team', NULL, 0, 'MRR'),
(7, 'Cash Reimbursement Request', 'to be filled by employees requesting reimbursement of personal cash spent on official expenses', 'Precurio Team', NULL, 1, 'CRR'),
(8, 'Test No Approval', '', 'root', NULL, 0, 'TNA'),
(9, 'Visitors Form', 'Forms for visitors to fill', 'Mayor Brain', NULL, 0, 'VF');

-- --------------------------------------------------------

--
-- Table structure for table `groups`
--

CREATE TABLE `groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `parent_id` int(11) unsigned DEFAULT '0',
  `is_location` tinyint(4) DEFAULT '0',
  `is_department` tinyint(4) DEFAULT '0',
  `is_role` tinyint(4) DEFAULT '0',
  `is_default` tinyint(4) DEFAULT '0',
  `is_team` tinyint(4) DEFAULT '0',
  `team_template_id` int(11) unsigned DEFAULT '0',
  `active` tinyint(4) NOT NULL DEFAULT '1',
  `date_created` char(15) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `groups`
--

INSERT INTO `groups` VALUES
(1, 1, 'Staff', 'General Staff Role', 0, 0, 0, 1, 1, 0, 0, 1, '1386835440'),
(2, 1, 'Administrators', 'Role for System Administrators', 1, 0, 0, 1, 0, 0, 0, 1, '1386835463'),
(3, 1, 'Content Managers', 'Role for users that will be adding uploading documents and creating contents', 1, 0, 0, 1, 0, 0, 0, 1, '1386835487');

-- --------------------------------------------------------

--
-- Table structure for table `group_apps`
--

CREATE TABLE `group_apps` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `group_id` int(11) DEFAULT NULL,
  `appid` varchar(255) DEFAULT NULL,
  `date_created` char(15) DEFAULT NULL,
  `active` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `group_categorys`
--

CREATE TABLE `group_categorys` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(10) unsigned NOT NULL,
  `group_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL COMMENT 'user that assigned the category to the group',
  `date_created` char(20) DEFAULT NULL,
  `active` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `group_contents`
--

CREATE TABLE `group_contents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `group_id` int(10) unsigned NOT NULL,
  `content_id` int(10) unsigned NOT NULL,
  `task_id` int(10) unsigned DEFAULT '0',
  `active` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `date_created` char(15) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `group_settings`
--

CREATE TABLE `group_settings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `group_id` int(10) unsigned NOT NULL,
  `content_requires_approval` tinyint(4) NOT NULL DEFAULT '1',
  `featured` tinyint(4) NOT NULL DEFAULT '0',
  `advert` tinyint(4) NOT NULL DEFAULT '0',
  `news` tinyint(4) NOT NULL DEFAULT '0',
  `date_created` char(15) NOT NULL,
  `last_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `invited_users`
--

CREATE TABLE `invited_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `activity_id` int(11) DEFAULT NULL,
  `team_id` int(11) DEFAULT NULL,
  `date_created` char(15) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=dec8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `links`
--

CREATE TABLE `links` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT ' ',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `url` varchar(255) DEFAULT '#',
  `description` text,
  `target` varchar(255) NOT NULL DEFAULT '_blank',
  `active` char(1) NOT NULL DEFAULT '0',
  `date_created` char(15) NOT NULL,
  `last_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `rating` int(11) NOT NULL DEFAULT '0',
  `is_site` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `locations`
--

CREATE TABLE `locations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `group_id` int(10) unsigned NOT NULL,
  `date_created` char(15) DEFAULT NULL,
  `active` tinyint(3) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `logs`
--

CREATE TABLE `logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `priority` varchar(255) DEFAULT NULL,
  `message` text,
  `timestamp` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `mail_queue`
--

CREATE TABLE `mail_queue` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `activity_id` int(10) unsigned DEFAULT '0',
  `subject` text NOT NULL,
  `body` text NOT NULL,
  `from` text NOT NULL,
  `to` text NOT NULL,
  `cc` text,
  `bcc` text,
  `attachment` text,
  `sent` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `error_count` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `date_created` char(15) NOT NULL,
  `date_sent` char(15) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `menu`
--

CREATE TABLE `menu` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT ' ',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0',
  `content_id` int(10) unsigned NOT NULL DEFAULT '0',
  `redirect_id` int(11) DEFAULT NULL COMMENT 'redirect this menu to another menu',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `url` text,
  `description` text,
  `target` varchar(255) NOT NULL DEFAULT '_self',
  `resource` varchar(255) DEFAULT NULL,
  `active` char(1) NOT NULL DEFAULT '0',
  `date_created` char(15) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=13 ;

--
-- Dumping data for table `menu`
--

INSERT INTO `menu` VALUES
(1, 'Home', 0, 0, 0, 1, '/default/index/home', '', '_self', '', '1', '1386793425'),
(2, 'Company', 0, 0, 0, 2, '#', '', '_self', '', '1', '1386793469'),
(3, 'News and Announcements', 2, 0, 0, 3, '/cms/list/0', '', '_self', 'cms_index', '1', '1386793494'),
(4, 'Staff Directory', 2, 0, 0, 4, '/employee', '', '_self', 'employee_index', '1', '1386793540'),
(5, 'Events', 0, 0, 0, 9, '/event', '', '_self', 'event_index', '1', '1386793647'),
(6, 'Departments', 2, 0, 0, 6, '/cms/site/list/all', '', '_self', 'cms_site', '1', '1386793688'),
(7, 'Documents', 0, 0, 0, 7, '/document/index/index', '', '_self', 'cms_index', '1', '1386793714'),
(8, 'Tasks', 0, 0, 0, 8, '/task/index/index', '', '_self', 'task_index', '1', '1386793841'),
(9, 'Discussions', 0, 0, 0, 9, '/discussion/index/index', '', '_self', 'discussion_index', '1', '1386793891'),
(10, 'Workflow', 0, 0, 0, 10, '/workflow', '', '_self', 'workflow_index', '1', '1386793926'),
(11, 'My Teams', 0, 0, 0, 11, '/team', '', '_self', 'team_index', '1', '1386793948'),
(12, 'Admin', 0, 0, 0, 12, '/admin', '', '_self', 'admin_index', '1', '1386793987');

-- --------------------------------------------------------

--
-- Table structure for table `notes`
--

CREATE TABLE `notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `body` text,
  `creator_user_id` int(11) DEFAULT NULL,
  `date_created` char(15) DEFAULT NULL,
  `last_updated` char(15) DEFAULT NULL,
  `active` tinyint(4) unsigned DEFAULT NULL,
  `is_team` tinyint(3) unsigned DEFAULT '0',
  `team_edit` tinyint(3) unsigned DEFAULT '1' COMMENT 'if team members can edit the note',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `note_groups`
--

CREATE TABLE `note_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` int(10) unsigned NOT NULL,
  `group_id` int(10) unsigned NOT NULL,
  `date_created` char(15) DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `options`
--

CREATE TABLE `options` (
  `optionid` int(11) NOT NULL AUTO_INCREMENT,
  `componentid` int(11) DEFAULT NULL,
  `options` text,
  `lastmodified` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`optionid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AVG_ROW_LENGTH=48 ROW_FORMAT=DYNAMIC AUTO_INCREMENT=10 ;

--
-- Dumping data for table `options`
--

INSERT INTO `options` VALUES
(1, 1, 'Annual,Emergency,Casual,Sick', '2010-03-30 16:12:56'),
(2, 12, 'Domestic,International', '2010-03-30 18:17:03'),
(3, 19, 'Air,Road,Water,Rail', '2010-03-30 18:23:01'),
(4, 20, 'Hotel Reservation,Car Hire', '2010-03-30 18:23:55'),
(5, 55, 'Conference Room 1, Conference Room 2', '2010-03-31 01:15:30'),
(6, 60, 'None,Weekly,Monthly', '2010-03-31 01:17:33'),
(7, 74, 'I hereby approve this request', '2010-04-03 19:33:57'),
(8, 83, 'Customer, Vendor', '2013-12-03 13:02:25'),
(9, 85, 'Yes,No', '2013-12-03 13:05:31');

-- --------------------------------------------------------

--
-- Table structure for table `out_of_office`
--

CREATE TABLE `out_of_office` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `proxy_id` int(11) NOT NULL COMMENT 'this is the person that will handle you tasks in your absence',
  `summary` varchar(255) DEFAULT NULL,
  `leave_date` char(15) DEFAULT NULL,
  `return_date` char(15) DEFAULT NULL,
  `active` tinyint(3) unsigned DEFAULT NULL,
  `date_created` char(15) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `p2_users`
--

CREATE TABLE `p2_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `identity` varchar(255) NOT NULL,
  `credential` varchar(255) NOT NULL,
  `date_created` char(255) DEFAULT NULL,
  `last_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `p2_users`
--

INSERT INTO `p2_users` VALUES
(1, '[[admin_email]]', '[[admin_pass]]', '[[timestamp]]', '[[regtime]]');

-- --------------------------------------------------------

--
-- Table structure for table `pages`
--

CREATE TABLE `pages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `content_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0',
  `order` smallint(6) NOT NULL DEFAULT '1',
  `url` text COMMENT 'this is set for external pages or apps.',
  `date_created` char(15) DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `is_site` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `polls`
--

CREATE TABLE `polls` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `multiple_answers` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `is_public` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `end_date` char(15) NOT NULL DEFAULT '0',
  `randomise_options` tinyint(15) unsigned DEFAULT '0',
  `active` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `date_created` char(15) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `poll_options`
--

CREATE TABLE `poll_options` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `poll_id` int(10) unsigned NOT NULL,
  `label` varchar(255) NOT NULL,
  `num_votes` int(10) unsigned NOT NULL DEFAULT '0',
  `date_created` char(15) NOT NULL,
  `active` tinyint(3) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `privileges`
--

CREATE TABLE `privileges` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `privilege` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=10 ;

--
-- Dumping data for table `privileges`
--

INSERT INTO `privileges` VALUES
(1, 'add'),
(2, 'view'),
(3, 'delete'),
(4, 'edit'),
(5, 'details'),
(6, 'share'),
(7, 'export'),
(8, 'import'),
(9, 'executive');

-- --------------------------------------------------------

--
-- Table structure for table `profile_pics`
--

CREATE TABLE `profile_pics` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `image_path` varchar(255) NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `content_id` int(11) NOT NULL DEFAULT '0' COMMENT 'profile picture must first be inserted into content table',
  `date_created` char(15) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `resources`
--

CREATE TABLE `resources` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'not used at all. just for indexing purpose',
  `resource` varchar(255) DEFAULT NULL,
  `parent` varchar(255) DEFAULT NULL,
  `display_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=50 ;

--
-- Dumping data for table `resources`
--

INSERT INTO `resources` VALUES
(1, 'admin_index', '', 'Admin Area / Content Management'),
(2, 'admin_setting', '', 'Core Admin Area (System Settings)'),
(3, 'admin_menu', 'admin_setting', ''),
(4, 'admin_notification', 'admin_setting', ''),
(5, 'admin_upgrade', 'admin_setting', ''),
(6, 'admin_theme', 'admin_setting', ''),
(7, 'admin_link', 'admin_index', ''),
(8, 'admin_cms', 'admin_index', ''),
(9, 'admin_page', 'admin_index', ''),
(10, 'admin_site', 'admin_index', ''),
(11, 'admin_user', 'admin_index', ''),
(12, 'cms_index', 'null', 'Contents'),
(13, 'cms_add', 'cms_index', ''),
(14, 'cms_delete', 'cms_index', ''),
(15, 'cms_edit', 'cms_index', ''),
(16, 'cms_view', 'cms_index', ''),
(17, 'chat_index', 'index_index', 'Chat'),
(18, 'contact_index', 'index_index', ''),
(19, 'index_index', '', 'Basic Intranet Applications'),
(20, 'employee_index', 'index_index', 'Staff Directory'),
(21, 'contact_list', 'contact_index', ''),
(22, 'employee_staff', 'employee_index', ''),
(23, 'event_index', 'index_index', 'Events'),
(24, 'event_my', 'event_index', ''),
(25, 'event_ongoing', 'event_index', ''),
(26, 'event_past', 'event_index', ''),
(27, 'event_upcoming', 'event_index', ''),
(28, 'cms_site', 'cms_index', 'Departmental Sites'),
(29, 'team_index', 'index_index', 'Team Workspace'),
(30, 'poll_index', 'index_index', ''),
(31, 'task_index', 'index_index', 'Tasks'),
(32, 'task_view', 'task_index', ''),
(33, 'user_index', 'index_index', 'User Profiles'),
(34, 'user_profile', 'user_index', ''),
(35, 'user_mypage', 'user_index', ''),
(36, 'workflow_index', '', 'Workflow'),
(37, 'workflow_process', 'workflow_index', ''),
(38, 'discussion_index', 'index_index', 'Discussions'),
(39, 'forum_mod', 'forum_index', ''),
(40, 'forum_post', 'forum_index', ''),
(41, 'forum_admin', 'forum_index', ''),
(42, 'report_index', '', ''),
(43, 'report_content', 'report_index', ''),
(44, 'report_portal', 'report_index', ''),
(45, 'report_search', 'report_index', ''),
(46, 'report_user', 'report_index', ''),
(47, 'report_workflow', 'report_index', ''),
(48, 'forum_topic', 'forum_index', ''),
(49, 'widget_index', 'index_index', 'Widgets');

-- --------------------------------------------------------

--
-- Table structure for table `roles`
--

CREATE TABLE `roles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `group_id` int(10) unsigned NOT NULL,
  `date_created` char(15) DEFAULT NULL,
  `active` tinyint(3) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `roles`
--

INSERT INTO `roles` VALUES
(1, 'Staff', 1, '1386835440', 1),
(2, 'Administrators', 2, '1386835463', 1),
(3, 'Content Managers', 3, '1386835487', 1);

-- --------------------------------------------------------

--
-- Table structure for table `rss`
--

CREATE TABLE `rss` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `logo` varchar(255) DEFAULT NULL,
  `url` varchar(255) NOT NULL,
  `last_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_created` char(15) NOT NULL,
  `active` tinyint(3) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `rss_content`
--

CREATE TABLE `rss_content` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `rss_id` int(10) unsigned NOT NULL,
  `rss_item_id` varchar(255) NOT NULL,
  `author` varchar(255) NOT NULL,
  `content_id` int(10) unsigned NOT NULL,
  `date_created` char(15) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `rules`
--

CREATE TABLE `rules` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(11) NOT NULL,
  `resource` varchar(255) NOT NULL,
  `privilege` varchar(255) NOT NULL,
  `allow` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `created_by` varchar(255) DEFAULT NULL,
  `last_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_created` char(15) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=109 ;

--
-- Dumping data for table `rules`
--

INSERT INTO `rules` VALUES
(1, 1, 'index_index', 'null', 0, '1', '2013-12-11 19:37:21', '1386835641'),
(2, 1, 'index_index', 'add', 1, '1', '2013-12-11 19:37:36', '1386835656'),
(3, 1, 'index_index', 'view', 1, '1', '2013-12-11 19:37:36', '1386835656'),
(4, 1, 'index_index', 'delete', 1, '1', '2013-12-11 19:37:36', '1386835656'),
(5, 1, 'index_index', 'edit', 1, '1', '2013-12-11 19:37:36', '1386835656'),
(6, 1, 'index_index', 'details', 1, '1', '2013-12-11 19:37:36', '1386835656'),
(7, 1, 'index_index', 'share', 1, '1', '2013-12-11 19:37:36', '1386835656'),
(8, 1, 'index_index', 'export', 1, '1', '2013-12-11 19:37:36', '1386835656'),
(9, 1, 'index_index', 'import', 1, '1', '2013-12-11 19:37:36', '1386835656'),
(10, 1, 'cms_site', 'null', 0, '1', '2013-12-11 19:37:43', '1386835663'),
(11, 1, 'cms_site', 'add', 0, '1', '2013-12-11 19:37:53', '1386835673'),
(12, 1, 'cms_site', 'view', 1, '1', '2013-12-11 19:37:53', '1386835673'),
(13, 1, 'cms_site', 'delete', 0, '1', '2013-12-11 19:37:53', '1386835673'),
(14, 1, 'cms_site', 'edit', 0, '1', '2013-12-11 19:37:53', '1386835673'),
(15, 1, 'cms_site', 'details', 1, '1', '2013-12-11 19:37:53', '1386835673'),
(16, 1, 'cms_site', 'share', 1, '1', '2013-12-11 19:37:53', '1386835673'),
(17, 1, 'cms_site', 'export', 0, '1', '2013-12-11 19:37:53', '1386835673'),
(18, 1, 'cms_site', 'import', 0, '1', '2013-12-11 19:37:53', '1386835673'),
(19, 1, 'cms_index', 'null', 0, '1', '2013-12-11 19:37:59', '1386835679'),
(20, 1, 'cms_index', 'add', 0, '1', '2013-12-11 19:38:05', '1386835685'),
(21, 1, 'cms_index', 'view', 1, '1', '2013-12-11 19:38:05', '1386835685'),
(22, 1, 'cms_index', 'delete', 0, '1', '2013-12-11 19:38:05', '1386835685'),
(23, 1, 'cms_index', 'edit', 0, '1', '2013-12-11 19:38:05', '1386835685'),
(24, 1, 'cms_index', 'details', 1, '1', '2013-12-11 19:38:05', '1386835685'),
(25, 1, 'cms_index', 'share', 1, '1', '2013-12-11 19:38:05', '1386835685'),
(26, 1, 'cms_index', 'export', 0, '1', '2013-12-11 19:38:05', '1386835685'),
(27, 1, 'cms_index', 'import', 0, '1', '2013-12-11 19:38:05', '1386835685'),
(28, 1, 'workflow_index', 'null', 0, '1', '2013-12-11 19:38:19', '1386835699'),
(29, 1, 'workflow_index', 'add', 1, '1', '2013-12-15 22:56:23', '1386835710'),
(30, 1, 'workflow_index', 'view', 1, '1', '2013-12-11 19:38:30', '1386835710'),
(31, 1, 'workflow_index', 'delete', 1, '1', '2013-12-15 22:56:23', '1386835710'),
(32, 1, 'workflow_index', 'edit', 1, '1', '2013-12-15 22:56:23', '1386835710'),
(33, 1, 'workflow_index', 'details', 1, '1', '2013-12-11 19:38:30', '1386835710'),
(34, 1, 'workflow_index', 'share', 1, '1', '2013-12-15 22:56:23', '1386835710'),
(35, 1, 'workflow_index', 'export', 0, '1', '2013-12-11 19:38:30', '1386835710'),
(36, 1, 'workflow_index', 'import', 0, '1', '2013-12-11 19:38:30', '1386835710'),
(37, 2, 'admin_index', 'null', 0, '1', '2013-12-11 19:39:03', '1386835743'),
(38, 2, 'admin_index', 'add', 1, '1', '2013-12-11 19:39:15', '1386835755'),
(39, 2, 'admin_index', 'view', 1, '1', '2013-12-11 19:39:15', '1386835755'),
(40, 2, 'admin_index', 'delete', 1, '1', '2013-12-11 19:39:15', '1386835755'),
(41, 2, 'admin_index', 'edit', 1, '1', '2013-12-11 19:39:15', '1386835755'),
(42, 2, 'admin_index', 'details', 1, '1', '2013-12-11 19:39:15', '1386835755'),
(43, 2, 'admin_index', 'share', 1, '1', '2013-12-11 19:39:15', '1386835755'),
(44, 2, 'admin_index', 'export', 1, '1', '2013-12-11 19:39:15', '1386835755'),
(45, 2, 'admin_index', 'import', 1, '1', '2013-12-11 19:39:15', '1386835755'),
(46, 2, 'admin_setting', 'null', 0, '1', '2013-12-11 19:39:19', '1386835759'),
(47, 2, 'admin_setting', 'add', 1, '1', '2013-12-11 19:39:25', '1386835765'),
(48, 2, 'admin_setting', 'view', 1, '1', '2013-12-11 19:39:25', '1386835765'),
(49, 2, 'admin_setting', 'delete', 1, '1', '2013-12-11 19:39:25', '1386835765'),
(50, 2, 'admin_setting', 'edit', 1, '1', '2013-12-11 19:39:25', '1386835765'),
(51, 2, 'admin_setting', 'details', 1, '1', '2013-12-11 19:39:25', '1386835766'),
(52, 2, 'admin_setting', 'share', 1, '1', '2013-12-11 19:39:25', '1386835766'),
(53, 2, 'admin_setting', 'export', 1, '1', '2013-12-11 19:39:25', '1386835766'),
(54, 2, 'admin_setting', 'import', 1, '1', '2013-12-11 19:39:25', '1386835766'),
(55, 3, 'admin_index', 'null', 0, '1', '2013-12-11 19:39:58', '1386835798'),
(56, 3, 'admin_index', 'add', 1, '1', '2013-12-11 19:40:03', '1386835803'),
(57, 3, 'admin_index', 'view', 1, '1', '2013-12-11 19:40:03', '1386835803'),
(58, 3, 'admin_index', 'delete', 1, '1', '2013-12-11 19:40:03', '1386835803'),
(59, 3, 'admin_index', 'edit', 1, '1', '2013-12-11 19:40:03', '1386835803'),
(60, 3, 'admin_index', 'details', 1, '1', '2013-12-11 19:40:03', '1386835803'),
(61, 3, 'admin_index', 'share', 1, '1', '2013-12-11 19:40:03', '1386835804'),
(62, 3, 'admin_index', 'export', 1, '1', '2013-12-11 19:40:03', '1386835804'),
(63, 3, 'admin_index', 'import', 1, '1', '2013-12-11 19:40:03', '1386835804'),
(64, 3, 'cms_index', 'null', 0, '1', '2013-12-11 19:40:07', '1386835807'),
(65, 3, 'cms_index', 'add', 1, '1', '2013-12-11 19:40:15', '1386835815'),
(66, 3, 'cms_index', 'view', 1, '1', '2013-12-11 19:40:15', '1386835815'),
(67, 3, 'cms_index', 'delete', 1, '1', '2013-12-11 19:40:15', '1386835815'),
(68, 3, 'cms_index', 'edit', 1, '1', '2013-12-11 19:40:15', '1386835815'),
(69, 3, 'cms_index', 'details', 1, '1', '2013-12-11 19:40:15', '1386835815'),
(70, 3, 'cms_index', 'share', 1, '1', '2013-12-11 19:40:15', '1386835815'),
(71, 3, 'cms_index', 'export', 1, '1', '2013-12-11 19:40:15', '1386835815'),
(72, 3, 'cms_index', 'import', 1, '1', '2013-12-11 19:40:15', '1386835815'),
(73, 3, 'cms_site', 'null', 0, '1', '2013-12-11 19:40:21', '1386835821'),
(74, 3, 'cms_site', 'add', 1, '1', '2013-12-11 19:40:28', '1386835829'),
(75, 3, 'cms_site', 'view', 1, '1', '2013-12-11 19:40:28', '1386835829'),
(76, 3, 'cms_site', 'delete', 1, '1', '2013-12-11 19:40:29', '1386835829'),
(77, 3, 'cms_site', 'edit', 1, '1', '2013-12-11 19:40:29', '1386835829'),
(78, 3, 'cms_site', 'details', 1, '1', '2013-12-11 19:40:29', '1386835829'),
(79, 3, 'cms_site', 'share', 1, '1', '2013-12-11 19:40:29', '1386835829'),
(80, 3, 'cms_site', 'export', 1, '1', '2013-12-11 19:40:29', '1386835829'),
(81, 3, 'cms_site', 'import', 1, '1', '2013-12-11 19:40:29', '1386835829'),
(82, 3, 'workflow_index', 'null', 0, '1', '2013-12-11 19:40:39', '1386835839'),
(83, 3, 'workflow_index', 'add', 1, '1', '2013-12-11 19:40:47', '1386835847'),
(84, 3, 'workflow_index', 'view', 1, '1', '2013-12-11 19:40:47', '1386835847'),
(85, 3, 'workflow_index', 'delete', 1, '1', '2013-12-11 19:40:47', '1386835847'),
(86, 3, 'workflow_index', 'edit', 1, '1', '2013-12-11 19:40:47', '1386835847'),
(87, 3, 'workflow_index', 'details', 1, '1', '2013-12-11 19:40:47', '1386835847'),
(88, 3, 'workflow_index', 'share', 1, '1', '2013-12-11 19:40:47', '1386835847'),
(89, 3, 'workflow_index', 'export', 1, '1', '2013-12-11 19:40:47', '1386835847'),
(90, 3, 'workflow_index', 'import', 1, '1', '2013-12-11 19:40:47', '1386835847'),
(91, 2, 'cms_index', 'null', 0, '1', '2013-12-15 23:33:59', '1387195437'),
(92, 2, 'cms_index', 'add', 1, '1', '2013-12-15 23:34:07', '1387195446'),
(93, 2, 'cms_index', 'view', 1, '1', '2013-12-15 23:34:07', '1387195446'),
(94, 2, 'cms_index', 'delete', 1, '1', '2013-12-15 23:34:07', '1387195446'),
(95, 2, 'cms_index', 'edit', 1, '1', '2013-12-15 23:34:07', '1387195446'),
(96, 2, 'cms_index', 'details', 1, '1', '2013-12-15 23:34:07', '1387195446'),
(97, 2, 'cms_index', 'share', 1, '1', '2013-12-15 23:34:07', '1387195446'),
(98, 2, 'cms_index', 'export', 1, '1', '2013-12-15 23:34:07', '1387195446'),
(99, 2, 'cms_index', 'import', 1, '1', '2013-12-15 23:34:07', '1387195446'),
(100, 2, 'widget_index', 'null', 0, '1', '2013-12-17 21:14:00', '1387359840'),
(101, 2, 'widget_index', 'add', 1, '1', '2013-12-17 21:14:11', '1387359851'),
(102, 2, 'widget_index', 'view', 1, '1', '2013-12-17 21:14:11', '1387359851'),
(103, 2, 'widget_index', 'delete', 1, '1', '2013-12-17 21:14:11', '1387359851'),
(104, 2, 'widget_index', 'edit', 1, '1', '2013-12-17 21:14:11', '1387359851'),
(105, 2, 'widget_index', 'details', 1, '1', '2013-12-17 21:14:11', '1387359851'),
(106, 2, 'widget_index', 'share', 1, '1', '2013-12-17 21:14:11', '1387359851'),
(107, 2, 'widget_index', 'export', 1, '1', '2013-12-17 21:14:11', '1387359851'),
(108, 2, 'widget_index', 'import', 1, '1', '2013-12-17 21:14:11', '1387359851');

-- --------------------------------------------------------

--
-- Table structure for table `sections`
--

CREATE TABLE `sections` (
  `sectionid` int(11) NOT NULL AUTO_INCREMENT,
  `formid` int(11) DEFAULT NULL,
  `formposition` int(11) DEFAULT NULL,
  `displayname` varchar(234) DEFAULT NULL,
  `sla` int(11) DEFAULT NULL,
  `sla_email` varchar(230) DEFAULT NULL,
  `userselect` int(1) DEFAULT NULL,
  `lastmodified` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `approval` int(1) DEFAULT NULL,
  PRIMARY KEY (`sectionid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=18 ;

--
-- Dumping data for table `sections`
--

INSERT INTO `sections` VALUES
(1, 1, 1, 'Supervisor', 24, '', 1, '[[regtime]]', 1),
(2, 1, 2, 'HR', 72, '', 0, '[[regtime]]', 1),
(3, 2, 1, 'Manager', 24, '', 1, '[[regtime]]', 1),
(4, 2, 2, 'Finance (Cost Implications)', 24, '', 0, '[[regtime]]', 1),
(5, 3, 1, 'Manager', 24, '', 1, '[[regtime]]', 1),
(6, 3, 2, 'Section 3', 72, '', 0, '[[regtime]]', 1),
(7, 5, 1, 'Supervisor', 24, '', 1, '[[regtime]]', 1),
(8, 5, 2, 'Finance', 72, '', 0, '[[regtime]]', 1),
(9, 4, 1, 'Manager', 24, '', 1, '[[regtime]]', 1),
(10, 4, 2, 'Finance', 24, '', 0, '[[regtime]]', 1),
(11, 6, 1, 'Manager', 24, '', 1, '[[regtime]]', 1),
(12, 7, 1, 'Supervisor', 24, '', 1, '[[regtime]]', 1),
(13, 7, 2, 'Finance', 48, '', 0, '[[regtime]]', 1),
(14, 8, 1, 'Supervisor', 24, '', 0, '[[regtime]]', 1),
(15, 9, 1, 'Second Step', 24, '', 1, '[[regtime]]', 0),
(16, 9, 2, 'Third Section', 24, '', 0, '[[regtime]]', 0),
(17, 1, 3, 'CEO', 24, '', 0, '[[regtime]]', 1);

-- --------------------------------------------------------

--
-- Table structure for table `secure_codes`
--

CREATE TABLE `secure_codes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `activity_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `secure_code` varchar(255) DEFAULT NULL,
  `date_created` char(15) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `shared_categorys`
--

CREATE TABLE `shared_categorys` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `sharer_id` int(10) unsigned NOT NULL COMMENT 'user that assigned the category to the user',
  `date_created` char(20) DEFAULT NULL,
  `active` tinyint(1) unsigned DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `shared_contents`
--

CREATE TABLE `shared_contents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `content_id` int(10) unsigned NOT NULL DEFAULT '0',
  `sharer_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'this is not the owner of the content, but the user sharing the content',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `date_created` char(15) NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `sites`
--

CREATE TABLE `sites` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `description` text,
  `welcome_page_id` int(11) DEFAULT '0',
  `resource_folder_id` int(11) DEFAULT '0',
  `date_created` char(15) DEFAULT NULL,
  `active` tinyint(1) DEFAULT NULL,
  `publish` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `site_admins`
--

CREATE TABLE `site_admins` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `site_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `active` tinyint(4) DEFAULT NULL,
  `date_created` char(15) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `site_categorys`
--

CREATE TABLE `site_categorys` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `site_id` int(10) unsigned NOT NULL,
  `category_id` int(10) unsigned NOT NULL,
  `active` tinyint(4) DEFAULT NULL,
  `date_created` char(15) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `site_contents`
--

CREATE TABLE `site_contents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `site_id` int(10) unsigned NOT NULL,
  `content_id` int(10) unsigned NOT NULL,
  `active` tinyint(4) DEFAULT NULL,
  `date_created` char(15) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `site_links`
--

CREATE TABLE `site_links` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `site_id` int(11) NOT NULL,
  `link_id` int(11) NOT NULL,
  `date_created` char(15) DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `site_pages`
--

CREATE TABLE `site_pages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `site_id` int(10) unsigned NOT NULL,
  `page_id` int(10) unsigned NOT NULL,
  `active` tinyint(4) DEFAULT NULL,
  `date_created` char(15) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `state_fields`
--

CREATE TABLE `state_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `state_id` int(10) unsigned DEFAULT NULL COMMENT 'remember that the state id is binded to the process id',
  `field_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 CHECKSUM=1 AUTO_INCREMENT=88 ;

--
-- Dumping data for table `state_fields`
--

INSERT INTO `state_fields` VALUES
(1, 1, 'type'),
(2, 1, 'number'),
(3, 1, 'start'),
(4, 1, 'end'),
(5, 1, 'contact'),
(6, 1, 'contact_address'),
(7, 1, 'notes'),
(8, 2, 'signature'),
(9, 3, 'signature_2'),
(10, 6, 'signature_2'),
(11, 5, 'signature'),
(12, 4, 'notes'),
(13, 4, 'preferences'),
(14, 4, 'means'),
(15, 4, 'arrival_time'),
(16, 4, 'arrival'),
(17, 4, 'departure_time'),
(18, 4, 'departure'),
(19, 4, 'destination'),
(20, 4, 'purpose'),
(21, 4, 'type'),
(22, 4, 'department'),
(23, 4, 'name'),
(24, 7, 'item'),
(25, 7, 'specifications'),
(26, 7, 'purpose'),
(27, 7, 'quantity'),
(28, 7, 'price'),
(29, 7, 'required'),
(30, 7, 'suggested'),
(31, 7, 'notes'),
(32, 8, 'signature'),
(33, 9, 'signature_2'),
(34, 10, 'amount'),
(35, 10, 'purpose'),
(36, 10, 'date'),
(37, 10, 'date_to'),
(38, 11, 'signature'),
(39, 12, 'signature_2'),
(40, 12, 'amount_issued'),
(41, 12, 'date_issued'),
(42, 13, 'item'),
(43, 13, 'description'),
(44, 13, 'quantity'),
(45, 14, 'signature'),
(46, 15, 'signature_2'),
(47, 15, 'quantity_issued'),
(48, 15, 'date'),
(49, 16, 'room'),
(50, 16, 'purpose'),
(51, 16, 'date'),
(52, 16, 'time'),
(53, 16, 'duration'),
(54, 16, 'recurring'),
(55, 16, 'additional'),
(56, 17, 'signature'),
(57, 18, 'amount'),
(58, 18, 'description'),
(59, 18, 'account'),
(60, 19, 'signature'),
(61, 20, 'signature_2'),
(62, 20, 'amount_approved'),
(63, 20, 'date'),
(64, 21, 'date'),
(65, 22, 'alternative'),
(66, 0, 'signature'),
(67, 0, 'signature'),
(68, 0, 'signature'),
(69, 21, 'name'),
(70, 23, 'finance'),
(71, 24, 'official'),
(72, 24, 'visitor_type'),
(73, 24, 'visitor'),
(74, 0, 'signature'),
(75, 0, 'signature'),
(76, 0, 'signature'),
(77, 0, 'signature'),
(78, 0, 'signature'),
(79, 0, 'signature'),
(80, 0, 'signature'),
(81, 0, 'signature'),
(82, 0, 'signature'),
(83, 0, 'signature'),
(84, 6, 'accommodation'),
(85, 6, 'flight'),
(86, 6, 'road'),
(87, 6, 'other');

-- --------------------------------------------------------

--
-- Table structure for table `status_messages`
--

CREATE TABLE `status_messages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `message` varchar(255) NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `content_id` int(10) unsigned NOT NULL DEFAULT '0',
  `group_id` int(10) unsigned NOT NULL DEFAULT '0',
  `date_created` char(15) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tags`
--

CREATE TABLE `tags` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `date_created` char(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `tasks`
--

CREATE TABLE `tasks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` char(20) DEFAULT NULL COMMENT 'some application defined types',
  `creator_user_id` int(10) unsigned DEFAULT '0',
  `creator_group_id` int(10) unsigned DEFAULT '0',
  `title` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `duration` int(10) unsigned DEFAULT NULL COMMENT 'number of hours. 24hrs = 1day',
  `start_time` char(15) DEFAULT NULL COMMENT 'unix timestamp ',
  `end_time` char(15) DEFAULT NULL COMMENT 'unix timestamp ',
  `complete_time` char(15) DEFAULT NULL COMMENT 'unix timestamp',
  `alert_type` smallint(20) DEFAULT '1' COMMENT '0, no alert. 1 notification and email, 2 ...i think this should be based on priority',
  `priority` smallint(20) DEFAULT '2' COMMENT '2 means normal priority, 1 is low priority',
  `is_transferable` tinyint(3) unsigned DEFAULT '1',
  `date_created` char(15) DEFAULT NULL COMMENT 'this will typically be the same as start time.',
  `last_updated` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `active` tinyint(3) unsigned DEFAULT '1',
  `status` tinyint(3) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `task_content`
--

CREATE TABLE `task_content` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `task_id` int(10) unsigned NOT NULL,
  `content_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL COMMENT 'user who attached content to task, this should either be the task creator or task doer, but not necessarily the content creator',
  `date_created` char(15) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `task_groups`
--

CREATE TABLE `task_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `task_id` int(10) unsigned DEFAULT NULL,
  `group_id` int(10) unsigned DEFAULT NULL,
  `date_created` char(15) DEFAULT NULL,
  `active` tinyint(3) unsigned DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `task_helpdesk`
--

CREATE TABLE `task_helpdesk` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `task_id` int(10) unsigned NOT NULL,
  `request_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `date_created` char(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `task_opportunity`
--

CREATE TABLE `task_opportunity` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `task_id` int(10) unsigned NOT NULL,
  `opportunity_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `date_created` char(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `task_proxy`
--

CREATE TABLE `task_proxy` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `task_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `proxy_id` int(10) unsigned NOT NULL,
  `out_of_office_id` int(10) unsigned NOT NULL,
  `date_created` char(15) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `task_transfer`
--

CREATE TABLE `task_transfer` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `task_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL COMMENT 'the person that did the transfer',
  `from_user_id` int(10) unsigned NOT NULL,
  `to_user_id` int(10) unsigned NOT NULL,
  `reason` varchar(255) DEFAULT NULL,
  `date_created` char(15) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `task_users`
--

CREATE TABLE `task_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `task_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `date_created` char(15) NOT NULL,
  `is_proxy` tinyint(3) unsigned DEFAULT '0',
  `is_transfer` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `is_active` tinyint(3) DEFAULT '0' COMMENT 'the user actively handling the task. Others are spectators',
  `active` tinyint(3) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `team_templates`
--

CREATE TABLE `team_templates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `description` text,
  `date_created` char(20) DEFAULT NULL,
  `active` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `team_templates`
--

INSERT INTO `team_templates` VALUES
(1, 'Sample Project', '', '1288559360', 0);

-- --------------------------------------------------------

--
-- Table structure for table `team_templates_data`
--

CREATE TABLE `team_templates_data` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `template_id` int(11) DEFAULT NULL,
  `appid` varchar(10) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `date_created` char(20) DEFAULT NULL,
  `active` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

--
-- Dumping data for table `team_templates_data`
--

INSERT INTO `team_templates_data` VALUES
(1, 1, 'task', 'Clarify Business Goals', 2, '1288559360', 1),
(2, 1, 'task', 'Prepare Project Charter', 3, '1288559360', 1),
(3, 1, 'cms', 'Contracts', 1, '1288559360', 1),
(4, 1, 'cms', 'Presentations', 1, '1288559360', 1),
(5, 1, 'cms', 'Status Reports', 1, '1288559360', 1),
(6, 1, 'task', 'Source for Consultants', 4, '1288559360', 1);

-- --------------------------------------------------------

--
-- Table structure for table `user_activities`
--

CREATE TABLE `user_activities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0',
  `type` smallint(5) unsigned DEFAULT NULL,
  `activity_id` int(10) unsigned NOT NULL DEFAULT '0',
  `url` varchar(255) DEFAULT NULL,
  `subject_id` int(11) NOT NULL DEFAULT '0',
  `date_created` char(15) NOT NULL,
  `active` tinyint(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `user_comments`
--

CREATE TABLE `user_comments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `appid` varchar(255) NOT NULL DEFAULT '0' COMMENT 'this is not the actual activity id, but the autoincrement id of the activities table',
  `item_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'a comment is either binded to an activity or a content',
  `message` text NOT NULL,
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'id of user who made the comment',
  `date_created` char(15) NOT NULL,
  `active` tinyint(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `user_details`
--

CREATE TABLE `user_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `boss_id` int(11) DEFAULT '0',
  `email` varchar(255) NOT NULL,
  `username` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `first_name` varchar(255) DEFAULT NULL,
  `last_name` varchar(255) DEFAULT NULL,
  `work_phone` char(20) DEFAULT NULL,
  `mobile_phone` char(20) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `birth_day` smallint(10) unsigned DEFAULT NULL,
  `birth_month` smallint(10) unsigned DEFAULT NULL,
  `birth_year` smallint(5) unsigned DEFAULT NULL,
  `gender` char(7) DEFAULT NULL,
  `location_id` int(11) NOT NULL DEFAULT '0',
  `job_title` varchar(255) DEFAULT NULL,
  `company` varchar(255) DEFAULT NULL,
  `department_id` int(10) unsigned NOT NULL DEFAULT '0',
  `job_description` text,
  `skills` text,
  `website` varchar(255) DEFAULT NULL,
  `profile_picture_id` int(10) unsigned DEFAULT '0',
  `percentage_complete` int(10) unsigned NOT NULL DEFAULT '0',
  `date_created` char(15) DEFAULT NULL,
  `last_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `active` tinyint(3) NOT NULL DEFAULT '1',
  `out_of_office` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `is_external` tinyint(3) DEFAULT '0',
  `last_seen` char(15) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- Dumping data for table `user_details`
--

INSERT INTO `user_details` VALUES
(1, 1, 0, '[[admin_email]]', 'admin', '[[admin_pass]]', '[[admin_fname]]', '[[admin_lname]]', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, NULL, 0, NULL, NULL, NULL, 0, 0, '[[timestamp]]', '[[regtime]]', 1, 0, 0, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `user_emails`
--

CREATE TABLE `user_emails` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `server` varchar(255) DEFAULT NULL,
  `port` char(10) DEFAULT NULL,
  `ssl` char(4) DEFAULT NULL,
  `date_created` char(15) DEFAULT NULL,
  `active` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `user_events`
--

CREATE TABLE `user_events` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `event_id` int(10) unsigned NOT NULL,
  `user_id` int(11) DEFAULT NULL COMMENT 'user who invited. usually the owner of the event',
  `invitee_id` int(10) unsigned NOT NULL COMMENT 'user who is invited',
  `date_created` char(15) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `user_groups`
--

CREATE TABLE `user_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `group_id` int(10) unsigned DEFAULT NULL,
  `date_created` char(15) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

--
-- Dumping data for table `user_groups`
--

INSERT INTO `user_groups` VALUES
(1, 1, 1, '1386835440'),
(2, 1, 2, '1386835440'),
(3, 1, 3, '1386835440');

-- --------------------------------------------------------

--
-- Table structure for table `user_processes`
--

CREATE TABLE `user_processes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `process_id` int(10) unsigned NOT NULL,
  `state_id` int(10) unsigned NOT NULL,
  `form_id` int(10) unsigned NOT NULL,
  `task_id` int(10) unsigned NOT NULL,
  `date_created` char(15) NOT NULL,
  `completed` tinyint(4) NOT NULL DEFAULT '0',
  `rejected` tinyint(4) NOT NULL DEFAULT '0',
  `active` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `user_process_history`
--

CREATE TABLE `user_process_history` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_process_id` int(10) unsigned DEFAULT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `type` tinyint(3) unsigned DEFAULT NULL,
  `old_value` text,
  `new_value` text,
  `date_created` char(15) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `user_process_reject`
--

CREATE TABLE `user_process_reject` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `user_process_id` int(10) unsigned NOT NULL,
  `comment` text NOT NULL,
  `date_created` char(15) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `user_ratings`
--

CREATE TABLE `user_ratings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `score` tinyint(3) NOT NULL DEFAULT '0',
  `user_id` int(10) unsigned NOT NULL,
  `type` char(30) NOT NULL DEFAULT 'LINK' COMMENT 'share the same type as user_tags',
  `item_id` int(10) unsigned NOT NULL COMMENT 'id of whatever item is being tagged',
  `date_created` char(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `user_search`
--

CREATE TABLE `user_search` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `query` varchar(255) DEFAULT NULL,
  `hit_count` int(10) unsigned NOT NULL DEFAULT '0',
  `date_created` char(15) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `user_settings`
--

CREATE TABLE `user_settings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `locale` char(10) NOT NULL DEFAULT 'en_GB',
  `widgets` text NOT NULL,
  `blocked_users` text NOT NULL,
  `last_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `date_created` char(15) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `user_tags`
--

CREATE TABLE `user_tags` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tag_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `type` char(30) NOT NULL DEFAULT 'LINK',
  `item_id` int(10) unsigned NOT NULL COMMENT 'id of whatever item is being tagged',
  `date_created` char(20) DEFAULT NULL,
  `active` tinyint(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `votes_users`
--

CREATE TABLE `votes_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `poll_id` int(11) unsigned DEFAULT NULL,
  `poll_option_id` int(11) unsigned DEFAULT NULL,
  `user_id` int(11) unsigned DEFAULT NULL,
  `date_created` char(15) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `wf_cash_advance_form`
--

CREATE TABLE `wf_cash_advance_form` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `amount` varchar(255) DEFAULT NULL,
  `purpose` text,
  `date` varchar(255) DEFAULT NULL,
  `date_to` varchar(255) DEFAULT NULL,
  `signature` varchar(255) DEFAULT NULL,
  `signature_2` varchar(255) DEFAULT NULL,
  `amount_issued` varchar(255) DEFAULT NULL,
  `date_issued` varchar(255) DEFAULT NULL,
  `date_created` char(15) DEFAULT NULL,
  `last_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `wf_cash_reimbursement_request`
--

CREATE TABLE `wf_cash_reimbursement_request` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `amount` varchar(255) DEFAULT NULL,
  `description` text,
  `account` varchar(255) DEFAULT NULL,
  `signature` varchar(255) DEFAULT NULL,
  `signature_2` varchar(255) DEFAULT NULL,
  `amount_approved` varchar(255) DEFAULT NULL,
  `date` varchar(255) DEFAULT NULL,
  `date_created` char(15) DEFAULT NULL,
  `last_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `wf_leave_request_form`
--

CREATE TABLE `wf_leave_request_form` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `type` varchar(255) DEFAULT NULL,
  `number` varchar(255) DEFAULT NULL,
  `start` varchar(255) DEFAULT NULL,
  `end` varchar(255) DEFAULT NULL,
  `contact` varchar(255) DEFAULT NULL,
  `contact_address` text,
  `notes` text,
  `signature` varchar(255) DEFAULT NULL,
  `signature_2` varchar(255) DEFAULT NULL,
  `date_created` char(15) DEFAULT NULL,
  `last_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `wf_materials_requisition_form`
--

CREATE TABLE `wf_materials_requisition_form` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `description` text,
  `quantity` varchar(255) DEFAULT NULL,
  `signature` varchar(255) DEFAULT NULL,
  `signature_2` varchar(255) DEFAULT NULL,
  `quantity_issued` varchar(255) DEFAULT NULL,
  `date` varchar(255) DEFAULT NULL,
  `date_created` char(15) DEFAULT NULL,
  `last_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `wf_meeting_room_request`
--

CREATE TABLE `wf_meeting_room_request` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `room` varchar(255) DEFAULT NULL,
  `purpose` text,
  `date` varchar(255) DEFAULT NULL,
  `time` varchar(255) DEFAULT NULL,
  `duration` varchar(255) DEFAULT NULL,
  `recurring` varchar(255) DEFAULT NULL,
  `additional` text,
  `signature` varchar(255) DEFAULT NULL,
  `date_created` char(15) DEFAULT NULL,
  `last_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `wf_purchase_request_form`
--

CREATE TABLE `wf_purchase_request_form` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `specifications` text,
  `purpose` text,
  `quantity` varchar(255) DEFAULT NULL,
  `price` varchar(255) DEFAULT NULL,
  `required` varchar(255) DEFAULT NULL,
  `suggested` text,
  `notes` text,
  `signature` varchar(255) DEFAULT NULL,
  `signature_2` varchar(255) DEFAULT NULL,
  `date_created` char(15) DEFAULT NULL,
  `last_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `wf_test_no_approval`
--

CREATE TABLE `wf_test_no_approval` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `date` varchar(255) DEFAULT NULL,
  `alternative` varchar(255) DEFAULT NULL,
  `signature` varchar(255) DEFAULT NULL,
  `finance` varchar(255) DEFAULT NULL,
  `date_created` char(15) DEFAULT NULL,
  `last_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `wf_travel_request_form`
--

CREATE TABLE `wf_travel_request_form` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `department` varchar(255) DEFAULT NULL,
  `type` varchar(255) DEFAULT NULL,
  `purpose` text,
  `destination` varchar(255) DEFAULT NULL,
  `departure` varchar(255) DEFAULT NULL,
  `departure_time` varchar(255) DEFAULT NULL,
  `arrival` varchar(255) DEFAULT NULL,
  `arrival_time` varchar(255) DEFAULT NULL,
  `means` varchar(255) DEFAULT NULL,
  `preferences` varchar(255) DEFAULT NULL,
  `notes` text,
  `signature` varchar(255) DEFAULT NULL,
  `signature_2` varchar(255) DEFAULT NULL,
  `accommodation` varchar(255) DEFAULT NULL,
  `flight` varchar(255) DEFAULT NULL,
  `road` varchar(255) DEFAULT NULL,
  `other` varchar(255) DEFAULT NULL,
  `date_created` char(15) DEFAULT NULL,
  `last_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `wf_visitors_form`
--

CREATE TABLE `wf_visitors_form` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `visitor` varchar(255) DEFAULT NULL,
  `visitor_type` varchar(255) DEFAULT NULL,
  `official` varchar(255) DEFAULT NULL,
  `signature` varchar(255) DEFAULT NULL,
  `date_created` char(15) DEFAULT NULL,
  `last_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `wgt_precuriotweet`
--

CREATE TABLE `wgt_precuriotweet` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `username` varchar(255) DEFAULT NULL,
  `twitter_user_id` int(10) unsigned DEFAULT NULL,
  `token` text,
  `date_created` char(15) DEFAULT NULL,
  `last_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `wgt_stock_ticker`
--

CREATE TABLE `wgt_stock_ticker` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `stock_symbol` char(15) DEFAULT NULL,
  `stock_name` varchar(255) DEFAULT NULL,
  `date_created` char(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `workflow`
--

CREATE TABLE `workflow` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_builder_formid` int(10) unsigned NOT NULL DEFAULT '0',
  `process` varchar(255) DEFAULT NULL COMMENT 'name of the process',
  `display_name` varchar(255) DEFAULT NULL,
  `code` char(20) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `department_id` int(255) unsigned NOT NULL DEFAULT '0' COMMENT 'this does not affect approval or request access. it is strictly for color coding.',
  `title_field` varchar(255) DEFAULT NULL,
  `date_created` char(15) NOT NULL,
  `active` tinyint(3) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=10 ;

--
-- Dumping data for table `workflow`
--

INSERT INTO `workflow` VALUES
(1, 1, 'leave_request_form', 'Leave Request Form', 'LRF', 'to be filled by employee when applying for leave', 0, 'type', '1288559360', 1),
(2, 2, 'travel_request_form', 'Travel Request Form', 'TRF', '', 0, '', '1387663770', 1),
(3, 3, 'purchase_request_form', 'Purchase Request Form', 'PRF', 'To be filled by employee when requesting the purchase of an item', 0, 'item', '1288559402', 0),
(4, 4, 'cash_advance_form', 'Cash Advance Form', 'CAF', '', 0, '', '1288559410', 0),
(5, 5, 'materials_requisition_form', 'Materials Requisition Form', 'MRF', 'to be filled by employee when requesting materials such as papers, ink etc', 0, '', '1288559419', 0),
(6, 6, 'meeting_room_request', 'Meeting Room Request', 'MRR', '', 0, '', '1288559428', 0),
(7, 7, 'cash_reimbursement_request', 'Cash Reimbursement Request', 'CRR', 'to be filled by employees requesting reimbursement of personal cash spent on official expenses', 0, '', '1288559443', 1),
(8, 9, 'test_no_approval', 'Test No Approval', 'TNA', '', 0, '', '1315377818', 0),
(9, 10, 'visitors_form', 'Visitors Form', 'VF', 'Forms for visitors to fill', 0, '', '1386166316', 0);

-- --------------------------------------------------------

--
-- Table structure for table `workflow_approval_access`
--

CREATE TABLE `workflow_approval_access` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `process_id` int(10) unsigned DEFAULT NULL,
  `state_id` int(10) unsigned DEFAULT NULL,
  `user_id` int(10) unsigned DEFAULT NULL COMMENT 'user id of person approving or rejecting',
  `group_id` int(11) DEFAULT NULL COMMENT 'approvals may also be tied to groups',
  `date_created` char(15) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `workflow_observers`
--

CREATE TABLE `workflow_observers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `process_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `group_id` int(10) unsigned NOT NULL,
  `date_created` char(15) DEFAULT NULL,
  `active` tinyint(1) unsigned DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `workflow_request_access`
--

CREATE TABLE `workflow_request_access` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `process_id` int(10) unsigned DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `group_id` int(10) unsigned DEFAULT NULL,
  `start_position` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'this determines at which state to start the process, default is state 0',
  `date_created` char(15) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Table structure for table `workflow_states`
--

CREATE TABLE `workflow_states` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'state_id',
  `form_builder_sectionid` int(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL COMMENT 'still cant remember what to use this for, may become useful later in dev.',
  `display_name` varchar(255) DEFAULT NULL COMMENT 'the name of the state. shows up as the label for the state.',
  `process_id` int(10) unsigned NOT NULL COMMENT 'process id , from workflow table',
  `position` int(10) unsigned NOT NULL DEFAULT '0',
  `duration` int(10) unsigned NOT NULL DEFAULT '24' COMMENT 'number of hours a process should spend in this state',
  `sla_email` varchar(255) NOT NULL,
  `departmental` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `locational` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `allow_approver_change` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `is_approval` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `use_supervisor` tinyint(3) NOT NULL DEFAULT '0',
  `include_form_in_notification` tinyint(3) NOT NULL DEFAULT '0',
  `date_created` char(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=27 ;

--
-- Dumping data for table `workflow_states`
--

INSERT INTO `workflow_states` VALUES
(1, 0, 'section_1', 'Section 1', 1, 0, 24, '', 0, 0, 0, 0, 0, 0, '1288559349'),
(2, 1, 'supervisor', 'Supervisor', 1, 1, 24, '', 0, 0, 1, 1, 1, 0, '1288559360'),
(3, 2, 'hr', 'HR', 1, 2, 72, '', 0, 0, 0, 1, 0, 0, '1288559360'),
(4, 0, 'section_1', 'Section 1', 2, 0, 24, '', 0, 0, 0, 0, 0, 0, '1288559392'),
(5, 3, 'manager', 'Manager', 2, 1, 24, '', 0, 0, 1, 1, 1, 0, '1387663770'),
(6, 4, 'finance_cost_implications', 'Finance (Cost Implications)', 2, 2, 24, '', 0, 0, 0, 1, 0, 0, '1387663771'),
(7, 0, 'section_1', 'Section 1', 3, 0, 24, '', 0, 0, 0, 0, 0, 0, '1288559401'),
(8, 5, 'manager', 'Manager', 3, 1, 24, '', 0, 0, 1, 1, 0, 0, '1288559402'),
(9, 6, 'section', 'Section 3', 3, 2, 72, '', 0, 0, 0, 1, 0, 0, '1288559402'),
(10, 0, 'section_1', 'Section 1', 4, 0, 24, '', 0, 0, 0, 0, 0, 0, '1288559410'),
(11, 7, 'manager', 'Manager', 4, 1, 24, '', 0, 0, 1, 1, 0, 0, '1288559410'),
(12, 8, 'finance', 'Finance', 4, 2, 24, '', 0, 0, 0, 1, 0, 0, '1288559410'),
(13, 0, 'section_1', 'Section 1', 5, 0, 24, '', 0, 0, 0, 0, 0, 0, '1288559418'),
(14, 9, 'supervisor', 'Supervisor', 5, 1, 24, '', 0, 0, 1, 1, 0, 0, '1288559419'),
(15, 10, 'finance', 'Finance', 5, 2, 72, '', 0, 0, 0, 1, 0, 0, '1288559419'),
(16, 0, 'section_1', 'Section 1', 6, 0, 24, '', 0, 0, 0, 0, 0, 0, '1288559427'),
(17, 11, 'manager', 'Manager', 6, 1, 24, '', 0, 0, 1, 1, 0, 0, '1288559428'),
(18, 0, 'section_1', 'Section 1', 7, 0, 24, '', 0, 0, 0, 0, 0, 0, '1288559442'),
(19, 12, 'supervisor', 'Supervisor', 7, 1, 24, '', 0, 0, 1, 1, 0, 0, '1288559443'),
(20, 13, 'finance', 'Finance', 7, 2, 48, '', 0, 0, 0, 1, 0, 0, '1288559443'),
(21, 0, 'section_1', 'Section 1', 9, 0, 24, '', 1, 0, 0, 0, 0, 0, '1315377807'),
(22, 15, 'second_step', 'Second Step', 9, 1, 24, '', 1, 0, 1, 0, 0, 0, '1315377818'),
(23, 16, 'third_section', 'Third Section', 9, 2, 24, '', 1, 0, 0, 0, 0, 0, '1315377818'),
(24, 0, 'section_1', 'Section 1', 8, 0, 24, '', 1, 0, 0, 0, 0, 0, '1386150821'),
(25, 14, 'supervisor', 'Supervisor', 8, 1, 24, '', 0, 0, 1, 1, 0, 0, '1386150821'),
(26, 17, 'ceo', 'CEO', 1, 3, 24, '', 0, 0, 0, 1, 0, 0, '1386150821');

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
