<?php
require_once 'functions.php';
$db = getDb();
$tr = getTranslator((empty($_GET['locale']) ? 'en' :$_GET['locale'] ));

$showPassed = true;//set to true if you want to display requirments that were ok. Default is false
$failedCount = 0;
?>
<div class="panels">
	<table>
		<tr>
			<th><?php echo $tr->translate('Requirement');?></th>
			<th width="30%"><?php echo $tr->translate('Your Server');?></th>
			<th width="30%"><?php echo $tr->translate('Recommended');?></th>
			<th width="10%"><?php echo $tr->translate('Status');?></th>
		</tr>
		<!-- Apache Version -->
		<?php $check = checkApacheVersion();
		if($check->getStatus() == false)$failedCount++;
		if($showPassed || $check->getStatus() == false):?>
		<tr title = "<?php echo $check->getMessage();?>">
			<td>
				<div class="sub"><?php echo $tr->translate("Apache Server");?></div>
			</td>
			<td><?php echo getLocalizedString("version {1}",$check->getValue());?></td>
			<td><?php echo $tr->translate("version 2.2.x");?></td>
			<td><img src="css/images/<?php echo $check->getIcon();?>" /></td>
		</tr>

		<?php endif;?>

		<!-- Rewrite Module -->
		<?php $check = checkModRewrite();
		if($check->getStatus() == false)$failedCount++;
		if($showPassed || $check->getStatus() == false):?>
		<tr title = "<?php echo $check->getMessage();?>">
			<td>
				<div class="sub"><?php echo $tr->translate("Apache Rewrite Module");?></div>
			</td>
			<td><?php echo $check->getValue();?></td>
			<td><?php echo $tr->translate("enabled");?></td>
			<td><img src="css/images/<?php echo $check->getIcon();?>" /></td>
		</tr>
		<?php endif;?>

		<!-- PHP version -->
		<?php $check = checkPHPVersion();
		if($check->getStatus() == false)$failedCount++;
		if($showPassed || $check->getStatus() == false):?>
		<tr title = "<?php echo $check->getMessage();?>">
			<td>
				<div class="sub"><?php echo $tr->translate("PHP");?></div>
			</td>
			<td><?php echo getLocalizedString("version {1}",$check->getValue());?></td>
			<td><?php echo $tr->translate("version 5.3.x");?></td>
			<td><img src="css/images/<?php echo $check->getIcon();?>" /></td>
		</tr>
		<?php endif;?>

		<!-- curl extension -->
		<?php $check = checkCurl();
		if($check->getStatus() == false)$failedCount++;
		if($showPassed || $check->getStatus() == false):?>
		<tr title = "<?php echo $check->getMessage();?>">
			<td>
				<div class="sub"><?php echo $tr->translate("PHP cURL Extension");?></div>
			</td>
			<td><?php echo $check->getValue();?></td>
			<td><?php echo $tr->translate("enabled");?></td>
			<td><img src="css/images/<?php echo $check->getIcon();?>" /></td>
		</tr>
		<?php endif;?>

		<!-- GD extension -->
		<?php $check = checkGD();
		if($check->getStatus() == false)$failedCount++;
		if($showPassed || $check->getStatus() == false):?>
		<tr title = "<?php echo $check->getMessage();?>">
			<td>
				<div class="sub"><?php echo $tr->translate("PHP GD Extension");?></div>
			</td>
			<td><?php echo $check->getValue();?></td>
			<td><?php echo $tr->translate("enabled");?></td>
			<td><img src="css/images/<?php echo $check->getIcon();?>" /></td>
		</tr>
		<?php endif;?>

		<!-- Database Driver -->
		<?php $check = checkMysQL();
		if($check->getStatus() == false)$failedCount++;
		if($showPassed || $check->getStatus() == false):?>
		<tr title = "<?php echo $check->getMessage();?>">
			<td>
				<div class="sub"><?php echo $tr->translate("MySQL Driver (PDO)");?></div>
			</td>
			<td><?php echo $check->getValue();?></td>
			<td><?php echo $tr->translate("enabled");?></td>
			<td><img src="css/images/<?php echo $check->getIcon();?>" /></td>
		</tr>
		<?php endif;?>
<!--
		There is currently no way to do this without first connecting to the database,
		and we don't have connection parameters yet
		Database Version
		<?php //$check = checkMysQLVersion();
		if($showPassed || $check->getStatus() == false):?>
		<tr title = "<?php echo $check->getMessage();?>">
			<td>
				<div class="sub"><?php echo $tr->translate("MySQL Server");?></div>
			</td>
			<td><?php echo getLocalizedString("version {1}",$check->getValue());?></td>
			<td><?php echo $tr->translate("version 5.1 or newer");?></td>
			<td><img src="css/images/<?php echo $check->getIcon();?>" /></td>
		</tr>
		<?php endif;?>
 -->
		<!-- ionCube Loader -->
		<?php $check = checkIoncube();
		if($check->getStatus() == false)$failedCount++;
		if($showPassed || $check->getStatus() == false):?>
		<tr title = "<?php echo $check->getMessage();?>">
			<td>
			<?php if($check->getStatus()):?>
				<div class="sub"><?php echo $tr->translate("ionCube Loader");?></div>
			<?php else:?>
				<div class="sub"><a href="ioncube/loader-wizard.php" target="_blank"><?php echo $tr->translate("ionCube Loader");?></a></div>
			<?php endif;?>
			</td>
			<td><?php echo $check->getValue();?></td>
			<td><?php echo $tr->translate("installed");?></td>
			<td><img src="css/images/<?php echo $check->getIcon();?>" /></td>
		</tr>
		<?php endif;?>

	</table>

</div>
<?php if($failedCount):?>
<div class="headtext"><?php echo $tr->translate("We are sorry, you cannot proceed with the
	installation yet as your server still needs additional configuration. Please consult the installation guide.");?></div>

<div class="bottombelle">
	<a href="" class="btn"> <?php echo $tr->translate("Check Server Again");?></a>
</div>
<?php else:?>
<form action="start.php" method="get">
<input type="hidden" name="step" value="1"/>
<div class="headtext">
	<?php echo $tr->translate("Your server is properly configured for Precurio.");?>
</div>
<div class="bottombelle">
	<input type="submit" class="btn" value="<?php echo $tr->translate("Proceed with Installation");?>"/>
</div>
</form>
<?php endif;?>