<?php require_once 'header.php';?>
<?php
//this are the installation steps. Each step corresponds to a page
$steps = array("requirements","database","admin","settings");

$step = isset($_GET['step']) ? $_GET['step']  : 0;

if(isset($_SESSION['ldap']) && $_SESSION['ldap'])//this variable is set at the first step if the user selects LDAP as Authentication Mode
	$steps[2] = "ldap";


//check if previous step has been completed.
if($step > 1)//only check if it is not the first step
{
	if(!isset($_SESSION[$steps[$step-1]]))//user trying to skip ahead. take user back to begining
	{
		$step = 0;
	}
}

$currentStep = $steps[$step];
$nextStep = false;
if($step < (count($steps)))
	$nextStep = (isset($steps[$step+1]) ? $steps[$step+1] : '');

?>
<body>
	<!-- Prompt IE 6 users to install Chrome Frame. Remove this if you support IE 6.
       chromium.org/developers/how-tos/chrome-frame-getting-started -->
	<!--[if lt IE 7]><p class=chromeframe>Unfortunately, your browser is not  <em>supported.</em> <a href="http://browsehappy.com/">Upgrade to a different browser</a> or <a href="http://www.google.com/chromeframe/?redirect=true">install Google Chrome Frame</a> to experience this site.</p><![endif]-->

	<?php require_once 'logo.php';?>
    <div class="container">
		<?php require_once 'top.php';?>
		<div id="mainContent">
			<?php require_once (($currentStep.".php"));?>
		</div>
		<div class="bottombelle">
			<?php if($step > 0):?>
			<a href="start.php?step=<?php echo ($step - 1)?>" class=" btn btn-sm btn-warning"><?php echo $tr->translate("Back");?></a>
			<?php endif;?>
			<?php if($nextStep):?>
			<a id="btnNext" href="start.php?step=<?php echo ($step + 1)?>" class="btn"><?php echo $tr->translate("Next");?></a>
			<?php else:?>
			<a id= "btnNext" href="finish.php" class="btn"><?php echo $tr->translate("Finish");?></a>
			<?php endif;?>
		</div>

	</div>
<?php require_once 'footer.php';?>
 </body>
</html>