<?php

class Precurio_Module{
	/**
	 * An array containing the module configuration (from precurio.ini)
	 * @var array
	 */
	protected $config;
	/**
	 * This is the name of the module, more specifically the folder name of the module.
	 * @var string
	 */
	protected $name;
	/**
	 * 1=>active, 0=>inactive,-1=>disabled
	 * @var int
	 */
	protected $status;
	/**
	 * @param string $name - name of the module.
	 * @return PrecurioModule
	 */
	public function __construct($name,$status=1)
	{
		$config = Zend_Registry::get('config');
		if(!isset($config->{$name}))
			throw new Exception('This module has not been properly configured. Please check precurio.ini settings');

		$arr = $config->{$name}->toArray();
		$this->config = $arr[$name];
		$this->name = $name;
		$this->status = $status;
		return $this;
	}
	/**
	 * Returns the name of the module, which must also be the folder name of the module.
	 * @return string
	 */
	public function getName()
	{
		return $this->name;
	}
	/**
	 * @return string
	 */
	public function getTitle()
	{
		return $this->config['title'];
	}
	/**
	 * @return string
	 */
	public function getShortTitle()
	{
		return $this->config['short_title'];
	}
	/**
	 * @return string
	 */
	public function getDescription()
	{
		return $this->config['description'];
	}
	/**
	 * @return int
	 */
	public function getStatus()
	{
		return (int)$this->status;
	}
	/**
	 * Determines if the module can standalone,ie it will have its own major link
	 * @return boolean
	 */
	public function isStandAlone()
	{
		return (boolean)$this->config['is_standalone'];
	}

	/**
	 * @return string
	 */
	public function getAuthor()
	{
		$author = isset($this->config['author']) ? $this->config['author']  : 'Precurio Development Team';
		return $author;
	}


	/* Magic methods below to take care of other developers needs */
	public function __call($name, $arguments) {
        if(substr($name,0,3) == 'get')
        {
        	$property = strtolower(substr($name,3));
        	if(!isset($this->config[$property]))$this->config[$property] = "";
        	return $this->config[$property];
        }
		if(substr($name,0,3) == 'set')
        {
        	$property = strtolower(substr($name,3));
        	$this->config[$property] = $arguments[0];
        	return null;
        }
    }
    public function __set($name, $value) {
        $this->config[$name] = $value;
    }

    public function __get($name) {
        if (!array_key_exists($name, $this->config)) {
            $this->config[$name] = "";
        }
		return $this->config[$name];
    }

    public function __isset($name) {
        return isset($this->config[$name]);
    }

    public function __unset($name) {
        unset($this->config[$name]);
    }

}

?>