<?php
require_once ('Zend/Db/Table/Row/Abstract.php');
require_once('user/models/UserUtil.php');
abstract class Precurio_ItemHistory extends Zend_Db_Table_Row_Abstract
{
	abstract public function getMessage();
	abstract public function getIconFile();
	abstract public static function createNew($id,$type,$new_value="",$old_value="");
	public function getSinceWhen()
	{
		$date = new Precurio_Date($this->date_created);
		return $date->toString();
	}
	/**
	 * Translates a string
	 * @param string $str
	 * @return string
	 */
	protected function translate($str)
	{
		$tr = Zend_Registry::get('Zend_Translate');
		return $tr->translate($str);
	}
	/**
	 * Returns a full name of user as a web link.
	 * @param User $user
	 * @return string
	 */
	protected function userProfileWrap($user)
	{
		$baseUrl = Zend_Controller_Front::getInstance()->getBaseUrl();
		$str = '<a href="'.$baseUrl.'/user/profile/view/'.$user->getId().'">'.$user->getFullName().'</a>';
		return $str;
	}
	public function getUser()
	{
		return UserUtil::getUser($this->user_id);
	}
}
?>