<?php
require_once 'workflow/models/vo/FormBuilderComponent.php';
require_once 'workflow/models/vo/Process.php';
require_once 'workflow/models/vo/ProcessState.php';
class Precurio_FormsBuilder {
	const DBNAME= "formsbuilder";
	const TABLE_FORMS = "forms";
	const TABLE_COMPONENTS = "components";
	const TABLE_OPTIONS = "options";
	const TABLE_SECTIONS = "sections";

	/**
	 * this is the formid on 'forms' table in the formsbuilder database.
	 * @var int
	 */
	private $form_id;
	private $db;

	private $oldComponentIds = array();
	private $oldComponentNames = array();

	function __construct($form_id)
	{
    	$this->form_id = $form_id;
    	$this->db = $this->getDb();
   	}

	function publish()
	{

		$this->generateXMLSchema();

		$process_id = $this->insertFormRecord();

		$this->insertStateRecords($process_id);

		$this->matchFieldsToStates($process_id);

		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::WORKFLOW,'rowClass'=>'Process'));
		$process = $table->fetchRow($table->select()->where('id = ?',$process_id));

		try
		{
			$table = new Zend_Db_Table(array('name'=>$process->getTableName()));
			$rows = $table->fetchAll();//an error will be thrown here if the table does not exist

			unset($rows);

		}
		catch (Exception $e)
		{
			$this->createMySqlFormTable($process_id);
			return $process_id;
		}

		$this->alterMySqlFormTable($process_id);

		return $process_id;
	}

	private function generateXMLSchema()
	{
		$processName = $this->getName();
		$root = Zend_Registry::get('root');

		$new = true;//flag to indicate if this is the first time we are generating this schema
		//if the schema already exists, then get the existing component ids.
		//this will be used in the alterMysqlFormTable function.
		if(file_exists($root.'/application/workflow/schemas/'.$processName.'.xml'))
		{
			$new = false;
			$tableSchema = simplexml_load_file($root.'/application/workflow/schemas/'.$processName.'.xml');
			$converter = new Precurio_XmlToArray();
			$tableSchema = $converter->GetXMLTree($tableSchema->asXML());
			$fields =  $tableSchema['process']['fields']['field'];


			$this->oldComponentIds = array();
			$this->oldComponentNames = array();
			foreach($fields as $field)
			{
				$this->oldComponentIds[] = $field['componentid'];
				$this->oldComponentNames[] = $field['name'];
			}
			unset($fields);
			unset ($tableSchema);
			unset($converter);

		}

		$table = new Zend_Db_Table(array('db'=>$this->db, 'name'=>self::TABLE_COMPONENTS,'rowClass'=>'FormBuilderComponent'));
		$components = $table->fetchAll($table->select()->where('componentform = ?',$this->form_id)->order('section asc')->order('rowid asc'));
		$position = 0;
		$xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n
				<process xmlns:local=\"schema\">\n";
		$xml .= $this->generateHeaderXml();
		$xml .= "<fields>\n";
		$names = array();
		foreach($components as $component)
		{
			$oldName = "";
			if(!$new)
			{
				$key = array_search($component->getId(),$this->oldComponentIds);
				if($key !== false)$oldName = $this->oldComponentNames[$key];
			}
			$names[] = $component->setName($names);
			$xml .= $component->generateSchema($oldName);
			$position++;
		}
		$xml .= "</fields></process>";
		$file = $root.'/application/workflow/schemas/'.$processName.'.xml';
		if(file_exists($file))
			unlink($file);
		file_put_contents($file,$xml);
	}
	private function generateHeaderXml()
	{
		$table = new Zend_Db_Table(array('db'=>$this->db, 'name'=>self::TABLE_FORMS));
		$form = $table->fetchRow($table->select()->where('formid = ?',$this->form_id));

		return "<header>
		<description>$form->formDescription</description>
		<label value='$form->formName'/>
	</header>\n";
	}

	private function insertFormRecord()
	{
		$table = new Zend_Db_Table(array('db'=>$this->db, 'name'=>self::TABLE_FORMS));
		$form = $table->fetchRow($table->select()->where('formid = ?',$this->form_id));

		$data = array(
		'form_builder_formid'=>$form->formid,
		'process'=>$this->getName(),
		'display_name'=>$form->formName,
		'code'=>$form->formCode,
		'description'=>$form->formDescription,
		'department_id'=>0,
		'date_created'=>Precurio_Date::now()->getTimestamp(),
		'active'=>1
		);

		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::WORKFLOW));
		$row = $table->fetchRow($table->select()->where('form_builder_formid = ?',$this->form_id)->where('active=1'));
		if($row)//form has been published before
		{
			$row->setFromArray($data);
			$id  = $row->save();
		}
		else
		{
			$row = $table->createRow($data);
			$id  = $row->save();
			//now insert the base state
			$data = array(
			'form_builder_sectionid'=>0,
			'name'=>'section_1',
			'display_name'=>'Section 1',
			'process_id'=>$id,
			'position'=>0,
			'duration'=>24,
			'sla_email'=>'',
			'allow_approver_change'=>0,
			'is_approval'=>0,
			'date_created'=>Precurio_Date::now()->getTimestamp(),
			);
			$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::WORKFLOW_STATES));
			$row = $table->createRow($data);
			$row->save();
		}
		return $id;

	}
	private function insertStateRecords($process_id)
	{
		$table = new Zend_Db_Table(array('db'=>$this->db, 'name'=>self::TABLE_SECTIONS));
		$sections = $table->fetchAll($table->select()->where('formid = ?',$this->form_id)->order('formposition asc'));

		$position = 1;
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::WORKFLOW_STATES));
		foreach($sections as $section)
		{
			$data = array(
				'form_builder_sectionid'=>$section->sectionid,
				'name'=>$this->getSectionName($section->displayname),
				'display_name'=>$section->displayname,
				'process_id'=>$process_id,
				'position'=>$position,
				'duration'=>$section->sla,
				'sla_email'=>$section->sla_email,
				'allow_approver_change'=>$section->userselect,
				'is_approval'=>$section->approval,
				'date_created'=>Precurio_Date::now()->getTimestamp(),
			);

			$row = $table->fetchRow($table->select()->where('form_builder_sectionid = ?',$section->sectionid));
			if($row)
			{
				$data['name'] = $row->name;
				$row->setFromArray($data);
				$row->save();
			}
			else
			{
				$row = $table->createRow($data);
				$row->save();
			}
			$position++;
		}

		//now remove states that have been deleted.
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::WORKFLOW_STATES));
		$rows = $table->fetchAll($table->select()->where('process_id = ?',$process_id));

		foreach($rows as $row)
		{
			if(empty($row->form_builder_sectionid))continue;
			$table = new Zend_Db_Table(array('db'=>$this->db, 'name'=>self::TABLE_SECTIONS));
			$section = $table->fetchRow($table->select()->where('sectionid = ?',$row->form_builder_sectionid));
			if(empty($section))
			{
				$row->delete();
			}
		}


	}
	private function matchFieldsToStates($process_id)
	{
		$processName = $this->getName();
		$root = Zend_Registry::get('root');
		if(!file_exists($root.'/application/workflow/schemas/'.$processName.'.xml'))
			throw new Zend_Config_Exception();

		//first we will delete existing state to field match
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::WORKFLOW_STATES));
		$states = $table->fetchAll($table->select()->where('process_id = ?',$process_id));

		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::STATE_FIELDS));
		foreach($states as $state)
		{
			$table->delete('state_id = '.$state->id);
		}
		//ok, now we have cleared existing matches, now lets generate a new one.
		//NOTE that there is no cascaded effect here, we are not using the state_field index key for anything.

		$tableSchema = simplexml_load_file($root.'/application/workflow/schemas/'.$processName.'.xml');
		$converter = new Precurio_XmlToArray();
		$tableSchema = $converter->GetXMLTree($tableSchema->asXML());
		$fields =  $tableSchema['process']['fields']['field'];

		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::STATE_FIELDS));
		$t = new Zend_Db_Table(array('db'=>$this->db, 'name'=>self::TABLE_COMPONENTS,'rowClass'=>'FormBuilderComponent'));
		foreach($fields as $field)
		{
			$component = $t->fetchRow($t->select()->where('componentid = ?',$field['componentid']));

			$state_id = $component->getStateId($process_id);
			$data = array(
				'state_id'=>$state_id,
				'field_name'=>$field['name'],
				);
			$row = $table->createRow($data);
			$row->save();

		}
		unset($fields);
		unset ($tableSchema);
		unset($converter);
	}

	private function createMySqlFormTable($process_id)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::WORKFLOW,'rowClass'=>'Process'));
		$process = $table->fetchRow($table->select()->where('id = ?',$process_id));

		$root = Zend_Registry::get('root');
		$tableSchema = simplexml_load_file($root.'/application/workflow/schemas/'.$process->getName().'.xml');
		$converter = new Precurio_XmlToArray();
		$tableSchema = $converter->GetXMLTree($tableSchema->asXML());
		$fields =  $tableSchema['process']['fields']['field'];
		$db = Zend_Registry::get('db');

		$sql = "CREATE TABLE {$process->getTableName()} (
		id INT unsigned NOT NULL AUTO_INCREMENT,
		user_id INT unsigned NOT NULL,";
		foreach($fields as $field)
		{
			if($field['type'] == 'user' || $field['type'] == 'department' || $field['type'] == 'location'
			 || $field['type'] == 'currency' || $field['type'] == 'date'|| $field['control'] == 'checkbox'
			 || $field['type'] == 'signature')
			 {
				$field['type'] = 'varchar';
			 }

			 if($field['control'] == 'textarea' )
				$field['type'] = 'text';

			if($field['type'] == 'signature')
				$field['type'] = 'tinyint';


			if($field['type'] == "varchar")
				$field['type'] = "varchar(255)";
			$sql .= $db->quoteColumnAs($field['name'],null)." ".$field['type'].",";
		}
		$sql .= "`date_created` char(15) ,
  `last_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)

		);";
		$log  = Zend_Registry::get('log');
		$log->info($sql);
		$db->query($sql);
		unset($fields);
		unset ($tableSchema);
		unset($converter);
	}

	private function alterMySqlFormTable($process_id)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::WORKFLOW,'rowClass'=>'Process'));
		$process = $table->fetchRow($table->select()->where('id = ?',$process_id));

		$root = Zend_Registry::get('root');
		$tableSchema = simplexml_load_file($root.'/application/workflow/schemas/'.$process->getName().'.xml');
		$converter = new Precurio_XmlToArray();
		$tableSchema = $converter->GetXMLTree($tableSchema->asXML());
		$fields =  $tableSchema['process']['fields']['field'];

		$db = Zend_Registry::get('db');

		$newComponentIds = array();
		$newComponentNames = array();
		foreach($fields as $field)
		{
			$newComponentIds[] = $field['componentid'];
			$newComponentNames[] = $field['name'];
		}

		$insertedComponentIds = array_diff($newComponentIds,$this->oldComponentIds);
		$deletedComponentIds = array_diff($this->oldComponentIds,$newComponentIds);

		$log = Zend_Registry::get('log');
		$sql = "";
		//ok now lets insert new components
		foreach($insertedComponentIds as $componentId)
		{
			$key = array_search($componentId,$newComponentIds);
			$componentName = $newComponentNames[$key];
			$sql = "alter table `{$process->getTableName()}` add column ". $db->quoteColumnAs($componentName,null)." varchar (255)  NULL";
			if($key == 0)
			{
				$sql .=   " first";
			}
			elseif(isset($this->oldComponentNames[$key-1]))
			{
				$sql .= " after ".$db->quoteColumnAs($this->oldComponentNames[$key-1],null);
			}


			try
			{
				$db->query($sql);
			}
			catch(Exception $e){$log->err($e->getMessage());}
		}
		$log->info($sql);
		//and the remove old components

		foreach($deletedComponentIds as $componentId)
		{
			$key = array_search($componentId,$this->oldComponentIds);
			$componentName = $this->oldComponentNames[$key];
			$sql = "alter table `{$process->getTableName()}` drop column ". $db->quoteColumnAs($componentName,null);
			try
			{
				$db->query($sql);
			}
			catch(Exception $e){$log->err($e->getMessage());}
		}

	}
	/**
	 * Simply determines the name of the state from the display name
	 * @param $displayName string
	 * @return string
	 */
	private function getSectionName($displayName)
	{
		$str = str_word_count(strtolower($displayName),1);
		return implode("_",$str);
	}
	/**
	 * Gets the name of the form (precurio), if form does not exist, a name is generated from the display name
	 * @return string
	 */
	private function getName()
	{
		if($this->form_id == 0)
		{
			$tr = Zend_Registry::get('Zend_Translate');
    		throw new Precurio_Exception($tr->translate(PrecurioStrings::MISSINGPROCESS),Precurio_Exception::EXCEPTION_MISSING_PROCESS);
		}

		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::WORKFLOW,'rowClass'=>'Process'));
		$row = $table->fetchRow($table->select()->where('form_builder_formid = ?',$this->form_id)->where('active=1'));
		if($row)
			return $row->getName();

		$table = new Zend_Db_Table(array('db'=>$this->db, 'name'=>self::TABLE_FORMS));
		$form = $table->fetchRow($table->select()->where('formid = ?',$this->form_id));
		$str = str_word_count(strtolower($form->formName),1);
		return implode("_",$str);


	}
	private function getDb()
	{
		return Zend_Registry::get('db');
	}
	public function getComponentOptions($componentId)
	{
		$table = new Zend_Db_Table(array('db'=>$this->db, 'name'=>self::TABLE_OPTIONS));
		$option = $table->fetchRow($table->select()->where('componentid = ?',$componentId));
		if($option==null)return array();
		return explode(",",$option->options);
	}

}

?>