<?php

class Precurio_Extranet
{
	/**
	 * Invites an external user to access the intranet
	 * @param int $user_id - The user inviting
	 * @param string $email - The email of person being invited
	 * @param int $activity_id -  ID of activity that person is being invited for
	 */
	public static function invite($user_id,$email,$activity_id)
	{
		//first check if user has not been invited for similar activity
		$activity = UserActivity::get($activity_id);

		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::INVITED_USERS));
		$select  = $table->select(false);
		$select->setIntegrityCheck(false);
		$select = $select->from(array('a' => PrecurioTableConstants::INVITED_USERS))
		->join(array('b' => PrecurioTableConstants::ACTIVITY_LOG),'a.activity_id = b.id',array('appid','type','item_id','user_id','session_user_id'))
		->where('b.active=1')
		->where('b.appid = ?',$activity->appid)
		->where('b.type = ?',$activity->type)
		->where('b.item_id = ?',$activity->item_id)
		->where('a.email = ?',$email);

		$items = $table->fetchAll($select);
		if($items->count() > 1)return;//do not re-invite a user for the same activity

		//now lets invite user
		$time = Precurio_Date::now()->getTimestamp();
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::INVITED_USERS));
		$table->insert(array(
				'user_id'=>$user_id,
				'email'=>$email,
				'activity_id'=>$activity_id,
				'date_created'=> $time
		));

		//send email to user

		//see if invited user is registered. If user is registered send link to object, else send link to registration in message body.
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::AUTH));
		$row = $table->fetchRow($table->select()->where('identity = ?',$email));
		if(empty($row))
		{
			$format = Precurio_Activity::getMessageFormat($activity,'mail');
			$baseUrl = Precurio_Extranet::getBaseUrl();
			$registerUrl = $baseUrl.'/user/register/id/'.Precurio_Utils::encrypt($email);
			$user = UserUtil::getUser($user_id);
			$body = getLocalizedString($format,$user->getFullName(),$user->getGenderPronoun(),$registerUrl,"",$user_id,0,$baseUrl,$activity->getLabel(),"");
		}
		else
		{
			$body = $activity->getMessage('mail',0,true);
		}

		$mail = new Precurio_Mail();
		$mail->sendData(array(
				'to'=>$email,
				'subject'=>$activity->getMailSubject(),
				'body'=>$body,
				'activity_id'=>$activity_id
		));

	}
	/**
	 * Checks if the email has been invited to access the extranet, and returns the activity id.
	 * @param string $email
	 * @return int
	 */
	public static function isInvited($email)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::INVITED_USERS));
		$select  = $table->select(false);
		$select->setIntegrityCheck(false);
		$select = $select->from(array('a' => PrecurioTableConstants::INVITED_USERS))
		->join(array('b' => PrecurioTableConstants::ACTIVITY_LOG),'a.activity_id = b.id',array('appid','type','item_id','user_id','session_user_id'))
		->where('b.active=1')
		->where('a.email = ?',$email)
		->order('a.id desc');

		$item = $table->fetchRow($select);
		if(empty($item))return false;

		return $item->activity_id;
	}
	/**
	 * Checks if an email is already registered on the system and returns the user_id
	 * @param string $email
	 * @return int
	 */
	public static function isRegistered($email)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::AUTH));
		$row = $table->fetchRow($table->select()->where('identity = ?',$email));
		if(empty($row))return false;
		return $row->id;
	}
	/**
	 * Gets the URL to the "extranet"
	 * @return string
	 */
	public static function getBaseUrl()
	{
		$config = Zend_Registry::get('config');
		$baseUrl = $config->base_url;
		if($baseUrl[strlen($baseUrl)-1] == "/")
			return $baseUrl.'extranet';
		return $baseUrl.'/extranet';
	}
	public static function getCurrentUserId()
	{
		try
		{
			$ns = new Zend_Session_Namespace(Precurio_Session::NAMESPACE_EXTRANET);
			if(!isset($ns->currentUser))//throw a re-login error because session has expired
			{
				$request = Zend_Controller_Front::getInstance()->getRequest();
				if(!($request->getControllerName() == 'login' || $request->getActionName() == 'remind' || $request->getControllerName() == 'error' || $request->getModuleName() == 'default' || $request->getModuleName() == NULL || $request->getModuleName() == 'chat' || $request->getModuleName() == 'install' || $request->getModuleName() == 'widget'))
				{
					if($request->isDispatched())
					{
						$ns->lastRequest = serialize($request->getRequestUri());
					}
				}
				if(Zend_Registry::isRegistered('Zend_Translate'))
					$tr = Zend_Registry::get('Zend_Translate');
				$msg = isset($tr) ? $tr->translate(PrecurioStrings::SESSIONEXPIRED) : PrecurioStrings::SESSIONEXPIRED;
				throw new Precurio_Exception($msg,Precurio_Exception::EXCEPTION_SESSION_EXPIRED);
			}

			$user = $ns->currentUser;

			return $user->id;
		}
		catch (Zend_Session_Exception $e)//i.e there was a problem retrieving the session user
		{
			return 0;
		}
	}
	/**
	 * Creates an extranet user
	 * @param array $params - User params should contain "email","first_name","last_name","password","mobile_phone"
	 * @return int - User ID
	 */
	public static function createUser($params)
	{
		//some validation
		if(empty($params['email']))return 0;
		if(empty($params['password']))return 0;
		if(empty($params['first_name']))return 0;

		//set data
		$data = array();
		$data['identity'] = $params['email'];
		$data['credential'] = md5($params['password']);
		$data['date_created'] = Precurio_Date::now()->getTimestamp();

		$data['email'] = $params['email'];
		$data['username'] = (stripos($data['email'],'@') === false ? $data['email'] : substr($data['email'],0,strpos($data['email'],'@')));
		$data['password'] = $data['credential'];
		$data['first_name'] = $params['first_name'];
		$data['last_name'] = $params['last_name'];
		$data['mobile_phone'] = $params['mobile_phone'];
		$data['is_external'] = 1;
		//first check if identity already exists
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::AUTH));
		$row = $table->fetchRow($table->select()->where('identity = ?',$data['identity']));
		if(!empty($row))
		{
			$existingUser = UserUtil::getUser($row->id);
			$existingUser->active = 1;
			$existingUser->save();
			return $row->id;
		}

		//create user in authentication table
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::AUTH));
		$user_id = $table->insert(array(
				'identity'=>$data['identity'],
				'credential'=>$data['credential'],
				'date_created'=>$data['date_created']
		));
		$data['user_id'] = $user_id;
		unset($data['identity']);unset($data['credential']);

		//then insert into user details
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::USERS));
		$row  = $table->createRow();$row->setFromArray($data);
		$id  = $row->save();

		//now set session
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::AUTH));
		$row = $table->fetchRow($table->select()->where('identity = ?',$data['email']));
		Precurio_Session::setCurrentUser($row,true);

		//finally, make sure user now has access to documents, tasks or discussions that had been shared with him
		//to do this, lets get all the activities this user has been invited for.
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::INVITED_USERS));
		$rows = $table->fetchRow($table->select()->where('email = ?',$data['email']));
		//for each invitation, get the object and add user.
		foreach($rows as $row)
		{
			$activity = UserActivity::get($row->activity_id);
			$object = $activity->getItem();
			if(is_a($object,"Precurio_ExtranetInterface"))
				$object->addExtranetUser($user_id,$row->user_id);
		}

		return $user_id;
	}

}

?>