<?php

require_once ('Zend/Date.php');

class Precurio_Date extends Zend_Date
{
	/**
     * Generates the standard date object, could be a unix timestamp, localized date,
     * string, integer, array and so on. Also parts of dates or time are supported
     * Always set the default timezone: http://php.net/date_default_timezone_set
     * For example, in your bootstrap: date_default_timezone_set('America/Los_Angeles');
     * For detailed instructions please look in the docu.
     *
     * @param  string|integer|Zend_Date|array  $date    OPTIONAL Date value or value of date part to set
     *                                                 ,depending on $part. If null the actual time is set
     * @param  string                          $part    OPTIONAL Defines the input format of $date
     * @param  string|Zend_Locale              $locale  OPTIONAL Locale for parsing input
     * @return Zend_Date
     * @throws Zend_Date_Exception
     */
    public function __construct($date = null, $part = null, $locale = null)
    {
    	if(Precurio_Utils::isNull($date))
    		$date = null;
		parent::__construct($date,$part,$locale);
	}
	public static function getMonthStr($month,$format = self::MONTH_NAME )
	{
		$date = new Zend_Date(array('month'=> $month,
						'day' => 1));
		return $date->get($format);
	}
	/**
	 * Returns how long ago from $date, If $date is null, it returns how long ago from now.
	 * @param $date Zend Date
	 * @return String
	 */
	public function getHowLongAgo($date = null)
	{
		$tr = Zend_Registry::get('Zend_Translate');
		//first get the time part
		$seperator = ':';
		$time = $this->get(self::HOUR) . $seperator.
				$this->get(self::MINUTE) . $seperator.
				$this->get(self::SECOND);
		if($date==null)
		{
			if($this->isYesterday())
				return $tr->translate(PrecurioStrings::YESTERDAY) . ' '.$time;//takes care of yesterday.

			$date = new Precurio_Date();
		}
		$dayDiff = floor(($date->getTimestamp() - $this->getTimestamp()) / (24*60*60));
		$str = "";

		if($dayDiff == 0)
		{
			$timeDiff = round(($date->getTimestamp() - $this->getTimestamp()) / (60*60));
			if($timeDiff == 0)
			{
				$minDiff = floor(($date->getTimestamp() - $this->getTimestamp()) / 60);
				if($minDiff == 0)
					return 	$tr->translate(PrecurioStrings::FEWSECONDSAGO);
				elseif($minDiff < 10)
					return $tr->translate(PrecurioStrings::FEWMINUTESAGO);
				else
					return $tr->translate(PrecurioStrings::SOMEMINUTESAGO);
			}
			elseif($timeDiff == 1)
			{
				return $tr->translate(PrecurioStrings::ABOUT).' '.$tr->translate(PrecurioStrings::AN).' '. $tr->translate(PrecurioStrings::HOURAGO);
			}
			elseif($timeDiff <= 6)
			{
				return $tr->translate(PrecurioStrings::ABOUT).' '.$timeDiff.' '. $tr->translate(PrecurioStrings::HOURSAGO);
			}
			else
				$str = $tr->translate(PrecurioStrings::TODAY).'';
		}
		elseif ($dayDiff < 4)
			$str = $dayDiff .' '. $tr->translate(PrecurioStrings::DAYSAGO);
		else
			return $this;
		return $str. ' '. $time ;

	}
	public static function getGreeting()
	{
		$tr = Zend_Registry::get('Zend_Translate');
		//Here we define out main variables
		$welcome_string= $tr->translate("Welcome!");
		$numeric_date= new Precurio_Date();
		$numeric_date = $numeric_date->get(self::HOUR);

		//Start conditionals based on military time
		if($numeric_date>=0&&$numeric_date<=11)
		$welcome_string=$tr->translate("Good Morning!");
		else if($numeric_date>=12&&$numeric_date<=17)
		$welcome_string=$tr->translate("Good Afternoon!");
		else if($numeric_date>=18&&$numeric_date<=23)
		$welcome_string=$tr->translate("Good Evening!");

		//Display our greeting
		return $welcome_string;
	}
	public static function getAllMonths($format=self::MONTH_NAME_SHORT)
	{
		$content = array();
		for($i=1;$i<=12;$i++)
		{
			$content[$i]['value'] = $i;
			$content[$i]['label'] = self::getMonthStr($i,$format);
		}
		return $content;
	}
	public static function getAllHours()
	{
		$content = array();
		for($i=0;$i<=23;$i++)
		{
			$content[$i]['value'] = $i;
			$content[$i]['label'] = str_pad($i,2,'0',STR_PAD_LEFT);
		}
		return $content;
	}
	public static function getAllMinutes()
	{
		$content = array();
		for($i=0;$i<=59;$i++)
		{
			$content[$i]['value'] = $i;
			$content[$i]['label'] = str_pad($i,2,'0',STR_PAD_LEFT);
		}
		return $content;
	}
	public static function getAllDays()
	{
		$content = array();
		for($i=1;$i<=31;$i++)
		{
			$content[$i]['value'] = $i;
			$content[$i]['label'] = str_pad($i,2,'0',STR_PAD_LEFT);
		}
		return $content;
	}
	public static function getAllYears($format=self::YEAR,$start = 1990)
	{
		$content = array();
		$currentYear = self::now()->get($format);
		for($i=$currentYear+1;$i> $start;$i--)
		{
			$content[$i]['value'] = $i;
			$content[$i]['label'] = $i;
		}
		return $content;
	}
}

?>