<?php
/****************************Code to load Zend Framework starts here*******************************/
defined('APPLICATION_PATH')
    || define('APPLICATION_PATH', realpath(dirname(__FILE__)));


set_include_path(implode(PATH_SEPARATOR, array(
    realpath(APPLICATION_PATH . '/../library'),
    realpath(APPLICATION_PATH . '/../application/default/models/'),
	realpath(APPLICATION_PATH .'/../application/default/models/vo'),
 	realpath(APPLICATION_PATH .'/../application/user/models/vo') ,
	realpath(APPLICATION_PATH .'/../application' ),
	realpath(APPLICATION_PATH .'/../application/default/layouts'),
    get_include_path(),
)));

define("PATH_TMP",APPLICATION_PATH . '/../application/tmp/');//path to tmp folder

require_once "Zend/Loader.php";
require_once 'Zend/Loader/Autoloader.php';

$autoloader = Zend_Loader_Autoloader::getInstance();
        $autoloader->setFallbackAutoloader(true);

$root = realpath(dirname(__FILE__) . '/../');
Zend_Registry::set('root',$root);
try
{
	//initialise config
	_initConfig();

	//initialse enviroment
	_initEnv();

	//initialse locale
	_initLocale();

	//initialise database connection . You can retrieve Zend_Db object from registry [Zend_Registry::get('db')]
	_initDb();

	//initialise log
	_initLog();
}
catch(Exception $e)
{
	echo $e->getMessage();
}
/**
 * Returns a string with some variables replaced
 * E.g.:
 * $str    = "Page {1}  ({1}/{2})";
 * $arg1   = "1";
 * $arg2   = "5";
 * echo localizedString($str,$arg1,$arg2);
 * would return: Page 1 (1/5)
 * @author http://moinne.com/blog/ronald/php/php-function-localizedstring/
 */
function getLocalizedString() {
    $patterns     = array();
    $replacements = array();
    $text         = func_get_arg(0);
    $numArgs      = func_num_args();

    for ($i = 1; $i < $numArgs; $i++) {
        $patterns[]     = '/\{'.$i.'\}/';
        $replacements[] = func_get_arg($i);
    }

    return preg_replace ($patterns, $replacements, $text);
}
/****************************Code to load Zend Framework stops here*******************************/
	function _initConfig()
	{
		$root = Zend_Registry::get('root');

		try
		{
			$frontendOptions = array('master_file'=>$root.'/application/configs/precurio.ini','automatic_serialization' => true,'lifetime' => 7200);//cache is valid for 2 hrs
			$backendOptions = array('cache_dir' => PATH_TMP);

			$cache = Zend_Cache::factory('File',
			'File',
			$frontendOptions,
			$backendOptions);
			if(!$config = $cache->load('config' ))
			{
				$config = new Zend_Config_Ini($root.'/application/configs/precurio.ini',null,array('allowModifications'=>true));
				$cache->save($config,'config');
			}
		}
		catch(Exception $e)
		{
			echo $e->getMessage();
		}
		Zend_Registry::set('config',$config);
    	return $config;
	}
	function _initDb()
	{
		if(Zend_Registry::isRegistered('db'))//if db has already been initialised
			return Zend_Registry::get('db');

		$config = Zend_Registry::get('config');

		$db = Zend_Db::factory("Pdo_Mysql",$config->mysql->database);
		$root = Zend_Registry::get('root');
		try {
			$db->getConnection(); //attempt to connect using details
		}
		catch(Zend_Exception $e)
		{
			echo ($e->getMessage());
		}

		Zend_Registry::set('db',$db); //store connection in registry
		Zend_Db_Table::setDefaultAdapter($db);//set as default connection adapter for all tables

		$frontendOptions = array('automatic_serialization' => true);//cache is valid for ever
		$backendOptions = array('cache_dir' => PATH_TMP);
		$cache = Zend_Cache::factory('Core','File',$frontendOptions,$backendOptions);

	    Zend_Db_Table_Abstract::setDefaultMetadataCache($cache);
	    return $db;
	}
	function _initEnv()
	{
		$config = Zend_Registry::get('config');
		$env = $config->enviroment;
		if ($env == 'development') {
			// Enable all errors so we'll know when something goes wrong.
			error_reporting(E_ALL & ~E_STRICT);
			ini_set('display_startup_errors', 1);
			ini_set('display_errors', 1);
        }
        if($env == 'test')
        {
        	// Enable only errors and warnings so we'll know when something goes wrong.
			error_reporting(E_ERROR | E_WARNING | E_PARSE| E_NOTICE);
			ini_set('display_startup_errors', 0);
			ini_set('display_errors', 1);
        }
		if($env == 'production')
        {
        	// disable all error display
			error_reporting(E_ERROR);
			ini_set('display_startup_errors', 0);
			ini_set('display_errors', 1);
        }

	}
	function _initLocale()
	{
		$root = Zend_Registry::get('root');

    	$frontendOptions = array('automatic_serialization' => true,'lifetime' => 21600);//cache is valid for 6 hrs
		$backendOptions = array('cache_dir' => PATH_TMP);

		$cache = Zend_Cache::factory('Core',
		'File',
		$frontendOptions,
		$backendOptions);

		Zend_Translate::setCache($cache);

		//get locale settings for registry
    	$registry = Zend_Registry::getInstance();
		$config = $registry->get('config');

   	 	$loc = $config->default_locale;
        $locale = new Zend_Locale($loc);

		$lang = $locale->getLanguage();
		$region = $locale->getRegion();
		//$t_file => translation file
		$t_file = $root ."/application/languages/$lang/LC_MESSAGES/".$lang.'_'."$region.mo";
		if(!file_exists($t_file))
			$t_file = $root .'/application/languages/'.$lang.'/LC_MESSAGES/precurio.mo';

		$translate = new Zend_Translate('gettext', $t_file,$loc);
		$translate->setLocale($locale);
		$translate->setOptions(array('disableNotices'  => true));
		$registry->set('Zend_Translate', $translate);
		$registry->set('Zend_Locale', $locale);
	}
	function _initLog()
    {
    	$log = new Precurio_Log();
    	Zend_Registry::set('log',$log);
    	return $log;

    }
    //load content class. Almost all email widget will be content related
    require_once ("cms/models/MyContents.php");
    require_once ("cms/models/vo/Content.php");
?>