<?php

/**
 * PollController
 *
 * This the controller for the Polls widget. No need to define new actions here, we simply
 * extend the existing Poll_IndexController. Please note that once Polls becomes a standalone
 * module, we will move the contents of Poll_IndexController here.
 *
 * @author Brain
 * @version 2.1
 */

require_once 'Zend/Controller/Action.php';
require_once ('poll/models/Polls.php');
require_once ('widget/controllers/IndexController.php');

class Widget_PollController extends Widget_IndexController
{

    /**
     * This is only called via AJAX, when the user votes.
     * Refreshes the widgets.
     */
    public function indexAction()
    {
        $this->_helper->layout->disableLayout();
        $poll = Polls::getActivePoll();
        $this->view->poll = $poll;
        $this->renderScript("views/home/poll.phtml");
    }

    public function voteAction()
    {
        $id = $this->getRequest()->getParam('id');
        $this->view->poll = Polls::getPoll($id);
        $this->render();
    }

    public function resultAction()
    {
        $id = $this->getRequest()->getParam('id');
        $this->view->poll = Polls::getPoll($id);
        $this->render();
    }

    public function submitvoteAction()
    {
        $this->_helper->viewRenderer->setNoRender();
        $params = $this->getRequest()->getParams();
        $poll_id = $params['poll_id'];
        $poll = Polls::getPoll($poll_id);
        foreach ($params as $key => $value)
        {
            if (substr($key, 0, 6) == 'option')
            {
                $poll->newVote($value);
            }
        }

        echo $this->view->translate("Thank you for voting");
        $this->render();
    }

    public function configureAction()
    {
    	if(!UserUtil::isAllowed('admin_index'))
    	{
    		throw new Precurio_Exception(PrecurioStrings::CANNOTACCESSRESOURCE,Precurio_Exception::EXCEPTION_INVALID_ROLE);
    		return;
    	}
        $id = $this->getRequest()->getParam('id',0);
        $poll = Polls::getPoll($id);
        if(!empty($poll))
            $this->view->poll = $poll;
        $userSetting = UserUtil::getUser()->getSettings();
        $this->view->widget = $userSetting->getWidget('poll');
        $this->renderScript('views/home/poll_configure.phtml');
    }

    public function deleteAction()
    {
        $this->_helper->layout->disableLayout();
        $this->_helper->viewRenderer->setNoRender();
        $id = $this->getRequest()->getParam('id', 0);
        if (! is_numeric($id))
        {
            echo "Invalid Parameter $id";
            return; // we are expecting an integer here.
        }
        $table = new Zend_Db_Table(array(
            'name' => PrecurioTableConstants::POLL
        ));
        $row = $table->find($id)->current();
        if (empty($row))
        {
            echo "No such record";
            return;
        }
        $row->active = 0;
        $row->save();
    }

    public function postSubmitConfig($formData)
    {
        if (! UserUtil::isAllowed('admin_index')) return;
        // delete all user setting to reset dashboard.
        $table = new Zend_Db_Table(array(
            'name' => PrecurioTableConstants::USER_SETTING
        ));
        $table->delete('id > 0');

        $root = Zend_Registry::get('root');
        $config = new Zend_Config_Ini($root . '/application/configs/precurio.ini', null, array(
            'allowModifications' => true,
            'skipExtends' => true
        ));

        $widget_name = strtolower($this->getRequest()->getControllerName());
        $config->{$widget_name}->{$widget_name}->title = $formData['title'];
        $config->{$widget_name}->{$widget_name}->order = $formData['order'];
        $config->{$widget_name}->{$widget_name}->position = $formData['position'];

        $item = new Precurio_ConfigWriter(array(
            'config' => $config,
            'filename' => $root . '/application/configs/precurio.ini'
        ));

        $item->write();

        if (!empty($formData['id']))
        {
            $id = $formData['id'];
            $this->updatePoll($id, $formData);
        }
        else
        {
            $id = $this->createPoll($formData);
        }

        return $this->_redirect('/widget/poll/configure/id/'.$id);
    }
    public function formAction()
    {
        $id = $this->getRequest()->getParam('id',0);
        $poll = Polls::getPoll($id);
        if(!empty($poll))
            $this->view->poll = $poll;
        $this->renderScript("views/home/poll_form.phtml");
    }
    private function updatePoll($id,$formData)
    {
        $poll = Polls::getPoll($id);
        if(empty($poll))return;
        $poll->title = $formData['question'];
        $poll->end_date = mktime(23,59,59,$formData['month'],$formData['day']);
        $poll->multiple_answers = empty($formData['multiple_answers']) ? 0 :1;
        $poll->randomise_options = empty($formData['randomise_options']) ? 0 : 1;
        $poll->save();

        $table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::POLL_OPTIONS,'rowClass'=>'PollOption'));
        $table->update(array('active'=>0), "poll_id = $id");//first remove all options
        //update existing options
        foreach($formData as $key=>$value)
        {
            if(substr($key,0,8)=='optionid')
            {
                $parts = explode("_",$key);
                $option_id  = $parts[1];
                $table->update(array('active'=>1,'label'=>$value), "id = $option_id");

            }
        }
        //create new options
        foreach($formData['options'] as $label)
        {

            //check if the new addition already exists, but first check if option was previously deleted
            $option = $table->fetchRow($table->select()->where('label = ?',$label)->where('poll_id = ?',$id));
            if(!empty($option))
            {
                $option->active = 1;
                $option->save();
                continue;
            }
            $table->insert(array(
                'poll_id'=>$id,
                'label'=>$label,
                'date_created'=>time(),
                'active'=>1
            ));
        }

        return $id;

    }
    private function createPoll($formData)
    {
        $table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::POLL));
        $id = $table->insert(array(
        	'title'=>$formData['question'],
            'randomise_options'=>empty($formData['randomise_options']) ? 0 : 1,
            'multiple_answers'=>empty($formData['multiple_answers']) ? 0 : 1,
            'end_date'=>mktime(23,59,59,$formData['month'],$formData['day']),
            'user_id'=>Precurio_Session::getCurrentUserId(),
            'date_created'=>time(),
            'is_public'=>1,
            'active'=>1
        ));
        $table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::POLL_OPTIONS));
        //create new options
        foreach($formData['options'] as $label)
        {
            $table->insert(array(
                'poll_id'=>$id,
                'label'=>$label,
                'date_created'=>time(),
                'active'=>1
            ));
        }

        return $id;
    }
}
?>