<?php
require_once('user/models/vo/UserTag.php');
require_once ('Zend/Db/Table/Row/Abstract.php');
class Rating
{
	protected $item_id;
	protected $type;
	public function __construct($item_id,$type)
	{
		$this->item_id = $item_id;
		$this->type = $type;
		return $this;
	}
	public function getScore()
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::USER_RATINGS));
		$select = $table->select(false);

		$select = $select->from(PrecurioTableConstants::USER_RATINGS,array('total_score'=>'sum(score)'))
					->where('item_id = ?',$this->item_id)
					->where('type = ?',$this->type);
		$row = $table->fetchRow($select);
		return $row->total_score;

	}
	public function setScore($score)
	{
		$user_id = Precurio_Session::getCurrentUserId();
		//check if user has rated before
		$userRating = UserRating::get($this->type, $this->item_id, $user_id);
		if(!empty($userRating))return $this->getScore();

		//user has not rated before. Insert score.
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::USER_RATINGS));
		$id = $table->insert(array(
		'score'=>$score,
		'item_id'=>$this->item_id,
		'type'=>$this->type,
		'user_id'=>$user_id,
		'date_created'=>time()
		));
		switch ($this->type)
		{
			case UserTag::TYPE_LINK:
				$link = Links::getLink($this->item_id);
				$link->rating = $link->rating + $score;
				$link->save();
				$user_id = $link->user_id;//needed for activity email notification so email will only be sent to link owner
		}
		//trigger notification
		Precurio_Activity::create(User::APPID,"rated", $id,$user_id);

		return $this->getScore();

	}
	/**
	 * Gets a particular user rating
	 * @param int $id
	 * @return UserRating
	 */
	public static function getUserRating($id)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::USER_RATINGS, 'rowClass'=>'UserRating'));
		return  $table->find($id)->current();
	}
}
class UserRating extends Zend_Db_Table_Row_Abstract
{
	/**
	 * Returns the label used for activity USER_RATED in the activity feed.
	 * This function should work without any modification, as long as the convention
	 * defined in UserTag.php is followed.
	 * @return string
	 */
	public function getActivityLabel()
	{
		$str = "";
		$item = UserTag::getTaggedItem($this->item_id,$this->type);
		$str = $item->title;

		$baseUrl = Zend_Controller_Front::getInstance()->getRequest()->getBaseUrl();
		$themes = new Precurio_Themes();

        $theme = $themes->getUserTheme();
        $style = $themes->getUserStyle($theme);
		$img = "&nbsp;<img src='$baseUrl/library/css/$theme/$style/images/".($this->score < 0 ? 'thumbsdown.png' :'thumbsup.png')."' width='16' height='16'>";
		$str .= $img;
		return $str;
	}
	/**
	 * Get the user rating for a particular item. Returns null if user has not rated item before
	 * @param int $type
	 * @param int $item_id
	 * @param int $user_id
	 * @return UserRating
	 */
	public static function get($type,$item_id,$user_id)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::USER_RATINGS, 'rowClass'=>'UserRating'));
		$select = $table->select(false);

		$select = $select->from(PrecurioTableConstants::USER_RATINGS)
					->where('item_id = ?',$item_id)
					->where('type = ?',$type)
					->where('user_id = ?',$user_id);
		return $table->fetchRow($select);
	}
}
?>