<?php
require_once ('employee/models/Employees.php');
require_once ('cms/models/MyContents.php');
/**
 * IndexController - The default controller class
 *
 * @author
 * @version
 */

class User_IndexController extends Zend_Controller_Action
{

    public function indexAction()
    {
    	$this->_helper->viewRenderer->setNoRender();
		$this->_helper->layout->disableLayout();
    	$this->_forward('view','profile');
    	return;
    }
    /**
     * Basically just echos "1". Only Used by the installer to test for mod_rewrite
     * Note, it MUST echo 1. i.e. <?php echo 1; ?>
     */
    public function testAction()
    {
    	$this->_helper->viewRenderer->setNoRender();
    	$this->_helper->layout->disableLayout();
    	echo 1;
    	return;
    }
    public function selectAction()
    {
    	$this->_helper->layout->disableLayout();
    	$ns = new Zend_Session_Namespace('temp');

    	$c_id = $this->getRequest()->getParam('c_id',0);
    	if($c_id != 0)
    	{
    		$ns->id = $c_id;
    		$content = MyContents::getContent($c_id) ;
    		$ns->selectedUsers = $content->getSharedUsers();//array

    	}
    	if(!isset($ns->callback))
    	{
    		$this->_helper->viewRenderer->setNoRender();
    		echo $this->view->translate("Invalid callback selected");
    		return;
    	}
    	if(!isset($ns->selectLabel))$ns->selectLabel = $this->view->translate("Selected");
    	$this->view->callback = $ns->callback;
    	$this->view->id = $ns->id;
    	$this->view->selectedUsers = $ns->selectedUsers;
    	$this->view->selectLabel = $ns->selectLabel;
    	$employees  = new Employees();
    	$this->view->employees = $employees->getAll(true);
    }
    public function autocompleteAction()
    {
    	$this->_helper->layout->disableLayout();
    	$this->_helper->viewRenderer->setNoRender();
    	$part = $this->getRequest()->getParam('part');

		$results = array();
		$tr = Zend_Registry::get('Zend_Translate');

		$users = UserUtil::getUsers();
		foreach($users as $user)
		{
			if($user->search($part))
			{
				$obj = new stdClass();
				$obj->id  = $user->getId();
				$obj->title = $user->getFullName();
				$obj->image = $user->getProfilePicture();
				$obj->label = $user->getJobTitle();
				$obj->type = 'user';
				if(empty($obj->label))$obj->label = (string)$user->getLocation();
				if(empty($obj->label))$obj->label = (string)$user->getDepartment();
				if(empty($obj->label))$obj->label = (string)$user->getMobilePhone();
				if(empty($obj->label))$obj->label = $tr->translate("User");
				$results[] = $obj;
			}
		}

		$groups = UserUtil::getGroups();
		foreach($groups as $group)
		{
			if($group->search($part))
			{
				$obj = new stdClass();
				$obj->id  = $group->getGroupId();
				$obj->title = $group->getTitle();
				$obj->image = '/library/themes/default/css/upload/staff-graphic.png';
				$obj->label = $tr->translate('Group');
				$obj->type = 'group';
				$results[] = $obj;
			}
		}

		usort($results, function($a, $b)
		{
			return strcmp($a->title, $b->title);
		});
		echo json_encode($results);
    }
    public function dataAction()
    {
    	$this->_helper->layout->disableLayout();
    	$this->_helper->viewRenderer->setNoRender();
    	$includeGroups = $this->getRequest()->getParam('groups',false);
    	$includeUsers = $this->getRequest()->getParam('users',true);

    	$results = array();
    	$tr = Zend_Registry::get('Zend_Translate');
		if($includeUsers)
		{
			$users = UserUtil::getUsers();
			foreach($users as $user)
			{
				$obj = new stdClass();
				$obj->id  = $user->getId();
				$obj->title = $user->getFullName();
				$obj->description = $user->getEmail();//does not display (But makes the email searchable)
				$obj->image = $user->getProfilePicture();
				$obj->label = $user->getJobTitle();
				$obj->type = 'user';
				if(empty($obj->label))$obj->label = (string)$user->getEmail();
				if(empty($obj->label))$obj->label = (string)$user->getLocation();
				if(empty($obj->label))$obj->label = (string)$user->getDepartment();
				if(empty($obj->label))$obj->label = (string)$user->getMobilePhone();
				if(empty($obj->label))$obj->label = $tr->translate("User");
				$results[] = $obj;
			}
		}

    	if($includeGroups)
    	{
    		$groups = UserUtil::getGroups();
    		foreach($groups as $group)
    		{
    				$obj = new stdClass();
    				$obj->id  = $group->getGroupId();
    				$obj->title = $group->getTitle();
    				$obj->image = '/library/themes/default/css/upload/staff-graphic.png';
    				$obj->label = $tr->translate('Group');
    				$obj->type = 'group';
    				$results[] = $obj;
    		}

    	}
    	usort($results, function($a, $b)
    	{
    		return strcmp($a->title, $b->title);
    	});
    	echo json_encode($results);
    }
    public function searchdataAction()
    {
    	$this->_helper->layout->disableLayout();
		$this->_helper->viewRenderer->setNoRender();

		$tr = Zend_Registry::get('Zend_Translate');
		$label = "{1} {2}";

		$users = UserUtil::getUsers();

		$results = array();
		foreach($users as $item)
		{
			$obj = new stdClass();
			$obj->id  = $item->getId();
			$obj->title = $item->getTitle();
			$obj->label = getLocalizedString($label,$item->getJobTitle(),$item->getDepartment());
			$obj->url = $item->getUrl();
			$results[] = $obj;
		}
		echo json_encode($results);
    }
    public function setstyleAction()
    {
    	$this->_helper->layout->disableLayout();
		$this->_helper->viewRenderer->setNoRender();
    	Precurio_Session::setStyle($this->getRequest()->getParam('style'));
    }
	public function updateusernamesAction()
	{
		$this->_helper->layout->disableLayout();
		$this->_helper->viewRenderer->setNoRender();
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::USERS));
		$users = $table->fetchAll();
		foreach($users as $user)
		{
			$user->username = substr($user->email,0,strpos($user->email,'@'));
			$user->save();
		}
		echo "Done!";

	}
	/**
	 * This action is called periodically be the user (via ajax (notifications.js)).
	 * It attempts to send some notifications and if enabled,gets some updates/feeds of notification that affects current user.
	 *
	 */
	public function periodicupdateAction()
	{
		$this->_helper->layout->disableLayout();
		$this->_helper->viewRenderer->setNoRender();
		try{
		$user_id = Precurio_Session::getCurrentUserId();
		}
		catch(Exception $e)
		{
			echo json_encode(array("error"=>"Invalid Session"));
			return;
		}

		$result = array();
		$config = Zend_Registry::get("config");
		$root = Zend_Registry::get('root');

		$filename = $root.'/application/tmp/notification.lock';

		if(empty($config->no_mail_queue) && $config->enable_periodic_notification)//i.e. no_mail_queue option is not enabled and periodic_notification is enabled. Note: If "no_mail_queue" were enabled, then there wil be no mail in the queue
		{
			$mail = new Precurio_Mail();
			//see if notification is locked
			$str = @file_get_contents($filename);
			if($str)//there is lock info
			{
				$status = explode(":", $str);
				if($status[0] == 1 && (time() < $status[1] + (10*60)))//notification is locked and has been locked for less 10mins
				{
					$result = array_merge($result,array("notification_status"=>"locked","error"=>1));
				}
				else//notification is not locked, execute.
				{
					$r = $mail->handleQueue();
					$result = array_merge($result,array("notification_status"=>($r ? "success" : "unable to send messages")));
				}
			}
			else //error reading lock file, means first run. execute.
			{
				$r = $mail->handleQueue();
				$result = array_merge($result,array("notification_status"=>($r ? "success" : "unable to send messages")));
			}
		}
		else //mail queue has been disabled.
		{
			$result = array_merge($result,array("notification_status"=>"disabed","error"=>1));
		}

		if(empty($config->enable_periodic_update))//periodic update feature not enabled
		{
			$result = array_merge($result,array("updates"=>array()));
		}
		else //get periodic update
		{
			$updates = array();//store the updates
			/*
			 * first let us know the last time we saw the user. Anything greater than 3mins means the periodic updater was closed (logged out or browser close)
			 * and since we do not want the user bombarded by notifications upon login; we ignore if user was last seen more than 3mins ago
			*/
			$user = UserUtil::getUser($user_id);
			if(!$user)
			{
				echo json_encode(array("error"=>"Invalid User"));
				return;
			}
			$last_seen = $user->last_seen;
			$now = time();
			if($now < ($last_seen + (3*60)))//user was last seen less than 3mins ago.
			{
				//now lets get all activities that have occured since we last seen user (maximum of 10 updates)
				$activities = Precurio_Activity::getUpdates($user_id,$last_seen,10);
				foreach($activities as $activity)
				{
					$updates[$activity->id] = $activity->getMessage();
				}

			}

			$user->last_seen = $now;
			$user->save();
			$result = array_merge($result,array("updates"=>$updates));
		}

		//send result
		echo json_encode($result);
		return;

	}

}
