<?php
require_once ('user/models/vo/UserActivity.php');
class TeamActivity extends UserActivity
{
	/**
	 * Gets activity updates for a particular team.
	 * @param int $team_id - The team for which to get activity updates for.
	 * @param timestamp $since OPTIONAL - Updates should not be earlier than $since.
	 * @param int $limit OPTIONAL default to 20.
	 * @return Zend_Db_Table_Rowset_Abstract|array
	 */
	public static function getUpdates($team_id,$since=null,$limit = 20)
	{
		/*
		 * Previous implementation, before battling with how to display document upload activity feed
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::ACTIVITY_EFFECT, 'rowClass'=>'TeamActivity'));
		$select  = $table->select(false);
		$select->setIntegrityCheck(false);
		$select = $select->from(array('a' => PrecurioTableConstants::ACTIVITY_EFFECT))
		->join(array('b' => PrecurioTableConstants::ACTIVITY_LOG),'a.activity_id = b.id',array('appid','type','item_id','date_created','user_id','session_user_id','group_id'))
		->order('a.date_created DESC')
		->where('a.active = 1 AND b.active=1')
		->where('b.group_id = ?',$team_id);

		if(!empty($since))
		{
			$select = $select->where('b.date_created > ?',$since);
		}

		$activities = $table->fetchAll($select);

		//remove duplicates
		$temp = array();
		foreach($activities as $activity)
		{
			$key = $activity->appid.$activity->type.$activity->item_id;
			$temp[$key]  = $activity;
			if(count($temp)>=$limit)break;
		}
		return $temp;
		*/

		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::ACTIVITY_LOG, 'rowClass'=>'TeamActivity'));
		$select = $table->select()->order('date_created DESC')->where('active=1')->where('group_id = ?',$team_id);

		if(!empty($since))
		{
			$select = $select->where('date_created > ?',$since);
		}

		$activities = $table->fetchAll($select);

		//remove duplicates
		$temp = array();
		foreach($activities as $activity)
		{
			if($activity->getItem() == null)continue;
			$activityR = Precurio_Registry::get($activity->appid, $activity->type);
			if(!$activityR->feed_enabled)continue;
			$key = $activity->appid.$activity->type.$activity->item_id;
			$temp[$key]  = $activity;
			if(count($temp)>=$limit)break;
		}
		return $temp;
	}
}

?>