<?php
/**
 * TaskController
 *
 * @author
 * @version
 */

require_once 'team/controllers/BaseController.php';
require_once "team/models/vo/TeamTask.php";
class Team_TaskController extends Team_BaseController{

	public function indexAction()
	{
		$team = $this->view->team;
		$this->view->tasks = TeamTask::getAll($team->getId());
	}
	public function viewAction()
	{
		$task = TeamTask::get($this->getParam('id'),$this->getParam('t_id'));
		if(!$task->isActive())$this->redirect('/team/task/index/t_id/'.$this->getParam('t_id'));
		if(empty($task))
		{
			throw new Precurio_Exception(PrecurioStrings::INVALIDPAGEACCESS, Precurio_Exception::EXCEPTION_INVALID_CONTENT);
		}
		if(!$task->canTeamAccess($this->getParam('t_id')))
		{
			throw new Precurio_Exception(PrecurioStrings::CANNOTACCESSRESOURCE, Precurio_Exception::EXCEPTION_NO_ACCESS);
		}

		$this->view->task = $task;
	}
	public function submitAction()
	{
		$this->_helper->layout->disableLayout();
		$this->_helper->viewRenderer->setNoRender(); 

		$timestamp = Precurio_Date::now()->getTimestamp();
		$params = $this->getRequest()->getPost();
		if(empty($params['title']))
		{
			echo $this->view->translate(PrecurioStrings::ERROR_PERFORMING_OPERATION);
			return;
		}
		$values = array();
		$values['creator_user_id'] = Precurio_Session::getCurrentUserId();
		$values['creator_group_id'] = $this->getParam('t_id');
		$values['date_created'] = $timestamp;
		$values['start_time'] = $timestamp;
		$values['end_time'] = "";
		$values['title'] = $params['title'];
		$values['user_id'] = isset($params['user_id']) ? $params['user_id'] : 0;
		$values['description'] = isset($params['description']) ? $params['description'] : '';

		try
		{
			$id = TeamTask::create($values);
		}
		catch (Exception $e)
		{
			$log = Zend_Registry::get('log');
			$log->err($e);
			echo $this->view->translate(PrecurioStrings::ERROR_PERFORMING_OPERATION);
			return;
		}
		finally {
		    echo $id;
		}
	}
	public function transferAction()
	{
		$this->_helper->layout->disableLayout();
		if($this->getRequest()->isPost())
		{
			$this->_helper->viewRenderer->setNoRender();

			$values = $this->getRequest()->getPost();

			$task = TeamTask::get($values['task_id'],$values['t_id']);
			$task->transfer(Precurio_Session::getCurrentUserId(),$values['user_id'],"");
			return;
		}
	}
	protected  function getAppName()
	{
		return "task";
	}
}

?>