<?php


require_once 'Zend/Controller/Action.php';
require_once ('team/models/vo/Team.php');
class Team_IndexController extends Zend_Controller_Action {
	/**
	 * The default action - list all teamrooms user can access
	 */
	public function indexAction()
	{
		Precurio_Session::getLicense()->validate();
		$this->renderScript('list.phtml');
	}
	public function newAction()
	{
		$this->renderScript('create.phtml');
	}
	public function editAction()
	{
		$id = $this->getRequest()->getParam("id");
		$team = Team::get($id);
		if(empty($team) || !$team->canAccess(Precurio_Session::getCurrentUserId()))
			throw new Precurio_Exception(PrecurioStrings::CANNOTACCESSRESOURCE,Precurio_Exception::EXCEPTION_NO_ACCESS);
		$this->view->team = $team;
		$this->renderScript('edit.phtml');
	}
	public function updateAction()
	{
		$params = $this->getRequest()->getPost();
		$team = Team::get($params['id']);

		if(empty($team) || !$team->canAccess(Precurio_Session::getCurrentUserId()))
			throw new Precurio_Exception(PrecurioStrings::CANNOTACCESSRESOURCE,Precurio_Exception::EXCEPTION_NO_ACCESS);

		$team->title = $params['title'];
		$team->description = $params['description'];
		$team->save();

		$team->setApps($params['apps']);

		$this->_redirect($team->getUrl());
	}
	public function submitAction()
	{
		$this->_helper->layout->disableLayout();
		$this->_helper->viewRenderer->setNoRender();

		$timestamp = Precurio_Date::now()->getTimestamp();
		$params = $this->getRequest()->getPost();

		if(empty($params['title']))
		{
			echo $this->view->translate(PrecurioStrings::ERROR_PERFORMING_OPERATION);
			return;
		}

		$id = Team::create($params);
		$team = Team::get($id);
		$this->_redirect($team->getUrl());
	}
	/**
	 * Used to delete a teamroom. Called via AJAX.
	 */
	public function deleteAction()
	{
		$team = Team::get($this->getParam('id'));

		if(empty($team) || !$team->canAccess(Precurio_Session::getCurrentUserId()))
			throw new Precurio_Exception(PrecurioStrings::CANNOTACCESSRESOURCE,Precurio_Exception::EXCEPTION_NO_ACCESS);

		$team->do_delete();
	}
	public function init()
	{
		$root = Zend_Registry::get('root');
		if($this->view->theme != 'default')
			$this->view->addScriptPath($root .  '/application/default/layouts/default/team');
		$this->view->addScriptPath($root .  '/application/default/layouts/'.$this->view->theme.'/team');
	}
}
