<?php
require_once('task/models/vo/TaskFolder.php');
require_once('user/models/vo/User.php');
require_once ('task/models/vo/Task.php');
require_once("team/models/vo/TeamTask.php");
class Tasks {
		/**
		 * Get all tasks associated with a user  (with option for pagination)
		 * @param int $user_id
		 * @param $limit - int - Number of records per page.Works with $page.
		 * @param $page - int - Set page number if you want to paginate result.
		 * @version 4
		 * @return array
		 */
		public static function getAll($user_id,$limit=0,$page=1)
		{
			$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::TASK, 'rowClass'=>'Task'));
			$select = $table->select(false);
			$select->setIntegrityCheck(false);
			$select->setTable($table);

			$select = $select->distinct()
							->from(array('a' => PrecurioTableConstants::TASK))
							->join(array('b' => PrecurioTableConstants::TASK_USERS),'a.id = b.task_id',array('user_id','is_proxy','is_transfer','date_assigned'=>'date_created'))
							->where('a.active = 1 AND b.active= 1 AND (a.creator_user_id = ? OR b.user_id = ?)' ,$user_id)
							->order('status asc')->order('id desc');
			$tasks = $table->fetchAll($select);
			//remove duplicates caused by joining to table "task_users"
			$result = array();
			foreach($tasks as $task)
			{
				$result[$task->getId()] = $task;
			}
			
			if($limit)
			{
			    $offset = ($page - 1) * $limit;
			    $result = array_slice($result, $offset,$limit);
			}
			/*
			 * Apply custom sort.
			 *
			 * First tasks should sorted normlly by due date (with the task due earliest appearing first)
			 * Then we want to see tasks that are overdue.
			 * And finally, tasks that are complete.
			 */

			usort($result, function($a,$b){
				if($a->isComplete() && $b->isComplete())return 0;
				if($a->isComplete() && !$b->isComplete())return 1;
				if(!$a->isComplete() && $b->isComplete())return -1;

				if($a->isDue() && $b->isDue())return 0;
				if($a->isDue() && !$b->isDue())return 1;
				if(!$a->isDue() && $b->isDue())return -1;

				if(empty($a->end_time) && empty($b->end_time))return $a->id > $b->id ? -1 : 1;
				if(empty($a->end_time) && !empty($b->end_time))return 1;
				if(!empty($a->end_time) && empty($b->end_time))return -1;

				return $a->end_time < $b->end_time ? -1 : 1;
			});
			return $result;
		}

		/**
		 *
		 * @param $creator_id int user_id of the user requesting content approval
		 * @param $content_id int
		 * @param $type string constant, the type of content.
		 * @return int Id of new task
		 */
		public function addContentTask($creator_id,$content_id,$type,$group_id = 0)
		{
			$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::CONTENT_APPROVAL));
			$select = $table->select();

			$field = strtolower($type);
			$select = $select->where("$field = 1")->where('group_id = ?',$group_id);

			$rows = $table->fetchAll($select);
			if($rows->count() == 0)//no user to approve
			{
				$obj = new stdClass();
				$obj->creator_id = $creator_id;
				$obj->content_id = $content_id;
				$obj->content_type = $type;
				$log = Zend_Registry::get('log');
				$log->warn('There was no user to assign task : '.serialize($obj));
			}
			//if we have more than one person approving this type of content
			//randomly select someone.
			if($rows->count() > 1)
			{
				$c = $rows->count();
				$i = rand(0,$c-1);
				$rows->seek($i);
			}

			$rec = $rows->current();
			//user_id is the ID of the user who will be assigned the task of approving the content.
			//if rec is null, i.e. there was no user to assign task, simply assign approval to the owner of the content/
			$user_id =  $rec== null ? $creator_id : $rec->user_id;
			$start = Precurio_Date::now()->getTimestamp();
			$end = $start + (48 * 60 * 60 );//you've got 48hrs to approve mehn

			$translate = Zend_Registry::get('Zend_Translate');
			$description = "<a href='<?php echo $this->baseUrl();?>/cms/view/details/c_id/{$content_id}' class='contentTask'>".$translate->translate('click here to view content')."</a>";
			if($group_id != 0)
				$description = $translate->translate("Your group needs you to approve a content")." <br/>".$description;
			$data = array(
			'type'=>$type,
			'creator_group_id'=>$group_id,
			'creator_user_id'=>$creator_id,
			'user_id'=>$user_id,
			'title'=>$translate->translate(PrecurioStrings::TASKCONTENTAPPROVAL).' : '.$type,
			'duration'=>48,
			'start_time'=>$start,
			'end_time'=>$end,
			'description'=>$description,
			'status'=>Task::STATUS_OPEN,
			'date_created'=>$start,
			'active'=>1

			);
			return $this->addTask($data);

		}

		/**
		 * @param $data Array - task data to insert
		 * @param $returnID Boolean - indicate where you want to return the insert ID, or not (default=false)
		 * @return int|string Returns the new task id, or the operation status if $returnID is false;
		 */
		public function addTask ($data,$returnID = false)
		{
			$tr = Zend_Registry::get('Zend_Translate');
			
			$user_id = $data['user_id'];
			
			if(isset($data['id']))unset($data['id']);//you must do this else lastInsertId wont work
			$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::TASK,'rowClass'=>'Task'));
			$msg = "";
			try
			{
				$row = $table->createRow($data);
				$id = $row->save();

				$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::TASK_USERS));

				$data['user_id'] = $user_id;
				$data['task_id'] = $id;
				$data['is_active'] = 1;//very important. to differentiate this guy from the other guys

				$row = $table->createRow();
				$row->setFromArray($data);
				$row->save();

				Precurio_Activity::create(Task::APPID,Task::ACTIVITY_NEW,$id,$data['creator_user_id']);

				$task = Task::get($id);
				//if user is out of office, reassign task to proxy. 
				//Also make sure the original user follows the task
				$outObj  = UserUtil::getUser($user_id)->outOfOffice();
				if($outObj)//if user is out of office get proxy, and assign to proxy
				{
					$proxy = $outObj->getProxy();
					$task->addUser($proxy->getId(),false, true,true);
				}
				$task->index();

			}
			catch (Exception $e)
			{
				$msg = $e->getMessage();//$tr->translate(PrecurioStrings::ERROR_PERFORMING_OPERATION);
				$log = Zend_Registry::get('log');
				$log->err($e);
			}


			return $returnID ? $id : $msg;

		}
		/**
		 * Gets the people a user assigns tasks ordered by the most assigned to least assigned
		 * Returns rowset of objects containing a user_id property.
		 * @param int $user_id
		 * @version 4
		 * @return Zend_Db_Table_Rowset_Abstract
		 */
		public static function getUserFriends($user_id)
		{
			$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::TASK_USERS));
			$select = $table->select();
			$select->setIntegrityCheck(false);
			$select->setTable($table);

			$select = $select->from($table,array('count(*) as num','user_id'))
			->join(array('b' => PrecurioTableConstants::TASK),'task_id = b.id',array())
			->where('creator_user_id = ?',$user_id)
			->group('user_id')
			->order('num desc');
			return $table->fetchAll($select);
		}
}

?>