<?php

/**
 * IndexController
 *
 * @author Precurio
 * @version 4
 */

require_once 'Zend/Controller/Action.php';
require_once('task/models/Tasks.php');
require_once('task/models/vo/Task.php');
require_once ('task/models/vo/TaskFolder.php');
class Task_IndexController extends Zend_Controller_Action {
	/**
	 * The default action - show the home page
	 */
	public function indexAction() {
	    
	    $page = $this->getRequest()->getParam('page',1);
	    $limit = 5;
	    
		$this->view->tasks = Tasks::getAll(Precurio_Session::getCurrentUserId(),$limit,$page);
		
		$this->view->pageCount = $limit;
		$this->view->cpage = $page;
		$this->renderScript('templates/tasks.phtml');
	}
	public function viewAction()
	{
		$task_id = $this->getRequest()->getParam('id',0);
		$task = Task::get($task_id);

		if(!$task->isActive())$this->redirect('/task');
		if(empty($task))
		{
			throw new Precurio_Exception(PrecurioStrings::INVALIDPAGEACCESS, Precurio_Exception::EXCEPTION_INVALID_CONTENT);
		}
		if(!$task->canAccess(Precurio_Session::getCurrentUserId()))
		{
			throw new Precurio_Exception(PrecurioStrings::CANNOTACCESSRESOURCE, Precurio_Exception::EXCEPTION_NO_ACCESS);
		}

		$this->view->task = $task;
		$this->renderScript('templates/task.phtml');
	}
	public function exportAction()
	{
		$this->_helper->layout->disableLayout();
		$this->_helper->viewRenderer->setNoRender();

		$task_id = $this->getRequest()->getParam('id',0);
		$task = Task::get($task_id);
		if(!$task->isActive())$this->redirect('/task');
		if(empty($task))
		{
			throw new Precurio_Exception(PrecurioStrings::INVALIDPAGEACCESS, Precurio_Exception::EXCEPTION_INVALID_CONTENT);
		}
		if(!$task->canAccess(Precurio_Session::getCurrentUserId()))
		{
			throw new Precurio_Exception(PrecurioStrings::CANNOTACCESSRESOURCE, Precurio_Exception::EXCEPTION_NO_ACCESS);
		}

		$iCal = $task->export();
		$filename = $task->getTitle().".ics";
		$this->getResponse()->setHeader('Content-Description','File Transfer');
		$this->getResponse()->setHeader('Content-Disposition',"attachment; filename=$filename");
		$this->getResponse()->setHeader('Content-Type','text/calendar');
		$this->getResponse()->setHeader('Content-Transfer-Encoding','binary');
		echo $iCal;
	}
	public function addAction()
	{
		if(isset($this->_helper->layout))
			$this->_helper->layout->disableLayout();
		//if there is a request_id, assign it to the view
		$request_id = $this->getRequest()->getParam('request_id',0);
		$opportunity_id = $this->getRequest()->getParam('opportunity_id',0);
		//$this->view->form = $this->getForm(null,$request_id,$opportunity_id);
		$this->renderScript("new_task.phtml");
	}
	public function deleteAction()
	{
		$this->_helper->layout->disableLayout();
		$this->_helper->viewRenderer->setNoRender();

		if(!$this->getRequest()->isPost())return;

		$values = $this->getRequest()->getPost();

		if(empty($values['task_id']))return;
		$task = Task::get($values['task_id']);
		if(empty($task))return;

		$task->do_delete();
	}
	public function downloadAction()
	{
		$this->_helper->layout->disableLayout();
		$this->view->task_id = $this->getRequest()->getParam('id');
		$this->view->type = $this->getRequest()->getParam('type');
		$this->getResponse()->setHeader('Content-Description','File Transfer');
		$this->getResponse()->setHeader('Content-Disposition',"attachment; filename=Mytask.doc");
		$this->getResponse()->setHeader('Content-Type','application/msowrd');
		$this->getResponse()->setHeader('Content-Transfer-Encoding','binary');
		$this->render('view');
	}
	public function submitAction()
	{
		$this->_helper->layout->disableLayout();
		$this->_helper->viewRenderer->setNoRender();

		$timestamp = Precurio_Date::now()->getTimestamp();
		$params = $this->getRequest()->getPost();
		if(empty($params['user_id']) || empty($params['title']))
		{
			echo $this->view->translate(PrecurioStrings::ERROR_PERFORMING_OPERATION);
			return;
		}
		$values = array();
		$values['creator_user_id'] = Precurio_Session::getCurrentUserId();
		$values['date_created'] = $timestamp;
		$values['start_time'] = $timestamp;
		$values['end_time'] = $timestamp + (24 * 60 * 60);//end time defaults to 24hours
		$values['title'] = $params['title'];
		$values['user_id'] = $params['user_id'];
		$values['description'] = isset($params['description']) ? $params['description'] : '';

		$tasks = new Tasks();
		if(Precurio_Utils::isNull($values['id']))
		{
			$result = $tasks->addTask($values,true);
		}
		else
		{
			//do nothing
		}
		if(empty($result))
		{
			echo $this->view->translate(PrecurioStrings::ERROR_PERFORMING_OPERATION);
			return;
		}
	}
	public function updateAction()
	{
		$this->_helper->layout->disableLayout();
		$this->_helper->viewRenderer->setNoRender();
		if(!$this->getRequest()->isPost())return;

		$values = $this->getRequest()->getPost();

		if(empty($values['task_id']))return;

		$task = Task::get($values['task_id']);

		if(empty($task))return;

		switch($values['form'])
		{
			case 'date':
				$end_time = mktime(17,0,0,$values['month'],$values['day'],$values['year']);//tasks are due by close of business (5pm)
				$task->updateDate($end_time);
			break;
			case 'status':
				$task->updateStatus($values['status'],Precurio_Session::getCurrentUserId());
			break;
			case 'add_user':
				if($values['user_id'])
					$task->addUser($values['user_id']);
			break;
			case 'remove_user':
				if($values['user_id'])
					$task->removeUser($values['user_id']);
			break;
			case 'remove_file':
				if($values['content_id'])
					$task->getFolder()->removeContents($values['content_id']);
			break;
		}

		return;
	}
	public function searchdataAction()
	{
		$this->_helper->layout->disableLayout();
		$this->_helper->viewRenderer->setNoRender();

		$tr = Zend_Registry::get('Zend_Translate');
		$label = $tr->translate("Created by {1} on {2}.");

		$tasks = Tasks::getAll(Precurio_Session::getCurrentUserId());

		$results = array();
		foreach($tasks as $task)
		{
			$obj = new stdClass();
			$obj->id  = $task->getId();
			$obj->title = $task->getTitle();
			$obj->label = getLocalizedString($label,$task->getOwner(),$task->getDateCreated());
			$obj->url = $task->getUrl();
			$results[] = $obj;
		}
		echo json_encode($results);
	}
	public function transferAction()
	{
		$this->_helper->layout->disableLayout();
		if($this->getRequest()->isPost())
		{
			$this->_helper->viewRenderer->setNoRender();

			$values = $this->getRequest()->getPost();

			$task = Task::get($values['task_id']);
			$task->transfer(Precurio_Session::getCurrentUserId(),$values['user_id'],"");
			return;
		}
	}
	public function remindAction()
	{
		$this->_helper->layout->disableLayout();
		$this->_helper->viewRenderer->setNoRender();
		try
		{
			$user_id = Precurio_Session::getCurrentUserId();
		}
		catch (Exception $e)
		{
			$str = Zend_Json::encode(array());
			echo $str;
			return;
		}

		$remind = array();
		$now = Precurio_Date::now()->getTimestamp();
		$min45 = 45 * 60;
		$min15 = 15 * 60;

		$tasks = new Tasks();
		$pendingTasks = $tasks->getTasksByStatus(false);
		foreach ($pendingTasks as $task)
		{
			$date = new Precurio_Date($task->end_time);
			//if it is not today and later, please skip
			if(!($date->isToday() && $date->isLater(Precurio_Date::now())))
				continue;

			$obj = array();
			$obj['title'] = $task->title;
			$obj['id'] = $task->id;
			$obj['when'] = $date->get(Precurio_Date::TIMES);

			$diff = $date->getTimestamp() - $now;//number of seconds till task.

			if($diff > 3600)//if it is still more than an hr ahead, ignore.
			{
				continue;
			}
			else if($diff > $min45)
			{
				$obj['time'] = $diff - $min45;//number of seconds till its 45minutes to task
				$obj['type'] = '45';
			}
			else if($diff > $min15)
			{
				$obj['time'] = $diff - $min15;//number of seconds till its 15minutes to task
				$obj['type'] = '15';
			}
			else
			{
				$obj['time'] = $diff;//number of seconds to task
				$obj['type'] = '0';
			}

			$remind[] = $obj;

		}
		$str = Zend_Json::encode($remind);
		echo $str;
		return;
	}
	public function init()
	{
	    $root = Zend_Registry::get('root');
	    if($this->view->theme != 'default')
	        $this->view->addScriptPath($root .  '/application/default/layouts/default/views/task');
	    $this->view->addScriptPath($root .  '/application/default/layouts/'.$this->view->theme.'/views/task');
	}
}
?>