<?php
/**
 * TagController
 *
 * @author
 * @version
 */
require_once 'Zend/Controller/Action.php';
require_once 'link/models/Links.php';
class Link_TagsController extends Zend_Controller_Action
{

    public function indexAction ()
    {
    	$this->_helper->layout()->setLayout(PrecurioLayoutConstants::MAIN_REPORT);
    	$params = $this->getRequest()->getParams();
    	$this->view->params = $params;
    	$this->_forward('index','index','link',$params);
    }
    /**
     * Action handles viewing all tags used by a user
     */
    public function userAction()
    {
		$user_id = $this->getRequest()->getParam('id');
		$this->view->user_id = $user_id;
		$this->view->tags = UserTag::getAll($user_id);
    }
	/**
	 * Action handles viewing all links tagged by a specifc tag
	 */
	public function viewAction()
    {

    }
    /**
     * Action handles getting the most popular tags
     */
    public function popularAction()
    {
		$this->view->tags = UserTag::getPopularTags();
    }
    /**
     *  Action handles getting the most popular people
     */
    public function peopleAction()
    {
		$this->view->people = Links::getPopularPeople();
    }
}
?>