<?php

/**
 * DocumentController
 *
 * @author
 * @version
 */

require_once 'extranet/controllers/BaseController.php';
require_once 'discussion/models/vo/Discussion.php';
require_once 'discussion/models/vo/DiscussionCategory.php';
class Extranet_DiscussionController extends Extranet_BaseController {
	public function indexAction()
	{
		$user_id = Precurio_Extranet::getCurrentUserId();
		$user = ExtranetUser::get($user_id);
		$discussions = $user->getDiscussions();
		$this->view->discussions = $discussions;
	}
	public function viewAction()
	{
		$id = $this->getRequest()->getParam('id');
		$discussion = Discussion::get($id);
		if(empty($discussion) || !$discussion->isActive() || !$discussion->canAccess(Precurio_Extranet::getCurrentUserId()))
			throw new Precurio_Exception(PrecurioStrings::CANNOTACCESSRESOURCE, Precurio_Exception::EXCEPTION_NO_ACCESS);

		$this->view->discussion  = $discussion;
		Precurio_Activity::create(Discussion::APPID,Discussion::ACTIVITY_VIEW,$id,Precurio_Extranet::getCurrentUserId());
	}
	public function commentAction()
	{
		if(isset($this->_helper->layout))
			$this->_helper->layout->disableLayout();
		$this->_helper->viewRenderer->setNoRender();

		$params = $this->getRequest()->getPost();
		$discussion = Discussion::get($params['id']);
		$user_id = Precurio_Extranet::getCurrentUserId();

		if(empty($discussion) || !$discussion->isActive() || !$discussion->canAccess($user_id))
			throw new Precurio_Exception(PrecurioStrings::CANNOTACCESSRESOURCE, Precurio_Exception::EXCEPTION_NO_ACCESS);

		$message = trim($params['message']);
		if(!empty($message))
			$discussion->postMessage($user_id,$params['message']);

		$this->redirect(Precurio_Extranet::getBaseUrl().'/discussion/view/id/'.$params['id']);
	}

}
?>