<?php
require_once ('event/models/vo/Event.php');
class Events {

	public static function getEvents($user_id,$location_id=null, $work_related=null)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::USER_EVENTS, 'rowClass'=>'Event'));
		$select = $table->select(false);
		$select->setIntegrityCheck(false);
		$select->setTable($table);
		$select = $select
						->from(array('a' => PrecurioTableConstants::EVENT))
						->join(array('b' => PrecurioTableConstants::USER_EVENTS),'a.id = b.event_id',array('date_invited'=>'date_created'))
						->join(array('c' => PrecurioTableConstants::USERS),'a.user_id = c.user_id',array('first_name','last_name','profile_picture_id'))
						->where('a.is_open = 1 OR (a.is_open = 0 AND b.invitee_id= ? )',$user_id)
						->where('a.active=1')
						->order('start_timestamp asc');
		if($location_id !== null)//i.e if user if filtering by event type
			$select = $select->where('a.location_id=?',$location_id);
		if($work_related !== null)//i.e if user if filtering by event type
			$select = $select->where('a.work_related = ?',$work_related);
//		$db = Zend_Registry::get('db');
//		$st = $db->query($select);
//		Precurio_Utils::debug($st);

		$result = array();
		$all = $table->fetchAll($select);
		foreach($all as $event)
			$result[$event->id] = $event;
		return $result;
	}
	public static function getMyEvents($user_id,$location_id, $work_related)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::USER_EVENTS, 'rowClass'=>'Event'));
		$select = $table->select();
		$select->setIntegrityCheck(false);
		$select->setTable($table);
		$select = $select
						->from(array('a' => PrecurioTableConstants::EVENT))
						->join(array('c' => PrecurioTableConstants::USERS),'a.user_id = c.user_id',array('first_name','last_name','profile_picture_id'))
						->where('a.user_id= ? ',$user_id)
						->where('a.active=1')
						->order('a.id desc');
		if($work_related !== null)//i.e if user if filtering by event type
			$select = $select->where('a.work_related = ?',$work_related);
		if($location_id !== null)//i.e if user if filtering by location
			$select = $select->where('a.location_id=?',$location_id);

		$all = $table->fetchAll($select);
		return $all;
	}
	public static function createEvent($data)
	{
		//insert into events table
		if(isset($data['id']))
		{
			unset($data['id']);
		}
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::EVENT));
		$newEvent = $table->createRow($data);
		$event_id = $newEvent->save();

		//immediately invite creator.
		$data = array();
		$user_id = Precurio_Session::getCurrentUserId();
		$date_created = Precurio_Date::now()->getTimestamp();
		$data['event_id'] = $event_id;
		$data['invitee_id'] = $user_id;
		$data['date_created'] = $date_created;
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::USER_EVENTS));
		$invite = $table->createRow($data);
		$invite->save();

		$event = Event::get($event_id);
		$event->index();

		//now create new activity., which also triggers notifications.
		Precurio_Activity::create(Event::APPID, Event::ACTIVITY_ADD_EVENT, $event_id, $user_id);
		return $event_id;
	}
	public static function updateEvent($data)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::EVENT));

		try
		{
			$event = $table->find($data['id'])->current();
			$event->setFromArray($data);
			$event->save();
			Precurio_Activity::create(Event::APPID, Event::ACTIVITY_EDIT_EVENT, $data['id'], Precurio_Session::getCurrentUserId());
		}
		catch (Exception $e)
		{
			$log = Zend_Registry::get('log');
			$log->err($e);
		}
		return $event;
	}
}

?>