<?php
require_once ('cms/models/vo/Category.php');
require_once ('document/models/vo/Document.php');
require_once ('document/models/vo/IDocumentObject.php');
class Folder extends Category implements IDocumentObject
{
	protected $categoryClass = 'Folder';//class used to represent a category record.
	protected $documentClass = 'Document';//class used to represent a document record.
	protected $lastDocument; //Document object to hold the last document in te folder
	/**
	 * Returns the total size of the category
	 * @param $formatted OPTIONAL - Set to true if you want the size formatted eg 10MB. Default is true
	 * @return string|long
	 */
	public function getSize($formatted = true)
	{
	    return "";
	    /**Stop execution, causes performance issues.**/
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::CONTENT_CATEGORYS));
		$select = new Zend_Db_Table_Select($table);
		$select->setIntegrityCheck(false);
		$select = $select->from(array('a' => PrecurioTableConstants::CONTENT_CATEGORYS),array('category_id'))
						->join(array('b' => PrecurioTableConstants::DOCUMENTS),'a.content_id = b.content_id',array('size'=>'SUM(file_size)'))
						->join(array('c' => PrecurioTableConstants::CONTENT),'b.content_id = c.id',array())
						->where('a.category_id = ?',$this->getId())
						->where('a.active=1')
						->where('c.active=1')
						->group('a.category_id');
		$row = $table->fetchRow($select);
		return empty($row) ? '' : ($formatted ? Document::formatSize($row->size) : $row->size);
	}
	/**
	 * Returns the date modified as a Date object
	 * We do this by checking date of last document. if no document, we return folder date created
	 * @return Precurio_Date
	 */
	public function getDateModified()
	{
	    $document = $this->getLastDocument();
	    
	    return empty($document) ?  new Precurio_Date($this->date_created) : $document->getDateModified();
	}

	/**
	 * Returns the user who last modified the contents of this folder.
	 * We do this by checking the most recent entry in document history.
	 * @return User
	 */
	public function getLastModifiedBy()
	{
	    $document = $this->getLastDocument();
	     
	    return empty($document) ?  $this->getOwner() : $document->getOwner();
	}
	/**
	 * Returns the icon to use for display
	 * @return string
	 */
	public function getIcon()
	{
		return "Folder.png";
	}
	/**
	 * Returns the url to view the folder (without prefixing the base url)
	 * @return string
	 */
	public function getUrl()
	{
		return '/document/category/view/id/'.$this->id;
	}
	/**
	 *
	 * version 3 implementation.
	public function getType()
	{

		$numFiles = count($this->getContentChildren(false));
		$numFolders = count($this->getCategoryChildren(false));
		$tr = Zend_Registry::get('Zend_Translate');
		if($numFiles == 0)
		{
			if($numFolders == 0)
			{
				return $tr->translate('Empty Folder');
			}
			else
			{
				return getLocalizedString($tr->translate('Folder ({1} subfolders)'),$numFolders);
			}
		}
		return getLocalizedString($tr->translate('Folder ({1} files)'),$numFiles);
	}
	 */
	/**
	 * Get folder type. (whether it is locked, empty, private or shared.)
	 * @return string
	 */
	public function getType()
	{
		$tr = Zend_Registry::get('Zend_Translate');

		if($this->isLocked())return $tr->translate("Locked");
		
		if($this->getAccessType() == Folder::ACCESS_PRIVATE)return $tr->translate('Private');
		if($this->getAccessType() == Folder::ACCESS_SHARED)return $tr->translate('Shared');
		
		return $tr->translate("Folder");
/**We do not execute the code below because of performance implication**/
		$numFiles = count($this->getContentChildren(false));
		$numFolders = count($this->getCategoryChildren(false));
		if($numFiles == 0 && $numFolders == 0)return $tr->translate('Empty');
		return empty($numFiles) ?
			getLocalizedString($tr->translate('Folder ({1} sub-folders)'),$numFolders) :
				getLocalizedString($tr->translate('Folder ({1} files)'),$numFiles);
	}
	/*
	 * The reason why we implemented this function is so we can
	 * only return content children that are documents.
	 * And we achieve that by creating join relationship with the documents table
	 * (non-PHPdoc)
	 * @see Category::getContentChildren()
	 */
	public function getContentChildren($recursive = true)
	{
		$categorys = array();
		$contents = array();
		//if you want to get all children (both direct and indirect), you have to first get all sub categorys
		if($recursive)
		{
			$categorys = $this->getCategoryChildren(true);
		}
		array_unshift($categorys,$this);//add this category
		
		$user_id = Precurio_Session::getCurrentUserId();

		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::CONTENT,'rowClass'=>$this->documentClass));
		foreach ($categorys as $category)
		{
			$select = new Zend_Db_Table_Select($table);
			$select->setIntegrityCheck(false);
			$select = $select->from(array('a' => PrecurioTableConstants::CONTENT),Document::$requiredContentProp)
							->join(array('b' => PrecurioTableConstants::CONTENT_CATEGORYS),'a.id = b.content_id',array())
							->join(array('c' => PrecurioTableConstants::DOCUMENTS),'a.id = c.content_id',Document::$requiredDocumentProp)
							->where('b.category_id = ?',$category->id)
							->where('a.active=1')
							->where('b.active=1')
							->order('c.last_modified desc');
			$temp = $table->fetchAll($select);
			foreach($temp as $t)//get contents Zend_Db_Table_RowSet into array , by looping.
			{
			    if(!$t->canAccess($user_id))continue;
				$contents[$t->id] = $t;//using $contents[$t->id] instead of  solves the issue of duplicate contents, since  already existing contents will replace themselves
			} 
		}

		return $contents;
	}
	public function isCheckedOut()
	{
		return false;
	}
	/**
	 * Creates another copy of this folder
	 * @param array $data - array containing unique values for new folder
	 * @param boolean $copyContent - Set to true if you want to copy the contents of the folder too.
	 * @return int - id of new folder
	 */
	public function createCopy($data,$copyContent=true)
	{
		$data['date_created'] = time();
		$data = array_merge($this->_data,$data);//new value in $data will overwite row data
		unset($data['id']);
		$id =  Folders::createNew($data);
		if($copyContent)
		{
			//for now, we only copy 'file' contents.
			//problem with copying folder contents is that
			// we also have to copy contents of those folders, which
			//leads to recurssion (complexity).
			//Future versions may support copying 'folder' contents too.
			$files = $this->getContentChildren(false);
			$content_ids = array();
			foreach($files as $file)$content_ids[] = $file->getContentId();
			$folder = Folder::get($id);
			$folder->addContents($content_ids);
		}
		return $id;
	}
	/**
	 * Very similar with static function getCategory(), just different rowClass.
	 * @param int $id id of category
	 * @return Folder
	 */
	public static function get($id)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::CATEGORYS,'rowClass'=>'Folder'));
		$item = $table->fetchRow($table->select()->where('id = ?',$id));
		return $item;
	}
	/**
	 * Gets the last document uploaded to the folder
	 * @return Document | null
	 */
	protected function getLastDocument()
	{
	    if(empty($this->lastDocument))
	    {
	        $table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::CONTENT_CATEGORYS));
	        $row  = $table->fetchRow($table->select()->where("category_id = ?",$this->getId())->where("active = 1")->order("date_created DESC"));
	        try{
	            $this->lastDocument = empty($row) ? null : Documents::getDocument($row->content_id);
	        }
	        catch(Exception $e){
	            return null;
	        }
	    }
	    
	    return $this->lastDocument;
	}

}
?>