<?php
require_once ('document/models/vo/Folder.php');
require_once ('document/models/vo/RootFolder.php');
class Folders
{
	/**
	 * Get folders that were recently modified/updated
	 * @param int OPTIONAL $limit - defaults to 10
	 * @return array of Folder objects
	 */
	public static function getRecent($limit = 10)
	{
		$folders = array();
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::CONTENT_CATEGORYS));
		$select = new Zend_Db_Table_Select($table);
		$select->setIntegrityCheck(false);
		$select = $select->from(array('a' => PrecurioTableConstants::CONTENT_CATEGORYS))
						->join(array('b' => PrecurioTableConstants::DOCUMENTS),'a.content_id = b.content_id',Document::$requiredDocumentProp)
						->join(array('c' => PrecurioTableConstants::CONTENT),'b.content_id = c.id',array())
						->where('a.active=1')
						->where('a.category_id>0')
						->where('c.active=1')
						->order('b.last_modified desc');
		$rows = $table->fetchAll($select);
		foreach($rows as $row)
		{
			if(count($folders) > $limit)break;
			$folders[$row->category_id] = Folder::get($row->category_id);
		}
		return $folders;
	}
	/**
	 * Creates a new folder
	 * @param array $data
	 * @return int - id of created folder
	 */
	public static function createNew($data)
	{
		if(empty($data['id']))unset($data['id']);//trick statement. Will only unset when data[id] = 0;
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::CATEGORYS));
		$row = $table->createRow();$row->setFromArray($data);
		$id = $row->save();

		if(isset($data['group_id']))
		{
			$data['category_id'] = $id;
			$data['active'] = 1;
			$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::GROUP_CATEGORYS));
			$row = $table->createRow();$row->setFromArray($data);
			$row->save();

		}
		return $id;
	}
}
?>