<?php

/**
 * Discussion CategoryController
 *
 * @author
 * @version
 */
require_once 'Zend/Controller/Action.php';
require_once 'discussion/models/vo/Discussion.php';
require_once 'discussion/models/vo/DiscussionCategory.php';
class Discussion_CategoryController extends Zend_Controller_Action {

	public function viewAction(){
		$category_id = $this->getRequest()->getParam('id');
		$category = DiscussionCategory::get($category_id);

		if(!$category->canAccess(Precurio_Session::getCurrentUserId()))
			throw new Precurio_Exception($this->view->translate(PrecurioStrings::CANNOTACCESSRESOURCE),Precurio_Exception::EXCEPTION_NO_ACCESS);

		$this->view->category = $category;
		$this->renderScript("category.phtml");
	}
	public function editAction(){
		$category_id = $this->getRequest()->getParam('id');
		$category = DiscussionCategory::get($category_id);

		if(!$category->canModify(Precurio_Session::getCurrentUserId()))
			throw new Precurio_Exception($this->view->translate(PrecurioStrings::CANNOTACCESSRESOURCE),Precurio_Exception::EXCEPTION_NO_ACCESS);

		$this->view->category = $category;
		$this->renderScript("new_category.phtml");
	}
	public function addAction(){
		$this->renderScript("new_category.phtml");
	}
	public function submitAction(){
		$this->_helper->layout->disableLayout();
		$this->_helper->viewRenderer->setNoRender(true);
		$params = $this->getRequest()->getPost();

		$params['appid'] = 'discussion';
		$params['is_folder'] = 0;
		$params['user_id'] = Precurio_Session::getCurrentUserId();
		$params['date_created'] = Precurio_Date::now()->getTimestamp();
		if(empty($params['title']))return;
		if(empty($params['id']))//create the category
			$params['id'] = Category::create($params);

		$category = DiscussionCategory::get($params['id']);

		if(empty($category))return;

		//remove all category to groups relationship
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::GROUP_CATEGORYS));
		$table->delete("category_id = ".$params['id']);

		if(empty($params['group_ids']))
		{
			unset($params["id"]);
			$params['access_type'] = Category::ACCESS_PUBLIC;
			$category->setFromArray($params);
			$category->save();
		}
		else
		{
			unset($params["id"]);
			$params['access_type'] = Category::ACCESS_SHARED;
			$category->setFromArray($params);
			$category->save();
			$category->addGroups($params['group_ids']);
		}
		$this->redirect($category->getUrl());
	}
	public function deleteAction()
	{
		$this->_helper->layout->disableLayout();
		$this->_helper->viewRenderer->setNoRender();
		$category_id = $this->getRequest()->getParam('id');
		$category = DiscussionCategory::get($category_id);

		if(!$category || !$category->canModify(Precurio_Session::getCurrentUserId()))
			throw new Precurio_Exception($this->view->translate(PrecurioStrings::CANNOTACCESSRESOURCE),Precurio_Exception::EXCEPTION_NO_ACCESS);

		$category->do_delete();
	}
	public function init()
	{
		$root = Zend_Registry::get('root');
		if($this->view->theme != 'default')
			$this->view->addScriptPath($root .  '/application/default/layouts/default/views/discussion');
		$this->view->addScriptPath($root .  '/application/default/layouts/'.$this->view->theme.'/views/discussion');
	}
}
