<?php

/**
 * IndexController - The default controller class
 *
 * @author
 * @version
 */

class IndexController extends Zend_Controller_Action
{
	/**
	 */
	public function preDispatch()
	{
		$this->_helper->layout->disableLayout();
	}
    public function indexAction()
    {
    	$this->_helper->viewRenderer->setNoRender();
		$this->_helper->layout->disableLayout();
		
		
	    $config = Zend_Registry::get('config');
	    
        //if single sign on is enabled, get windows user and sign on.
	    if(!empty($config->enable_sso))
	    {
	        if($_SERVER['REMOTE_USER'])
	        {
		        $cred = explode('\\',$_SERVER['REMOTE_USER']);
		        if (count($cred) == 1) array_unshift($cred, false);
		        list($domain, $username) = $cred;
		        try 
		        {
    		        //validate the user with active directory. SSO must be used with Active directory
    		        $auth = $this->_helper->getHelper('LdapAuth');
    		        $auth->validate($username,'ldap_password'.$username,true);//this method will create the user if it does not exist
		        
    		        Precurio_Session::setCurrentUser($auth->getUser());
		            $this->_redirect('/default/index/home');
		        }
	           catch (Exception $e)//i.e there was a problem validating SSO
        		{
        			//simply do nothing and continue execution
	               //throw new Exception("You enabled Single Sign-on, but user credential was not detected", 1401);
        		}
	        }
	    }
	    
	    //if anonymous access is enabled, get guest user and go to home page
	    if(!empty($config->allow_anonymous_user))
	    {
	        try
	        {
		        $user_id = Precurio_Session::getCurrentUserId();
		        $this->_redirect('/default/index/home');
	        }
	        catch (Precurio_Exception $e)//i.e there was a problem retrieving the session user
	        {
	            //simply do nothing and continue execution
	        }
	    }
	    
	    

    	$this->_forward('login','login');
    	return;
    }
    public function homeAction()
    {
    	Precurio_Session::getLicense()->validate();
    	$this->view->activityLimit = $this->getRequest()->getParam('l',10);
    	$this->_helper->layout->setLayout(PrecurioLayoutConstants::MAIN);
    }
}
