<?php
require_once ('cms/models/vo/Fact.php');
require_once ('cms/models/vo/Category.php');
require_once ('cms/models/vo/Page.php');
require_once ('cms/models/vo/Menu.php');
require_once ('link/models/Links.php');
require_once ('cms/models/vo/Site.php');
class MyContents {

	/**
	 * @param int $num
	 * @return array
	 */
	public static function getArticles($num=10)
	{
		$config = Zend_Registry::get('config');
		$articles_id = $config->cms->cms->articles_category_id;

		$category = Category::getCategory($articles_id);
		return empty($category) ? array() : $category->getContentChildren(false);
	}
	/**
	 * @return Content
	 */
	public static function getFeaturedArticle()
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::CONTENT,'rowClass'=>'Content'));
		$select = $table->select();
		$select->setIntegrityCheck(false);
		$select = $select->from(array('a' => PrecurioTableConstants::CONTENT))
						->join(array('c' => PrecurioTableConstants::USERS),'a.user_id = c.user_id',array('first_name','last_name','profile_picture_id'))
						->where('a.active=1')->where('a.title <> ?',"")->where('a.is_featured = 1')->order('a.last_updated DESC');
		return $table->fetchRow($select);
	}
	/**
	 * @param $id int $id of the object you are finding
	 * @param $subClass boolean. Determine if function should return a subclass where possible.Default is True
	 * @return Content
	 */
	public static function getContent($id,$subClass = true)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::CONTENT,'rowClass'=>'Content'));
		$content = $table->find($id);
		$content = $content->current();
		if(empty($content))return null;
		if(!$subClass)return $content;

		if($content->isPage())
		{
			$page = Page::get($id,true);
			if($page)
				return $page;
		}
		if($content->isDocument())
		{
			$document = Documents::getDocument($id);
			if($document)
				return $document;
		}
		return $content;
	}
	/**
	 * Get all contents
	 * @param boolean $includePages - Include pages in result (default = false)
	 * @param boolean $includeDocs - Include documents in result (default = false)
	 * @return Array
	 */
	public static function getAll($includePages = false,$includeDocs = false,$includeSite = false)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::CONTENT,'rowClass'=>'Content'));
		$select = $table->select();
		$select->setIntegrityCheck(false);
		$select->setTable($table);
		$select = $select->from(array('a' => PrecurioTableConstants::CONTENT))
						->join(array('c' => PrecurioTableConstants::USERS),'a.user_id = c.user_id',array('first_name','last_name','profile_picture_id'))
						->where('a.active=1')
						->where('a.title <> ?',"")
						->where('a.is_photo = 0')
						->order('a.id DESC');
		if(!$includePages)
			$select = $select->where('a.is_page = 0');
		if(!$includeDocs)
			$select = $select->where('a.is_document = 0');
		if(!$includeSite)
			$select = $select->where('a.is_site = 0');

		$all = $table->fetchAll($select);

		$contents = array();
		try {
		$user_id = Precurio_Session::getCurrentUserId();
		}
		catch(Exception $e){$user_id = 0;}
		foreach($all as $content)
		{
			if($content->canAccess($user_id))
			{
				$contents[] = $content;
			}
		}
		return $contents;
	}
	public function getGroupContent($group_id,$publicOnly=false)
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::CONTENT,'rowClass'=>'Content'));
		$select = $table->select();
		$select->setIntegrityCheck(false);
		$select->setTable($table);
		$select = $select->from(array('a' => PrecurioTableConstants::CONTENT))
						->join(array('b' => PrecurioTableConstants::GROUP_CONTENTS),'a.id = b.content_id',array())
						->join(array('c' => PrecurioTableConstants::USERS),'a.user_id = c.user_id',array('first_name','last_name','profile_picture_id'))
						->where('a.active=1')
						->where('b.group_id = ?',$group_id)
						->where('b.active=1')
						->where('a.title <> ?',"")
						->where('a.is_photo = 0')
						->order('a.id DESC');
		if($publicOnly)
			$select = $select->where('a.is_public=1');

		$contents = $table->fetchAll($select);
		return $contents	;
	}

	public function getFacts()
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::FACTS,'rowClass'=>'Fact'));
		$facts = $table->fetchAll($table->select()->where('active= ? ',1)
													->order('id DESC'));
		return $facts;
	}

	/**
	 * Get all links created by the administrator
	 * @return Zend_Db_Table_Rowset_Abstract
	 */
	public function getLinks()
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::LINKS,'rowClass'=>'Link'));
		return $table->fetchAll($table->select()->where('active= ? ',1)->where('user_id = 0 ')->where('is_site = 0')
													->order('id DESC'));
	}

	public function getRss()
	{
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::RSS));
		return $table->fetchAll($table->select()->where('active= ? ',1)
													->order('id DESC'));
	}


}

?>