<?php
require_once ('cms/models/MyContents.php');
class Cms_SiteController  extends Zend_Controller_Action{


	public function viewAction()
	{
		$this->renderSite(0);
	}
	public function announcementsAction()
	{
		$this->renderSite(1);
	}
	public function resourcesAction()
	{
		$this->renderSite(2);
	}
	public function galleryAction()
	{
		$this->renderSite(3);
	}
	public function albumAction()
	{
		$album = Category::getCategory($this->getRequest()->getParam('album_id',0));
		$this->view->album = $album;
		$this->renderSite(5);
	}
	public function photoAction()
	{
		$photo = MyContents::getContent($this->getRequest()->getParam('photo_id',0),false);
		$this->view->photo = $photo;
		$album = Category::getCategory($this->getRequest()->getParam('album_id',0));
		$this->view->album = $album;
		$this->renderSite(6);
	}
	public function renderSite($section)
	{
		$site = Site::get($this->getRequest()->getParam('id',0));
		if(empty($site) || !$site->active())
			throw new Precurio_Exception($this->view->translate("Sorry, this site does not exist."),Precurio_Exception::EXCEPTION_INVALID_SITE);
		if(!$site->published() && !$site->isAdmin(Precurio_Session::getCurrentUserId()))
			throw new Precurio_Exception($this->view->translate("Sorry, this site is not published."),Precurio_Exception::EXCEPTION_UNPUBLISHED_SITE);
		$this->view->site = $site;
		$this->view->section = $section;
		$this->render('view');
	}
	public function viewcontentAction()
	{
		$content = MyContents::getContent($this->getRequest()->getParam('c_id',0));
		$content->viewed(Precurio_Session::getCurrentUserId());
		$this->view->content = $content;
		$this->renderSite(4);
	}
	public function listAction()
	{
		$this->view->sites = Site::getAll();
	}
}

?>