<?php
require_once ('cms/models/MyContents.php');
class Cms_IndexController extends Zend_Controller_Action
{

    public function indexAction()
    {
    	$this->_redirect('/cms/list/0');
    }

    public function viewAction()
    {
    	$content_id = $this->getRequest()->getParam('c_id');
    	$content = MyContents::getContent($content_id);

    	if(empty($content) || !$content->isActive() )
    	{
    		throw new Precurio_Exception($this->view->translate(PrecurioStrings::MISSINGCONTENT),Precurio_Exception::EXCEPTION_MISSING_CONTENT);
    	}
    	if(!$content->canAccess(Precurio_Session::getCurrentUserId()))
    	{
    		throw new Precurio_Exception($this->view->translate(PrecurioStrings::CANNOTACCESSRESOURCE),Precurio_Exception::EXCEPTION_NO_ACCESS);
    	}

    	$content->viewed(Precurio_Session::getCurrentUserId());
    	$this->view->content = $content;
    }
    /**
     * You can now add content without going to the admin
     * @version 4.3.6
     */
    public function addAction()
    {
        $this->view->header = true; //we only set this variable so that the back button works properly
        $this->view->redirect_after_submit = "content_view";//options are admin_list, content_list, admin_edit, content_view
        $this->renderScript("forms/admin/content_form.phtml");
    }
    public function editAction()
    {
        $this->view->header = true; //we only set this variable so that the back button works properly
        $this->view->redirect_after_submit = "content_view";//options are admin_list, content_list, admin_edit, content_view
        $id =  $this->getRequest()->getParam('c_id',0);
        $this->view->content = MyContents::getContent($id,false);
        $this->renderScript("forms/admin/content_form.phtml");
    }
    public function listAction()
    {
    	$category_id = $this->getRequest()->getParam('c_id');
    	$category = Category::getCategory($category_id);
    	if($category && !$category->canAccess(Precurio_Session::getCurrentUserId()))
    	{
    		throw new Precurio_Exception($this->view->translate(PrecurioStrings::CANNOTACCESSRESOURCE),Precurio_Exception::EXCEPTION_NO_ACCESS);
    	}
    	$this->view->category = $category;
    }
    public function shareAction()//this action is ONLY called by the user select popup facebox
    {
    	$this->_helper->layout->disableLayout();
    	$this->_helper->viewRenderer->setNoRender();
    	$data = $this->getRequest()->getParam('data');
    	$id = $this->getRequest()->getParam('id');
    	if(empty($id))return;
    	$content = MyContents::getContent($id);
    	$content->setSharedUsers($data['user']);
    	$content->groupShare($data['group']);
    	$content->extranetShare($data['email']);
    	if(empty($data['user']) && empty($data['group']) && empty($data['email']))
    		echo 'alert("'.$this->view->translate('You have successfully disabled share for this content').'");';
    	else
    		echo 'alert("'.$this->view->translate('You have successfully shared this content').'");';
    }

    /**
     * Action is called when user confirms he has read a content
     */
    public function readAction()
    {
    	$this->_helper->layout->disableLayout();
    	$this->_helper->viewRenderer->setNoRender();
    	$content_id = $this->getRequest()->getParam('c_id');
		$user_id = Precurio_Session::getCurrentUserId();
    	Precurio_Activity::create(Content::getAppId(), Content::ACTIVITY_READ, $content_id, $user_id);
    }

    public function searchdataAction()
    {
    	$this->_helper->layout->disableLayout();
    	$this->_helper->viewRenderer->setNoRender();

    	$tr = Zend_Registry::get('Zend_Translate');
    	$label = $tr->translate("Published on {1}.");

    	$contents = MyContents::getAll(true);

    	$results = array();
    	foreach($contents as $item)
    	{
    		$obj = new stdClass();
    		$obj->id  = $item->getId();
    		$obj->title = $item->getTitle();
    		$obj->label = getLocalizedString($label,$item->getDateAdded());
    		$obj->url = $item->getUrl();
    		$results[] = $obj;
    	}
    	echo json_encode($results);
    }

}
