<?php

/**
 * WorkflowController
 *
 * @author
 * @version
 */

require_once ('admin/controllers/BaseController.php');
require_once ('workflow/models/vo/Process.php');
class Admin_WorkflowController extends Admin_BaseController {

	function generateHeader() {
		return array('',$this->translate('Name'),$this->translate('Description'),$this->translate('Code'),$this->translate('Department'));
	}

	function generateList($searchText) {

		$this->view->tableOptions = array('view_href'=>" href='{$this->view->pathToController}view/id/%1\$s' ",
										'enable_view'=>true,'enable_edit'=>true,
										'view_label'=>$this->view->translate('Manage'));

		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::WORKFLOW,'rowClass'=>'Process'));
		$items = $table->fetchAll($table->select()->where('active=1'));

		$arr = array();
		$i = 1;
		foreach($items as $item)
		{
			if(!Precurio_Utils::isNull($searchText))
			{
				if(stripos($item->display_name,$searchText)===FALSE)
				{
					if(stripos($item->description,$searchText)===FALSE)
					{
						continue;
					}
				}
			}

		$arr[] = array($i++,'display_name'=>$item->display_name,'description'=>$item->description,'code'=>$item->code,'department'=>$item->getDepartmentName(),'id'=>$item->id);
		}
		return $arr;
	}

	public function indexAction()
	{
		$searchText = $this->getRequest()->getParam('search','');

		$this->view->searchText = $searchText;
		$this->view->list =  $this->generateList($searchText);
		$this->view->header = $this->generateHeader();
		$this->view->pageTitle = $this->getPageTitle();
		$this->view->table = $this->getTableName();
		$this->view->cpage = $this->getRequest()->getParam('cpage',$this->getRequest()->getParam('page',1));
		$this->view->errorMessages = implode('<br/>',$this->_helper->flashMessenger->getMessages());
	}
	public function editAction()
	{
		$id =  $this->getRequest()->getParam('id',0);
		$process = Process::get($id);
		$this->view->process = $process;
		$this->view->form = $this->getForm($process);
		$this->renderScript('forms/admin/workflow_form.phtml');
	}

	function getForm($item = null, $viewMode = false)
	{
		$form = new Zend_Form();
		$form->setAction($this->getRequest()->getBaseUrl().'/admin/workflow/submit')
			->setMethod('post')
			->setAttrib('id','form')
			->setAttrib('name','addForm')
			->setAttrib('enctype', 'multipart/form-data');


		$form->addElement('hidden', 'id', array(
				'validators' => array(
				),

				'required' => false,
				'value'=>$item['id']
				));

		$form->addElement('hidden', 'date_created', array(
				'validators' => array(
				),
				'required' => false,
				'value'=>$item == null ? Precurio_Date::now()->getTimestamp() : $item['date_created'],
				));
		$form->addElement('hidden', 'active', array(
				'validators' => array(
				),
				'required' => false,
				'value'=>1,
				));


		$form->addElement('text', 'display_name', array(
				'validators' => array(
				),
				'required' => true,
				'label'=>$this->translate('Name'),
				'value'=>$item['display_name']
				));
		$form->addElement('textarea', 'description', array(
				'validators' => array(
				),
				'required' => false,
				'label'=>$this->translate('Description'),
				'value'=>$item['description'],
				'rows'=>4
				));

		$form->addElement('text', 'code', array(
				'validators' => array(
				),
				'required' => true,
				'label'=>$this->translate('Code'),
				'value'=>$item['code']
				));

		$department_id = new Zend_Form_Element_Select('department_id');
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::DEPARTMENTS));
		$select = $table->select()->where('active=1')->order('title');
		$departments = $table->fetchAll($select);
		$department_id->addMultiOption(0,$this->translate('No Department'));
		foreach($departments as $department)
		{
			$department_id->addMultiOption($department->id,$department->title);
		}
		$department_id->setValue($item['department_id']);
		$department_id->setLabel($this->translate('Select Department'));
		#$form->addElement($department_id);

		$form->addElement('hidden', 'title_field', array('value'=>$item['title_field']));

		if(!$viewMode)
			$form->addElement('submit', 'submit', array(
					'class'=>'standout',
					'label'=>$this->translate('Submit'),
					));


		return $form;
	}

	public function getStateForm($item=null)
	{
		$form = new Zend_Form();
		$form->setAction($this->getRequest()->getBaseUrl().'/admin/workflow/submitstate')
			->setMethod('post')
			->setAttrib('id','form')
			->setAttrib('name','addForm');


		$form->addElement('hidden', 'id', array(
				'validators' => array(),
				'decorators' => array('ViewHelper'),
				'required' => true,
				'value'=>$item['id'],
				));

		$form->addElement('hidden', 'process_id', array(
				'validators' => array(),
				'decorators' => array('ViewHelper'),
				'required' => false,
				'value'=>$item['process_id'],
				));

		$form->addElement('text', 'display_name', array(
				'validators' => array(),
				'decorators' => array('ViewHelper','Label'),
				'required' => true,
				'label'=>$this->translate('Name'),
				'value'=>$item['display_name']
				));


		$form->addElement('text', 'SLA', array(
				'validators' => array(),
				'decorators' => array('ViewHelper','Label'),
				'required' => false,
				'label'=>$this->translate('SLA'),
				'value'=>$item['duration']
				));
		$form->addElement('text', 'sla_email', array(
				'validators' => array(),
				'decorators' => array('ViewHelper','Label'),
				'required' => false,
				'label'=>$this->translate('SLA Email'),
				'value'=>$item['sla_email']
				));

		if($item['is_approval'] || empty($item))
		{
			$form->addElement('checkbox', 'departmental', array(
				'validators' => array(),
				'decorators' => array('ViewHelper','Label'),
				'required' => false,
				'label'=>$this->translate('Departmental?'),
				'value'=> $item['departmental'],
				));

			$form->addElement('checkbox', 'locational', array(
				'validators' => array(),
				'decorators' => array('ViewHelper','Label','HtmlTag'),
				'required' => false,
				'label'=>$this->translate('Location-Based?'),
				'value'=> $item['locational'],
				));

			$form->addElement('checkbox', 'use_supervisor', array(
					'validators' => array(),
					'decorators' => array('ViewHelper','Label','HtmlTag'),
					'required' => false,
					'label'=>$this->translate('Approval by Direct Manager'),
					'value'=> $item['use_supervisor'],
			));


			$form->addElement('checkbox', 'allow_approver_change', array(
				'validators' => array(),
				'decorators' => array('ViewHelper','Label','HtmlTag'),
				'required' => false,
				'label'=>$this->translate('Allow approver change?'),
				'value'=> $item['allow_approver_change'],
				));
			
			$form->addElement('checkbox', 'include_form_in_notification', array(
					'validators' => array(),
					'decorators' => array('ViewHelper','Label'),
					'required' => false,
					'label'=>$this->translate('Include Form in Notification'),
					'value'=> $item['include_form_in_notification'],
			));
		}

		$form->addElement('submit', 'submit', array(
				'decorators' => array('ViewHelper'),
					'class'=>'submitbutton',
					'label'=>$this->translate('Submit'),
					));


		return $form;
	}
	public function submitstateAction()
	{
		$params = $this->getRequest()->getParams();
		if (!$this->getRequest()->isPost()) {
			return $this->_forward('index');
		}

		$form = $this->getStateForm();


		if (!$form->isValid($_POST))
		{
			// Failed validation; redisplay form
			$this->view->state = ProcessState::get($values['id']);
			$this->view->form = $form;
			return $this->render('state');
		}

		$values = $form->getValues($_POST);

		$this->preSubmit($values);
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::WORKFLOW_STATES));
		$row = $table->find($values['id'])->current();
		$row->setFromArray($values);
		$row->save();

		return $this->_redirect('/admin/workflow/state/id/'.$values['id']);
	}
	function getPageTitle() {
		return $this->translate('Workflows');
	}

	function getTableName() {
		return PrecurioTableConstants::WORKFLOW;
	}

	public function viewAction()
	{
		$id = $this->getRequest()->getParam('id',0);

		//we are using sessions to remember the last viewed id, because i can't figure how to make Zend_Navigation pass parameters
		$ns = new Zend_Session_Namespace(Precurio_Session::NAMESPACE_WORKFLOW);
		if($id == 0)
		{
			if(isset($ns->id))
				$id = $ns->id;
		}
		$ns->id = $id;

		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::WORKFLOW,'rowClass'=>'Process'));
		$item = $table->fetchRow($table->select()->where('id = ?',$id));

		if($item == null)return $this->_forward('index');

		$this->view->process = $item;
		$this->view->pageTitle = $this->getPageTitle();
	}

	/**
	 * View a particular state/section of the workflow.
	 *
	 */
	public function stateAction()
	{
		$state_id = $this->getRequest()->getParam('id');
		$state =  ProcessState::get($state_id);

		$this->view->state = $state;
		$this->view->form = $this->getStateForm($state);
	}

	/**
	 * Action is called when a user/group is added to a state
	 */
	public function submituserAction()
	{
		$this->_helper->layout->disableLayout();
		$this->_helper->viewRenderer->setNoRender();

		$state_id = $this->getRequest()->getParam('id');
		$state =  ProcessState::get($state_id);

		$params = $this->getRequest()->getPost();
		if($params['type'] != 'group_id' && $params['type'] != 'user_id')return;

		$values = array();

		$values['group_id'] = 0;
		$values['start_position'] = 0;
		$values['user_id'] = 0;
		$values['date_created'] = time();
		$values['state_id'] = $state_id;
		$values['process_id'] = $state->getProcessId();

		$values[$params['type']] = $params['item_id'];//$params['type'] is either group_id, user_id

		$tableName =  $state->isApproval() ? PrecurioTableConstants::WORKFLOW_APPROVAL_ACCESS : PrecurioTableConstants::WORKFLOW_REQUEST_ACCESS;

		$table = new Zend_Db_Table(array('name'=>$tableName));
		$row = $table->createRow();$row->setFromArray($values);

		$row->save();
	}
	public function submitobserverAction()
	{
		$this->_helper->layout->disableLayout();
		$this->_helper->viewRenderer->setNoRender();
		
		$process_id = $this->getRequest()->getParam('id');
		
		$params = $this->getRequest()->getPost();
		if($params['type'] != 'user_id')return;
		
		$values = array();
		
		$values['process_id'] = $process_id;
		$values[$params['type']] = $params['item_id'];//$params['type']  user_id
		$values['date_created'] = time();
		$values['active'] = 1;
		
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::WORKFLOW_OBSERVERS));
		$row = $table->createRow();$row->setFromArray($values);
		
		$row->save();
	}

	public function removeuserAction()
	{
		$state_id = $this->getRequest()->getParam('id');
		$state =  ProcessState::get($state_id);

		$params = $this->getRequest()->getPost();
		if($params['type'] != 'group_id' && $params['type'] != 'user_id')return;

		$tableName =  $state->isApproval() ? PrecurioTableConstants::WORKFLOW_APPROVAL_ACCESS : PrecurioTableConstants::WORKFLOW_REQUEST_ACCESS;

		$table = new Zend_Db_Table(array('name'=>$tableName));
		$select = $table->select()->where("process_id = ?",$state->getProcessId())
								->where($params['type']." = ?",$params['item_id']);
		if($state->isApproval())
			$select = $select->where("state_id = ?",$state_id);

		$row = $table->fetchRow($select);
		$row->delete();
	}
	
	public function removeobserverAction()
	{
		$process_id = $this->getRequest()->getParam('id');
		
		$params = $this->getRequest()->getPost();
		if($params['type'] != 'user_id')return;
		
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::WORKFLOW_OBSERVERS));
		$select = $table->select()->where("process_id = ?",$process_id)
		->where($params['type']." = ?",$params['item_id']);
		
		$row = $table->fetchRow($select);
		$row->active = 0;
		$row->save();
	}
	public function publishAction()
	{
		Precurio_Session::getLicense()->validate();
		Precurio_Session::getLicense()->proFeature();

		$id = $this->getRequest()->getParam('id');
		$formsBuilder = new Precurio_FormsBuilder($id);
		$process_id = $formsBuilder->publish();


		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::WORKFLOW,'rowClass'=>'Process'));
		$this->view->process = $table->fetchRow($table->select()->where('id = ?',$process_id));

		$this->view->pageTitle = $this->getPageTitle().' : '.$this->view->translate('Publish');

	}
	public function deleteAction()
	{
		$ids = $this->getRequest()->getParam("ids");
		foreach($ids as $id)
		{
			$process = Process::get($id);
			$process->do_delete();
		}

		return $this->_redirect('/'.$this->getRequest()->getModuleName().'/'.$this->getRequest()->getControllerName().'/');
	}

	public function init()
	{
		$root = Zend_Registry::get('root');
		if($this->view->theme != 'default')
			$this->view->addScriptPath($root .  '/application/default/layouts/default/views/admin');
		$this->view->addScriptPath($root .  '/application/default/layouts/'.$this->view->theme.'/views/admin');
	}
}
?>