<?php
require_once ('admin/controllers/GroupController.php');
class Admin_RoleController extends Admin_GroupController {

	function generateHeader() {
		return array('',$this->translate('Title'),$this->translate('Description'),$this->translate('Default'));
	}

	function generateList($searchText)
	{
		$userUtil = new UserUtil();
		$items = $userUtil->getGroups();

		$arr = array();
		$i = 1;
		foreach($items as $item)
		{
			if(!$item->is_role)continue;

			$role = $item->getRole();
			if(!$role->active)continue;

			if(!Precurio_Utils::isNull($searchText))
			{
				if(stripos($item->title,$searchText)===FALSE)
				{
					if(stripos($item->description,$searchText)===FALSE)
					{
						continue;
					}
				}

			}

			$arr[] = array($i++,'title'=>$item->title,'description'=>$item->description,'default'=>$item->isDefault() ? $this->translate(PrecurioStrings::YES) : $this->translate(PrecurioStrings::NO),'id'=>$item->id);
		}
		$this->view->tableOptions = array('enable_view'=>1,'view_label'=>$this->view->translate('Setup Rules'),'view_href'=>"href='".$this->view->baseUrl()."/admin/rule/index/id/%1\$s'");
		return $arr;
	}
	function getForm($item = null, $viewMode = false) {
		$form = parent::getForm($item,$viewMode);
		$form->removeElement('is_location');
		$form->removeElement('is_department');
		$form->removeElement('is_role');

		$form->addElement('hidden', 'is_role', array(
				'validators' => array(
				),
				'decorators'=>array(
				'ViewHelper',
				'FormElements'
				),
				'value'=>1,
				));
		$form->addElement('hidden', 'from_role', array(
				'validators' => array(
				),
				'decorators'=>array(
				'ViewHelper',
				'FormElements'
				),
				'value'=>1,
				));

		$form->setAction($this->getRequest()->getBaseUrl().'/admin/role/submit');
		return $form;
	}

	function getPageTitle() {
	 return $this->translate("Roles");
	}

	function getTableName() {
		return PrecurioTableConstants::GROUPS;
	}


}

?>