<?php
require_once ('admin/controllers/CmsController.php');
/**
 * @author brain
 *	Create, edit and delete pages
 *
 */
class Admin_PageController extends Admin_CmsController {
	function generateHeader() {
		return array('',$this->translate('Title'),$this->translate('Date'));
	}
	function generateList($searchText) {
		$items = Page::getAll();
		$arr = array();
		$i = 1;
		foreach($items as $item)
		{
			if(!empty($item->is_site))continue;//do not show site pages
			if(!Precurio_Utils::isNull($searchText))
			{
				if(stripos($item->getTitle(),$searchText)===FALSE)
				{
					continue;
				}
			}
			$parent = $item->getParent();
			$parent = empty($parent) ? '' : $parent->getTitle();
			$arr[] = array($i++,'title'=>$item->getTitle(),'date'=>$item->getDateAdded(),'id'=>$item->getContentId());
		}
		return $arr;
	}
	public function addAction()
	{
		$this->view->form = $this->getForm();
		$this->renderScript('forms/admin/page_form.phtml');
	}
	public function editAction()
	{
		$id =  $this->getRequest()->getParam('id',0);
		$this->view->content = Page::get($id,true);
		$this->renderScript('forms/admin/page_form.phtml');
	}

	function getPageTitle() {
		return $this->translate('Pages');
	}

	function getTableName() {
		return PrecurioTableConstants::PAGES;
	}
	function postSubmit($params)
	{
		$page = Page::get($params['content_id'],true);
		if(empty($page))
		{
			$page = Page::createNew($params);
		}
		else
		{
			$page->setFromArray($params);
		}
		$page->save();
		$this->_redirect('admin/page/edit/id/'.$params['content_id']);
		//$this->_redirect('/admin/page');
	}
}

?>