<?php

require_once ('cms/models/MyContents.php');
require_once ('admin/controllers/BaseController.php');

class Admin_MenuController extends Admin_BaseController
{
	function generateHeader() {
		return array(" ",$this->translate("Title"),$this->translate("Url"),$this->translate("Order"));
	}

	public function generateList($searchText)
	{
		$links = Menu::getAll();

		$arr = array();
		$i = 1;
		foreach($links as $link)
		{
			if(!Precurio_Utils::isNull($searchText))
			{
				if(stripos($link->title,$searchText)===FALSE)
				{
					if(stripos($link->url,$searchText)===FALSE)
					{
						continue;
					}
				}

			}

			$arr[] = array($i++,'title'=>$link->title,'url'=>$link->url,'order'=>$link->menu_order,'id'=>$link->id);
		}
		return $arr;
	}

	public function addAction()
	{
		$this->renderScript('forms/admin/menu_form.phtml');
	}
	public function editAction()
	{
		$id =  $this->getRequest()->getParam('id',0);
		$this->view->menu = Menu::get($id);
		$this->renderScript('forms/admin/menu_form.phtml');
	}
	public function getForm($menu = null,$viewMode = false)
	{
		$form = new Zend_Form();
		$form->setAction($this->getRequest()->getBaseUrl().'/admin/link/submit')
		->setMethod('post')
		->setAttrib('id','form')
		->setAttrib('name','addForm');


		$form->addElement('hidden', 'id', array('value'=>$menu['id']));
		$form->addElement('hidden', 'title', array('value'=>$menu['title']));
		$form->addElement('hidden', 'description', array('value'=>$menu['description']));
		$form->addElement('hidden', 'parent_id', array('value'=>$menu['parent_id']));
		$form->addElement('hidden', 'url', array('value'=>$menu['url']));
		$form->addElement('hidden', 'menu_order', array('value'=>$menu['menu_order']));
		$form->addElement('hidden', 'content_id', array('value'=>$menu['content_id']));
		$form->addElement('hidden', 'redirect_id', array('value'=>$menu['redirect_id']));
		$form->addElement('hidden', 'target', array('value'=>$menu['target']));
		$form->addElement('hidden', 'date_created', array('value'=>$menu['date_created']));
		$form->addElement('hidden', 'resource', array('value'=>$menu['resource']));
		$form->addElement('hidden', 'active', array('value'=>$menu['active']));
		return $form;
	}
	function getPageTitle() {
		return $this->translate("Menu");
	}

	function getTableName() {
		return PrecurioTableConstants::MENU;
	}
}
