<?php
require_once ('user/models/UserUtil.php');
require_once ('admin/controllers/BaseController.php');
class Admin_GroupController extends Admin_BaseController {

	function generateHeader() {
		return array('',$this->translate('Title'),$this->translate('Description'),$this->translate('Is Location'),$this->translate('Is Department'),$this->translate('Is Role'),$this->translate('Default'));
	}

	function generateList($searchText)
	{
		$userUtil = new UserUtil();
		$items = $userUtil->getGroups();

		$arr = array();
		$i = 1;
		foreach($items as $item)
		{
			if($item->is_team)continue;
			if(!Precurio_Utils::isNull($searchText))
			{
				if(stripos($item->title,$searchText)===FALSE)
				{
					if(stripos($item->description,$searchText)===FALSE)
					{
						continue;
					}
				}

			}

			$arr[] = array($i++,'title'=>$item->title,'description'=>$item->description,'is_location'=>$item->is_location ? $this->translate(PrecurioStrings::YES) : $this->translate(PrecurioStrings::NO),'is_department'=>$item->is_department ? $this->translate(PrecurioStrings::YES) : $this->translate(PrecurioStrings::NO),'is_role'=>$item->is_role ? $this->translate(PrecurioStrings::YES) : $this->translate(PrecurioStrings::NO),'is_default'=>$item->is_default ? $this->translate(PrecurioStrings::YES) : $this->translate(PrecurioStrings::NO),'id'=>$item->id);
		}
		return $arr;
	}
	public function deleteAction()
	{
		$ids = $this->getRequest()->getParam("ids");
		$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::GROUPS,'rowClass'=>'Group'));
		$items = $table->find($ids);

		foreach($items as $obj)
		{
			switch ($this->getRequest()->getControllerName())//perform some sort of polymorphism
			{
				case 'group':
					$obj->deactivate();//this will also deactivate corresponding roles, departments or locations
					break;
				case 'role':
					$obj->deactivateRole();
					break;
				case 'location':
					$obj->deactivateLocation();
					break;
				case 'department':
					$obj->deactivateDepartment();
					break;
			}
		}

		return $this->_redirect('/'.$this->getRequest()->getModuleName().'/'.$this->getRequest()->getControllerName().'/');
	}
	function getForm($item = null, $viewMode = false)
	{
		$form = new Zend_Form();
		$form->setAction($this->getRequest()->getBaseUrl().'/admin/group/submit')
			->setMethod('post')
			->setAttrib('id','form')
			->setAttrib('name','addForm')
			->setAttrib('enctype', 'multipart/form-data');



		$form->addElement('hidden', 'id', array(
				'validators' => array(
				),
				'decorators'=>array(
				'ViewHelper',
				'FormElements'
				),
				'required' => false,
				'value'=>$item['id'],
				));

		$form->addElement('hidden', 'date_created', array(
				'validators' => array(
				),
				'decorators'=>array(
				'ViewHelper',
				'FormElements'
				),
				'required' => false,
				'value'=>$item == null ? Precurio_Date::now()->getTimestamp() : $item['date_created'],
				));
		$form->addElement('hidden', 'active', array(
				'validators' => array(
				),
				'decorators'=>array(
				'ViewHelper',
				'FormElements'
				),
				'required' => false,
				'value'=>1,
				));


		$form->addElement('text', 'title', array(
				'validators' => array(
				),
				'required' => true,
				'label'=>$this->translate('Title'),
				'value'=>$item['title']
				));
		$form->addElement('text', 'description', array(
				'validators' => array(
				),
				'required' => false,
				'label'=>$this->translate('Description'),
				'value'=>$item['description']
				));


		$form->addElement('checkbox', 'is_location', array(
				'validators' => array(
				),
				'required' => false,
				'label'=>$this->translate('Is Location'),
				'value'=>$item == null ? 0 : $item['is_location'],
				));
		$form->addElement('checkbox', 'is_department', array(
				'validators' => array(
				),
				'required' => false,
				'label'=>$this->translate('Is Department'),
				'value'=>$item == null ? 0 : $item['is_department'],
				));
		$form->addElement('checkbox', 'is_role', array(
				'validators' => array(
				),
				'required' => false,
				'label'=>$this->translate('Is Role'),
				'value'=>$item == null ? 0 : $item['is_role'],
				));
		$form->addElement('checkbox', 'is_default', array(
				'validators' => array(
				),
				'required' => false,
				'label'=>$this->translate('Default'),
				'value'=>$item == null ? 0 : $item['is_default'],
				));
		$userUtil = new UserUtil();
		$form->addElement('select', 'parent_id', array(
				'required' => false,
				'label' => $this->translate('Parent Group'),
				'multiOptions'=> Precurio_FormElement::getOptionsArray($userUtil->getGroups(),'id','title',1),
		        'value'=>$item['parent_id']
				));
		if($viewMode && $item->parent_id == 0)
			$form->removeElement('parent_id');

		if(!$viewMode)
			$form->addElement('submit', 'submit', array(
					'class'=>'standout',
					'label'=>$this->translate('Submit'),
					));


		return $form;
	}

	function getPageTitle() {
		return $this->translate('Groups');
	}

	function getTableName() {
		return PrecurioTableConstants::GROUPS;
	}
	public function addAction()
	{
		$this->view->module = $this->getRequest()->getControllerName();//used by group_form to hide checkboxes
		$this->renderScript('forms/admin/group_form.phtml');
	}
	public function editAction()
	{
		$id = $this->getRequest()->getParam('id',0);

		$item = UserUtil::getGroup($id);

		if($item == null)return $this->_forward('index');

		$this->view->group = $item;
		$this->view->module = $this->getRequest()->getControllerName();//used by group_form to hide checkboxes
		$this->renderScript('forms/admin/group_form.phtml');
	}

	function preSubmit(&$params)
	{
		if($params['id'] == $params['parent_id'])$params['parent_id'] = 0;
		return $params;
	}
	function postSubmit($params)
	{
		//handle group members
		$group = UserUtil::getGroup($params[id]);
		$group->setUserMembers($params['user_ids']);
		$data = array(
				'title'=>$params['title'],
				'group_id'=>$params['id'],
				'date_created'=>$params['date_created'],
				'active'=>1
				);
		if(isset($params['is_location']))
		{
			//first get location
			$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::LOCATIONS));
			$row = $table->fetchRow($table->select()->where('group_id = ?',$params['id']));

			//set active flag to is_location (which is either 0 or 1 depending on checkbox)
			$data['active'] = $params['is_location'];

			//if there is no location and group has been set as location, create the location row.
			//note that this will happen if a) this is a new group or b) an existing group has just been set has a location
			if(Precurio_Utils::isNull($row) && $params['is_location'])$row = $table->createRow();

			//if there is a row set the data. This will activate or deactivate, depending on value of checkbox.
			if($row)
			{
				$row->setFromArray($data);
				$row->save();//save data
			}
		}

		if(isset($params['is_department']))
		{
			//first get department
			$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::DEPARTMENTS));
			$row = $table->fetchRow($table->select()->where('group_id = ?',$params['id']));

			//set active flag to is_department (which is either 0 or 1 depending on checkbox)
			$data['active'] = $params['is_department'];

			//if there is no department and group has been set as department, create the department row.
			//note that this will happen if a) this is a new group or b) an existing group has just been set has a department
			if(Precurio_Utils::isNull($row) && $params['is_department'])$row = $table->createRow();

			//if there is a row set the data. This will activate or deactivate, depending on value of checkbox.
			if($row)
			{
				$row->setFromArray($data);
				$row->save();//save data
			}
		}
		if(isset($params['is_role']))
		{
			//first get role
			$table = new Zend_Db_Table(array('name'=>PrecurioTableConstants::ROLES));
			$row = $table->fetchRow($table->select()->where('group_id = ?',$params['id']));

			//set active flag to is_role (which is either 0 or 1 depending on checkbox)
			$data['active'] = $params['is_role'];

			//if there is no role and group has been set as role, create the role row.
			//note that this will happen if a) this is a new group or b) an existing group has just been set has a role
			if(Precurio_Utils::isNull($row) && $params['is_role'])$row = $table->createRow();

			//if there is a row set the data. This will activate or deactivate, depending on value of checkbox.
			if($row)
			{
				$row->setFromArray($data);
				$row->save();//save data
			}
		}

	}

}

?>