(function(){

  $.fn.popbox = function(options){
    var settings = $.extend({
      selector      : this.selector,
      open          : '.open',
      box           : '.box',
      arrow         : '.arrow',
      arrow_border  : '.arrow-border',
      close         : '.close'
    }, options);

    var methods = {
      open: function(event){
        event.preventDefault();

        var pop = $(this);
        var box = $(this).parent().find(settings['box']);
        box.find(settings['arrow']).css({'left': box.width()/2 - 10 - 120 });
        box.find(settings['arrow_border']).css({'left': box.width()/2 - 10 - 120});

        var contentArea = box.find(".box-content");
        if(box.css('display') == 'block'){
          methods.close();
        } else {
          methods.close();
          box.css({'display': 'block', 'top': 10, 'left': ((pop.parent().width()/2) -box.width()/2 + 120 )});
          url = $(this).attr('href');
          methods.loadContent(url,contentArea);
        }

        if ($('#nameinput').length > 0) {
            $("#nameinput").focus();
        }
      },

      close: function(event){
        $(settings['box']).fadeOut("fast");
      },

      loadContent: function(url,contentArea){
    	  $.ajax({
    		 'url': url,
    		 'type': 'GET',
    		 success: function(data){
    			 $(contentArea).html(data);
    		 },
    		 error: function(xhr, reason, exception){
    			 console.log(reason);
    		 }
    	  });
      }
    };

    $(document).live('keyup', function(event){
      if(event.keyCode == 27){
        methods.close();
      }
    });

    $(document).live('click', function(event){
      if(!$(event.target).closest(settings['selector']).length){
        methods.close();
      }
    });

    return this.each(function(){
     // $(this).css({'width': $(settings['box']).width()}); // Width needs to be set otherwise popbox will not move when window resized.
      $(settings['open'], this).live('click', methods.open);
      $(settings['close'], this).live('click', function(event){
        event.preventDefault();
        methods.close();
      });
    });
  }

}).call(this);
