(function(){

  $.fn.popout_newtask = function(options){
    var settings = $.extend({
      selector      : this.selector,
      open          : '.open',
      box           : '.box',
      arrow         : '.arrow',
      arrow_border  : '.arrow-border',
      close         : '.close'
    }, options);

    var methods = {
      open: function(event){
        event.preventDefault();

        var pop = $(this);
        var box = $(this).parent().find(settings['box']);

        box.find(settings['arrow']).css({'left': 30});
        box.find(settings['arrow_border']).css({'left': 30});

        if(box.css('display') == 'block')

        {
          methods.close();
        } else {
          methods.close();
          //we test if the <a> is an actionbutton or just a normal link
          box.css({'display': 'block', 'top': ($(this).hasClass("actionbutton") ? '40px' : '0px'), 'left': (0 )});
        }

          if ($('#taskinput').length > 0) {
            $("#taskinput").focus();
        }

      },

      close: function(){
        $(settings['box']).fadeOut("fast");
      }
    };

    $(document).bind('keyup', function(event){
      if(event.keyCode == 27){
        methods.close();
      }
    });

    $(document).bind('click', function(event){
      if(!$(event.target).closest(settings['selector']).length){
        methods.close();
      }
    });

    return this.each(function(){
    // $(this).css({'width': 1}); // Width needs to be set otherwise popbox will not move when window resized.
      $(settings['open'], this).bind('click', methods.open);
      $(settings['open'], this).parent().find(settings['close']).bind('click', function(event){
        event.preventDefault();
        methods.close();
      });
    });
  }

}).call(this);
