(function($){

// Creating the sweetPages jQuery plugin:

$.fn.sweetPages = function(opts){

	// If no options were passed, create an empty opts object

	if(!opts) opts = {};

	var resultsPerPage = opts.perPage || 3;

	// The plugin works best for unordered lists, althugh ols would do just as well:

	var ul = this;

	var li = ul.find('li');


	li.each(function(){

		// Calculating the height of each li element, and storing it with the data method:

		var el = $(this);

		el.data('height',el.outerHeight(true));

	});

	

	// Calculating the total number of pages:

	var pagesNumber = Math.ceil(li.length/resultsPerPage);

	

	// If the pages are less than two, do nothing:

	if(pagesNumber<2) return this;



	// Creating the controls div:

	var swControls = $('<div class="swControls">');

	

	for(var i=0;i<pagesNumber;i++)

	{

		// Slice a portion of the lis, and wrap it in a swPage div:

		li.slice(i*resultsPerPage,(i+1)*resultsPerPage).wrapAll('<div class="swPage" />');

		

		// Adding a link to the swControls div:

		swControls.append('<a href="" class="swShowPage">'+(i+1)+'</a>');

	}



	ul.append(swControls);

	

	var maxHeight = 0;

	var totalWidth = 0;

	

	var swPage = ul.find('.swPage');

	swPage.each(function(){

		

		// Looping through all the newly created pages:

		

		var elem = $(this);



		var tmpHeight = 0;

		elem.find('li').each(function(){tmpHeight+=$(this).data('height');});



		if(tmpHeight>maxHeight)

			maxHeight = tmpHeight;



		totalWidth+=elem.outerWidth();

		

		elem.css('float','left').width(ul.width());

	});

	

	swPage.wrapAll('<div class="swSlider" />');

	

	// Setting the height of the ul to the height of the tallest page:

	ul.height(maxHeight);

	

	var swSlider = ul.find('.swSlider');

	swSlider.append('<div class="clear" />').width(totalWidth);



	var hyperLinks = ul.find('a.swShowPage');

	

	hyperLinks.click(function(e){

		

		// If one of the control links is clicked, slide the swSlider div 

		// (which contains all the pages) and mark it as active:



		$(this).addClass('active').siblings().removeClass('active');

		

		swSlider.stop().animate({'margin-left':-(parseInt($(this).text())-1)*ul.width()},'slow');

		e.preventDefault();

	});

	

	// Mark the first link as active the first time this code runs:

	hyperLinks.eq(0).addClass('active');

	

	// Center the control div:

	swControls.css({

		'left':'20px',

		'margin-left':0

	});

	

	return this;

	

}})(jQuery);


// make dropdown
(function(a){function f(a){i(),g(),d=a.find("ul").css("visibility","visible")}function g(){d&&(d.css("visibility","hidden"),d=null)}function h(){c=window.setTimeout(g,b)}function i(){c&&(window.clearTimeout(c),c=null)}function j(a){d&&a.has(d[0]).length?g():f(a)}var b=500,c=0,d=null,e="ontouchstart"in window||window.DocumentTouch&&document instanceof DocumentTouch;a.fn.make_dropdown=function(c){return this.each(function(){c&&c.timeout&&(b=c.timeout),a(this).click(function(b){j(a(this)),b.stopPropagation()}),e||a(this).mouseover(function(){f(a(this))}).mouseout(h)})},a(document).click(g)})(jQuery);



//jquery.cslider
(function(a,b){a.Slider=function(b,c){this.$el=a(c);this._init(b)};a.Slider.defaults={current:0,bgincrement:50,autoplay:false,interval:4e3};a.Slider.prototype={_init:function(b){this.options=a.extend(true,{},a.Slider.defaults,b);this.$slides=this.$el.children("div.da-slide");this.slidesCount=this.$slides.length;this.current=this.options.current;if(this.current<0||this.current>=this.slidesCount){this.current=0}this.$slides.eq(this.current).addClass("da-slide-current");var c=a('<nav class="da-dots"/>');for(var d=0;d<this.slidesCount;++d){c.append("<span/>")}c.appendTo(this.$el);this.$pages=this.$el.find("nav.da-dots > span");this.$navNext=this.$el.find("span.da-arrows-next");this.$navPrev=this.$el.find("span.da-arrows-prev");this.isAnimating=false;this.bgpositer=0;this.cssAnimations=Modernizr.cssanimations;this.cssTransitions=Modernizr.csstransitions;if(!this.cssAnimations||!this.cssAnimations){this.$el.addClass("da-slider-fb")}this._updatePage();this._loadEvents();if(this.options.autoplay){this._startSlideshow()}},_navigate:function(a,b){var c=this.$slides.eq(this.current),d,e=this;if(this.current===a||this.isAnimating)return false;this.isAnimating=true;var f,g,h;if(!b){a>this.current?h="next":h="prev"}else{h=b}if(this.cssAnimations&&this.cssAnimations){if(h==="next"){f="da-slide-toleft";g="da-slide-fromright";++this.bgpositer}else{f="da-slide-toright";g="da-slide-fromleft";--this.bgpositer}this.$el.css("background-position",this.bgpositer*this.options.bgincrement+"% 0%")}this.current=a;d=this.$slides.eq(this.current);if(this.cssAnimations&&this.cssAnimations){var i="da-slide-toleft da-slide-toright da-slide-fromleft da-slide-fromright";c.removeClass(i);d.removeClass(i);c.addClass(f);d.addClass(g);c.removeClass("da-slide-current");d.addClass("da-slide-current")}if(!this.cssAnimations||!this.cssAnimations){d.css("left",h==="next"?"100%":"-100%").stop().animate({left:"0%"},1e3,function(){e.isAnimating=false});c.stop().animate({left:h==="next"?"-100%":"100%"},1e3,function(){c.removeClass("da-slide-current")})}this._updatePage()},_updatePage:function(){this.$pages.removeClass("da-dots-current");this.$pages.eq(this.current).addClass("da-dots-current")},_startSlideshow:function(){var a=this;this.slideshow=setTimeout(function(){var b=a.current<a.slidesCount-1?b=a.current+1:b=0;a._navigate(b,"next");if(a.options.autoplay){a._startSlideshow()}},this.options.interval)},page:function(a){if(a>=this.slidesCount||a<0){return false}if(this.options.autoplay){clearTimeout(this.slideshow);this.options.autoplay=false}this._navigate(a)},_loadEvents:function(){var b=this;this.$pages.on("click.cslider",function(c){b.page(a(this).index());return false});this.$navNext.on("click.cslider",function(a){if(b.options.autoplay){clearTimeout(b.slideshow);b.options.autoplay=false}var c=b.current<b.slidesCount-1?c=b.current+1:c=0;b._navigate(c,"next");return false});this.$navPrev.on("click.cslider",function(a){if(b.options.autoplay){clearTimeout(b.slideshow);b.options.autoplay=false}var c=b.current>0?c=b.current-1:c=b.slidesCount-1;b._navigate(c,"prev");return false});if(this.cssTransitions){if(!this.options.bgincrement){this.$el.on("webkitAnimationEnd.cslider animationend.cslider OAnimationEnd.cslider",function(a){if(a.originalEvent.animationName==="toRightAnim4"||a.originalEvent.animationName==="toLeftAnim4"){b.isAnimating=false}})}else{this.$el.on("webkitTransitionEnd.cslider transitionend.cslider OTransitionEnd.cslider",function(a){if(a.target.id===b.$el.attr("id"))b.isAnimating=false})}}}};var c=function(a){if(this.console){console.error(a)}};a.fn.cslider=function(b){if(typeof b==="string"){var d=Array.prototype.slice.call(arguments,1);this.each(function(){var e=a.data(this,"cslider");if(!e){c("cannot call methods on cslider prior to initialization; "+"attempted to call method '"+b+"'");return}if(!a.isFunction(e[b])||b.charAt(0)==="_"){c("no such method '"+b+"' for cslider instance");return}e[b].apply(e,d)})}else{this.each(function(){var c=a.data(this,"cslider");if(!c){a.data(this,"cslider",new a.Slider(b,this))}})}return this}})(jQuery)


/**
 * Copyright (c) 2007-2012 Ariel Flesler - aflesler(at)gmail(dot)com | http://flesler.blogspot.com
 * Dual licensed under MIT and GPL.
 * @author Ariel Flesler
 * @version 1.4.3
 */
;(function($){var h=$.scrollTo=function(a,b,c){$(window).scrollTo(a,b,c)};h.defaults={axis:'xy',duration:parseFloat($.fn.jquery)>=1.3?0:1,limit:true};h.window=function(a){return $(window)._scrollable()};$.fn._scrollable=function(){return this.map(function(){var a=this,isWin=!a.nodeName||$.inArray(a.nodeName.toLowerCase(),['iframe','#document','html','body'])!=-1;if(!isWin)return a;var b=(a.contentWindow||a).document||a.ownerDocument||a;return/webkit/i.test(navigator.userAgent)||b.compatMode=='BackCompat'?b.body:b.documentElement})};$.fn.scrollTo=function(e,f,g){if(typeof f=='object'){g=f;f=0}if(typeof g=='function')g={onAfter:g};if(e=='max')e=9e9;g=$.extend({},h.defaults,g);f=f||g.duration;g.queue=g.queue&&g.axis.length>1;if(g.queue)f/=2;g.offset=both(g.offset);g.over=both(g.over);return this._scrollable().each(function(){if(!e)return;var d=this,$elem=$(d),targ=e,toff,attr={},win=$elem.is('html,body');switch(typeof targ){case'number':case'string':if(/^([+-]=)?\d+(\.\d+)?(px|%)?$/.test(targ)){targ=both(targ);break}targ=$(targ,this);if(!targ.length)return;case'object':if(targ.is||targ.style)toff=(targ=$(targ)).offset()}$.each(g.axis.split(''),function(i,a){var b=a=='x'?'Left':'Top',pos=b.toLowerCase(),key='scroll'+b,old=d[key],max=h.max(d,a);if(toff){attr[key]=toff[pos]+(win?0:old-$elem.offset()[pos]);if(g.margin){attr[key]-=parseInt(targ.css('margin'+b))||0;attr[key]-=parseInt(targ.css('border'+b+'Width'))||0}attr[key]+=g.offset[pos]||0;if(g.over[pos])attr[key]+=targ[a=='x'?'width':'height']()*g.over[pos]}else{var c=targ[pos];attr[key]=c.slice&&c.slice(-1)=='%'?parseFloat(c)/100*max:c}if(g.limit&&/^\d+$/.test(attr[key]))attr[key]=attr[key]<=0?0:Math.min(attr[key],max);if(!i&&g.queue){if(old!=attr[key])animate(g.onAfterFirst);delete attr[key]}});animate(g.onAfter);function animate(a){$elem.animate(attr,f,g.easing,a&&function(){a.call(this,e,g)})}}).end()};h.max=function(a,b){var c=b=='x'?'Width':'Height',scroll='scroll'+c;if(!$(a).is('html,body'))return a[scroll]-$(a)[c.toLowerCase()]();var d='client'+c,html=a.ownerDocument.documentElement,body=a.ownerDocument.body;return Math.max(html[scroll],body[scroll])-Math.min(html[d],body[d])};function both(a){return typeof a=='object'?a:{top:a,left:a}}})(jQuery);


/*
 * jQuery One Page Nav Plugin
 * http://github.com/davist11/jQuery-One-Page-Nav
 *
 * Copyright (c) 2010 Trevor Davis (http://trevordavis.net)
 * Dual licensed under the MIT and GPL licenses.
 * Uses the same license as jQuery, see:
 * http://jquery.org/license
 *
 * @version 2.1
 *
 * Example usage:
 * $('#nav').onePageNav({
 *   currentClass: 'current',
 *   changeHash: false,
 *   scrollSpeed: 750
 * });
 */

;(function($, window, document, undefined){

	// our plugin constructor
	var OnePageNav = function(elem, options){
		this.elem = elem;
		this.$elem = $(elem);
		this.options = options;
		this.metadata = this.$elem.data('plugin-options');
		this.$nav = this.$elem.find('a');
		this.$win = $(window);
		this.sections = {};
		this.didScroll = false;
		this.$doc = $(document);
		this.docHeight = this.$doc.height();
	};

	// the plugin prototype
	OnePageNav.prototype = {
		defaults: {
			currentClass: 'current',
			changeHash: false,
			easing: 'swing',
			filter: '',
			scrollSpeed: 750,
			scrollOffset: 0,
			scrollThreshold: 0.5,
			begin: false,
			end: false,
			scrollChange: false
		},

		init: function() {
			var self = this;
			
			// Introduce defaults that can be extended either
			// globally or using an object literal.
			self.config = $.extend({}, self.defaults, self.options, self.metadata);
			
			//Filter any links out of the nav
			if(self.config.filter !== '') {
				self.$nav = self.$nav.filter(self.config.filter);
			}
			
			//Handle clicks on the nav
			self.$nav.on('click.onePageNav', $.proxy(self.handleClick, self));

			//Get the section positions
			self.getPositions();
			
			//Handle scroll changes
			self.bindInterval();
			
			//Update the positions on resize too
			self.$win.on('resize.onePageNav', $.proxy(self.getPositions, self));

			return this;
		},
		
		adjustNav: function(self, $parent) {
			self.$elem.find('.' + self.config.currentClass).removeClass(self.config.currentClass);
			$parent.addClass(self.config.currentClass);
		},
		
		bindInterval: function() {
			var self = this;
			var docHeight;
			
			self.$win.on('scroll.onePageNav', function() {
				self.didScroll = true;
			});
			
			self.t = setInterval(function() {
				docHeight = self.$doc.height();
				
				//If it was scrolled
				if(self.didScroll) {
					self.didScroll = false;
					self.scrollChange();
				}
				
				//If the document height changes
				if(docHeight !== self.docHeight) {
					self.docHeight = docHeight;
					self.getPositions();
				}
			}, 250);
		},
		
		getHash: function($link) {
			return $link.attr('href').split('#')[1];
		},
		
		getPositions: function() {
			var self = this;
			var linkHref;
			var topPos;
			
			self.$nav.each(function() {
				linkHref = self.getHash($(this));
				topPos = $('#' + linkHref).offset().top;
			
				self.sections[linkHref] = Math.round(topPos) - self.config.scrollOffset;
			});
		},
		
		getSection: function(windowPos) {
			var returnValue = null;
			var windowHeight = Math.round(this.$win.height() * this.config.scrollThreshold);

			for(var section in this.sections) {
				if((this.sections[section] - windowHeight) < windowPos) {
					returnValue = section;
				}
			}
			
			return returnValue;
		},
		
		handleClick: function(e) {
			var self = this;
			var $link = $(e.currentTarget);
			var $parent = $link.parent();
			var newLoc = '#' + self.getHash($link);
			
			if(!$parent.hasClass(self.config.currentClass)) {
				//Start callback
				if(self.config.begin) {
					self.config.begin();
				}
				
				//Change the highlighted nav item
				self.adjustNav(self, $parent);
				
				//Removing the auto-adjust on scroll
				self.unbindInterval();
				
				//Scroll to the correct position
				$.scrollTo(newLoc, self.config.scrollSpeed, {
					axis: 'y',
					easing: self.config.easing,
					offset: {
						top: -self.config.scrollOffset
					},
					onAfter: function() {
						//Do we need to change the hash?
						if(self.config.changeHash) {
							window.location.hash = newLoc;
						}
						
						//Add the auto-adjust on scroll back in
						self.bindInterval();
						
						//End callback
						if(self.config.end) {
							self.config.end();
						}
					}
				});
			}

			e.preventDefault();
		},
		
		scrollChange: function() {
			var windowTop = this.$win.scrollTop();
			var position = this.getSection(windowTop);
			var $parent;
			
			//If the position is set
			if(position !== null) {
				$parent = this.$elem.find('a[href$="#' + position + '"]').parent();
				
				//If it's not already the current section
				if(!$parent.hasClass(this.config.currentClass)) {
					//Change the highlighted nav item
					this.adjustNav(this, $parent);
					
					//If there is a scrollChange callback
					if(this.config.scrollChange) {
						this.config.scrollChange($parent);
					}
				}
			}
		},
		
		unbindInterval: function() {
			clearInterval(this.t);
			this.$win.unbind('scroll.onePageNav');
		}
	};

	OnePageNav.defaults = OnePageNav.prototype.defaults;

	$.fn.onePageNav = function(options) {
		return this.each(function() {
			new OnePageNav(this, options).init();
		});
	};
	
})( jQuery, window , document );



<!--Plugin for Task Tab - Olen-->
window.onload=function() {

  // get tab container
  	var container = document.getElementById("tabContainer");
		var tabcon = document.getElementById("tabscontent");
		//alert(tabcon.childNodes.item(1));
    // set current tab
    var navitem = document.getElementById("tabHeader_1");
    if(!navitem)return;
		
    //store which tab we are on
    var ident = navitem.id.split("_")[1];
		//alert(ident);
    navitem.parentNode.setAttribute("data-current",ident);
    //set current tab with class of activetabheader
    navitem.setAttribute("class","tabActiveHeader");

    //hide two tab contents we don't need
   	 var pages = tabcon.getElementsByTagName("div");
    	for (var i = 1; i < pages.length; i++) {
     	 pages.item(i).style.display="none";
		};

    //this adds click event to tabs
    var tabs = container.getElementsByTagName("li");
    for (var i = 0; i < tabs.length; i++) {
      tabs[i].onclick=displayPage;
    }
}

// on click of one of tabs
function displayPage() {
  var current = this.parentNode.getAttribute("data-current");
  //remove class of activetabheader and hide old contents
  document.getElementById("tabHeader_" + current).removeAttribute("class");
  document.getElementById("tabpage_" + current).style.display="none";

  var ident = this.id.split("_")[1];
  //add class of activetabheader to new active tab and show contents
  this.setAttribute("class","tabActiveHeader");
  document.getElementById("tabpage_" + ident).style.display="block";
  this.parentNode.setAttribute("data-current",ident);
}


<!--end Plug in for task tabs-->