/*
 * This script is responsible for the periodic update & email notifications feature.
 * What it does is simple. Call the periodic update controller "user/index/periodicupdate" at intervals
 *
 */
	var displayed = [];//stores IDs of all updates that have been displayed. This is used to avoid repetitions
	function sendPing()
	{
		$.get(baseUrl + '/user/index/periodicupdate', null, handlePingResult);
	}
	function handlePingResult(result)
	{
		var data = $.parseJSON(result);
		handlePeriodicUpdates(data.updates);
		setTimeout(sendPing, 100000);//call function every 100 seconds
	}

	function initializeGrowl()
	{
		$.jGrowl.defaults.closerTemplate = '<div>hide all notifications</div>';
	}
	function handlePeriodicUpdates(updates)
	{
		$.each(updates, function( activity_id, update ) {
			if(displayed.indexOf(activity_id) == -1)//activity hasn't been displayed before
				$.jGrowl(update,{sticky: true});

			displayed.push(activity_id);
		});
	}
	$(document).ready(function() {
		setTimeout(sendPing,60000);//only begin polling one minute after load
		initializeGrowl();
	});
